
#include "Key_user.h"
#include "Components.h"


__align(4)

#define BACK_MENU_TIME		1000

// #define MENU_GRADE		  g_u8Menu_Grade
#define CURSOR_POSITION   g_u8Cursor_Posittion
_Menu_Data MenuData;
uint8_t PageType; //设置时间参数（设置小时或者分钟）
uint8_t Key_Right_Long_Press_Flag;
uint8_t Key_Left_Long_Press_Flag;

RTC_TimeTypeDef RTC_TimeStruct;
RTC_DateTypeDef RTC_DateStruct;



RTC_CounterTypeDef counter_val;

void Key_Operation_Left(Key_Event_en_t enKeyEvent)//Mode
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		// if(MENU_GRADE == 0x00)
		// {
		// 	Menu_Service(MENU_KEY_LEFT_SHORT);
		// }
		// else
		// {
		// 	Menu_Service(MENU_KEY_DOWN_SHORT);
		// }
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		// if(MENU_GRADE == 0x00)
		// {
		// 	Menu_Service(MENU_KEY_LEFT_LONG);
		// }
		// else
		// {
		// 	Menu_Change_Branch_To_Item(0, MENU_ITEM_DriveInfo);
		// 	Menu_Service(MENU_KEY_DOWN_LONG);
		// }
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
		// if(MENU_GRADE == 0x00)
		// {
		// 	Menu_Service(MENU_KEY_LEFT_SUPER_LONG);
		// }
		// else
		// {
		// 	Menu_Service(MENU_KEY_DOWN_SUPER_LONG);
		// }
		Key_Left_Long_Press_Flag = 1;
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		Key_Left_Long_Press_Flag = 0;
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)//Set
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		// Menu_Service(MENU_KEY_CONFIRM_SHORT);
		break;
	case KEY_EVENT_SHORT_PRESS_2:
		// Menu_Service(MENU_KEY_CONFIRM_LONG);		
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		// Menu_Service(MENU_KEY_CONFIRM_SUPER_LONG);
		Key_Right_Long_Press_Flag = 1;
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		break;
	case KEY_EVENT_LONG_PRESS_3:	//5s
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		Key_Right_Long_Press_Flag = 0;
		break;
	default:		
		break;
	}
}


/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (SYS_OPR_STAT_IGN_ON)
	{
		// if (RTE_GPIO_Get_Level(MODE_P_IN))
		// {
		// 	enKeyReal = KEY_REALTIME_LOOSEN;
		// }
		// else
		// {
		// 	enKeyReal = KEY_REALTIME_PRESS;
		// }
	}
	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (SYS_OPR_STAT_IGN_ON)
	{
		// if (RTE_GPIO_Get_Level(SET_P_IN))
		// {
		// 	enKeyReal = KEY_REALTIME_LOOSEN;
		// }
		// else
		// {
		// 	enKeyReal = KEY_REALTIME_PRESS;
		// }
	}
	return enKeyReal;
}


/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
{
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
	{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_FLIP, Key_Operation_FLIP},
	//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_ADJUST, Key_Operation_ADJUST},
};

/*---------------------------------------------------------------------------------------*/

Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,10000U);

	Key_Parameter_Set_Long_Press_1_Time(10000U);
	Key_Parameter_Set_Long_Press_2_Time(60000U);
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; 
	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,1000U);
	Key_Parameter_Set_Short_Press_2_Time(3000U,10000U);

	Key_Parameter_Set_Long_Press_1_Time(10000U);
	Key_Parameter_Set_Long_Press_2_Time(60000U);
}

void Key_Check_Service(void)
{
	PageType = Page_Time_Set_Hour;
}

void Key_Auto_Save(void)
{
	if(PageType == Page_Time_Set_Hour)
	{
		RTC_SetTime(&counter_val.time);
	}

	if(PageType == Page_Time_Set_Minute)
	{
		RTC_SetTime(&counter_val.time);
	}
	PageType = Page_Time;
}



uint8_t ClearODO_Flag = 0;
void TYW_RESET_ODO(void)
{
	if(SYS_OPR_STAT_IGN_ON)
   {
       if(ClearODO_Flag < 1)
       {
           //if((Get_DispVechileSpeed() >= 1200)&&(Get_DispEngineSpeed() >= 11000))
           {
               ClearODO_Flag = 1;
               Data_Mileage_Clear();
           }
       }
   }
   else
   {
       ClearODO_Flag = 0;
   }
}

uint8_t Get_Dis_Hour_Time(void)
{
	return counter_val.time.RTC_Hours;
}

uint8_t Get_Dis_Minute_Time(void)
{
	return counter_val.time.RTC_Minutes;
}

uint8_t Get_Current_PageType(void)
{
	return PageType;
}

uint8_t Get_Dis_Unit(void)
{
	return MenuData.Unit; //0km,1mile
}
