/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.jimage.decompressor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import jdk.internal.jimage.decompressor.CompressIndexes;
import jdk.internal.jimage.decompressor.ResourceDecompressor;

public class StringSharingDecompressor
implements ResourceDecompressor {
    public static final int EXTERNALIZED_STRING = 23;
    public static final int EXTERNALIZED_STRING_DESCRIPTOR = 25;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_InvokeDynamic = 18;
    private static final int CONSTANT_Module = 19;
    private static final int CONSTANT_Package = 20;
    private static final int[] SIZES = new int[21];

    public static int[] getSizes() {
        return (int[])SIZES.clone();
    }

    public static byte[] normalize(ResourceDecompressor.StringsProvider provider, byte[] transformed, int offset) throws IOException {
        DataInputStream stream = new DataInputStream(new ByteArrayInputStream(transformed, offset, transformed.length - offset));
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(transformed.length);
        DataOutputStream out = new DataOutputStream(outStream);
        byte[] header = new byte[8];
        stream.readFully(header);
        out.write(header);
        int count = stream.readUnsignedShort();
        out.writeShort(count);
        block6: for (int i = 1; i < count; ++i) {
            int tag = stream.readUnsignedByte();
            switch (tag) {
                case 1: {
                    out.write(tag);
                    String utf = stream.readUTF();
                    out.writeUTF(utf);
                    continue block6;
                }
                case 23: {
                    int index = CompressIndexes.readInt(stream);
                    String orig = provider.getString(index);
                    out.write(1);
                    out.writeUTF(orig);
                    continue block6;
                }
                case 25: {
                    String orig = StringSharingDecompressor.reconstruct(provider, stream);
                    out.write(1);
                    out.writeUTF(orig);
                    continue block6;
                }
                case 5: 
                case 6: {
                    ++i;
                }
                default: {
                    out.write(tag);
                    int size = SIZES[tag];
                    byte[] arr = new byte[size];
                    stream.readFully(arr);
                    out.write(arr);
                }
            }
        }
        out.write(transformed, transformed.length - stream.available(), stream.available());
        out.flush();
        return outStream.toByteArray();
    }

    private static String reconstruct(ResourceDecompressor.StringsProvider reader, DataInputStream cr) throws IOException {
        int descIndex = CompressIndexes.readInt(cr);
        String desc = reader.getString(descIndex);
        byte[] encodedDesc = StringSharingDecompressor.getEncoded(desc);
        int indexes_length = CompressIndexes.readInt(cr);
        byte[] bytes = new byte[indexes_length];
        cr.readFully(bytes);
        List<Integer> indices = CompressIndexes.decompressFlow(bytes);
        ByteBuffer buffer = ByteBuffer.allocate(encodedDesc.length * 2);
        buffer.order(ByteOrder.BIG_ENDIAN);
        int argIndex = 0;
        for (byte c : encodedDesc) {
            if (c == 76) {
                buffer = StringSharingDecompressor.safeAdd(buffer, c);
                int index = indices.get(argIndex);
                ++argIndex;
                String pkg = reader.getString(index);
                if (pkg.length() > 0) {
                    pkg = pkg + "/";
                    byte[] encoded = StringSharingDecompressor.getEncoded(pkg);
                    buffer = StringSharingDecompressor.safeAdd(buffer, encoded);
                }
                int classIndex = indices.get(argIndex);
                ++argIndex;
                String clazz = reader.getString(classIndex);
                byte[] encoded = StringSharingDecompressor.getEncoded(clazz);
                buffer = StringSharingDecompressor.safeAdd(buffer, encoded);
                continue;
            }
            buffer = StringSharingDecompressor.safeAdd(buffer, c);
        }
        byte[] encoded = buffer.array();
        ByteBuffer result = ByteBuffer.allocate(encoded.length + 2);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putShort((short)buffer.position());
        result.put(encoded, 0, buffer.position());
        ByteArrayInputStream stream = new ByteArrayInputStream(result.array());
        DataInputStream inStream = new DataInputStream(stream);
        String str = inStream.readUTF();
        return str;
    }

    public static byte[] getEncoded(String pre) throws IOException {
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        DataOutputStream resultOut = new DataOutputStream(resultStream);
        resultOut.writeUTF(pre);
        byte[] content = resultStream.toByteArray();
        if (content.length <= 2) {
            return new byte[0];
        }
        return Arrays.copyOfRange(content, 2, content.length);
    }

    private static ByteBuffer safeAdd(ByteBuffer current, byte b) {
        byte[] bytes = new byte[]{b};
        return StringSharingDecompressor.safeAdd(current, bytes);
    }

    private static ByteBuffer safeAdd(ByteBuffer current, byte[] bytes) {
        if (current.remaining() < bytes.length) {
            ByteBuffer newBuffer = ByteBuffer.allocate((current.capacity() + bytes.length) * 2);
            newBuffer.order(ByteOrder.BIG_ENDIAN);
            newBuffer.put(current.array(), 0, current.position());
            current = newBuffer;
        }
        current.put(bytes);
        return current;
    }

    @Override
    public String getName() {
        return "compact-cp";
    }

    public StringSharingDecompressor(Properties properties) {
    }

    @Override
    public byte[] decompress(ResourceDecompressor.StringsProvider reader, byte[] content, int offset, long originalSize) throws Exception {
        return StringSharingDecompressor.normalize(reader, content, offset);
    }

    static {
        StringSharingDecompressor.SIZES[3] = 4;
        StringSharingDecompressor.SIZES[4] = 4;
        StringSharingDecompressor.SIZES[5] = 8;
        StringSharingDecompressor.SIZES[6] = 8;
        StringSharingDecompressor.SIZES[7] = 2;
        StringSharingDecompressor.SIZES[8] = 2;
        StringSharingDecompressor.SIZES[9] = 4;
        StringSharingDecompressor.SIZES[10] = 4;
        StringSharingDecompressor.SIZES[11] = 4;
        StringSharingDecompressor.SIZES[12] = 4;
        StringSharingDecompressor.SIZES[15] = 3;
        StringSharingDecompressor.SIZES[16] = 2;
        StringSharingDecompressor.SIZES[18] = 4;
        StringSharingDecompressor.SIZES[19] = 2;
        StringSharingDecompressor.SIZES[20] = 2;
    }
}

