#ifndef FAULTCODE_H
#define FAULTCODE_H
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>


/*故障码类型A can报文轮询发送方式*/
#define FaultCodeType_A     1


#define FaultCodeType       FaultCodeType_A

#define MaxFaultCode 40
#define FaultCodeCount 5000

typedef enum
{
    DTC1,
    DTC2,
    DTC3,
    NUM_FAULT_TYPES,
} FaultCodeType_Num;

typedef uint32_t (*FaultCodeCallback)(void);    /* 故障码回调函数 */
typedef uint16_t (*FaultCodeNumback)(void);     /* 故障码个数回调函数 */
typedef uint16_t (*FaultCodeValidback)(void);     /* 故障码有效回调函数 */

typedef struct
{
    uint32_t u16FaultCode;          /* 故障码 */
    uint16_t u16FaultCodeCount;     /* 故障码总数 */
} _st_FaultCode;



typedef struct
{
    FaultCodeCallback callbacks[NUM_FAULT_TYPES];
    FaultCodeNumback FaultCodeNumCbk;
    FaultCodeValidback FaultCodeVaildCbk;

} _st_Init;




extern void FaultCode_Service(uint16_t Cycle);

extern void FaultCode_Init(void);



extern uint32_t Get_Current_FaultCode(void);
extern uint8_t Get_Current_Hight_FaultCode(void);
extern uint8_t Get_Current_Hight_FaultCode(void);
extern uint8_t Get_FaultCode_Valid(void);

#endif