#include "AMT630H.h"
#include <stdint.h>
#include "UartProtocol.h"
#include "Components.h"
#include "PicBin.h"
#include "GpioUser.h"
__align(4) /* 四字节对齐 */
//#include "AMT630H_Datas.h"
#define AMT630H_ERR_TIME            10000U
#define AMT630H_RELEASE_MODE        1U
unsigned int AMT630H_InitTime = 0;
uint8_t g_sysFlag_Lcdcheck = 0;
/* Initialization */
LCD_TFT_SOUND_PARA_ST LcdSoundParamterData;
SOFTWARE_VERSION_ST amt630Version;

uint8_t Amt630hInitFinishFlag = 0;

uint32_t Amt630hInitTimerCnts = 0;
uint32_t Amt630hSequentialTimerCnts = 0;
uint32_t Amt630hFlashCheckTimerCnts = 0;
uint32_t Amt630hServiceTimerCnts = 0;


/* SOC Error */
uint16_t AMT630H_REQ_Time[ALIVE_COUNTER_TOTAL] = { 0 };
uint8_t AMT630H_Err = 0U;
uint8_t AMT630H_AliveCounter[ALIVE_COUNTER_TOTAL] = { 0 };
uint16_t AMT630H_CrcErrTime = 0;
uint32_t AMT630H_CrcErrCounter = 0;
uint8_t AMT630H_CrcErrMaxCounter = 0;

/* Flash Check */
#define  FLASH_CHECK_TIME_NUM       20000
s_AMT630H_FlashCheck_t AMT630H_FlashCheck;

/* Delay Time */
unsigned long Delay_Time = 0;
unsigned long Delay_Time_Set = 0;

extern uint32_t Check_Upgrade;
extern uint32_t Check_Upgrade_Cnt;

/* Refresh Time */
unsigned long AMT630H_RefreshTime = 0;
static uint8_t AMT630H_Animation_Start = 0;
static uint8_t AMT630H_Animation_Finish = 0;
static uint16_t AMT630H_Animation_DispPic = 0;
static uint16_t AMT630H_Animation_RefreshTime = 0;
static uint32_t AMT630H_Animation_RefreshTime_default = 0;
static const uint16_t BootAnimationList[AMT630H_ANIMATION_PIC_NUM] = {
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1125_0_0,
    Pic_1124_0_0,
    Pic_1123_0_0,
    Pic_1122_0_0,
    Pic_1121_0_0,
    Pic_1120_0_0,
    Pic_1119_0_0,
    Pic_1118_0_0,
    Pic_1117_0_0,
    Pic_1116_0_0,
    Pic_1115_0_0,
    Pic_1114_0_0,
    Pic_1113_0_0,
    Pic_1112_0_0,
    Pic_1111_0_0,
    Pic_1110_0_0,
    Pic_1109_0_0,
    Pic_1108_0_0,
    Pic_1107_0_0,
    Pic_1106_0_0,
    Pic_1105_0_0,
    Pic_1104_0_0,
    Pic_1103_0_0,
    Pic_1102_0_0,
    Pic_1101_0_0,
    Pic_1100_0_0,
    Pic_1099_0_0,
    Pic_1098_0_0,
    Pic_1097_0_0,
    Pic_1096_0_0,
    Pic_1095_0_0,
    Pic_1094_0_0,
    Pic_1093_0_0,
    Pic_1092_0_0,
    Pic_1091_0_0,
    Pic_1090_0_0,
    Pic_1089_0_0,
    Pic_1088_0_0,
    Pic_1087_0_0,
    Pic_1086_0_0,
    Pic_1085_0_0,
    Pic_1084_0_0,
    Pic_1083_0_0,
    Pic_1082_0_0,
    Pic_1081_0_0,
    Pic_1080_0_0,
    Pic_1079_0_0,
    Pic_1078_0_0,
    Pic_1077_0_0,
    Pic_1076_0_0,
    Pic_1075_0_0,
    Pic_1074_0_0,
    Pic_1073_0_0,
    Pic_1072_0_0,
    Pic_1071_0_0,
    Pic_1070_0_0,
    Pic_1069_0_0,
    Pic_1068_0_0,
    Pic_1067_0_0,
    Pic_1066_0_0,
    Pic_1065_0_0,
    Pic_1064_0_0,
    Pic_1063_0_0,
    Pic_1062_0_0,
    Pic_1061_0_0,
    Pic_1060_0_0,
    Pic_1059_0_0,
    Pic_1058_0_0,
    Pic_1057_0_0,
    Pic_1056_0_0,
    Pic_1055_0_0,
};
void AMT630H_Animation_PlayProc(uint16_t PicIndex)
{
    // unsigned char *pBuf;
    // uint32_t tmpLen = 0;
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0); 
    SetPageBackground(GRAPHICS_PAGE_0, PicIndex);
    // if (AMT630H_Animation_DispPic == (AMT630H_ANIMATION_PIC_NUM - 30)) 
    // {
    //     IOState = IOState | 0x02;
    //     PackedTransfer_EasyNavigation(IOState);
    // }
    // else 
    // {
    //     IOState = IOState & 0x01;
    //     PackedTransfer_EasyNavigation(IOState);
    // }
    PackedTransfer_Page();
  //  PackedTransfer_GetSwVer();

}
/* Timer */
void AMT630H_Timer(unsigned char Tms)
{
    unsigned char i = 0U;

    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_REQ_Time[i] < AMT630H_ERR_TIME)
        {
            AMT630H_REQ_Time[i] += Tms;
        }
    }
    if(AMT630H_RefreshTime < AMT630H_REFRESH_TIME)
    {
        AMT630H_RefreshTime += Tms;
    }
    if(Delay_Time < Delay_Time_Set)
    {
        Delay_Time += Tms;
    }
    if(AMT630H_InitTime < 5000)
    {
        AMT630H_InitTime += Tms;
    }
    if(AMT630H_Animation_Finish == 0)
    {
        if(AMT630H_Animation_RefreshTime < AMT630H_ANIMATION_TIME)
        {
            AMT630H_Animation_RefreshTime += Tms;
        }
    }
    else
    {
        AMT630H_Animation_RefreshTime = 0;
    }
}
void Delay_Time_Ctrl(unsigned long Tms)
{
    Delay_Time = 0;
    Delay_Time_Set = Tms;

    while(Delay_Time < Delay_Time_Set)
    {
        RTE_WDT_Clear();
    }

    Delay_Time = 0;
    Delay_Time_Set = 0;
}

uint8_t UartRevBuff[0x1000] = { 0 };
uint32_t UartRevCnts = 0;
void Amt630hUartRecvData(uint16_t u16UARTData)
{
    UartRevBuff[UartRevCnts++] = (u16UARTData & 0xff);
    if (UartRevCnts >= 0x1000) 
    {
        UartRevCnts = 0;
    }
}
void AMT630H_RstCtrl(void)
{
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);//630
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 0);//630
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);//lcd
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);//lcd
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 1);   
    Delay_Time_Ctrl(15);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 1);
    Delay_Time_Ctrl(45);
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 1); 
    Delay_Time_Ctrl(15); 
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 1); 
    Delay_Time_Ctrl(10);
    RTE_GPIO_Set_Level(x1530_EN_MCU, 1);//1530
   
}
void Amt630hInit(void)
{
    uint8_t i = 0;
    AMT630H_RstCtrl();
    AMT630H_RefreshTime = AMT630H_REFRESH_TIME;
    // Error State Init
    AMT630H_Err = 0U;
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        AMT630H_REQ_Time[i] = 0U;
        AMT630H_AliveCounter[i] = 0;
    }
    AMT630H_CrcErrTime = 0;
    AMT630H_CrcErrCounter = 0;

    // Param Config
    LcdSoundParamterData.LcdWidth = 1024;
    LcdSoundParamterData.LcdHeight = 600;
    LcdSoundParamterData.LcdBpp = 32;
    LcdSoundParamterData.LcdVideoInputValid = 0;
    LcdSoundParamterData.Ark7116ResetPin = 0;
    LcdSoundParamterData.LcdInterfaceType = LCD_INTERFACE_LVDS;
    LcdSoundParamterData.LcdWiringMode = LCD_WIRING_MODE_BGR;
    LcdSoundParamterData.LcdWiringBitOrder = LCD_WIRING_BIT_ORDER_MSB;
    LcdSoundParamterData.LcdDotClkReverse = 0;  /* NuoMa 50pin TFT */
    LcdSoundParamterData.LvdsPanelFormat = LVDS_PANEL_FORMAT_TI;
    LcdSoundParamterData.LvdsPanelData = LVDS_PANEL_DATA_8BIT;

    LcdSoundParamterData.LcdTimingVBP = 12;
    LcdSoundParamterData.LcdTimingVFP = 20;
    LcdSoundParamterData.LcdTimingVSW = 4;

    LcdSoundParamterData.LcdTimingHBP = 160;
    LcdSoundParamterData.LcdTimingHFP = 160;
    LcdSoundParamterData.LcdTimingHSW = 24;

    LcdSoundParamterData.LcdClkFreq = 51200000;

    LcdSoundParamterData.SoundChannelNum = 0;
    LcdSoundParamterData.SoundFreq = AUDIO_FREQ_48K;
    SetLcdSoundParameter(&LcdSoundParamterData);
    SetSwVerBuf((uint8_t*)&amt630Version);

    User_PicIndexDataInit();
    ResetInitedState();    

    AnalysisUartData();

    AMT630H_InitTime = 0;

    AMT630H_Animation_Start = 0;
    // AMT630H_Animation_Finish = 0;
    // AMT630H_Animation_DispPic = 0;
    AMT630H_Animation_RefreshTime = 0;
    AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);

    Amt630hInitFinishFlag = 0;

    AMT630H_FlashCheck.Flag = 0;
    AMT630H_FlashCheck.InquireTime = 0;
    AMT630H_FlashCheck.CheckStateTime = 0;
    AMT630H_FlashCheck.Result = 0;
    Check_Upgrade = 0;
    Check_Upgrade_Cnt = 0;
}
void AMT630H_Sleep(void)
{
    RTE_GPIO_Set_Level(STBYB_LCD_MCU, 0);    
    Delay_Time_Ctrl(30);    
    RTE_GPIO_Set_Level(VCC_33_EN_MCU, 0);
    RTE_GPIO_Set_Level(VCC1V2_AMT_EN, 0);
    RTE_GPIO_Set_Level(MCU_RSTB_LCD, 0);
    
}
static void AMT630H_AliveCounterMonitor(void)
{
    uint8_t i = 0;
    if(AMT630H_CrcErrCounter != GetCrcErrCnts())
    {
        AMT630H_CrcErrCounter = GetCrcErrCnts();
        AMT630H_CrcErrTime++;
        if(AMT630H_CrcErrTime >= 120)
        {
            AMT630H_Err = 1;
        }
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0;
        }
    }
    for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
    {
        if(AMT630H_AliveCounter[i] != GetAliveCounter(i))
        {
            AMT630H_AliveCounter[i] = GetAliveCounter(i);
            AMT630H_REQ_Time[i] = 0;
            if(AMT630H_CrcErrMaxCounter < AMT630H_CrcErrTime)
            {
                AMT630H_CrcErrMaxCounter = (unsigned char)AMT630H_CrcErrTime;
            }
            AMT630H_CrcErrTime = 0;
        }
        if(AMT630H_REQ_Time[i] >= AMT630H_ERR_TIME)
        {
            AMT630H_Err = 1;
        }
    }
}

void AMT630H_Main(void)
{
    unsigned char i;
    AnalysisUartData();
        
    if(GetLcdInitSt() != 1)
    {
        for(i = 0; i < ALIVE_COUNTER_TOTAL; i++)
        {
            AMT630H_REQ_Time[i] = 0U;           
        }
        return;
    }
    AMT630H_AliveCounterMonitor();
    if(AMT630H_Err == 1U)
    {
        AMT630H_Err = 0;
        Amt630hInit();
        AMT630H_Animation_Finish = 1;
        return;
    }
    // if(g_sysFlag_Lcdcheck == 1)
    // {
    //     if(AMT630H_FlashCheck.Flag == 0)
    //     {
    //         AMT630H_FlashCheck.Flag = 1;
    //         AMT630H_FlashCheck.InquireTime = 0;
    //         AMT630H_FlashCheck.CheckStateTime = 0;
    //         PackedTransfer_CheckFlash();           
    //         AMT630H_FlashCheck.Result = 0xFF;
    //     }
    //     if(AMT630H_FlashCheck.Flag == 1)
    //     {
    //         if(AMT630H_FlashCheck.InquireTime >= 100)
    //         {
    //             AMT630H_FlashCheck.InquireTime = 0;
    //             AMT630H_FlashCheck.Result = PackedTransfer_CheckFlashGetResult();
    //             if(AMT630H_FlashCheck.Result != 0xFF)
    //             {
    //                 if(AMT630H_FlashCheck.Result == 1)
    //                 {
    //                     PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_PASS, 3000);
    //                     AMT630H_FlashCheck.Flag = 2;
    //                 }
    //                 else if (AMT630H_FlashCheck.CheckStateTime >= FLASH_CHECK_TIME_NUM)
    //                 {
    //                     PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECK_FAIL, 60000);
    //                     AMT630H_FlashCheck.Flag = 2;
    //                 }
    //             }
                
    //         }
    //         else
    //         {
    //             PackedTransfer_CheckFlashForceDisplay(DISPLAY_CHECKING, 60000);
    //         }
    //     }
    // }
    if (SYS_OPR_STAT_IGN_ON)
    {
        if(AMT630H_Animation_Finish == 1)
        {
            AMT630H_Animation_RefreshTime = 0;
            if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
            {                
                AMT630H_RefreshTime = 0;
                AMT630H_GUI_DisplayProc();
                //SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);
                //SetPageBackground( GRAPHICS_PAGE_0, Pic_0001_0_0 );
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0002_751_440);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0003_681_441);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0005_521_444);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0010_90_443);
                //SetPagePic(GRAPHICS_PAGE_0, Pic_0012_0_95);
                //PackedTransfer_Page();
            }
        }
        else
        {
            AMT630H_RefreshTime = 0;
            if(AMT630H_Animation_Start == 0)
            {
                AMT630H_Animation_Start = 1;                
                AMT630H_Animation_RefreshTime_default = AMT630H_ANIMATION_REFRESHTIME_DEF(0);
            }
            if(AMT630H_Animation_RefreshTime >= AMT630H_Animation_RefreshTime_default)
            {
                AMT630H_Animation_RefreshTime = 0;
                AMT630H_Animation_PlayProc(BootAnimationList[AMT630H_Animation_DispPic]);
                AMT630H_Animation_DispPic++;
                if(AMT630H_Animation_DispPic >= AMT630H_ANIMATION_PIC_NUM)
                {
                    AMT630H_Animation_Finish = 1;
                }
            }
        } 
        

    }
    else
    {
        PicObj.qr_logo_id = 0;//Pic_0234 小数字9  EA
        PicObj.main_pic_id = Pic_0001; //转速红12
        PicObj.update_pic_id = Pic_0233;//小数字8   E9
        PicObj.second_menu = 0;
        PicObj.navigation_task_id = Pic_0411;//红色小e  19B
        if(g_u8Display_Mode == ModeDAY)
        {
            PicObj.qr_pic_id =  Pic_0494;//请使用猎变APP扫码连接 
        }
        else
        {
            PicObj.qr_pic_id =  Pic_1031;//请使用猎变APP扫码连接
        } 
        if(AMT630H_RefreshTime >= AMT630H_REFRESH_TIME)
        {
            AMT630H_RefreshTime = 0;
            //AMT630H_GUI_DisplayProc();
            SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);
            PackedTransfer_DisplayPhoneMirrorQRcode(0, PicObj);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
            PackedTransfer_Page();
        }
    }
}

unsigned char AMT630H_isInitFinish(void)
{
    if((AMT630H_InitTime >= 600) || (GetLcdInitSt() == 1))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

void AMT630H_Animation_IGON(void)
{
    AMT630H_Animation_Finish = 0;
    AMT630H_Animation_DispPic = 0;
}
unsigned char AMT630H_Animation_Finish_Flage(void)
{
    if(AMT630H_Animation_Finish == 1)
    {
        return 1;
    }
    else
    {
        return 0;
    }
    
}
