#include "PowerManagement.h"
#include "Components.h"

//RTC_Information_st_t g_stRTCInformation;

static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);

static Power_Status_em Power_Stay_ON(void);
static Power_Status_em Power_Stay_OFF(void);
static Power_Status_em Power_Stay_Protect(void);
static Power_Status_em Power_Stay_Sleep(void);



static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

static void Power_KL30_Init(void)
{

//    ClearODO_Flag = 0;

    Gpio_Init(Gpio_KL30_Init);
    eeprom_StoreInfo_Init();

    Analog_Signal_Conv_Init();

   BackLight_Init();
//    Sys_KL30_Init();
//    Checkself_Init();
    //Data_Vehicle_Speed_KL30_Init();
    //Data_Engine_Speed_KL30_Init();
//    LINE_IN_Init();
   Key_KL30_Init_EXample();
   //Light_Sensor_Init_Example();//注意顺序1

    Data_User_Mileage_KL30Init();
   Fuel_KL30_Init();

   TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 64000000);
   TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
//    Telltales_Auto_Start_Stop();
//    Telltales_Init();
//    MenuData_Unit_Init();
//    g_stRTCInformation.u8RTCSecond = 0;
//	g_stRTCInformation.u8RTCMinute = 0;
//	g_stRTCInformation.u8RTCHour = 0;          
//	g_stRTCInformation.u8RTCDayOfMonth = 1;
//	g_stRTCInformation.u8RTCMonth = 1;   
//	g_stRTCInformation.u8RTCYear = 20; 
//    RTE_RTC_Init(g_stRTCInformation);
//    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(WAKEUP_KL15_In,Trigger_Rising);
    Protocol_KL30_Wakeup_Init();
}
//extern uint32_t PowerIgnOffTimeLine;
static void Power_Wakeup_Init(void)
{
//    PowerIgnOffTimeLine = 0;

    Gpio_Init(Gpio_WakeUp_Init);

    eeprom_StoreInfo_Init();
    Analog_Signal_Conv_Init();
    Data_User_Mileage_WakeupInit();

   BackLight_Init();
//    Sys_WakeUp_Init();
    // Data_Vehicle_Speed_KL30_Init();
    // Data_Engine_Speed_KL30_Init();
//    LINE_IN_Init();
   Key_Wakeup_Init_EXample();
   Line_In_KL15_ON_Init();
   //Light_Sensor_Init_Example();//注意顺序1
   Fuel_KL30_Init();

   TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 64000000);
   TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
//    Telltales_Init();
//    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(WAKEUP_KL15_In,Trigger_Rising);
    Protocol_KL30_Wakeup_Init();
}

static void Power_LVP_Init(void)
{
    
}
static void Power_OVP_Init(void)
{
    
}

static void Power_IG_OFF_Init(void)
{
   Line_In_KL15_OFF_Init();
//    Checkself_Init();
}

static void Power_IG_ON_Init(void)
{
//    ClearODO_Flag = 0;
   BackLight_Init();
//    Checkself_Init();
   Line_In_KL15_ON_Init();
//    Telltales_KL15_Init();
   Fuel_KL15_Init();

//    Telltales_Auto_Start_Stop();
    // Data_Vehicle_Speed_KL15_Init();
    // Data_Engine_Speed_KL15_Init();
}

static void Power_Sleep_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 400, 0);
//	//RTC_Stop();
//	rte_can_deinit(CAN_CH_0);
	TMM0_Stop();
	TMM1_Stop();
    TMM_All_Stop();
   RTE_ADC_DeInit();
//	//CGC->CSC = 1 ;   //HIOSTOP = 1

    Gpio_Init(Gpio_Sleep_Init);

   
   Analog_Signal_Conv_Stop();
//    RTE_DEEPSLEEP_Enable();
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_ON;

   if (SYS_OPR_STAT_IGN_OFF)
   {
       u8PowerSts = EM_IGN_OFF_Init;
   }

   if (SYS_OPR_STAT_HALT)
   {
       u8PowerSts = EM_IGN_LIMIT;
   }

    return u8PowerSts;
}
static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_OFF;

   if (SYS_OPR_STAT_IGN_ON)
   {
       u8PowerSts = EM_IGN_ON_Init;
   }
   else
   {
       if ((Common_GetIgnOffTime() < 20000))
       {
           u8PowerSts = EM_IGN_OFF;
       }
       else
       {
           u8PowerSts = EM_IGN_Sleep_Init;
       }
   }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
   Power_Status_em u8PowerSts;
//    static uint8_t  i;
   static uint8_t  Delaycnt;


   /* 关闭所有外设，坪保留AD采集，电溝状思切�? */
   {

        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
   }
   u8PowerSts = EM_IGN_OFF_Init;
   /* 电溝模弝正常 */
   for ( ;; )
   {
       RTE_WDT_Clear();
       Gen_TimeDelay(2000u, 50u);
       Analog_Signal_Conv_Service();
       Sys_Status_Update_Service();

       if ( SYS_OPR_STAT_RUN )
       {
           return u8PowerSts;
       }
   }
}

static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_Sleep;

   while (1)
   {
       RTE_WDT_Clear();
       if (RTE_GPIO_Get_Level(KL15_AD_IN))/* KL15 */
       {
           u8PowerSts = EM_IGN_Wakeup;
           break;
       }
   }

    return u8PowerSts;
}


