#ifndef FAULTCODE_H
#define FAULTCODE_H
#include <stdint.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>




#define MaxFaultCode 72
#define FaultCodeCount 5000
#define DISP_TIMER 500


typedef uint32_t(*Get_FaultCode)(void);
typedef uint8_t(*Get_FaultCodeNum)(void);
typedef struct __attribute__((aligned(4)))
{
    uint32_t *code_list;                    //故障码列表
    uint8_t hade;                           //列表头
    uint8_t tail;                           //列表尾
    uint16_t code_num;                       //获取的故障码数量
    uint8_t len;                            //故障码列表最大长度
    uint8_t disp;                           //故障码显示下标
    uint16_t TimeCount;                     //故障码循环显示用的定时器
    uint16_t disp_timer;                    //故障码显示的超时时间，超时显示下一个
    Get_FaultCode Get_FaultCode1_cbk;       //获取故障码的回调函数1
    Get_FaultCode Get_FaultCode2_cbk;       //获取故障码的回调函数2
    Get_FaultCodeNum Get_FaultCodeNum_cbk;  //获取故障码数量的回调函数
}FaultCodeList_t;

uint8_t List_Init(FaultCodeList_t *CodeList, uint32_t Arr[], uint8_t Len);

void FaultCode_Init(void);
void FaultCode_Servers(void);



extern uint32_t Get_Current_FaultCode(void);
extern uint8_t Get_Current_Hight_FaultCode(void);
extern uint8_t Get_Current_Mid_FaultCode(void);
// extern uint8_t Get_FaultCode_Valid(void);

#endif