#include  "CAN_CH0_CAN_Communication_Matrix.h"
/* 2024/06/20 16:36:58 */
st_CanMsgOp CAN_CH0_CanMsgOp;
st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_CH0 &CAN_CH0_CanMsgOp

const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] =
{
    {0}
};

const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] =
{
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x101ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x111ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x401ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x402ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x12Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        5000ul,
        0x450ul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
    {
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        {0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u},
        500ul,
        0x37Bul,
        (( void * )0),
        (( void * )0),
        (( void * )0),
    },
};

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_101_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 6u) >> 7u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 6u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 6u) >> 5u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 6u) >> 4u) & 0x01u));
}

uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Temperature(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 4u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Throttle_Position(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_101_Sig_ECU_Vehicle_Speed(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_101_Sig_ECU_Engine_Speed(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_101_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_111_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Tair_Enable(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 6u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Power_Enable(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 4u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_SideStand(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 3u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Power(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 2u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Ready(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 1u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Batt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 4u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 3u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff_State(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 2u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_Autostop(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 1u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_111_Sig_ISG_Engine_InjIgn_Cutoff(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_111_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Checksum(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_401_Livecounter(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 6u) >> 0u) & 0x0Fu));
}

uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Fuel_Consumption(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 3u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_401_Sig_ECU_Battery_Voltage(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint16_t Get_CAN_CH0_ID_401_Sig_ECU_Environment_Presure(void)
{
    return (((uint16_t)((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 0u) >> 0u) & 0xFFu) << 8u) + \
    ((uint16_t)((uint16_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_401_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_Warning_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 7u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 6u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 5u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH2(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 4u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTC1Amnt(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 3u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCL1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 2u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCM1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 1u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_402_Sig_ECU_DTCH1(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_402_Msg_Count, 0u) >> 0u) & 0xFFu));
}

uint8_t  Get_CAN_CH0_ID_12B_Sig_Abs_warning_lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_12B_Msg_Count, 4u) >> 1u) & 0x03u));
}

uint8_t  Get_CAN_CH0_ID_450_Sig_Dashboard_TCSFunSwitch(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_450_Msg_Count, 1u) >> 0u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_450_Sig_ABSOFF_Selection(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_450_Msg_Count, 0u) >> 0u) & 0x01u));
}

uint8_t  Get_CAN_CH0_ID_37B_Sig_TCS_Work_Mode(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_37B_Msg_Count, 3u) >> 4u) & 0x0Fu));
}

uint8_t  Get_CAN_CH0_ID_37B_Sig_TCS_Warning_Lamp(void)
{
    return (((uint8_t)((uint8_t)CAN_MSG_Read(CAN_CH0,CAN_CH0_ID_CH0_37B_Msg_Count, 3u) >> 2u) & 0x01u));
}

uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID)
{
    uint8_t u8Result = CAN_CH0_ID_TOTAL_MAX;
    switch (MsgID)
    {
    case CAN_CH0_ID_CH0_101_Msg:
        u8Result = CAN_CH0_ID_CH0_101_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_111_Msg:
        u8Result = CAN_CH0_ID_CH0_111_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_401_Msg:
        u8Result = CAN_CH0_ID_CH0_401_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_402_Msg:
        u8Result = CAN_CH0_ID_CH0_402_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_12B_Msg:
        u8Result = CAN_CH0_ID_CH0_12B_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_450_Msg:
        u8Result = CAN_CH0_ID_CH0_450_Msg_Count;
        break;
    case CAN_CH0_ID_CH0_37B_Msg:
        u8Result = CAN_CH0_ID_CH0_37B_Msg_Count;
        break;
    default :
        u8Result = CAN_CH0_ID_TOTAL_MAX;
        break;
    }
    return u8Result;
}

