#include "BackLight.h"
#include "Components.h"
#define LIGHT_DATA_TIME 10u /*这里填写多长时间采集一个数据，单位ms*/
#define LIGHT_DATA_NUM 20u  /*燃油电阻采集数据总数 最大255*/
#define LIGHT_CAL_START 5u  /*数据排序后取中间部分计算平均：起始*/
#define LIGHT_CAL_END 15u   /*数据排序后取中间部分计算平均：结束*/
Light_uint8_t LightADCompleteFlg = 0u;
Light_uint16_t LightR = 0u;
Light_uint16_t LightR_Status = 0;
Light_uint16_t LightR_Status_Count = 0u;
Light_uint16_t NtcDataCount;
Light_uint16_t NtcData[LIGHT_DATA_NUM] = {0};
typedef struct
{
    uint8_t u8Lvl;
    uint8_t Pos_Lamp_Sts;

	uint16_t u16DialcurDuty;
    uint16_t u16DialdestDuty;
    uint16_t u16DialDampingTimer;

	uint16_t u16TftcurDuty;
    uint16_t u16TftdestDuty;
    uint16_t u16TftDampingTimer;

    uint8_t destFactor;
    uint8_t curFactor;
    uint16_t Ntc_Timer;
} _Back_Light_Struct;



_Back_Light_Struct g_stBL;


typedef enum
{
    Light_Lvl_0 = 0,
    Light_Lvl_1,
    Light_Lvl_2,
    Light_Lvl_3,
    Light_Lvl_4,
    Light_Lvl_5,
    Light_Lvl_6,
    Light_Lvl_Max, 
}_BL_LVL_Enum;

void BackLight_Back_PWM_Init(void); 

void BackLight_30_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    BackLight_Set_Lvl(Light_Lvl_4); 
	g_stBL.curFactor = 100;
}

void BackLight_15_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    g_stBL.curFactor = 100;
}

void BackLight_WakeUp_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    g_stBL.curFactor = 100;
}

void BackLight_Sleep_Init(void)
{
	TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
}

void BackLight_Back_PWM_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
}

uint16_t NTCDegreesBoard[] = 
{
	550, 
    600, 
    650, 
    700, 
    750, 
    800, 
    850, 
    900, 
    950, 
    1000,
};

uint16_t NTCResBoard[] = 
{
    27091,
    22224,
    18323,
    15184,
    12635,
    10566,
    8873,
    7481,
    6337,
    5384,
};

/**
 * @brief 实现数据的渐变效果
 * 该函数用于更新当前值，使其逐渐接近目标值，渐变的步长由step参数控制。同时，通过timer参数来实现一定的延迟效果，
 * 仅当计时器达到或超过预设的timedelay时，才会进行一次渐变操作。这有助于平滑数据的变化，避免突变。
 * @param cur 当前值的指针，函数将更新这个值
 * @param dest 目标值，当前值将逐渐变化到这个值
 * @param step 每次变化的步长
 * @param timer 计时器的指针，用于实现变化的延迟
 * @param timedelay 延迟的时间阈值，当计时器达到或超过这个值时，才会进行变化
 */
void U16_Data_Gradient(Light_uint16_t *cur, Light_uint16_t dest, Light_uint16_t step, Light_uint16_t *timer, const Light_uint16_t timedelay)
{
    if (*cur > dest)
    {
        if ((*cur - dest) > step)
        {
            if (*timer >= timedelay)
            {
                (*cur) -= step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
    else
    {
        if ((dest - *cur) > step)
        {
            if (*timer >= timedelay)
            {
                (*cur) += step;
                (*timer) = 0;
            }
            else
            {
                (*timer)++;
            }
        }
        else
        {
            *cur = dest;
            *timer = 0;
        }
    }
}

uint16_t NTC_Get_Degrees(uint16_t *ResBoard, uint16_t *DegreesBoard, uint8_t size, uint16_t input)
{
	uint8_t i = 0;
	uint16_t ret = 0;
	uint32_t temp = 0;
	if(input >= ResBoard[0])
	{
		ret = DegreesBoard[0];
	}
	else if(input <= ResBoard[size-1])
	{
		ret = DegreesBoard[size-1];
	}
	else
	{
		for(i=0; i<size-1; i++)
		{
			if((input < ResBoard[i] )&&(input >= ResBoard[i+1]))
			{
				temp = DegreesBoard[i+1] - DegreesBoard[i];
				temp *= (ResBoard[i] - input);
				temp /= (ResBoard[i] - ResBoard[i+1]);
				temp += DegreesBoard[i];
				ret = (uint16_t)temp;
				break;
			}
		}
	}

	return ret;
}


void BackLight_Get_curDuty(void)
{
	uint16_t tftBL = 0;
	uint16_t dialBL = 0;
	uint16_t NTCDegrees = 0;
	uint16_t NTCresistance = 0; 	 
	uint32_t wtemp = 0;
	/* 获取NTC阻值 */
	NTCresistance = ADC_Read_Signal(ADC_CH_NTC_TEMP);
	/* 计算温度值 */
	NTCDegrees = NTC_Get_Degrees(NTCResBoard ,NTCDegreesBoard, sizeof(NTCResBoard)/sizeof(uint16_t), NTCresistance);
    if ( NTCDegrees < 600 )   
	{
		g_stBL.destFactor = 100;
	}
    else if ( NTCDegrees <= 850 )
	{
		wtemp = (850 - NTCDegrees);
		wtemp *= 1;
		wtemp += 700;
		wtemp /= 10;
		g_stBL.destFactor = wtemp;
		/* 85°为70%占空比，60°为95%占空比, 1°大概为1% */
	}
    else if(NTCDegrees <= 880 )
	{
		wtemp = (880 - NTCDegrees);
		wtemp *= 16;
		wtemp += 200;
		wtemp /= 10;
		g_stBL.destFactor = wtemp;
		/* 88°为20%占空比，85°为70%占空比, 1°大概为16.6% */
	}
    else if(NTCDegrees <= 900 )
	{
		wtemp = (900 - NTCDegrees);
		wtemp *= 5;
		wtemp += 100;
		wtemp /= 10;
		g_stBL.destFactor = wtemp;
		/* 90°为10%占空比，88°为20%占空比, 1°大概为5% */
	}
    else
    {
        g_stBL.destFactor = 10;
    }

	if ( (g_stBL.curFactor < g_stBL.destFactor) && (NTCDegrees < 750) )
    {
        if ( g_stBL.Ntc_Timer <= 400 )    
            g_stBL.Ntc_Timer++;
        else
        {
            g_stBL.Ntc_Timer = 0;
            g_stBL.curFactor++;
        }

        if ( g_stBL.curFactor >= g_stBL.destFactor )
            g_stBL.curFactor = g_stBL.destFactor;
    }
    else if ( g_stBL.curFactor > g_stBL.destFactor )
    {
        if ( g_stBL.Ntc_Timer <= 200 )    
            g_stBL.Ntc_Timer++;
        else
        {
            g_stBL.Ntc_Timer = 0;
            g_stBL.curFactor--;
        }

        if ( g_stBL.curFactor <= g_stBL.destFactor )
            g_stBL.curFactor = g_stBL.destFactor;
    }
        
	/* 背光等级 */
	switch (g_stBL.u8Lvl)
	{
		case Light_Lvl_0:
		{
			tftBL = 100;
			break;
		}
		case Light_Lvl_1:
		{
			tftBL = 200;
			break;
		}
		case Light_Lvl_2:
		default:
		{
			tftBL = 400;
			break;
		}
		case Light_Lvl_3:
		{
			tftBL = 600;
			break;
		}
		case Light_Lvl_4:
		{
			tftBL = 800;
			break;
		}
	}
/* 两路PWM的时候再启用 */
#if 0
	g_stBL.u16DialdestDuty = ( uint32_t )(( uint32_t )dialBL * ( uint32_t )g_stBL.curFactor / ( uint32_t )100);

	if(g_stBL.u16DialdestDuty < 100)
	{
		g_stBL.u16DialdestDuty = 100;
	}

    if(g_stBL.u16DialcurDuty < 100)
    {
        g_stBL.u16DialcurDuty = g_stBL.u16DialdestDuty;
    }
    else
    {
        U16_Data_Gradient((uint16_t *)&g_stBL.u16DialcurDuty, g_stBL.u16DialdestDuty, 1u,  (uint16_t *)&g_stBL.u16DialDampingTimer, 1u);
    }

#endif
    /* 计算具体应该多少占空比 */
	g_stBL.u16TftdestDuty = ( uint32_t )(( uint32_t )tftBL * ( uint32_t )g_stBL.curFactor / ( uint32_t )100);

    /* 确保目标占空比不小于100 */
	if(g_stBL.u16TftdestDuty < 100)
	{
		g_stBL.u16TftdestDuty = 100;
	}

    // /* 如果当前占空比小于100，那还是按照上次结果显示 */
    // if(g_stBL.u16TftcurDuty < 100)
    // {
    //     g_stBL.u16TftcurDuty = g_stBL.u16TftdestDuty;
    // }
    // /* 逐步逼近目标占空比 */
    // else
    // {
    //     U16_Data_Gradient((uint16_t *)&g_stBL.u16TftcurDuty, g_stBL.u16TftdestDuty, 1u,  (uint16_t *)&g_stBL.u16DialDampingTimer, 1u);
    // }
        g_stBL.u16TftcurDuty = g_stBL.u16TftdestDuty;
}

#if 0
/* 此项目用不上 */
//10MS
void BackLight_Control(void)
{
    uint16_t wtemp = 0;

	if(SYS_OPR_STAT_HALT)
	{
		PWM_Channel_Set_Duty(5, 0); 
		PWM_Channel_Set_Duty(3, 0);
		return;
	}

	if(Get_Core_StartStatus()  == Soc_Startup)
	{
		PWM_Channel_Set_Duty(5, 0); 
		PWM_Channel_Set_Duty(3, 0);
		return;
	}


    BackLight_Get_curDuty();

    if(Common_Get_IG_Sts() == COMMON_POWER_ON)
    {
        PWM_Channel_Set_Duty(5, g_stBL.u16DialcurDuty); 
		PWM_Channel_Set_Duty(3, g_stBL.u16TftcurDuty); 
    }
    else
    {
        PWM_Channel_Set_Duty(5, 0); 
		PWM_Channel_Set_Duty(3, 0);
    }
}
#endif
/* 获取当前背光等级 */
uint8_t BackLight_Get_Lvl(void )
{
	return g_stBL.u8Lvl;
}
/* 设置当前背光等级 */
void BackLight_Set_Lvl(Light_uint8_t lvl)
{
	g_stBL.u8Lvl = lvl;
}



void Data_Light_Res_service(Light_uint8_t deltaTime)//获取光感阻值，并做平均
{
    uint16_t LightRes = 0U;
    uint8_t i, j;
    uint32_t temp32;
    static uint16_t timeCount = 0;
    if (timeCount >= LIGHT_DATA_TIME)
    {
        timeCount = 0;
        if (NtcDataCount < LIGHT_DATA_NUM)
        {
            /*获取光敏电阻*/
            LightRes = ADC_Read_Signal(ADC_CH_LIGHT_SENSITIVE); // ADC_Read_Signal(ADC_CH_FUEL1);
            /*四舍五入*/
            if (LightRes < 32000)
            {
                if (LightRes % 10 >= 5)
                {
                    LightRes += 5;
                }
            }
            else
            {
                LightRes = 32000;
            }

            /*由小到大插入数据*/
            for (i = 0; i < NtcDataCount; i++)
            {
                if (LightRes < NtcData[i])
                {
                    break;
                }
            }
            for (j = NtcDataCount; j > i; j--)
            {
                NtcData[j] = NtcData[j - 1];
            }
            NtcData[i] = LightRes;
            NtcDataCount++;
        }
        else
        {
            /*一组数据采集完毕，取中间部分计算平均值*/
            temp32 = 0;
            for (i = LIGHT_CAL_START; i < LIGHT_CAL_END; i++)
            {
                temp32 += NtcData[i];
            }
            LightR = (uint16_t) (temp32 / (LIGHT_CAL_END - LIGHT_CAL_START));
            NtcDataCount = 0;
            LightADCompleteFlg = 1;
        }
    }
    timeCount += deltaTime;
}

/* 背光等级回调函数 */
Light_uint8_t Backlight_GetPwmLevel(void)
{
 	Light_uint8_t Backlight_PwmLevel;

    if(LightR > 0 && LightR <= 400)
    {
        Backlight_PwmLevel = 1U;
    }
    else if(LightR > 400 && LightR <= 800)
    {
        Backlight_PwmLevel = 2U;
    }
    else if(LightR > 800 && LightR <= 1400)
    {
        Backlight_PwmLevel = 3U;
    }
    else if(LightR > 1400 && LightR <= 2000)
    {
        Backlight_PwmLevel = 4U;
    }
    else if(LightR > 2000 && LightR <= 2600)
    {
        Backlight_PwmLevel = 5U;
    }
    return Backlight_PwmLevel;
}

/* 背光服务，10ms调用 */
void BackLight_Process(void)
{
	if(SYS_OPR_STAT_IGN_ON)
    {
        /* 自动模式，判断白天还是黑夜 */
        if(Menu_Item_Select_Get(MENU_ITEM_SELECT_AUTO))
        {
            if(LightADCompleteFlg)
            {
                if(g_u8Display_Mode == ModeNIGHT)
                {
                    LightR_Status = 0U;
                }
                else if(g_u8Display_Mode == ModeDAY)
                {
                    LightR_Status = 1U;
                }

                if(LightR <= 200)
                {
                    LightR_Status_Count++;
                    if(LightR_Status_Count>=150)
                    {
                        LightR_Status_Count = 0;
                        LightR_Status = 0;
                        g_u8Display_Mode = ModeNIGHT;
                    }          
                }
                else if(LightR > 200)
                {
                    LightR_Status_Count++;
                    if(LightR_Status_Count>=150)
                    {
                        LightR_Status_Count = 0;
                        LightR_Status = 1;
                        g_u8Display_Mode = ModeDAY;
                    }            
                }
                /* 系统的意思是要当前背光等级基础上的80%和20%，不是直接设置背光 */
                /*if(LightR_Status == 0)
                {
                    BackLight_Set_Lvl(Light_Lvl_1);                          
                }
                else
                {
                    BackLight_Set_Lvl(Light_Lvl_4);
                }*/
                // if(LightR_Status == 0)
                // {
                //     g_u8Display_Mode = ModeNIGHT;
                // }
                // else if(LightR_Status == 1)
                // {
                //     g_u8Display_Mode = ModeDAY;
                // }
            }
        }
        /* 根据感光判断当前应该设置什么背光等级 */
        if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_AUTO))
        {
            if(Backlight_GetPwmLevel() == 1U)
            {
                BackLight_Set_Lvl(Light_Lvl_0);   
            }
            else if(Backlight_GetPwmLevel() == 2U)
            {
                BackLight_Set_Lvl(Light_Lvl_1);   
            }
            else if(Backlight_GetPwmLevel() == 3U)
            {
                BackLight_Set_Lvl(Light_Lvl_2);   
            }
            else if(Backlight_GetPwmLevel() == 4U)
            {
                BackLight_Set_Lvl(Light_Lvl_3);   
            }
            else if(Backlight_GetPwmLevel() == 5U)
            {
                BackLight_Set_Lvl(Light_Lvl_4);  
            }
        }
        /* 菜单设置 */
        else
        {
        	if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_5) == 1)
        	{
        	    BackLight_Set_Lvl(Light_Lvl_4); 
        	}
        	else if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_4) == 1)
        	{
        	    BackLight_Set_Lvl(Light_Lvl_3);  
        	}
        	else if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_3) == 1)
        	{
        	    BackLight_Set_Lvl(Light_Lvl_2);
        	}
        	else if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_2) == 1)
        	{
        	    BackLight_Set_Lvl(Light_Lvl_1); 
        	}
        	else if(Menu_Item_Select_Get(MENU_ITEM_BACKLIGHT_1) == 1)
        	{
        	    BackLight_Set_Lvl(Light_Lvl_0);
        	}
        	else
        	{
        	    BackLight_Set_Lvl(Light_Lvl_3); 
        	}
		}
        /* 数据处理，包括NTC功能 */
        BackLight_Get_curDuty();
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, g_stBL.u16TftcurDuty);
        // if(Menu_Item_Select_Get(MENU_ITEM_SELECT_AUTO))
        // {
        //     uint16_t u16TftPwmBackShow = g_stBL.u16TftcurDuty ;
        //     if(LightR_Status == 0)
        //     {
        //         u16TftPwmBackShow *= 20U;
		// 		u16TftPwmBackShow /= 100U;                          
        //     }
        //     else
        //     {
		// 		u16TftPwmBackShow *= 80U;
		// 		u16TftPwmBackShow /= 100U; 
        //     }
        //     TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, u16TftPwmBackShow);
        // }
        // else
        // {
        //     TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, g_stBL.u16TftcurDuty);
        // }
	}
    else
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
    }
}
