#ifndef _Data_Vspeed_H_
#define _Data_Vspeed_H_

#include "common.h"

/*** 参数设置 ***/
#define   DATA_VEHICLE_RUNNING_THRESHOLD    25  //汽车行进阈值    
#define   DATA_VEHICLE_STOP_THRESHOLD       20  //汽车停止阈值

#define   DATA_VSPEED_DAMPING_FACTOR        3   //阻尼系数
#define   DATA_VSPEED_INC_STEP              4   //速度增加时慢加速速度变化步长
#define   DATA_VSPEED_DEC_STEP              6   //方向改变时急减速速度变化步长
#define   DATA_VSPEED_APPR_SPEED_MIN        2   //最小逼近速度
#define   DATA_VSPEED_HYSTERESIS            10  //回差 

/*** 控制结构 ***/
typedef struct
{
    uint16_t  Timer;
    uint16_t  Timer1;
    uint16_t  Backup;
    uint16_t  Buffer[3];
    uint8_t   Cnt;
} DataVSpeedSamplerStruct;            //车速采样结构

typedef struct
{
    uint16_t  Speed;
    uint16_t  Delta;
    uint8_t   Dir;
} DataVSPeedDampingStruct;            //车速阻尼结构


/******************************************************************************
Data_Vehicle_Speed_KL30_Wakeup_Init
功  能：车速数据KL30_Wakeup_Init
参  数：无
返回值：无
******************************************************************************
注  意：该函数KL30_Wakeup_Init被调用一次
******************************************************************************/
void Data_Vehicle_Speed_KL30_Wakeup_Init(void);

/******************************************************************************
函数名：Data_Vehicle_Speed_Processing_Service
功  能：车速数据处理函数
参  数：无
返回值：无
******************************************************************************
注  意：该函数必须每20ms被调用一次
******************************************************************************/
void Data_Vehicle_Speed_Processing_Service(void);

uint8_t Get_VechileSpeedValid(void);

/*真实的车速，精度10倍,*/
uint16_t Get_ActualVechileSpeed(void);

/*显示车速，精度10倍，取整，舍去小数点*/
uint16_t Get_DispVechileSpeed(void);
uint16_t Get_DispVechileSpeed_Mile(void);

#endif
