#ifndef _BLUETOOTH_H
#define _BLUETOOTH_H

typedef enum {
    
    TEXT_NUM_BLUETOOTH_NAME,
    TEXT_NUM_BLUETOOTH_PHONENAME,
    TEXT_NUM_PHONE_NUMBER,

    TEXT_NUM_PHONE_NUMBER_TOTAL,
    TEXT_NUM_INFORMATION_MCUVER,
    TEXT_NUM_INFORMATION_SWVERSION,
    TEXT_NUM_INFORMATION_HW,
    TEXT_NUM_INFORMATION_OS,
    TEXT_NUM_INFORMATION_MCU,
    TEXT_NUM_FAUULT_CODE,
    TEXT_NUM_TOTAL,
} TEXT_NUM_ENUM;

typedef struct {
    TEXT_NUM_ENUM TextNum;
    uint16_t LableNum;
    uint16_t Vaild;
}TEXT_STRUCT;

#define INFORMATION_VERSION_DATE   "20240915"
#define SW_EXTERNAL_VERSION        "100"

static const uint8_t DATA_Version[8] =  {INFORMATION_VERSION_DATE};
static const uint8_t SW_Version[3] =  {SW_EXTERNAL_VERSION};


/*QRCode X Y height Width*/
#define QRCode_X 178
#define QRCode_Y 130
#define QRCode_HEIGHT 240
#define QRCode_WIDTH 240
#define QRCode_TYPE Square_Instrument


extern void BlueToothService(void);
extern _PICID_Struct PicObj;
extern _QRCODE_RECT QRCode_Rect;
extern uint8_t PhoneNumber[40];
extern uint8_t CurBlueToothPhoneName[100];
extern uint8_t BlueToothName[40];
extern uint8_t PhoneNumberTotal[20];
extern uint8_t InformationOSVersion[20];
extern uint8_t InformationMCUVersion[26];
extern uint8_t TextFaultCodeNum[10];
extern TEXT_STRUCT TextPara[];

#endif