#include "PowerManagement.h"
#include "Components.h"
#include "FaultCode.h"

RTC_Information_st_t g_stRTCInformation;

static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);
static Power_Status_em Power_Stay_ON(void);
static Power_Status_em Power_Stay_OFF(void);
static Power_Status_em Power_Stay_Protect(void);
static Power_Status_em Power_Stay_Sleep(void);

static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

static void Power_KL30_Init(void)
{
//    ClearODO_Flag = 0;
    UART_Channel_Config_st_t loc_config;
    eeprom_StoreInfo_Init();
    loc_config.u32UARTChEn            = 1U;
    loc_config.u32UARTbps             = 115200U;
    loc_config.pfnUARTConfirmCallBack = NULL;
    loc_config.pfnUARTReadMsgCallBack = Amt630hUartRecvData;
    RTE_UART_Init(UART_CH2, &loc_config);
    Common_DataInit();
    Analog_Signal_Conv_Init();
    Sys_KL30_Init();
    Data_Vehicle_Speed_KL30_Wakeup_Init();
    Data_Engine_Speed_KL30_Wakeup_Init();
    LINE_IN_Init();
    Key_KL30_Init_EXample();
    Data_User_Mileage_KL30Init();
    Fuel_KL30_Init();
    Amt630hInit();
    Telltales_Init();
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    g_stRTCInformation.u8RTCSecond = 0;
	g_stRTCInformation.u8RTCMinute = 0;
	g_stRTCInformation.u8RTCHour = 0;          
	g_stRTCInformation.u8RTCDayOfMonth = 1;
	g_stRTCInformation.u8RTCMonth = 1;   
	g_stRTCInformation.u8RTCYear = 20; 
    RTE_RTC_Init(g_stRTCInformation);
    Menu_User_Init();
    Can_Init();
    Protocol_KL30_Wakeup_Init();
    TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 500);
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(KL15_AD_IN, Trigger_Rising);
    FaultCode_Init();
}

static void Power_Wakeup_Init(void)
{
    Common_DataInit();
    Gpio_Init(Gpio_WakeUp_Init);
    eeprom_StoreInfo_Init();
    Analog_Signal_Conv_Init();
    Data_User_Mileage_WakeupInit();
    Sys_WakeUp_Init();
    Data_Vehicle_Speed_KL30_Wakeup_Init();
    Data_Engine_Speed_KL30_Wakeup_Init();
    LINE_IN_Init();
    Key_Wakeup_Init_EXample();
    Line_In_KL15_ON_Init();
    Fuel_KL30_Init();
    Amt630hInit();
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 64000000);
    TimerM_PWM_CH_Output_init(TIMERM_COUNTER1, TIMERM_CHB, ActiveLevel_High);
    Telltales_Init();
    Key_KL30_Init_EXample();    
    Menu_User_WAKEUP();
    Can_Init();
    Protocol_KL30_Wakeup_Init();
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(KL15_AD_IN, Trigger_Rising);
    FaultCode_Init();
}

static void Power_LVP_Init(void)
{
    
}
static void Power_OVP_Init(void)
{
    
}

static void Power_IG_OFF_Init(void)
{
   Line_In_KL15_OFF_Init();
   TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
}

static void Power_IG_ON_Init(void)
{
//    ClearODO_Flag = 0;
   Line_In_KL15_ON_Init();
   Telltales_KL15_Init();
   Fuel_KL15_Init();
   //RTE_GPIO_Set_Level(Blacklight_PWM, 1);
   FaultCode_Init();
}

static void Power_Sleep_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 0);
	rte_can_deinit(CAN_CH_0);
	TMM0_Stop();
	TMM1_Stop();
    TMM_All_Stop();
    RTE_ADC_DeInit();
    Gpio_Init(Gpio_Sleep_Init);
    AMT630H_Sleep();
    Analog_Signal_Conv_Stop();
    if (RTE_GPIO_Get_Level(KL15_AD_IN) == 0)/* KL15 */
    {
        RTE_DEEPSLEEP_Enable();
    }
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_ON;

   if (SYS_OPR_STAT_IGN_OFF)
   {
       u8PowerSts = EM_IGN_OFF_Init;
   }

   if (SYS_OPR_STAT_HALT)
   {
       u8PowerSts = EM_IGN_LIMIT;
   }

    return u8PowerSts;
}
static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_OFF;

    if (SYS_OPR_STAT_IGN_ON)
    {
        u8PowerSts = EM_IGN_ON_Init;
    }
    else
    {
        if ((Common_GetIgnOffTime() < 20000))
        {
            u8PowerSts = EM_IGN_OFF;
        }
    }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
    Power_Status_em u8PowerSts;
//    static uint8_t  i;
    static uint8_t  Delaycnt;


    /* 关闭所有外设，坪保留AD采集，电溝状思切�? */
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
        //CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Disable);
    }
    u8PowerSts = EM_IGN_OFF_Init;
    /* 电溝模弝正常 */
    for ( ;; )
    {
        RTE_WDT_Clear();
        Gen_TimeDelay(2000u, 50u);
        Analog_Signal_Conv_Service();
        Sys_Status_Update_Service();
 
        if ( SYS_OPR_STAT_RUN )
        {
            //CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
            return u8PowerSts;
        }
 
    }
}

static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_Sleep;

    while (1)
    {
        RTE_WDT_Clear();
        if (RTE_GPIO_Get_Level(KL15_AD_IN))/* KL15 */
        {
            u8PowerSts = EM_IGN_Wakeup;
            break;
        }
    }

    return u8PowerSts;
}


