
#include "FaultCode.h"
#include  "CAN_CH0_CAN_Communication_Matrix.h"
FaultCodeList_t FaultCode_t;
uint32_t FaultCodeList [MaxFaultCode];
static uint8_t u8FaultCodeValid = 0;
uint32_t Get_FaultCodeDtc1(void)
{
    uint32_t u16FaultCode = 0x0000;
    uint8_t DTCH1 = 0;
    uint8_t DTCM1 = 0;

    uint32_t DTC1 = 0;

    DTCH1 = Get_CAN_CH0_ID_402_Sig_ECU_DTCH1();
    DTCM1 = Get_CAN_CH0_ID_402_Sig_ECU_DTCM1();

    if(DTCH1 > 0)
    {
        DTC1 |= (DTCH1 & 0xFF);
    }
    else
    {
        ;
    }
    DTC1 <<= 8;
    if(DTCM1 > 0)
    {
        DTC1 |= (DTCM1 & 0xFF);
    }
    else
    {
        ;
    }
    
    // if (((DTCH1 & 0xF0) >> 4) >= 0xA)
    // {
    //     DTC1 |= ((DTCH1 & 0xF0) >> 4);
    // }
    // else
    // {
    //     DTC1 |= (DTCH1 & 0xF0) >> 4;
    // }
    // DTC1 <<= 8;
    // if ((DTCH1 & 0xF) >= 0xA)
    // {
    //     DTC1 |= (DTCH1 & 0xF);
    // }
    // else
    // {
    //     DTC1 |= DTCH1 & 0xF;
    // }
    // DTC1 <<= 8;

    // if (((DTCM1 & 0xF0) >> 4) >= 0xA)
    // {
    //     DTC1 |= ((DTCM1 & 0xF0) >> 4) + 3;
    // }
    // else
    // {
    //     DTC1 |= (DTCM1 & 0xF0) >> 4;
    // }
    // DTC1 <<= 8;
    // if ((DTCM1 & 0xF) >= 0xA)
    // {
    //     DTC1 |= (DTCM1 & 0xF) ;
    // }
    // else
    // {
    //     DTC1 |= DTCM1 & 0xF;
    // }

    // if (DTC1 == 0)
    // {
    //     return 0XFFFF;
    // }

    u16FaultCode = DTC1;

    return u16FaultCode;
}

uint32_t Get_FaultCodeDtc2(void)
{
    uint32_t u16FaultCode = 0x0000;
    uint8_t DTCH2 = 0;
    uint8_t DTCM2 = 0;
    uint32_t DTC2 = 0;

    DTCH2 = Get_CAN_CH0_ID_402_Sig_ECU_DTCH2();
    DTCM2 = Get_CAN_CH0_ID_402_Sig_ECU_DTCM2();
    if(DTCH2 > 0)
    {
        DTC2 |= (DTCH2 & 0xFF);
    }
    else
    {
        ;
    }
    DTC2 <<= 8;
    if(DTCM2 > 0)
    {
        DTC2 |= (DTCM2 & 0xFF);
    }
    else
    {
        ;
    }
    // if (((DTCH2 & 0xF0) >> 4) >= 0xA)
    // {
    //     DTC2 |= ((DTCH2 & 0xF0) >> 4) + 3;
    // }
    // else
    // {
    //     DTC2 |= (DTCH2 & 0xF0) >> 4;
    // }
    // DTC2 <<= 8;
    // if ((DTCH2 & 0xF) >= 0xA)
    // {
    //     DTC2 |= (DTCH2 & 0xF) + 3;
    // }
    // else
    // {
    //     DTC2 |= DTCH2 & 0xF;
    // }
    // DTC2 <<= 8;

    // if (((DTCM2 & 0xF0) >> 4) >= 0xA)
    // {
    //     DTC2 |= ((DTCM2 & 0xF0) >> 4) + 3;
    // }
    // else
    // {
    //     DTC2 |= (DTCM2 & 0xF0) >> 4;
    // }
    // DTC2 <<= 8;
    // if ((DTCM2 & 0xF) >= 0xA)
    // {
    //     DTC2 |= (DTCM2 & 0xF) + 3;
    // }
    // else
    // {
    //     DTC2 |= DTCM2 & 0xF;
    // }

    // if (DTC2 == 0)
    // {
    //     return 0XFFFF;
    // }

    u16FaultCode = DTC2;

    return u16FaultCode;
}

/**
 * @brief 故障码初始化函数
 */
void FaultCode_Init(void)
{
    FaultCode_t.Get_FaultCode1_cbk = Get_FaultCodeDtc1;
    FaultCode_t.Get_FaultCode2_cbk = Get_FaultCodeDtc2;
    FaultCode_t.Get_FaultCodeNum_cbk = Get_CAN_CH0_ID_402_Sig_ECU_DTC1Amnt;
    FaultCode_t.disp_timer = DISP_TIMER;
    List_Init(&FaultCode_t, FaultCodeList, (uint8_t)MaxFaultCode);
}



uint8_t List_GetNum(FaultCodeList_t *CodeList)
{
    if(CodeList == NULL)
    {
        return 0;
    }
    return CodeList->tail - CodeList->hade;
}

uint8_t List_Init(FaultCodeList_t *CodeList, uint32_t Arr[], uint8_t Len)
{
    if((CodeList == NULL) || (Arr == NULL))
    {
        return 2;//空指针，初始化失败
    }
    if(Len < 1)
    {
        return 1;//列表空
    }
    CodeList->code_list = Arr;
    CodeList->len = Len;
    CodeList->hade = 0;
    CodeList->code_num = 0;
    CodeList->tail = 0;
    CodeList->disp = 0;
    CodeList->TimeCount = 0;
    return 0;
}

uint8_t List_Find(FaultCodeList_t *CodeList, uint32_t FaultCode)
{
    if(CodeList == NULL)
    {
        return 2;
    }
    if(List_GetNum(CodeList) == 0)
    {
        return 0;
    }
    for(int i=CodeList->hade; i<CodeList->tail; i++)
    {
        if(CodeList->code_list[i] == FaultCode)
        {
            return 1;
        }
    }
    return 0;
}

uint8_t List_add(FaultCodeList_t *CodeList, uint32_t FaultCode)
{
    if(CodeList == NULL)
    {
        return 3;
    }
    if(FaultCode == 0)
    {
        return 4;//无效值：0
    }
    if((CodeList->tail+1) >= CodeList->len)
    {
        return 1;//列表满
    }
    if(List_Find(CodeList, FaultCode) != 0)
    {
        return 2;//已存在
    }
    CodeList->code_list[CodeList->tail] = FaultCode;
    CodeList->tail++;
    return 0;
}

uint8_t List_Clear(FaultCodeList_t *CodeList)
{
    if(CodeList == NULL)
    {
        return 2;
    }
    CodeList->hade = 0;
    CodeList->tail = 0;
    //CodeList->disp = 0;
    //CodeList->code_num = 0;
    return 0;
}



//10ms
void FaultCode_Servers(void)
{
    if(FaultCode_t.TimeCount < 2*FaultCode_t.disp_timer)
    {
        FaultCode_t.TimeCount++;
    }
    
    uint16_t FaultCodeNum = FaultCode_t.Get_FaultCodeNum_cbk();
    if(FaultCode_t.code_num != FaultCodeNum)//故障码数量变化，清空
    {
        FaultCode_t.code_num = FaultCodeNum;
        List_Clear(&FaultCode_t);
    }
    
    if((List_GetNum(&FaultCode_t) > FaultCodeNum) )//故障码变化，清空
    {
        List_Clear(&FaultCode_t);
    }

    if(FaultCodeNum != 0)
    {
        List_add(&FaultCode_t, FaultCode_t.Get_FaultCode1_cbk());
        if(FaultCodeNum > 1)
        {
            List_add(&FaultCode_t, FaultCode_t.Get_FaultCode2_cbk());
        }
    }
    
}

uint32_t List_Display(FaultCodeList_t *CodeList)
{
    if((CodeList == NULL) || (List_GetNum(CodeList) == 0))
    {
        return 0;
    }
    if(CodeList->TimeCount >= CodeList->disp_timer)
    {
        CodeList->TimeCount = 0;
        if(++(CodeList->disp) >= (CodeList->tail))
        {
            CodeList->disp = CodeList->hade;
        }
    }
    return CodeList->code_list[CodeList->disp];
}

/**
 * @brief 获取当前故障码
 */
uint32_t Get_Current_FaultCode(void)
{
    return List_Display(&FaultCode_t);
}

uint8_t Get_Current_Hight_FaultCode(void)
{
    uint8_t u8FaultHight = 0;
    u8FaultHight = (uint8_t)(((List_Display(&FaultCode_t))&(0x0000FF00))>>8);
    return u8FaultHight;
}

uint8_t Get_Current_Mid_FaultCode(void)
{
    uint8_t u8FaultMid = 0;
    u8FaultMid = (uint8_t)(((List_Display(&FaultCode_t))&(0x000000FF)));
    return u8FaultMid;
}

// uint8_t Get_FaultCode_Valid(void)
// {
//     return u8FaultCodeValid;
// }
/*
*NAME : Get_FaultCode_Lost()
*FUNCTION : 获取发送故障码的CAN是否掉线
*RETURN : 0-LOST 1-ONLINE
*/
uint8_t Get_FaultCode_Lost(void)
{
    uint8_t u8FaultCodeLost = 0;
    if(CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_CH0_402_Msg_Count) == CAN_SIG_LOST)
    {
        u8FaultCodeLost = 0;
    }
    else
    {
        u8FaultCodeLost = 1;
    }
    return u8FaultCodeLost;
}
