#include "PowerManagement.h"
#include "Components.h"
#include "FaultCode.h"
#include "System_Monitor\System_Monitor_User.h"
#include "dma.h"

RTC_Information_st_t g_stRTCInformation;

static void Power_KL30_Init(void);
static void Power_Wakeup_Init(void);
static void Power_LVP_Init(void);
static void Power_OVP_Init(void);
static void Power_IG_OFF_Init(void);
static void Power_IG_ON_Init(void);
static void Power_Sleep_Init(void);
static Power_Status_em Power_Stay_ON(void);
static Power_Status_em Power_Stay_OFF(void);
static Power_Status_em Power_Stay_Protect(void);
static Power_Status_em Power_Stay_Sleep(void);

static const st_PowerGroup g_stPwrTasks = {
    Power_KL30_Init,
    Power_IG_OFF_Init,
    Power_Stay_OFF,
    Power_Sleep_Init,
    Power_Stay_Sleep,
    Power_Wakeup_Init,
    Power_IG_ON_Init,
    Power_Stay_ON,
    Power_LVP_Init,
    Power_OVP_Init,
    Power_Stay_Protect,
};

void PwrMemInit(void)
{
    PowerMemInit(&g_stPwrTasks);
}

static void Power_KL30_Init(void)                                               //588.6ms
{
//    ClearODO_Flag = 0;
    RTE_GPIO_Init();                                                            //50us
    Gpio_Init(Gpio_KL30_Init);                                                  //650us
    UART_Channel_Config_st_t loc_config;
    eeprom_StoreInfo_Init();                                                    //50us
    loc_config.u32UARTChEn            = 1U;
    loc_config.u32UARTbps             = 500000U;
    loc_config.pfnUARTConfirmCallBack = NULL;
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_INTERRUPT)
    loc_config.pfnUARTReadMsgCallBack = Amt630hUartRecvData;
    #endif
    
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_DMA)
    loc_config.pfnUARTReadMsgCallBack = NULL;
    #endif
    UART_DeInit(UART2);                                                         //50us
    RTE_UART_Init(UART_CH2, &loc_config);                                       //68.35ms

    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_DMA)
    DMA_InitTypeDef  DMA_InitTypeDef_Struct;
    DMA_InitTypeDef_Struct.DMA_Vector = DMA_VECTOR_SR2;//指定串口2为启动源
    DMA_InitTypeDef_Struct.DMA_CtrlId = 4;//指定启动源在DMA控制数据区的ID
    DMA_InitTypeDef_Struct.DMA_SrcAddr =(uint32_t)&SCI1->SCI.RXD2 /*0x40041512*/;//传送源地址
    DMA_InitTypeDef_Struct.DMA_DstAddr = (uint32_t)UartRevBuff1;//传送目标地址
    DMA_InitTypeDef_Struct.DMA_BufferSize = MCU_RX_630_UART_BUF_SIZE;//0x800的buffer，也是DMA重复循环一轮传输数据的次数
    DMA_InitTypeDef_Struct.DMA_SrcInc = 0;//传送源地址不自增，DMACR寄存器，MODE位为“1”（重复模式）并且RPTSEL位为“1”（传送源为重复区）时，SAMOD位的设置无效。
    DMA_InitTypeDef_Struct.DMA_DstInc = 0;//传送目标地址自增，DMACR寄存器，MODE位为“1”（重复模式）并且RPTSEL位为“0”（传送目标为重复区）时，DAMOD位的设置无效。
    DMA_InitTypeDef_Struct.DMA_DataSize = DMA_DataSize_Byte;//传送数据长度为8位
    DMA_InitTypeDef_Struct.DMA_Mode = DMA_Mode_Repeat;//重复模式
    DMA_InitTypeDef_Struct.DMA_RepeatAreaAddr = DMA_RepeatAreaAddr_Dst;//DMACR寄存器，RPTSEL位为“0”（传送目标为重复区）
    DMA_InitTypeDef_Struct.DMA_RepeatInt = DMA_RepeatInt_Disable;//禁止发生中断
    DMA_InitTypeDef_Struct.DMA_ChainTrans = DMA_ChainTrans_None;//禁止链传送

    DMA_Init(&DMA_InitTypeDef_Struct);
	DMA_Start(DMA_VECTOR_SR2);
    #endif

    Common_DataInit();                                                          //50us
    Analog_Signal_Conv_Init();                                                  //150us
    Sys_KL30_Init();                                                            //275.55ms
    Data_Vehicle_Speed_KL30_Wakeup_Init();                                      //50us
    Data_Engine_Speed_KL30_Wakeup_Init();                                       //50us
    LINE_IN_Init();                                                             //50us+    
    Key_KL30_Init_EXample();                                                    //50us
    Data_User_Mileage_KL30Init();                                               //145.7ms
    Fuel_KL30_Init();                                                           //50us
    Oil_Pressure_KL30_Init();                                                   //50us
    BackLight_30_Init();                                                        //50us+    
    Amt630hInit();                                                              //97.9ms
    Telltales_Init();                                                           //50us+    
    g_stRTCInformation.u8RTCSecond = 0;
	g_stRTCInformation.u8RTCMinute = 0;
	g_stRTCInformation.u8RTCHour = 0;          
	g_stRTCInformation.u8RTCDayOfMonth = 1;
	g_stRTCInformation.u8RTCMonth = 1;   
	g_stRTCInformation.u8RTCYear = 20; 
    RTE_RTC_Init(g_stRTCInformation);                                           //100us
    Menu_User_Init();                                                           //100us
    UDS_Startup_Init();                                                         //50us    
    Can_Init();                                                                 //300us
    Protocol_KL30_Wakeup_Init();                                                //50us
    
    
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(KL15_AD_IN, Trigger_Rising);            //50us+
    FaultCode_Init();                                                           //50us
    TEMP_KL30_Init();                                                           //50us
    // g_u32ISRtime.g_u32Starttime = g_u32ISRtime.g_u32Ntime;
    // g_u32ISRtime.g_u8IAsrtimesta = SysTick->VAL;
    
    // g_u32ISRtime.g_u32Endtime   = g_u32ISRtime.g_u32Ntime;
    // g_u32ISRtime.g_u8IAsrtimeend = SysTick->VAL;
    


}

static void Power_Wakeup_Init(void)
{
    UART_Channel_Config_st_t loc_config;
    Common_DataInit();
    Gpio_Init(Gpio_WakeUp_Init);
    eeprom_StoreInfo_Init();
    Analog_Signal_Conv_Init();
    Data_User_Mileage_WakeupInit();
    Sys_WakeUp_Init();
    RTE_CLOCK_Select_Start();          /* 由于休眠的时候时钟关闭，唤醒的时候打开时钟，才能进行下一步 */
    Data_Vehicle_Speed_KL30_Wakeup_Init();
    Data_Engine_Speed_KL30_Wakeup_Init();
    LINE_IN_Init();
    Key_Wakeup_Init_EXample();
    Line_In_KL15_ON_Init();
    Fuel_KL30_Init();
    Oil_Pressure_KL30_Init();
    BackLight_WakeUp_Init();
    RTE_UART_Sleep_Init(UART_CH2);
    loc_config.u32UARTChEn            = 1U;
    loc_config.u32UARTbps             = 500000U;
    loc_config.pfnUARTConfirmCallBack = NULL;
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_INTERRUPT)
    loc_config.pfnUARTReadMsgCallBack = Amt630hUartRecvData;
    #endif
    
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_DMA)
    loc_config.pfnUARTReadMsgCallBack = NULL;
    #endif
    UART_DeInit(UART2);
    RTE_UART_Init(UART_CH2, &loc_config); /* 配置串口，630H上电发送0x0D，但是底板没回复 */
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_DMA)
	DMA_Start(DMA_VECTOR_SR2);
    #endif
    Amt630hInit();
    Telltales_Init();
    Key_KL30_Init_EXample();    
    Menu_User_WAKEUP();
    Can_Init();
    Protocol_KL30_Wakeup_Init();
    RTE_DEEPSLEEP_GPIO_Interrupt_Enable(KL15_AD_IN, Trigger_Rising);
    FaultCode_Init();
    TEMP_KL30_Init();
}

static void Power_LVP_Init(void)
{
    
}
static void Power_OVP_Init(void)
{
    
}

static void Power_IG_OFF_Init(void)
{
   Line_In_KL15_OFF_Init();
   BackLight_15_Init();
   BlueTooth_IGOFF_INIT();
   Menu_Change_Branch_To_Item(MENU_BRANCH_ANIMATION,MENU_ITEM_MAIN_ITEM);
}

static void Power_IG_ON_Init(void)
{
//    ClearODO_Flag = 0;
   Line_In_KL15_ON_Init();
   Telltales_KL15_Init();
   Fuel_KL15_Init();
   Oil_Pressure_KL15_Init();
   TEMP_KL15_Init();
   //RTE_GPIO_Set_Level(Blacklight_PWM, 1);
   FaultCode_Init();
   mwAmt630hUartSendDatainit();
   AMT630H_Animation_IGON();
//    Amt630hInit();
   AMT630H_GUI_SELFCHECK_STS_INIT();
   Menu_Service(MENU_KEY_TIMEOUT); /* 菜单回到初始界面 */
   g_u8UDSreadprec = 0U;
}

static void Power_Sleep_Init(void)
{
    TimerM_PWM_counter_Output_Init(TIMERM_COUNTER1, 20000, 0);
    Can_Tx_Apply_Buff();
	rte_can_deinit(CAN_CH_0);
	TMM0_Stop();
	TMM1_Stop();
    TMM_All_Stop();
    RTE_ADC_DeInit();
    AMT630H_Sleep();
    Gpio_Init(Gpio_Sleep_Init);
    Analog_Signal_Conv_Stop();
    RTE_UART_Sleep_Init(UART_CH2);
    #if (MCU_RX_630_MODE == MCU_RX_630_MODE_UART_DMA)
    DMA_Stop(DMA_VECTOR_SR2);
    #endif
    CGC_HSI_CFG_AS_FCLK();       /* 配置时钟生成控制器(cgc)以将内部高速振荡器（HSI）作为CPU系统时钟（FCLK）以及可能的其他硬件电路的时钟源。 */
    //SystemCoreClockUpdate();   /* 更新时钟频率，暂时用不上，先注释 */
    RTE_DEEPSLEEP_Enable();
    // RTE_CLOCK_Select_Sleep(); /* 这边代码是开启时钟，暂时用不上，先注释 */
}

static Power_Status_em Power_Stay_ON(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_ON;

   if (SYS_OPR_STAT_IGN_OFF)
   {
       u8PowerSts = EM_IGN_OFF_Init;
   }

   if (SYS_OPR_STAT_HALT)
   {
       u8PowerSts = EM_IGN_LIMIT;
   }

    return u8PowerSts;
}
static Power_Status_em Power_Stay_OFF(void)
{
    Power_Status_em u8PowerSts;
    u8PowerSts = EM_IGN_OFF;

    if (SYS_OPR_STAT_IGN_ON)
    {
        u8PowerSts = EM_IGN_ON_Init;
    }
    else
    {
        if ((Common_GetIgnOffTime() < 5000))
        {
            u8PowerSts = EM_IGN_OFF;
        }
        else
        {
            u8PowerSts = EM_IGN_Sleep_Init;
        }
    }

    return u8PowerSts;
}

static Power_Status_em Power_Stay_Protect(void)
{
    Power_Status_em u8PowerSts;
//    static uint8_t  i;
    // static uint8_t  Delaycnt;


    /* 关闭所有外设，坪保留AD采集，电溝状思切�? */
    {
        TimerM_PWM_set_duty(TIMERM_COUNTER1, TIMERM_CHB, 0);
        // CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Disable);
    }
    u8PowerSts = EM_IGN_OFF_Init;
    /* 电溝模弝正常 */
    for ( ;; )
    {
        RTE_WDT_Clear();
        Gen_TimeDelay(2000u, 50u);
        Analog_Signal_Conv_Service();
        Sys_Status_Update_Service();
 
        if ( SYS_OPR_STAT_RUN )
        {
            Amt630hInit();
            // CAN_TX_SetEnable(&CAN_CH0_CanMsgTxOp, CAN_N_TX_Enable);
            return u8PowerSts;
        }
 
    }
}

static Power_Status_em Power_Stay_Sleep(void)
{
    Power_Status_em u8PowerSts = EM_IGN_Sleep;

    while (1)
    {
        RTE_WDT_Clear();
        if (RTE_GPIO_Get_Level(KL15_AD_IN))/* KL15 */
        {
            u8PowerSts = EM_IGN_Wakeup;
            break;
        }
    }

    return u8PowerSts;
}


