#ifndef HYSTERESIS_H__
#define HYSTERESIS_H__
// #define HYS_PLATFORM_16BIT
#ifdef HYS_PLATFORM_16BIT
typedef unsigned char Hys_uint8_t;
typedef unsigned int Hys_uint16_t;
typedef unsigned long Hys_uint32_t;
#else
typedef unsigned char Hys_uint8_t;
typedef unsigned short Hys_uint16_t;
typedef unsigned int Hys_uint32_t;
typedef unsigned long long Hys_uint64_t;
#endif


/*所有需要处理的物理量枚举*/
typedef enum
{
	HYS_TEMP = 0U, /*水温*/
	HYS_PWM,			   /*..*/
	HYS_NUM_MAX,
} HYS_Num_en_t;
/***************************Do not modify the following*********************************/
/***************************Do not modify the following*********************************/
/***************************Do not modify the following*********************************/
/*当前文件版本号*/
#define HYS_VERSION_NUM 0X10U
#define HYS_RAM_DATA_LEN (HYS_NUM_MAX * 2U)
/*操作函数返回状态*/
typedef enum
{
	HYS_OPERATE_SUCCESS = 0UL, /*函数操作成功*/
	HYS_OPERATE_FAIL,		   /*函数操作失败*/
} HYS_Operate_Type_en_t;
typedef struct
{
	/*该段的下限值*/
	Hys_uint16_t u16HYSSegLow;
	/*该段的上限值*/
	Hys_uint16_t u16HYSSegHigh;
} HYS_Seg_Table_st_t;
typedef struct
{
	/*参数分段属性表*/
	const HYS_Seg_Table_st_t *pstHYSSegTable;
	/*默认填0U即可*/
	Hys_uint16_t u16HYSReserved;
	/*分段属性表长度*/
	Hys_uint8_t u8HYSSegTableLen;
	/*1U:正序 0U:降序*/
	Hys_uint8_t u8HYSSortBy;
} HYS_Attribute_st_t;
typedef struct
{
	/*物理量数量，也就是 HYS_NUM_MAX */
	Hys_uint8_t u8HYSNum;
} HYS_Init_st_t;
/************************************************************************/
/*30初始化，所有状态重新开始计算*/
void HYS_KL30_Init(Hys_uint8_t *pu8HYSRamData, const HYS_Attribute_st_t *pstHYSAttribute, HYS_Init_st_t *pstHYSInit);
/*唤醒初始化，会保持休眠唤醒前的状态*/
void HYS_Wakeup_Init(Hys_uint8_t *pu8HYSRamData, const HYS_Attribute_st_t *pstHYSAttribute, HYS_Init_st_t *pstHYSInit);
/*输入对应索引的物理量参数*/
HYS_Operate_Type_en_t HYS_Physical_Quantity_Input(HYS_Num_en_t enHYSIndex, Hys_uint16_t u16HYSPhysValue);
/*获取分段结果，返回0xFF表示无效*/
Hys_uint8_t HYS_Get_Seg(HYS_Num_en_t enHYSIndex);
/*复位某个物理量，重新判断计算*/
HYS_Operate_Type_en_t HYS_Reset_Physical_Quantity(HYS_Num_en_t enHYSIndex);
/*读取版本号*/
Hys_uint8_t HYS_Version_Read(void);
#endif