#ifndef _MCU_CORE_PROTOCOL_H_
#define _MCU_CORE_PROTOCOL_H_

#include "stdint.h"

#define CORE_Timeout_CNT       1000u    //单位20ms,20超时
#define TEL_DATA_PROTOCOL_ID   0x01     //指示灯、菜单
#define WIN_DATA_PROTOCOL_ID   0x02     //行车电脑显示信息 
#define TPMS_PROTOCOL_ID       0x03     //胎压显示信息
#define CHECK_CODE_ID          0x06     //校验字符串

#define SOC_START_PROTOCOL_ID  0x10     // SOC启动后，发送此报文，需MCU回复0x20
#define SOC_HEART_PROTOCOL_ID  0x12
#define MCU_SOC_PROTOCOL_ID    0x20    //收到SOC发送的0x10后，回复此ID

// #define WIN_LEFT_SWITCH_ID     (0x04) 
// #define WIN_LEFT_MUSIC_ID      (0x05) 
// #define WIN_LEFT_RADIO_ID      (0x06) 
// #define WIN_LEFT_BLUETOOTH_ID  (0x07) 
// #define WIN_LEFT_NAVI_ID       (0x08) 

typedef enum
{
    CheckON,
    CheckOFF,    
} enSelfCheck_t;

typedef enum
{
    Soc_Startup = 0u, /**<启动中...*/
    Soc_Run,          /**<运行中...*/
    Soc_Timeout,      /**<启动超时*/
} SOC_Status;

typedef enum
{
    Win_IGNON,
    Win_IGNOFF,
    Win_Debug,
} enWinType_t;

typedef enum
{
    Anim_None,
    Anim_Startup,
    Anim_Shutdown,
} enAnimType_t;

/****************************************************
0x01 报警灯或指示符号 菜单信息（50ms）
****************************************************/
typedef struct 
{
    uint8_t u8Interface     : 2; /**< 显示界面 */
    uint8_t u8SelfCheck     : 1; /**< 自检 (0-自检开始 1-自检结束) */
    uint8_t u8Language      : 1; /**< 语言 (0-中文 1-英文) */
    uint8_t u8Theme         : 2; /**< 主题 */
    uint8_t u8ThemeColour   : 2; /**< 颜色 */

    uint8_t u8LowFuel       : 1; /**< 燃油低指示灯 */
    uint8_t u8ABS           : 1; /**< ABS/HBB故障 */
    uint8_t u8SmartLock     : 1; /**< 智能锁指示灯 */
    uint8_t u8EfiFault      : 1; /**< 电喷故障指示灯 */
    uint8_t u8HiBeam        : 1; /**< 远光灯 */
    uint8_t u8Position      : 1; /**< 位置灯 */
    uint8_t u8Right         : 1; /**< 右转灯 */
    uint8_t u8Left          : 1; /**< 左转灯 */

    uint8_t u8AutoStartStop : 1; /**< 自动启停 */
    uint8_t u8LowPower      : 1; /**< 电池电压低报警灯 */
    uint8_t u8TCS           : 1; /**< TCS指示灯 */
    uint8_t u8TPMS          : 1; /**< 胎压报警灯 */    
    uint8_t u8BlueTooth     : 1; /**< 蓝牙显示*/
    uint8_t u8Gears         : 1; /**< 1~6挡位指示灯*/
    uint8_t u8NeutralLight  : 1; /**< 空挡指示灯*/
    uint8_t u8HiTemp        : 1; /**< 水温指示灯 */
    
    uint8_t u8SentryKey     : 1; /**< 钥匙防盗 */
    uint8_t u8WIFI          : 7; /**< WIFI */

    uint8_t u8BlueControl   : 8; /**<  蓝牙控制 */
    uint8_t u8ZoneB_B       : 8; /**<  指示灯B区位置B预留 */
    uint8_t u8ZoneB_C       : 8; /**<  指示灯B区位置C预留 */
}Protoco_Telltales_st_t;

typedef struct 
{
    uint8_t u8Subject       :8; /**<  主题选择光标位置 */
    uint8_t u8Mode          :8; /**<  黑天白天模式选择 */
}Subject_Mode;

typedef struct 
{
    uint8_t u8Option        :8; /**<  二级菜单光标位置 */
    uint8_t u8Link          :4; /**<  蓝牙链接状态显示 */
    uint8_t u8LinkName      :4; /**<  蓝牙名称是否显示 */
}Blue_Tooth_Setting;

typedef struct 
{
    uint8_t u8TPMSPosition  :4; /**<  胎压二级菜单光标位置 */
    uint8_t u8TPMSUnit      :4; /**<  胎压单位 */

    uint8_t u8FrontStudyStatus :4; /**<  胎压学习前轮学习状态 */
    uint8_t u8BackStudyStatus  :4; /**<  胎压学习后轮学习状态 */

    uint8_t u8FrontHPressure :8; /**<  前轮胎压数值高字节 */
    uint8_t u8FrontLPressure :8; /**<  前轮胎压数值低字节 */
    uint8_t u8BackHPressure  :8; /**<  后轮胎压数值高字节 */
    uint8_t u8BackLPressure  :8; /**<  后轮胎压数值低字节 */
    uint8_t u8SensorHID      :8; /**<  传感器ID高字节 */
    uint8_t u8SensorHCID     :8; /**<  传感器ID中高字节 */
    uint8_t u8SensorLCID     :8; /**<  传感器ID低高字节 */
    uint8_t u8SensorLID      :8; /**<  传感器ID低字节 */
}TPMS_Study;

typedef struct 
{
    uint8_t u8Code           :8; /**<  二维码显示类型 */
}QR_Code;

typedef struct 
{
    uint8_t u8Backlight      :8; /**<  背光等级 */
}Backlight_Class;

typedef struct 
{
    uint8_t u8Version            :8; /**<  二级菜单光标位置 */

    uint8_t u8SoftYearH          :8; /**<  软件版本年高字节 */
    uint8_t u8SoftYearL          :8; /**<  软件版本年低字节 */
    uint8_t u8SoftMonth          :8; /**<  软件版本月字节 */

    uint8_t u8SoftDay            :6; /**<  软件版本日字节 */
    uint8_t u8SoftVDisplay       :2; /**<  软件字母V显示 */

    uint8_t u8SoftVersionH       :7; /**<  软件高版本号 */
    uint8_t u8SoftDotHDisplay    :1; /**<  软件“.”显示（高版本号之后的） */

    uint8_t u8SoftVersionC       :7; /**<  软件中版本号 */
    uint8_t u8SoftDotCDisplay    :1; /**<  软件“.”显示（中版本号之后的） */

    uint8_t u8SoftVersionL       :8; /**<  软件低版本号 */

    uint8_t u8HardYearH          :8; /**<  硬件版本年高字节 */
    uint8_t u8HardYearL          :8; /**<  硬件版本年低字节 */
    uint8_t u8HardMonth          :8; /**<  硬件版本月字节 */

    uint8_t u8HardDay            :6; /**<  硬件版本日字节 */
    uint8_t u8HardVDisplay       :2; /**<  硬件字母V显示 */

    uint8_t u8HardVersionH       :7; /**<  硬件高版本号 */
    uint8_t u8HardDotHDisplay    :1; /**<  硬件“.”显示（高版本号之后的） */

    uint8_t u8HardVersionC       :7; /**<  硬件中版本号 */
    uint8_t u8HardDotCDisplay    :1; /**<  硬件“.”显示（中版本号之后的） */

    uint8_t u8HardVersionL       :8; /**<  硬件低版本号 */

    uint8_t u8BlueYearH          :8; /**<  蓝牙版本年高字节 */
    uint8_t u8BlueYearL          :8; /**<  蓝牙版本年低字节 */
    uint8_t u8BlueMonth          :8; /**<  蓝牙版本月字节 */

    uint8_t u8BlueDay            :6; /**<  蓝牙版本日字节 */
    uint8_t u8BlueVDisplay       :2; /**<  蓝牙字母V显示 */

    uint8_t u8BlueVersionH       :7; /**<  蓝牙高版本号 */
    uint8_t u8BlueDotHDisplay    :1; /**<  蓝牙“.”显示（高版本号之后的） */

    uint8_t u8BlueVersionC       :7; /**<  蓝牙中版本号 */
    uint8_t u8BlueDotCDisplay    :1; /**<  蓝牙“.”显示（中版本号之后的） */

    uint8_t u8BlueVersionL       :8; /**<  蓝牙低版本号 */
}Version;

typedef struct 
{
    uint8_t u8Clock              :8; /**<  光标位置 */
    uint8_t u8TimeAM_PM          :2; /**<  AM/PM显示 */
    uint8_t u8TimeFormat         :6; /**<  时钟亮灭 */
    uint8_t u8Hour               :8; /**<  小时数字 */
    uint8_t u8Minute             :8; /**<  分钟数字 */
    uint8_t u8Colon              :8; /**<  “:”亮灭 */
}Clock;

typedef struct 
{
    uint8_t u8UnitsSetup         :8; /**<  光标位置 */
}Units_Setup;

typedef struct 
{
    uint8_t u8Language           :8; /**<  光标位置 */
}Language;

typedef struct 
{
    uint8_t u8DVRSetTowLevel     :8; /**<  二级菜单光标位置 */
    uint8_t u8DVRSetThreeLevel   :8; /**<  三级菜单光标位置 */
    uint8_t u8DVRSet             :2; /**<  DVR是否可以设置 */
    uint8_t u8DVRSetStatus       :2; /**<  DVR是否可以设置 */
    uint8_t u8DVRSetFourLevel    :8; /**<  四级菜单光标位置以及选择 */
}DVRSet;

typedef struct 
{
    uint8_t u8Factory_Reset     :8; /**<  二级菜单光标位置以及选择 */
}Factory_Reset;

typedef struct 
{
    uint8_t u8MenuGrade      : 4; /**<  菜单级别 */
    uint8_t u8MenuStair      : 4; /**<  一级菜单 */
 
    Subject_Mode         stSubject_Mode ;   /**<  主题模式 */
    Units_Setup          stUnits_Setup;     /**<  单位设置 */
    Clock                stClock;           /**<  时钟信息 */
    Backlight_Class      stBacklight_Class; /**<  亮度设置 */
    TPMS_Study           stTPMS_Study;      /**<  胎压学习 */
    Language             stLanguage;        /**<  语言设置 */
    Blue_Tooth_Setting   stBlue_Tooth ;     /**<  蓝牙设置 */
    DVRSet               stDVR;             /**<  DVR */
    Version              stVersion;         /**<  版本信息 */
    Factory_Reset        stFactory_Reset;    /**<  恢复出厂设置 */
    QR_Code              stQR_Code;         /**<  手机互联 */
    
}Menu_Setting;

typedef union
{
    uint8_t                u8Msg[30];
    Protoco_Telltales_st_t stSig;
    Menu_Setting           stMenu;
}Protoco_Telltales_un_t;

/****************************************************
0x02 界面控制逻辑 (20ms)
****************************************************/

typedef union
{
    uint8_t      u8Msg[20];
    uint8_t      u8Speed          : 8; /**< 显示车速 */
 
    uint8_t      u8ESpeedH        : 6; /**< 转速高字节 */
    uint8_t      u8ESpeedColore   : 1; /**< 转速显示颜色 */
    uint8_t      u8SpeedUnit      : 1; /**< 车速单位 */
 
    uint8_t      u8ESpeedL        : 8; /**< 转速低字节 */
    uint8_t      u8CoolantSeg     : 6; /**< 水温段 */
    uint8_t      u8CoolantSegSign : 2; /**< 水温段开短路标志 */
    uint8_t      u8FuelSeg        : 6; /**< 燃油段 */
    uint8_t      u8FuelSegSign    : 2; /**< 燃油段开短路标志 */
    uint8_t      u8Resv1          : 8; /**< 占位 */
    uint8_t      u8Resv2          : 8; /**< 占位 */
 
    uint8_t      u8MileageH       : 4; /**< TOTAL里程高4位 */ 
    uint8_t      u8MileageUnit    : 2; /**< 里程单位 */ 
    uint8_t      u8MileageMode    : 2; /**< 里程显示 */ 
 
    uint8_t      u8MileageC       : 8; /**< TOTAL里程中8位 */ 
    uint8_t      u8MileageL       : 8; /**< TOTAL里程低8位 */ 
    uint8_t      u8TripAH         : 8; /**< 小计里程A高字节 */ 
    uint8_t      u8TripAL         : 8; /**< 小计里程A低字节 */ 
    uint8_t      u8TripBH         : 8; /**< 小计里程B高字节 */ 
    uint8_t      u8TripBL         : 8; /**< 小计里程B低字节 */ 
    uint8_t      u8PhoneH         : 8; /**< 来电号码高字节 */ 
    uint8_t      u8PhoneC         : 8; /**< 来电号码中字节 */ 
 
    uint8_t      u8EasyNavigation : 1; /**< 简易导航是否显示 */ 
    uint8_t      u8BlueDisplay    : 3; /**< 蓝牙电话控制显示 */ 
    uint8_t      u8PhoneL         : 4; /**< 来电号码低字节 */ 

    uint8_t      u8TimeFormat     : 2; /**< 时间制式 */ 
    uint8_t      u8TimeAM_PM      : 2; /**< AM/PM */ 
    uint8_t      u8Colon          : 4; /**<  “:”亮灭 */

    uint8_t      u8Hour           : 8; /**<  小时数字 */
    uint8_t      u8Minute         : 8; /**<  分钟数字 */
}Protoco_Display_Info_un_t;

/****************************************************
0x03 胎压控制逻辑 (20ms)
****************************************************/

typedef union
{
    uint8_t      u8Msg[8];
    uint8_t u8TPMSDisplay   : 8;      /**< 是否显示 */
    uint8_t u8PressUnit     : 4;      /**< 胎压单位 (0-psi 1-kPa 2-bar) */
    uint8_t u8PressPopup    : 4;      /**< 胎压单位 (0-psi 1-kPa 2-bar) */
    uint8_t u8PressureFH    : 8;      /**< 前轮胎压高字节 */
    uint8_t u8PressureFL    : 8;      /**< 前轮胎压低字节 */
    uint8_t u8PressureRH    : 8;      /**< 后轮胎压高字节 */
    uint8_t u8PressureRL    : 8;      /**< 后轮胎压低字节 */
    uint8_t u8TemperatureF  : 8;      /**< 前轮胎温 */
    uint8_t u8TemperatureR  : 8;      /**< 后轮胎温 */
}TPMS_Display_Info_un_t;

/****************************************************
0x06 事件型信息，底板向核心板发送字符串，核心板校验成功以后，回复ID0x16，回复内容为ID+字符串类型+2个字节的CRC校验值
****************************************************/

typedef union
{
    uint8_t      u8Msg[3];
    uint8_t      u8UUID    : 8;
    uint8_t      u8data    : 8;
    uint8_t      u8ASCII    : 8;
}Check_Code_un_t;

/*****************************************************************/
/*-------------------------核心板心跳数据------------------------*/
/*****************************************************************/
typedef union
{
    uint8_t Msg [ 7u ];
    struct
    {
        /*Byte4*/
        uint8_t MessageID : 6;
        uint8_t PowerMode : 2;
        /*Byte5*/
        uint8_t Data0;
        /*Byte6*/
        uint8_t Data1;
        /*Byte7*/
        uint8_t Animation_Status : 4;
        uint8_t TD_Status        : 1;
        uint8_t APP_Status       : 2;
        uint8_t Lap_Status       : 1;

        /*Byte8*/
        uint8_t DataType    : 2;
        uint8_t SnapShot_FB : 3u;    //截屏提示 0无 1仪表截屏成功 2仪表截屏失败 3仪表截屏传输失败，可稍后重试
        uint8_t Tell_Req    : 1u;
        uint8_t Media_Req   : 2u;
        /*Byte8*/
        uint8_t MediaSource;
        /*Byte9*/
        uint8_t Boot_Req;

    } Sig;
} Rec_ID_12_Struct;

extern Rec_ID_12_Struct Rec_Dat_12;


typedef union
{
    uint8_t u8Msg[22];
    struct
    {
        uint8_t u8BlueStatus       : 8; /* 蓝牙电话状态 */
        uint8_t u8Resv1            : 8; /**< 占位 */
  
        uint8_t u8PhoneType        : 4; /* 手机类型 */
        uint8_t u8NetworkState     : 4; /* 核心板配网状态 */
  
        uint8_t u8Resv2            : 8; /**< 占位 */
  
        uint8_t u8BlueLink         : 4; /**< 蓝牙连接状态 */
        uint8_t u8WifiLink         : 4; /**< 蓝牙连接状态 */
  
        uint8_t u8AnimStatus       : 8; /* 显示状态 */
  
        uint8_t u8Hour             : 8; /**<  小时数字 */
        uint8_t u8Minute           : 8; /**<  分钟数字 */
        uint8_t u8Seconds          : 8; /**<  秒数字 */
  
        uint8_t u8Updatestatus     : 8; /**<  核心板升级状态 */
  
        uint8_t u8SignalStrength   : 4; /**<  手机信号强度 */
        uint8_t u8SocDesVal        : 4; /**<  手机电量 */
  
        uint8_t u8WifiSignal       : 8; /**<  WIFI信号强度 */
        uint8_t MenuInit           : 8; /**<  菜单初始化完成标志 */
        uint8_t u8Resv3            : 8; /**<  升级预留占位 */

        uint8_t u8FrontStudyStatus : 4; /**<  胎压学习前轮学习状态 */
        uint8_t u8BackStudyStatus  : 4; /**<  胎压学习后轮学习状态 */

        uint8_t u8TemperatureF     : 8; /**< 前轮胎温 */
        uint8_t u8TemperatureR     : 8; /**< 后轮胎温 */
        uint8_t u8PressureFH       : 8; /**< 前轮胎压高字节 */
        uint8_t u8PressureFL       : 8; /**< 前轮胎压低字节 */
        uint8_t u8PressureRH       : 8; /**< 后轮胎压高字节 */
        uint8_t u8PressureRL       : 8; /**< 后轮胎压低字节 */
        uint8_t u8SensorHID        : 8; /**<  传感器ID高字节 */
        uint8_t u8SensorHCID       : 8; /**<  传感器ID中高字节 */
        uint8_t u8SensorLCID       : 8; /**<  传感器ID低高字节 */
        uint8_t u8SensorLID        : 8; /**<  传感器ID低字节 */

    }Sig;
    
}Rec_0x012_un_t;

extern Rec_0x012_un_t g_unRec_0x012;

extern uint8_t Get_Core_StartStatus(void);
extern uint8_t Get_Animation_Status(void);

void MCU_SOC_Commnuication(void);
void Core_Startup_Handle(uint8_t status);
void Core_Heart_Handle(const uint8_t *pData, uint8_t len);
void Core_WinData_Service(void);
void Core_TelltalesData_Service(void);

extern void WinLeft_Data_Service(void);
extern void WinLeft_Disp_Service(void);
extern uint8_t Navi_FULL_Get(void);
extern uint8_t Mcu_BlueTooth_Get(void);
extern void Mcu_Disp_Priority(void);
extern uint8_t SOC_Online_Status_Get(void);
extern uint8_t SOC_Online_Valid(void);


#endif
