
#include "Sys_Scheduler_Lib.h"
#include "Components.h"
//#include "CommonInterface.h"
#include "RTE.h"

void Sys_Pseudo_Real_Time_Tasks(void)
{
    Power_Management_Service();
}

void Sys_2ms_Tasks(void)
{
    Common_Input_Para();
    Sys_Status_Update_Service();
    Analog_Signal_Conv_Service();
    AMT630H_Main();
    //Can_Write_Fun(&CAN_CH0_CanMsgTxOp, 2000u);无外发
    CanMSg_XMS_Analysis(&CAN_CH0_CanMsgOp, 2u);
}

void Sys_5ms_Tasks(void)
{
    Flash_Sync_Signal_Generation_Service();
}

void Sys_10ms_Tasks(void)
{
    Line_In_Debounce_Service(10u);
    Key_Service();
    Data_Mileage_Write_EEPROM();
    Key_Clear_Time();
    Key_TimeOut_Service();
    Fuel_R_Cal(10u);
}

void Sys_20ms_Tasks(void)
{
    Data_Vehicle_Speed_Processing_Service();
    Data_Engine_Speed_Processing_Service();
}

void Sys_50ms_Tasks(void)
{
    Telltales_Management();
    g_u8Cursor_Posittion = Menu_Get_Current_Cursor_Information();
}

void Sys_100ms_Tasks(void)
{
    Get_DisTime_Service();
    Fuel_Cal_Sevice(100u);
    Services_Mileage_Callback();
    RTE_GPIO_Set_Level(Blacklight_PWM, 1);
}
static uint16_t task_2ms = 0u;
void Sys_Exact_50us_Tasks(void)
{
    static uint32_t task_1ms = 0u;
    GenDelay_Tick();
    ////DoCAN_Timer_Update(50u);
    task_1ms++;
    if ( task_1ms >=20U )   
    {
        task_1ms =0U;
        eeprom_1ms_timeCount( );
    }

    task_2ms++;
    if (task_2ms >= 40)
    {
        task_2ms = 0;        
        AMT630H_Timer(2);
    }
}