#include "Components.h"
uint8_t Pic_mode = PIC_DAYTIME_Main_CH;
uint8_t MENU_MODE = MAIN_MENU;
// 菜单背景,菜单前必带
void AMT630H_GUI_BACKGRAND(void);
// 菜单调用函数
void AMT630H_GUI_SETTING(void);
// 一级菜单
void AMT630H_GUI_Quit(void);
void AMT630H_GUI_Phone_Connect(void);
void AMT630H_GUI_Fault_Information(void);
void AMT630H_GUI_Language_Information(void);
void AMT630H_GUI_Unit_Information(void);
void AMT630H_GUI_Display_Mode_Information(void);
void AMT630H_GUI_Backlight_Information(void);
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON);
void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min);
// 二级菜单
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT);       /*时钟设置*/
void AMT630H_GUI_Backlight_Setting(uint8_t back_mode);                                                 /*背光设置*/
void AMT630H_GUI_Display_Mode_Setting(uint8_t Display_mode);                                           /*显示模式*/
void AMT630H_GUI_Bluetooth_Connect_Setting(uint8_t select, uint8_t sync_contacts, uint8_t Connect_ON); /*蓝牙连接*/
void AMT630H_GUI_Unit_Setting(uint8_t select);                                                         /*单位设置*/
void AMT630H_GUI_Language_Setting(uint8_t select);                                                     /*语言设置*/
void AMT630H_GUI_Phone_Connect_Win(void);                                                              /*手机互联*/

void AMT630H_GUI_Background()
{
    if (SYS_OPR_STAT_IGN_ON)
    {
        if (MENU_MODE == SETTING_MENU)
        {
            AMT630H_GUI_SETTING(); /*设置菜单*/
        }
        else if (MENU_MODE == MAIN_MENU)
        {
            AMT630H_GUI_BACKGRAND(); /*主界面*/
        }
    }
    else
    {
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0013_0_57);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0012_0_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0047_264_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0048_610_229);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0052_44_95);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0053_49_229);
        // SetPagePic(GRAPHICS_PAGE_0, Pic_0057_376_336);
    }
}

/***********************************************一级菜单*******************************************/
/**
 * @brief 故障信息 一级菜单
 * @param[in] //暂无
 */
void AMT630H_GUI_Fault_Information(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0163_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0164_913_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0165_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0155_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0166_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0091_567_356);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0167_341_354);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0093_574_292);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0168_350_290);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0095_633_240);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0169_353_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0095_633_175);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0170_354_162);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0350_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0351_913_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0352_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0342_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0353_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0279_567_356);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0354_341_354);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0281_574_292);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0355_350_290);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0283_633_240);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0356_353_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0283_633_175);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0357_354_162);
    }
}
/**
 * @brief 显示模式信息 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Display_Mode_Information(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0190_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0191_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0161_207_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0185_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0192_445_517);

        SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0152_434_232);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0377_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0378_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0348_207_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0372_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0379_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0339_434_232);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0123_18_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0124_898_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0086_222_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0125_729_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0126_415_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0077_414_234);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0311_18_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0312_898_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0272_222_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0313_729_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0314_415_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0263_414_234);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
    }
}

void AMT630H_GUI_Backlight_Information(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0187_37_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0188_904_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0156_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0181_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0189_446_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0374_37_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0375_904_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0343_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0368_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0376_446_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0118_52_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0119_891_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0120_174_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0121_732_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0122_436_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0306_52_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0307_891_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0308_174_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0309_732_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0310_436_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
    }
}
static uint16_t Bluetooth_num_day[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};
static uint16_t Bluetooth_num_night[] = {
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289,
};
/**
 * @brief 蓝牙连接 一级菜单
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Information(uint8_t sync_contacts, uint8_t Connect_ON)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0183_26_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0184_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0185_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0177_738_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0186_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163);

        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0370_26_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0371_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0372_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0364_738_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0373_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_345);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0326_369_287);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0329_367_226);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0330_367_163);

        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0328_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0327_584_226);
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0113_14_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0114_924_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0115_189_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0116_724_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0117_440_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_348);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0037_376_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0054_377_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0056_377_166);

        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0052_574_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0053_573_226);
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0301_14_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0302_924_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0303_189_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0304_724_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0305_440_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_348);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0237_376_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0240_377_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0242_377_166);

        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0238_574_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0239_573_226);
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }
}

static uint16_t Time_num_day[] = {
    Pic_0022_550_211,
    Pic_0023_564_211,
    Pic_0024_550_211,
    Pic_0025_552_211,
    Pic_0026_548_211,
    Pic_0027_550_211,
    Pic_0028_551_211,
    Pic_0029_549_211,
    Pic_0030_550_211,
    Pic_0031_551_211,
};
static uint16_t Time_num_night[] = {
    Pic_0210_550_211,
    Pic_0211_564_211,
    Pic_0212_550_211,
    Pic_0213_552_211,
    Pic_0214_548_211,
    Pic_0215_550_211,
    Pic_0216_551_211,
    Pic_0217_549_211,
    Pic_0218_550_211,
    Pic_0219_551_211,
};
/**
 * @brief 时钟设置 一级菜单
 * @param[in]  Clock_Hour  小时
 * @param[in]  Clock_Min   分钟
 */
void AMT630H_GUI_Clock_Information(uint8_t Clock_Hour, uint8_t Clock_Min)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0179_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0180_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0181_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0173_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0182_446_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0366_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0367_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0368_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0360_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0369_446_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_338);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0108_19_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0109_899_399);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0110_192_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0111_758_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0112_429_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_341);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0296_19_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0297_899_399);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0298_192_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0299_758_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0300_429_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_341);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = Time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
}

/**
 * @brief 单位设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Unit_Information(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0175_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0176_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0177_198_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0165_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0178_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0362_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0363_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0364_198_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0352_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0365_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0103_22_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0104_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0105_184_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0106_733_488);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0107_476_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0015_469_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0016_457_155);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0291_22_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0292_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0293_184_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0294_733_488);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0295_476_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0204_469_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0205_457_155);
    }
}

/**
 * @brief 语言设置 一级菜单
 * @param[in] null
 */
void AMT630H_GUI_Language_Information(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0171_28_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0172_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0173_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0160_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0174_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0358_28_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0359_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0360_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0347_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0361_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0098_14_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0099_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0100_218_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0101_728_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0102_441_521);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0286_14_398);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0287_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0288_218_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0289_728_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0290_441_521);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
    }
}

/**
 * @brief 手机互联 一级菜单
 *
 */
void AMT630H_GUI_Phone_Connect(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0158_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0159_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0160_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0161_747_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0162_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0345_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0346_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0347_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0348_747_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0349_445_517);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0083_23_399);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0084_869_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0085_188_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0086_762_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0087_435_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0005_304_155);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0269_23_399);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0270_869_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0271_188_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0272_762_487);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0273_435_519);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0195_304_155);
    }
}

/**
 * @brief 退出 一级菜单
 * @param[in]  null
 */
void AMT630H_GUI_Quit(void)
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0153_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0154_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0155_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0156_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0157_461_517);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0340_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0341_903_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0342_197_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0343_737_485);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0344_461_517);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0078_18_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0079_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0080_188_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0081_714_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0082_481_519);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0264_18_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0265_895_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0266_188_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0267_714_486);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0268_481_519);
    }
}

/***********************************************二级菜单*******************************************/
static uint16_t time_num_day[] = {
    Pic_0022_550_211,
    Pic_0023_564_211,
    Pic_0024_550_211,
    Pic_0025_552_211,
    Pic_0026_548_211,
    Pic_0027_550_211,
    Pic_0028_551_211,
    Pic_0029_549_211,
    Pic_0030_550_211,
    Pic_0031_551_211};
static uint16_t time_num_night[] = {
    Pic_0210_550_211,
    Pic_0211_564_211,
    Pic_0212_550_211,
    Pic_0213_552_211,
    Pic_0214_548_211,
    Pic_0215_550_211,
    Pic_0216_551_211,
    Pic_0217_549_211,
    Pic_0218_550_211,
    Pic_0219_551_211};
/**
 * @brief 时间设
        置 二级菜单
 * @param[in]  Clock_Hour  小时
 * @param[in]  Clock_Min   分钟
 * @param[in]  Clock_BIT   选中位数 5选中返回
 */
static void AMT630H_GUI_Clock_Setting(uint8_t Clock_Hour, uint8_t Clock_Min, uint8_t Clock_BIT)
{

    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0135_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_338);

        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335); // 返回
            break;
        default:
            break;
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 455;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 572;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0323_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_338);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);
        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0207_437_316); // 返回
            break;
        default:
            break;
        }
        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 455;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 572;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0017_19_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_341);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0021_510_222);

        /*光标*/
        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0018_441_335); // 返回
            break;
        default:
            break;
        }

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = time_num_day;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0206_19_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_341);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0209_510_222);

        /*光标*/
        switch (Clock_BIT)
        {
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_408_209); // 小时第一位
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_455_209); // 小时第二位
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_525_209); // 分钟第一位
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0020_572_209); // 分钟第二位
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0207_437_316); // 返回
            break;
        default:
            break;
        }

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t Clock_HourNumber;
        uint8_t Clock_MinNumber;
        Clock_HourNumber = Clock_Hour;
        Clock_MinNumber = Clock_Min;

        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 457;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_HourNumber);

        DisplayNumPara.NumList = time_num_night;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 47;
        DisplayNumPara.x = 574;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Clock_MinNumber);
    }
}

/**
 * @brief 显示模式设置 二级菜单
 * @param[in]  back_mode  显示模式 0为日间 1为夜间 2为自动
 */
void AMT630H_GUI_Display_Mode_Setting(uint8_t Display_mode) /*图 显示模式*/
{
    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0146_27_396);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_256);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0149_448_101);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0147_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0152_434_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);

            SetPagePic(GRAPHICS_PAGE_0, Pic_0150_448_343);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0148_472_231);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0151_476_117);
            break;
        default:
            break;
        }
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0333_27_396);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_256);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0336_448_101);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0334_476_359);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0339_434_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);

            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0337_448_343);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0335_472_231);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0338_476_117);
            break;
        default:
            break;
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0071_18_397);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_257);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0074_422_103);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0072_454_360);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0077_414_234);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);

            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0075_409_345);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0073_456_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0076_461_118);
            break;
        default:
            break;
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0257_18_397);
        switch (Display_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_90);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0259_456_257);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0260_422_103);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_221);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0258_454_360);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0263_414_234);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);

            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0261_409_345);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0259_456_232);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0262_461_118);
            break;
        default:
            break;
        }
    }
}

/**
 * @brief 背光设置 二级菜单
 * @param[in]  back_mode  背光模式 0为自动
 */
void AMT630H_GUI_Backlight_Setting(uint8_t back_mode) /*图 背光*/
{
    /*case 0              自动*/
    /*case 1             选中1*/
    /*case 2             选中2*/
    /*case 3             选中3*/
    /*case 4             选中4*/
    /*case 5             选中5*/

    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0144_37_396);
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0145_477_340);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_325);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0067_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_229);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0066_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_183);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0064_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_138);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0063_495_145);
            break;

        default:
            break;
        }
    }
    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0331_37_396);
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_297);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0332_477_340);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_290);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_239);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0253_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_194);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0252_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_148);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0250_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_103);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0249_495_145);
            break;

        default:
            break;
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0057_52_398); /*下方菜单*/
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0070_466_342);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_325);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0069_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0067_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0068_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_229);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0066_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_183);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0064_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0065_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0058_360_138);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0059_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0060_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0061_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0062_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0063_495_145);
            break;

        default:
            break;
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0243_52_398);
        switch (back_mode)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_297);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0256_466_342);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_136);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_290);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0255_506_332);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_286);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_239);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0253_495_281);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0254_505_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 3:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_194);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0252_496_236);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_186);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 4:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_148);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0250_493_190);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0251_504_136);
            break;
        case 5:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0244_360_103);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0245_509_353);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0246_504_307);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0247_505_264);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0248_503_219);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0249_495_145);
            break;

        default:
            break;
        }
    }
}

static uint16_t Bluetooth_Connect_num_day[] = {
    Pic_0040_605_289,
    Pic_0041_606_290,
    Pic_0042_604_289,
    Pic_0043_604_289,
    Pic_0044_604_290,
    Pic_0045_604_290,
    Pic_0046_605_289,
    Pic_0047_605_290,
    Pic_0048_605_289,
    Pic_0049_605_289};

static uint16_t Bluetooth_Connect_num_night[] = {
    Pic_0225_605_289,
    Pic_0226_606_290,
    Pic_0227_604_289,
    Pic_0228_604_289,
    Pic_0229_604_290,
    Pic_0230_604_290,
    Pic_0231_605_289,
    Pic_0232_605_290,
    Pic_0233_605_289,
    Pic_0234_605_289};
/**
 * @brief 蓝牙连接 二级菜单
 * @param[in]  select  0为选择蓝牙连接 1选择同步联系人 2选择返回
 * @param[in]  sync_contacts  同步联系人
 * @param[in]  Connect_ON  0 关 1 开
 */
void AMT630H_GUI_Bluetooth_Connect_Setting(uint8_t select, uint8_t sync_contacts, uint8_t Connect_ON)
{

    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        /*光标位置*/
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }

        SetPagePic(GRAPHICS_PAGE_0, Pic_0137_26_396);  /*下方菜单*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0136_489_345); /*返回*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0139_369_287); /*同步联系人*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0142_367_226); /*蓝牙连接*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165); /*HI3EA0*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0143_367_163); /*蓝牙名称*/

        /*蓝牙开或关选择*/
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0140_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0141_584_226);
        }

        /*同步联系人*/

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0325_26_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0324_489_345);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0326_369_287);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0329_367_226);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0330_367_163);
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0328_584_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0327_584_226);
        }

        /*蓝牙联系人选择*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0034_14_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0019_478_348);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0037_376_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0054_377_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0055_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0056_377_166);
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0052_574_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0053_573_226);
        }

        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;
        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0038_590_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0039_583_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_day;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_205);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0036_336_266);
            break;
        case 2:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0035_336_324);
            break;
        default:
            break;
        }
        SetPagePic(GRAPHICS_PAGE_0, Pic_0222_14_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0208_478_348);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0237_376_289);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0240_377_227);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0241_570_165);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0242_377_166);
        if (Connect_ON == 0)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0238_574_226);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0239_573_226);
        }

        /*蓝牙联系人选择*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint8_t sync_contactsNumber;
        sync_contactsNumber = sync_contacts;

        if (sync_contacts < 10)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0223_590_287);
            DisplayNumPara.NumList = Bluetooth_Connect_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 604;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0224_583_287);
            DISPLAY_NUM_ST DisplayNumPara;
            uint8_t ArrivalNumber;
            ArrivalNumber = sync_contacts;
            DisplayNumPara.NumList = Bluetooth_Connect_num_night;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 14;
            DisplayNumPara.x = 612;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, sync_contactsNumber);
        }
    }
}

/**
 * @brief 单位设置 二级菜单
 * @param[in]  select  0为公制 1为英制
 */
void AMT630H_GUI_Unit_Setting(uint8_t select) /*图 单位设置*/
{

    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0130_27_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0133_473_288);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0134_436_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0131_435_272);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0132_474_168);
            break;
        default:
            break;
        }
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0318_27_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0321_473_288);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0322_436_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0319_435_272);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0320_474_168);
            break;
        default:
            break;
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0012_22_397);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0015_469_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0016_457_155);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0013_437_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0014_481_170);
            break;
        default:
            break;
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0201_22_397);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_141);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0204_469_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0205_457_155);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0202_437_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0203_481_170);
            break;
        default:
            break;
        }
    }
}

/**
 * @brief 语言设置 二级菜单
 * @param[in]  select  0为中文 1为英文
 */
void AMT630H_GUI_Language_Setting(uint8_t select) /*图 语言设置*/
{

    /*日间中文*/
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0129_28_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
            break;
        default:
            break;
        }
    }

    /*夜间中文*/
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0317_28_396);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
            break;
        default:
            break;
        }
    }

    /*日间英文*/
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0006_14_397);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0007_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0008_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0010_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0011_490_168);
            break;
        default:
            break;
        }
    }

    /*夜间英文*/
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0196_14_397);
        switch (select)
        {
        case 0:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0199_475_289);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0200_474_152);
            break;
        case 1:
            SetPagePic(GRAPHICS_PAGE_0, Pic_0009_321_261);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0197_448_274);
            SetPagePic(GRAPHICS_PAGE_0, Pic_0198_490_168);
            break;
        default:
            break;
        }
    }
}

/**
 * @brief 手机互联成功 二级菜单
 * @param[in]  NULL
 */
void AMT630H_GUI_Phone_Connect_Win(void)
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0127_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0128_429_152);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0315_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0316_429_152);
    }
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0003_23_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0005_304_155);
    }
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0194_23_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0195_304_155);
    }
}

/**************************************日间模式的主界面************************************/
static const uint16_t NumbeList_TIME_DAY[] = {
    Pic_0523_950_491,
    Pic_0524_957_491,
    Pic_0525_951_491,
    Pic_0526_952_491,
    Pic_0527_950_491,
    Pic_0528_951_491,
    Pic_0529_951_491,
    Pic_0530_950_491,
    Pic_0531_951_491,
    Pic_0532_951_491,
    Pic_0533_959_511,
    Pic_0534_953_501,
};
static const uint16_t NumbeList_TIME_NIGHT[] = {
    Pic_0635_950_491,
    Pic_0636_957_491,
    Pic_0637_951_491,
    Pic_0638_952_491,
    Pic_0639_950_491,
    Pic_0640_951_491,
    Pic_0641_951_491,
    Pic_0642_950_491,
    Pic_0643_951_491,
    Pic_0644_951_491,
    Pic_0645_959_511,
    Pic_0646_953_501,
};
static const uint16_t NumbeList_Telephone[] = {
    Pic_0536_54_499,
    Pic_0537_55_499,
    Pic_0538_54_499,
    Pic_0539_54_499,
    Pic_0540_54_499,
    Pic_0541_54_499,
    Pic_0542_55_499,
    Pic_0543_54_499,
    Pic_0544_54_499,
    Pic_0545_54_499,
    Pic_0546_58_514,
    Pic_0547_57_510,
};
static const uint16_t NumbeList_Voltage_DAY[] = {
    Pic_0565_943_451,
    Pic_0567_948_451,
    Pic_0568_944_451,
    Pic_0569_944_451,
    Pic_0570_943_451,
    Pic_0571_943_451,
    Pic_0572_944_451,
    Pic_0573_943_451,
    Pic_0574_943_451,
    Pic_0575_944_451,
    Pic_0566_949_465,
    Pic_0576_945_458,
};
static const uint16_t NumbeList_Voltage_NIGHT[] = {
    Pic_0673_943_451,
    Pic_0675_948_451,
    Pic_0676_944_451,
    Pic_0677_944_451,
    Pic_0678_943_451,
    Pic_0679_943_451,
    Pic_0680_944_451,
    Pic_0681_943_451,
    Pic_0682_943_451,
    Pic_0683_944_451,
    Pic_0674_949_465,
    Pic_0684_945_458,
};
static const uint16_t NumbeList_ODO_DAY[] = {
    Pic_0579_53_328,
    Pic_0581_61_327,
    Pic_0582_54_327,
    Pic_0583_54_327,
    Pic_0584_52_327,
    Pic_0585_54_327,
    Pic_0586_54_327,
    Pic_0587_53_327,
    Pic_0588_53_327,
    Pic_0589_54_327,
    Pic_0590_62_349,
    Pic_0591_56_338,
};
static const uint16_t NumbeList_ODO_NIGHT[] = {
    Pic_0687_53_328,
    Pic_0689_61_327,
    Pic_0690_54_327,
    Pic_0691_54_327,
    Pic_0692_52_327,
    Pic_0693_54_327,
    Pic_0694_54_327,
    Pic_0695_53_327,
    Pic_0696_53_327,
    Pic_0697_54_327,
    Pic_0698_62_349,
    Pic_0699_56_338,
};
static const uint16_t NumbeList_VSpeed_DAY[] = {
    Pic_0594_456_256,
    Pic_0595_492_255,
    Pic_0596_458_255,
    Pic_0597_461_255,
    Pic_0598_451_255,
    Pic_0599_458_255,
    Pic_0600_459_255,
    Pic_0601_454_255,
    Pic_0602_456_255,
    Pic_0603_459_255,
    Pic_0604_500_361,
    Pic_0605_470_308,
};
static const uint16_t NumbeList_VSpeed_NIGHT[] = {
    Pic_0702_456_256,
    Pic_0703_492_255,
    Pic_0704_458_255,
    Pic_0705_461_255,
    Pic_0706_451_255,
    Pic_0707_458_255,
    Pic_0708_459_255,
    Pic_0709_454_255,
    Pic_0710_456_255,
    Pic_0711_459_255,
    Pic_0712_500_361,
    Pic_0713_470_308,
};
static const uint16_t PICList_ESpeed_DAY[] = {
    Pic_0619_94_123,
    Pic_0618_140_111,
    Pic_0617_193_110,
    Pic_0616_291_128,
    Pic_0615_381_149,
    Pic_0614_446_149,
    Pic_0613_511_149,
    Pic_0612_569_149,
    Pic_0611_623_119,
    Pic_0610_677_110,
    Pic_0609_731_111,
    Pic_0608_782_125,
};
static const uint16_t PICList_ESpeed_NIGHT[] = {
    Pic_0727_94_123,
    Pic_0726_138_111,
    Pic_0725_191_110,
    Pic_0724_292_128,
    Pic_0723_379_149,
    Pic_0722_94_114,
    Pic_0721_511_149,
    Pic_0720_570_149,
    Pic_0719_623_119,
    Pic_0718_677_110,
    Pic_0717_731_111,
    Pic_0716_782_125,
};
static const uint16_t PICList_Fuel[] = {
    Pic_0554_315_473,
    Pic_0555_366_473,
    Pic_0556_426_473,
    Pic_0557_469_473,
    Pic_0558_514_473,
    Pic_0559_550_473,
    Pic_0560_586_473,
    Pic_0561_623_473,
};

/*时间显示函数*/
static void AMT630H_GUI_TIME(uint16_t Hour, uint16_t Minute)
{
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {
        /*外部接收小时和分钟*/
        if (FLASH_SYNC_1Hz)
        {
            SetPagePicFree(GRAPHICS_PAGE_0, Pic_0522_916_503, 918, 501);
        }
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t HourNumber;
        uint16_t MinuteNumber;
        HourNumber = Hour;
        MinuteNumber = Minute;
        /*小时显示*/
        DisplayNumPara.NumList = NumbeList_TIME_DAY;
        DisplayNumPara.x = 891;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, HourNumber);
        /*分钟显示*/
        DisplayNumPara.NumList = NumbeList_TIME_DAY;
        DisplayNumPara.x = 950;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, MinuteNumber);
    }
    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        /*外部接收小时和分钟*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0634_916_503);
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t HourNumber;
        uint16_t MinuteNumber;
        HourNumber = Hour;
        MinuteNumber = Minute;
        /*小时显示*/
        DisplayNumPara.NumList = NumbeList_TIME_NIGHT;
        DisplayNumPara.x = 891;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, HourNumber);
        /*分钟显示*/
        DisplayNumPara.NumList = NumbeList_TIME_NIGHT;
        DisplayNumPara.x = 950;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 23;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 2;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, MinuteNumber);
    }
}

/*手机号显示函数*/
// uint16_t Telephone[] = {1,2,3,4,5,6,7,8,9,1,1};
// static void AMT630H_GUI_Telephone(uint16_t Telephone[])
// {
//     DISPLAY_NUM_ST DisplayNumPara;
//     SetPagePic(GRAPHICS_PAGE_0, Pic_0548_62_401); /*电话图标*/
//     /*预留来电人显示*/
//     for(int i=0;i<11;i++)
//     {
//         DisplayNumPara.NumList = NumbeList_Telephone;
//         DisplayNumPara.x = XList_Telephone[i];
//         DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT |0;
//         DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
//         DisplayNumPara.DecimalNum = 0;
//         DisplayNumPara.MinDigits = 1;
//         DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara,Telephone[i]);
//     }
// }

/*燃油显示函数*/
uint8_t g_u16_GUI_PerFuelLevel = 1;
static void AMT630H_GUI_Fuel(uint8_t Fuel)
{
    /*外部传参燃油处于数组第几格*/
    /*R>83且处于非开路状态时 黄色燃油灯闪烁*/
    /*R开路状态时 黄色燃油灯闪烁*/
    /*以上两种情况黄色燃油灯闪烁的频率不同*/
    uint8_t FuelLevel;
    FuelLevel = Fuel;
    static uint8_t s_FuelLowTime = 0U;
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0553_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0550_715_533); /*F*/
        if (FuelLevel == 0)
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            s_FuelLowTime = 0;
        }
        else if (FuelLevel == 1)
        {
            s_FuelLowTime++;
            if (s_FuelLowTime < 15)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
            if (s_FuelLowTime == 20)
            {
                s_FuelLowTime = 0;
            }
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0551_503_529); /*黑色燃油灯*/
            s_FuelLowTime = 0;
        }
    }
    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0662_315_473); /*燃油格*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0549_299_533); /*E*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0660_715_533); /*F*/
        if (FuelLevel == 0)
        {
            if (FLASH_SYNC_1Hz)
            {
                SetPagePic(GRAPHICS_PAGE_0, Pic_0552_503_529); /*黄色燃油灯*/
            }
        }
        else
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0661_503_529); /*白色燃油灯*/
        }
    }

    /*燃油格数走格*/
    if (FuelLevel > 1)
    {
        if (FuelLevel != g_u16_GUI_PerFuelLevel)
        {
            if (FuelLevel > g_u16_GUI_PerFuelLevel)
            {
                g_u16_GUI_PerFuelLevel++;
            }
            else if ((FuelLevel < g_u16_GUI_PerFuelLevel) && (g_u16_GUI_PerFuelLevel != 0))
            {
                g_u16_GUI_PerFuelLevel--;
            }
            else if (FuelLevel == g_u16_GUI_PerFuelLevel)
            {
            }
        }
        else if (FuelLevel == g_u16_GUI_PerFuelLevel)
        {
        }

        for (uint8_t i = 0; i < g_u16_GUI_PerFuelLevel; i++)
        {
            SetPagePic(GRAPHICS_PAGE_0, PICList_Fuel[i]);
        }
    }
    else
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0562_315_473);
    }
}

/*电压显示函数*/
static void AMT630H_GUI_Voltage(uint16_t Voltage)
{
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VoltageNumber;
        VoltageNumber = Voltage / 10;
        if (Voltage % 10 > 5)
        {
            VoltageNumber++;
        }
        uint16_t Voltage_Hundred;
        uint16_t Voltage_Ten;
        uint16_t Voltage_Unit;
        uint16_t Front;
        if ((VoltageNumber <= 120) || (VoltageNumber > 150))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0563_923_407); /*电压图标*/
        }
        /*数据处理*/
        Voltage_Hundred = VoltageNumber / 100;
        Voltage_Ten = (VoltageNumber % 100) / 10;
        Voltage_Unit = VoltageNumber % 10;
        Front = Voltage_Hundred * 10 + Voltage_Ten;
        DisplayNumPara.NumList = NumbeList_Voltage_DAY;

        if ((VoltageNumber >= 100) && (VoltageNumber < 1000))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0564_966_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0566_946_465); /* . */
            DisplayNumPara.x = 951;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 0;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Voltage_Unit);

            DisplayNumPara.x = 930;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 15;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Front);
        }

        else if (0 <= VoltageNumber < 100)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0564_958_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0566_938_465); /* . */
            DisplayNumPara.x = 943;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 21;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 1;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VoltageNumber);
        }

        else
        {
            ;
        }
    }
    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0563_923_407); /*电压图标*/

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VoltageNumber;
        VoltageNumber = Voltage / 10;
        uint16_t Voltage_Hundred;
        uint16_t Voltage_Ten;
        uint16_t Voltage_Unit;
        uint16_t Front;

        /*数据处理*/
        Voltage_Hundred = VoltageNumber / 100;
        Voltage_Ten = (VoltageNumber % 100) / 10;
        Voltage_Unit = VoltageNumber % 10;
        Front = Voltage_Ten * 10 + Voltage_Unit;
        DisplayNumPara.NumList = NumbeList_Voltage_NIGHT;

        if ((VoltageNumber >= 100) && (VoltageNumber < 1000))
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0672_966_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0674_946_465); /* . */
            DisplayNumPara.x = 951;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 0;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Voltage_Unit);

            DisplayNumPara.x = 930;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 15;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, Front);
        }

        else if (0 <= VoltageNumber < 100)
        {
            SetPagePic(GRAPHICS_PAGE_0, Pic_0672_958_451); /* V */
            SetPagePic(GRAPHICS_PAGE_0, Pic_0674_938_465); /* . */
            DisplayNumPara.x = 943;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 21;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 1;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VoltageNumber);
        }
        else
        {
            ;
        }
    }

    else
    {
        ;
    }
}

/*大计里程显示函数*/
static void AMT630H_GUI_ODO(uint32_t ODO, uint8_t mode)
{
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {
        /*ODO位数不同 KM位置不同*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0577_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0578_55_296);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0580_211_324);

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t ODONumber;
        ODONumber = ODO;

        DisplayNumPara.NumList = NumbeList_ODO_DAY;
        DisplayNumPara.x = 173;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 6;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ODONumber);
    }

    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        /*ODO位数不同 KM位置不同*/
        SetPagePic(GRAPHICS_PAGE_0, Pic_0685_48_272);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0686_55_296);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0688_211_324);

        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t ODONumber;
        ODONumber = ODO;

        DisplayNumPara.NumList = NumbeList_ODO_NIGHT;
        DisplayNumPara.x = 173;
        DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 24;
        DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
        DisplayNumPara.DecimalNum = 0;
        DisplayNumPara.MinDigits = 6;
        DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, ODONumber);
    }

    else
    {
        ;
    }
}

/*车速显示函数*/
static void AMT630H_GUI_VSpeed(uint16_t VSpeed)
{
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0592_617_271);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0593_889_310);

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VSpeedNumber;
        VSpeedNumber = VSpeed;

        DisplayNumPara.NumList = NumbeList_VSpeed_DAY;
        if (100 <= VSpeedNumber)
        {
            DisplayNumPara.x = 574;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 3;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if ((10 <= VSpeedNumber))
        {
            DisplayNumPara.x = 515;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (0 <= VSpeedNumber)
        {
            if (VSpeedNumber == 1)
            {
                DisplayNumPara.x = 492; // 1的宽度与其他数字不同 坐标没给
            }
            else
            {
                DisplayNumPara.x = 456;
            }
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }
        else
        {
            ;
        }
    }
    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0700_617_271);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0701_889_310);

        /*数据处理*/
        DISPLAY_NUM_ST DisplayNumPara;
        uint16_t VSpeedNumber;
        VSpeedNumber = VSpeed;

        DisplayNumPara.NumList = NumbeList_VSpeed_NIGHT;
        if (100 <= VSpeedNumber)
        {
            DisplayNumPara.x = 574;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 3;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (10 <= VSpeedNumber)
        {
            DisplayNumPara.x = 515;
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 2;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else if (0 <= VSpeedNumber)
        {
            if (VSpeedNumber == 1)
            {
                DisplayNumPara.x = 492; // 1的宽度与其他数字不同 坐标没给
            }
            else
            {
                DisplayNumPara.x = 456;
            }
            DisplayNumPara.NumInterval = GROUP_PIC_DIR_LEFT | 118;
            DisplayNumPara.y = GROUP_PIC_USE_PSD_Y_POS;
            DisplayNumPara.DecimalNum = 0;
            DisplayNumPara.MinDigits = 1;
            DisplayNum(GRAPHICS_PAGE_0, &DisplayNumPara, VSpeedNumber);
        }

        else
        {
            ;
        }
    }
    else
    {
        ;
    }
}

/*转速显示函数*/
static void AMT630H_GUI_ESpeed(uint16_t ESpeed)
{
    uint8_t PIC = 0;
    if ((Pic_mode == PIC_DAYTIME_Main_CH) || (Pic_mode == PIC_DAYTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0606_834_199); /* 1000r/min */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0607_94_110);  /* 底 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0620_56_165);  /* 数字0-12 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0621_118_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0622_178_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0623_268_89);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0624_350_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0625_422_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0626_498_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0627_570_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0628_634_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0629_721_86);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0630_803_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0631_877_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0632_925_165);

        /*数据处理*/
        uint16_t ESpeedLevel;
        uint16_t ESpeedNumber;
        ESpeedNumber = ESpeed;

        if (ESpeedNumber > 0)
        {
            ESpeedLevel = (ESpeedNumber - 1) / 1000;
            for (PIC = 0; PIC <= ESpeedLevel; PIC++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_ESpeed_DAY[PIC]);
            }
        }
        else if (ESpeedNumber == 0)
        {
            ESpeedLevel = 0;
        }
    }

    else if ((Pic_mode == PIC_NIGHTTIME_Main_CH) || (Pic_mode == PIC_NIGHTTIME_Main_EN))
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0714_834_199); /* 1000r/min */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0715_94_110);  /* 底 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0728_56_165);  /* 数字0-12 */
        SetPagePic(GRAPHICS_PAGE_0, Pic_0729_118_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0730_178_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0731_268_89);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0732_350_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0733_422_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0734_498_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0735_570_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0628_634_114);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0629_721_86);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0630_803_81);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0631_877_95);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0632_925_165);

        /*数据处理*/
        uint16_t ESpeedLevel;
        uint16_t ESpeedNumber;
        ESpeedNumber = ESpeed;

        if (ESpeedNumber > 0)
        {
            ESpeedLevel = (ESpeedNumber - 1) / 1000;
            for (PIC = 0; PIC <= ESpeedLevel; PIC++)
            {
                SetPagePic(GRAPHICS_PAGE_0, PICList_ESpeed_NIGHT[PIC]);
            }
        }
        else if (ESpeedNumber == 0)
        {
            ESpeedLevel = 0;
        }
    }
    else
    {
        ;
    }
}

/******************************************************************************************/
/**
 * @brief 主界面显示
 *
 */
void AMT630H_GUI_BACKGRAND()
{
    if (Pic_mode == PIC_DAYTIME_Main_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
    }
    else if (Pic_mode == PIC_DAYTIME_Main_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0753_109_331);
    }
    else if (Pic_mode == PIC_NIGHTTIME_Main_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0001_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0754_109_347);
    }

    AMT630H_GUI_TIME(Get_Dis_Hour_Time(), Get_Dis_Minute_Time());
    /* AMT630H_GUI_Telephone(Telephone); */
    if(Get_Fuel_Sensor_State() == FuelSensorNormal)
    {
        AMT630H_GUI_Fuel(Get_CurFuelSetp());
    }
    else
    {
        AMT630H_GUI_Fuel(0);
    }
    AMT630H_GUI_Voltage((ADC_Read_Signal(ADC_CH_KL30_VOLTAGE)) / 10);
    AMT630H_GUI_ODO(Get_ODO_Value() / 10, 0);
    if (Get_VechileSpeedValid() == 1)
    {
        AMT630H_GUI_VSpeed(Get_DispVechileSpeed() / 10);
    }
    else
    {
        AMT630H_GUI_VSpeed(0);
    }
    if (Get_EngineValid() == 1)
    {
        AMT630H_GUI_ESpeed(Get_DispEngineSpeed());
    }
    else
    {
        AMT630H_GUI_ESpeed(0);
    }
}
void AMT630H_GUI_SETTING()
{
    if (Pic_mode == PIC_DAYTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0382_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0002_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
    else if (Pic_mode == PIC_NIGHTTIME_CH)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0380_396_528);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0381_615_528);
    }
    else if (Pic_mode == PIC_DAYTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0315_27_396);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
    }
    else if (Pic_mode == PIC_NIGHTTIME_EN)
    {
        SetPagePic(GRAPHICS_PAGE_0, Pic_0193_0_0);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0194_23_397);
        SetPagePic(GRAPHICS_PAGE_0, Pic_0004_336_140);
    }

    AMT630H_GUI_Clock_Setting(12, 13, 3);
    AMT630H_GUI_Backlight_Setting(3);
    AMT630H_GUI_Display_Mode_Setting(0);
    AMT630H_GUI_Bluetooth_Connect_Setting(0, 8, 1);
    AMT630H_GUI_Unit_Setting(0);
    AMT630H_GUI_Language_Setting(0);
    AMT630H_GUI_Phone_Connect_Win();

    // AMT630H_GUI_Clock_Setting(Clock_Hour,  Clock_Min,  Clock_BIT);
    // AMT630H_GUI_Backlight_Setting( back_mode);
    // AMT630H_GUI_Display_Mode_Setting( Display_mode);
    // AMT630H_GUI_Bluetooth_Connect_Setting( select, sync_contacts, Connect_ON);
    // AMT630H_GUI_Unit_Setting( select);
    // AMT630H_GUI_Language_Setting( select)
    // AMT630H_GUI_Phone_Connect_Win();
}

void AMT630H_GUI_DisplayProc(void)
{
    SetPageGuid(GRAPHICS_PAGE_0, 1, 0, 0);

    AMT630H_GUI_Background();

    PackedTransfer_Page();
}