#include "stddef.h"
#include "RTE_Components.h"
#include "BAT32A279.h"
#include "RTE_CLOCK_Select.h"
#include "cgc.h"
#include "delay.h"
#include "core_cm0plus.h"
#define USED_FX_FCLK
//#define USED_FHOCO_FCLK
uint32_t RTE_SystemCoreClock; 
extern uint32_t SystemCoreClock; 
void RTE_CLOCK_Select_Start(void)
{
	////uint32_t msCnt; 

#ifdef USED_FX_FCLK
/* config clock */
    CGC_HSEConfig(OSC_OSCILLATOR,OSC_UNDER_10M);
	CGC_PLL_Setting(PLL_SR_fMX,PLL_DIV_2,PLL_MUL_16);
	CGC_PLL_CFG_AS_FCLK(); 
	SystemCoreClockUpdate();
	RTE_SystemCoreClock = SystemCoreClock;
	delay_init(64000000);
	SystemCoreClock = 64000000UL;
#endif

#ifdef USED_FHOCO_FCLK	
	SystemCoreClockUpdate();
  msCnt = SystemCoreClock / 1000;
  SysTick_Config(msCnt);
  delay_init(SystemCoreClock);
#endif
}

void RTE_CLOCK_Select_Stop(void)
{

}

uint32_t RTE_CLOCK_Sys_Get(void)
{
	return RTE_SystemCoreClock;
}


