#ifndef DATA_COOLANT_H
#define DATA_COOLANT_H

#include "Components.h"


#define Coolant_LEN  17

typedef unsigned int INT16U;
/*** 控制结构 ***/

typedef struct
{   
  uint8_t u8_DestSeg;
  uint8_t u8_CurSeg;
}DataCoolantTempDisStruct;

extern DataCoolantTempDisStruct DataCoolantTemp_Dis;

typedef struct
{
    uint16_t  Temp_Value;
    uint8_t   Symbol;
    uint16_t  u16Can_Actual;
    uint8_t   u8Can_Valid;
    uint16_t  u16Res_Actual;
    uint16_t  u16Res_ADValue;
    uint8_t   u8Res_Valid;
    uint8_t   u8Res_ADValid;
    uint8_t   u8Res_Flashtimer ;
    uint8_t TEMPSetp;
    uint8_t TEMPMode;
    uint16_t   TEMP_Fastime ;
}DataCoolantTempStruct;        //水温数据结构  


typedef struct
{
    uint32_t  Buffer[5];
    uint8_t   Cnt;
    uint8_t   time;
    uint16_t  ResOpen_ActTimer;
    uint16_t  ResOpen_InActTimer;

}DataCoolantTempSamplerStruct;  

void Common_SelfCheckTime_Init(void);
void Common_SelfCheckTime(void);

void Data_Coolant_Temp_Processing_Service(void);
uint16_t Get_Coolant_Res_To_Temp(uint16_t Temp_Res);
void Get_Coolant_Temp_Seg(uint16_t Temp_Value);
void Data_Coolant_Temp_Display ( void );
extern uint16_t GET_DataCollantTempSegValid(void);
extern void TEMP_KL30_Init ( void );
extern void TEMP_KL15_Init ( void );
extern uint8_t GET_DataCoolantTempSegDisp(void);
void TEMP_Gauges_Cal(void);

uint16_t Get_Res_To_Temp(uint16_t *ResBoard, uint16_t *TempBoard, uint8_t Len, uint16_t input);

extern DataCoolantTempStruct DataCoolantTemp ;
#endif
