
#include "g_includes.h"

#pragma ghs section bss = ".myNonInitArea"

Menu_TimeSetData_Struct MenuData;
Menu_uint8_t u8MenuRamData[MENU_RAM_DATA_LEN];

#pragma ghs section bss = default
void Menu_Logic_Operation_ECU_TRIP(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_RANGE(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_INS_FUEL(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_AVER_FUEL(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_AVER_SPEED(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_MAINTAIN(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_ECU_TPMS(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_Backlight(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_Sound(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TimeHour(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_TimeMin(Menu_Key_en_t enKeyType);
void Menu_Logic_Operation_SET_LDWS(Menu_Key_en_t enKeyType);
void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat);
void Menu_u16Data_Updata_Process(uint8_t updateDir , uint16_t datMax, uint8_t datMin, uint16_t datStep, uint16_t *dat);



extern uint16_t LocalMinOfs_TBOX;
extern uint16_t LocalHrOfs_TBOX;
RTITimingStruct RealTimeClock;
//Menu_Error_Information_en_t aaa;
void Menu_User_Init(PoMa_Reset_en_t PowerType)
{

	Menu_Init_st_t Menu_Init_st;
	Menu_Init_st.enMenuBranchLen = MENU_BRANCH_MAX;
	Menu_Init_st.enMenuInterfaceLen = MENU_INTERFACE_MAX;
	Menu_Init_st.enMenuItemLen = MENU_ITEM_MAX;
	Menu_Init_st.uintMenuConfig = 0x0001;
	Menu_Init_st.uintMenuCursorMemoryDepth = 0;
	if(PowerType == POMA_RESET_KL30)
	{
		Menu_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
		Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_TRIP);
		//aaa = Menu_Attribute_Error_Check((uint8_t *) u8MenuRamData,(Menu_Item_Attribute_st_t *) stMenuItemAttribute,(Menu_Init_st_t *)&Menu_Init_st);
	}
	else if(PowerType == POMA_RESET_WAKEUP)
	{
		Menu_Wake_Up_Init((uint8_t *)u8MenuRamData, (Menu_Item_Attribute_st_t *)stMenuItemAttribute, (Menu_Init_st_t *)&Menu_Init_st);
	}
	else
	{

	}
}

void Menu_Hide_Service(void)
{
	if((Get_NodeConfig_TPMS() == 1)||(Get_NodeConfig_TPMS() == 2))
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_TPMS, 1);
	}
	else
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_ECU_TPMS, 0);
	}
	if(Get_NodeConfig_LWDS() == 1)
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_Ldws, 1);
	}
	else
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_Ldws, 0);
	}
	if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST)||(CanReceive.Can_18FF9CF1 != 1))
	{
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 1);
		Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 1);
	}
	else
	{
		if((Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts() == 1)||
		   ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_LOST)||
	   	   (CanReceive.Can_18FF9DF1 != 1)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() > 0XEC) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX() > 0X3B) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX() > 0X17) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() > 0x0C)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() < 1)|| 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() > 0x7C)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() < 1)|| 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX() > 0xFA))||
		   (LocalMinOfs_TBOX > 0xb8)||(LocalMinOfs_TBOX < 0x42)||
		   (LocalHrOfs_TBOX > 0x94)||(LocalHrOfs_TBOX < 0x66))
		{
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 1);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 1);
		}
		else
		{
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeHour, 0);
			Menu_Item_Exist_Condition_Set(MENU_ITEM_SET_TimeMin, 0);
		}
	}
}


const Menu_Item_Attribute_st_t stMenuItemAttribute[MENU_ITEM_MAX] =
{	 					   
/*MENU_ITEM_ECU_TRIP */     	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 0U, 7U, 1U, 0U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_TRIP},
/*MENU_ITEM_ECU_RANGE */    	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 1U, 7U, 1U, 1U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_RANGE},
/*MENU_ITEM_ECU_INS_FUEL */ 	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 2U, 7U, 1U, 2U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_INS_FUEL},
/*MENU_ITEM_ECU_AVER_FUEL */	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 3U, 7U, 1U, 3U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_AVER_FUEL},
/*MENU_ITEM_ECU_AVER_SPEED */	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 4U, 7U, 1U, 4U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_AVER_SPEED},
/*MENU_ITEM_ECU_MAINTAIN */ 	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 5U, 7U, 1U, 5U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_MAINTAIN},
/*MENU_ITEM_ECU_TPMS */     	{MENU_BRANCH_ECU,  MENU_INTF_ECU, MENU_ITEM_MAX, 6U, 7U, 1U, 6U, 7U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_ECU_TPMS},

/*MENU_ITEM_SET_Backlight */	{MENU_BRANCH_SET,  MENU_INTF_SET, MENU_ITEM_MAX, 0U, 5U, 1U, 0U, 5U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_Backlight},
/*MENU_ITEM_SET_Sound */    	{MENU_BRANCH_SET,  MENU_INTF_SET, MENU_ITEM_MAX, 1U, 5U, 1U, 1U, 5U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_Sound},
/*MENU_ITEM_SET_TimeHour */ 	{MENU_BRANCH_SET,  MENU_INTF_SET, MENU_ITEM_MAX, 2U, 5U, 1U, 2U, 5U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TimeHour},
/*MENU_ITEM_SET_TimeMin */  	{MENU_BRANCH_SET,  MENU_INTF_SET, MENU_ITEM_MAX, 3U, 5U, 1U, 3U, 5U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_TimeMin},
								{MENU_BRANCH_SET,  MENU_INTF_SET, MENU_ITEM_MAX, 4U, 5U, 1U, 4U, 5U, MENU_DIRECTION_LONGITUDINAL, 0XFFU, MENU_INTERFACE_MAX, MENU_JUMP_FIRST, 0xFFFF, MENU_JUMP_FIRST, 	MENU_INTERFACE_MAX, MENU_JUMP_FIRST,Menu_Logic_Operation_SET_LDWS},
};

void Menu_Logic_Operation_ECU_TRIP(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{  
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_RANGE);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_RANGE(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)	
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_INS_FUEL);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_INS_FUEL(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)	
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_AVER_FUEL);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_AVER_FUEL(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_AVER_SPEED);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_AVER_SPEED(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_MAINTAIN);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_MAINTAIN(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)	
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			if((Get_NodeConfig_TPMS() == 1)||(Get_NodeConfig_TPMS() == 2))
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_TPMS);
			}
			else
			{
				Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_TRIP);
			}
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}
void Menu_Logic_Operation_ECU_TPMS(Menu_Key_en_t enKeyType)
{
	if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	{
		return;
	}
	else
	{
		if(enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_ECU, MENU_ITEM_ECU_TRIP);
		}
		else if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Backlight);
		}
		else
		{
			;
		}
	}
}

//-----------------------------SET----------------------------------------------//
void Menu_Logic_Operation_SET_Backlight(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint16_t datmax = 0u;
	uint8_t datmin = 0u;

	//if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	//{
	//	return;
	//}
	//else
	//{
		if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Sound);
		}
		else if (enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			updataDir = 1;
			datmax = 500u;
    	    datmin = 150u; 
			Menu_u16Data_Updata_Process(updataDir, datmax, datmin, 50u, (uint16_t*)&(g_Light.Duty));
		}
		else if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
		}
		else
		{
			;
		}
	//}
}
void Menu_Logic_Operation_SET_Sound(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;

	//if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	//{
	//	return;
	//}
	//else
	//{
		if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			if((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST)||
		   	(CanReceive.Can_18FF9CF1 != 1)||(Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts() == 1)||
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() > 0XEC) || 
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX() > 0X3B) || 
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX() > 0X17) || 
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() > 0x0C) || 
			(Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() < 1)|| 
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() > 0x7C) || 
			(Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() < 1)|| 
		   	(Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX() > 0xFA)||
			(LocalMinOfs_TBOX > 0xb8)||(LocalMinOfs_TBOX < 0x42)||
	   		(LocalHrOfs_TBOX > 0x94)||(LocalHrOfs_TBOX < 0x66))
		   	{
				Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_TimeHour);
		   	}
		   	else 
		   	{
				if(Get_NodeConfig_LWDS() == 1)
				{
					Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Ldws);
				}
				else
				{
					Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
				}
		   	}
			
		}
		else if (enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			updataDir = 1;
			datmax = 3u;
    	    datmin = 1u; 
			Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Sound));
		 	Buzzer_Volume_Set(MenuData.Sound);
			Sound_Alarm_Trigger_Volume();
		}
		else if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
		}
		else
		{
			;
		}
	//}
}

void Menu_Logic_Operation_SET_TimeHour(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;

	//if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
	//{
	//	return;
	//}
	//else
	//{
		if(enKeyType == MENU_KEY_LEFT_SHORT)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_TimeMin);
		}
		else if (enKeyType == MENU_KEY_RIGHT_SHORT)
		{
			updataDir = 1;
			datmax = 23u;
    	    datmin = 0u;  
			Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Hour));
			RTC_Set_Time((uint8_t*)&g_stRTCInformation);
		}
		else 
		{
			if(enKeyType == MENU_KEY_TIMEOUT)
			{
				Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
				MenuData.Hour = RTC_HOUR;
			}
		}
	//}
}
void Menu_Logic_Operation_SET_TimeMin(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;

	if(enKeyType == MENU_KEY_LEFT_SHORT)
	{
		if(Get_NodeConfig_LWDS() == 1)
		{
			Menu_Change_Branch_To_Item(MENU_BRANCH_SET, MENU_ITEM_SET_Ldws);
		}
		else
		{
			Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
		}
		RTC_HOUR = MenuData.Hour;
		RTC_MINUTE = MenuData.Minute;
		RTC_Set_Time((uint8_t*)&g_stRTCInformation);
	}
	else if (enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		updataDir = 1;
		datmax = 59u;
	 	datmin = 0u;
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Minute));
	}
	else 
	{
		if(enKeyType == MENU_KEY_TIMEOUT)
		{
			Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
			MenuData.Hour = RTC_HOUR;
		    MenuData.Minute = RTC_MINUTE;
		}
	}
}
void Menu_Logic_Operation_SET_LDWS(Menu_Key_en_t enKeyType)
{
	uint8_t updataDir = 0u;
	uint8_t datmax = 0u;
	uint8_t datmin = 0u;

	if(enKeyType == MENU_KEY_LEFT_SHORT)
	{
		Menu_Change_Branch(MENU_BRANCH_ECU, MENU_CHANGE_HOLD);
	}
	else if (enKeyType == MENU_KEY_RIGHT_SHORT)
	{
		updataDir = 1;
		datmax = 2u;
    	datmin = 1u; 
		Menu_u8Data_Updata_Process(updataDir, datmax, datmin, 1u, (uint8_t*)&(MenuData.Ldws));//1关,2开
	}
	else
	{
		;
	}
}



/*static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey);
static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey);



static void Menu_Cursor_Preprocess(Menu_Key_en_t enMenuKey)
{
}

static void Menu_Cursor_Postprocess(Menu_Key_en_t enMenuKey)
{
}*/


void Menu_Service(Menu_Key_en_t enMenuKey)
{
	if(SYS_OPR_STAT_IGN_ON)
	{
		Menu_Logic_Process(enMenuKey);
	}
	
	//Menu_Cursor_Preprocess(enMenuKey);
	//Menu_Cursor_Process(enMenuKey);
	//Menu_Cursor_Postprocess(enMenuKey);
	
}




void Menu_u8Data_Updata_Process(uint8_t updateDir , uint8_t datMax, uint8_t datMin, uint8_t datStep, uint8_t *dat)
{
	uint8_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (255u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
                temp = datMin;
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}

void Menu_u16Data_Updata_Process(uint8_t updateDir , uint16_t datMax, uint8_t datMin, uint16_t datStep, uint16_t *dat)
{
	uint16_t temp = *dat;
    if(datMax > datMin)
    {
        if(updateDir == 1u)
        {
            if(temp < datMax)
            {
                if((temp) <= (65535u-datStep))
                {
                    temp += datStep;
                }
            } 
            else
            {
				//if(temp == (datMax + 1))
				//{
				//	temp = temp - 1;
				//}
				//else
				{
					temp = datMin;
				}
            }        
        }
        else if(updateDir == 2u)
        {
            if(temp > datMin)
            {
                if(temp >= datStep)
                {
                    temp -= datStep;
                }
            } 
            else
            {
                temp = datMax;
            }
        }
        else
        {
        }
    }
    else
    {
    }

	*dat = temp;
}
