#include "g_includes.h"
#pragma ghs section bss = ".myNonInitArea"
DataAvgFuelStruct g_aveFuel;
uint32_t Fuel_Remainder;
 #pragma ghs section bss = default
 extern uint16_t FuelRate;
void Data_AvgFuel_KL30_Init ( void )
{
	g_aveFuel.RateSum = 0;
	Fuel_Remainder = 0 ;
}

void Can_AvgFuel_KL30_WakeUp_Init(void)
{
	g_aveFuel.Flg_18FEF200 = 0;
	Data_InsFuel.Flg_18FEF200 = 0;
	FuelMeter.Flg_18FEF200 = 0;
}

void Data_AvgFuel_KL15_Init ( void )
{
	g_aveFuel.FlashtimeA = 300;		
}

void Data_AvgFuel_A_KL30_Init ( void )//
{
	
	g_aveFuel.TripSum_FlgA = 0;
	g_aveFuel.ValidA_Dis = 0;
	g_aveFuel.ValueA_Dis = 0;
	Fuel_Remainder = 0 ;	
	g_aveFuel.ValueA_Last = 0;
}



void CAN_18FEF200_Receive(canlib_uint8_t CopyData [])
{
    g_aveFuel.Flg_18FEF200 = 1;
	Data_InsFuel.Flg_18FEF200 = 1;
	FuelMeter.Flg_18FEF200 = 1;
	Data_Fuel_Consumption_Count_ISR(CopyData);
}


uint32_t InsFuel_Cons = 0;	
uint16_t FuelRate = 0;
void Data_Fuel_Consumption_Count_ISR(canlib_uint8_t CopyData [] )//100ms
{
	uint32_t FuelRate_Cons = 0;		
    uint16_t InsFuelRate = 0;
    
	FuelRate = ((uint16_t)CopyData [1]<< 8u)|CopyData [0];
	
	if(FuelRate < 0xFFFF)
	{
		if(FuelRate >= 0xFAFF )
		{
			FuelRate_Cons = 0xFAFF;
		}
		else
		{
			FuelRate_Cons =  FuelRate;//L/h 
		}	
	}
	else
	{
		g_aveFuel.ValidA = 0;
		Data_InsFuel.Valid = 0;	
	}

	InsFuelRate = FuelRate_Cons;
	InsFuel_Cons = InsFuelRate*5;//L/h 100p

	FuelRate_Cons = FuelRate_Cons*5;//L/h 100p
	FuelRate_Cons = FuelRate_Cons*250;//UL/100ms 100p
	Fuel_Remainder += (FuelRate_Cons) % 900;
	FuelRate_Cons = (FuelRate_Cons) / 900;//UL/100ms 100p  
	
	if(Fuel_Remainder >= 900)
	{
		Fuel_Remainder -= 900;
		
		if(Fuel_Remainder >= 900)
		{
			Fuel_Remainder = 0 ;
		}
		FuelRate_Cons++;
	}  

	if((SYS_OPR_STAT_IGN_ON)&&(Common_Get_Act_V_Speed_Valid()))   
	{
		if(FuelRate < 0xFFFF)
		{
			if(g_aveFuel.RateSum < 0x7FFFFFFF)
			{
				g_aveFuel.RateSum += FuelRate_Cons;//add100ms 100p UL
			}
			else
			{
				g_aveFuel.RateSum = 0;
			}
		}
	}
}

void Data_AvgFuel_Trip_ADD(uint32_t KM_Data)
{
	if(g_aveFuel.TripSum_FlgA <= 5)
	{
		g_aveFuel.TripSum_FlgA += KM_Data;	
	}
	//g_aveFuel.TripASum += KM_Data;
}


void Data_AvgFuel_Processing_Service (void)
{ 
	if(SYS_OPR_STAT_IGN_ON)
	{   
		if((CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEF200_Msg_Count) == CAN_MSG_LOST)||(g_aveFuel.Flg_18FEF200 != 1))
		{
			g_aveFuel.ValidA = 0;	
			g_aveFuel.Flg_18FEF200 = 0;
		}
		else
		{
			if(Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP() == 1)
			{
				g_aveFuel.ValueA = g_aveFuel.ValueA_Last;
			}
			else
			{
				if(FuelRate < 0xFFFF)
				{
					g_aveFuel.ValidA = 1;
				}

				//if((g_aveFuel.RateASum >= 0x7FFFFFFF)||(g_aveFuel.TripASum >= 0x7FFFFFFF))
				//{
				//	g_aveFuel.RateASum = 0 ;
				//	g_aveFuel.TripASum = 0;
				//}

				//if(g_aveFuel.TripASum == 0)
				//{
				//	g_aveFuel.ValueA = 0;	
				//}
				//else
				//{
				//	g_aveFuel.ValueA = (g_aveFuel.RateASum / g_aveFuel.TripASum) / 10;//100p_ul/0.1km
				//	g_aveFuel.ValueA += 5;
				//	g_aveFuel.ValueA /= 10;
				//}

				g_aveFuel.ValueA  = GetCurAFC();

				if(g_aveFuel.ValueA > 199)
				{
					g_aveFuel.ValueA = 199 ; 	
				}
				g_aveFuel.ValueA_Last = g_aveFuel.ValueA;
			}
		}
	}
}

void Data_AvgFuel_TripA_Display_Service ( void )
{	
	if(SYS_OPR_STAT_IGN_ON)
	{
		if(Common_GetIgnOnTime() < SELF_CHECK_TIME)
		{
			g_aveFuel.FlashtimeA = 300;		
		}
		else
		{
			if(g_aveFuel.ValidA == 0)
			{
				g_aveFuel.ValidA_Dis = 0;	
				g_aveFuel.FlashtimeA = 300;		
			}
			else
			{
				if(g_aveFuel.TripSum_FlgA >= 5)
				{
					g_aveFuel.ValidA_Dis = 1;
				}
				else 
				{
					g_aveFuel.ValidA_Dis = 0;	
				}
			}

			if(g_aveFuel.ValidA_Dis)	
			{
				g_aveFuel.FlashtimeA++;
				if(g_aveFuel.FlashtimeA >= 300)//60s
				{
					g_aveFuel.ValueA_Dis = g_aveFuel.ValueA;
					g_aveFuel.FlashtimeA = 0;
				}
			}
			else
			{
				g_aveFuel.FlashtimeA = 300;	
			}
		}
	}
	else
	{
		g_aveFuel.FlashtimeA = 300;		
	}
}

uint16_t GET_AvgFuel_TripA_Value_Dis(void)
{
   return g_aveFuel.ValueA_Dis;
}