/*
****************************************************************************
PROJECT : BSP - GFX
FILE    : $Id: r_bsp_sys_gfx.c 7327 2016-01-22 10:29:57Z matthias.nippert $
============================================================================
DESCRIPTION
BSP Implementation D1X MANGO Board
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2014
                                  by
                    Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2014 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

/*
  Section: BSP SYS GFX description

  This is the board specific GFX implementation for the BSP.

*/

/*******************************************************************************
  Section: Includes
*/

#include "r_typedefs.h" /* Renesas basic types, e.g. uint32_t */

#include "r_dev_api.h"
#include "r_gpio_api.h"
#include "r_xbus_api.h"

#include "r_bsp_gfx_api.h"
#include "r_bsp_gfx_sys.h"

/*******************************************************************************
  Section: Local Defines
*/

/* Module reset control register */
#define LOC_MRSTC       0xFFF8F400u
#define LOC_PROTSMRST   0xFFF8F484u
#define LOC_PROTCMDMRST 0xFFF8F480u

/* Module reset control register bits */
#define MRSTC_XC0RES   (( uint32_t )(1ul << 13u))
#define MRSTC_SDRB0RES (( uint32_t )(1ul << 12u))
#define MRSTC_MLBB0RES (( uint32_t )(1ul << 11u))
#define MRSTC_LCBI0RES (( uint32_t )(1ul << 10u))
#define MRSTC_SG4RES   (( uint32_t )(1ul << 9u))
#define MRSTC_SG3RES   (( uint32_t )(1ul << 8u))
#define MRSTC_SG2RES   (( uint32_t )(1ul << 7u))
#define MRSTC_SG1RES   (( uint32_t )(1ul << 6u))
#define MRSTC_SG0RES   (( uint32_t )(1ul << 5u))
#define MRSTC_ADCE0RES (( uint32_t )(1ul << 4u))
#define MRSTC_ISM0RES  (( uint32_t )(1ul << 3u))
#define MRSTC_ETNB0RES (( uint32_t )(1ul << 2u))
#define MRSTC_VDCE1RES (( uint32_t )(1ul << 1u))
#define MRSTC_VDCE0RES (( uint32_t )(1ul << 0u))

static const r_xbus_Cfg_t xbus_cfg = {
    0,
    0,
    {{R_XBUS_AM_CACHE, 0x1u, 0x98000000u, 0x07F00000u},  /* Cached SDRAM  (0x9800_0000 - 0x9fff_ffff) */
     {R_XBUS_AM_CACHE, 0x1u, 0xa0000000u, 0x1FF00000u},  /* Cached SFMA mirror (0xa000_0000 - 0xBFff_ffff)*/
     {R_XBUS_AM_DIRECT, 0x1u, 0x40000000u, 0x1FF00000u}, /* (disabled) buffered SDRAM */
     {R_XBUS_AM_DIRECT, 0x1u, 0x3FCE8000u, 0x00100000u}} /* (disabled) buffered VRAM */
};

/*******************************************************************************
  Section: Local Types
*/
/* --------------------------- */
/* SDRB ARBITER INITIALISATION */

typedef struct
{
    uint32_t enable; /* Arbiter -> 0: Disabled; 1: Enabled */
    /* Signed values from [-8192..+8191] */
    int32_t  initial_value;             /* Initial value, must be bigger or equal to 1 */
    int32_t  threshold0;                /* 1st threshold, must be smaller than initial_value */
    int32_t  threshold1;                /* 2nd threshold, must be smaller than 1st threshold */
    int32_t  threshold2;                /* 3rd threshold, must be smaller than 2nd threshold */
    uint32_t act_to_idle_type;          /* Count the -> 0: Requests; 1: Bytes */
    uint32_t act_to_idle_threshold;     /* Max number of granted bytes/requests before returning to arbitration mode */
    uint32_t reload_type;               /* Reload counter value -> 0: Without carry-over; 1: With carry over */
    uint32_t counter_values_are_signed; /* Interprets initial_value and threshold<n> as -> 0: unsigned; 1: signed values. Signed values will be converted. */
} r_sdrb_arbiter_config_t;

/*******************************************************************************
  Section: Local Functions
*/
static void loc_DisableVOPixelClocks(void);
static void loc_InitVideoIOPort(void);

static void loc_InitGfxBus(void);

/*******************************************************************************
  Function: loc_DisableVOPixelClocks

  Disable the video output pixel clock as default.
*/

static void loc_DisableVOPixelClocks(void)
{
    r_dev_ClkSelConfig_t ClkSelCfg;

    ClkSelCfg.Cks       = R_DEV_CKS_DOTCK0;
    ClkSelCfg.SrcId     = R_DEV_CKS_SRC_DISABLED;
    ClkSelCfg.Div       = 0;
    ClkSelCfg.StpReqMsk = 0;
    R_DEV_ClkIdSet(&ClkSelCfg);
}

/*******************************************************************************
  Function: loc_InitGfxBus

  Configure the Gfx bus (cache)
*/
static void loc_InitGfxBus(void)
{
    /* Init XBus Bridge */
    if ( R_XBUS_ERR_OK == R_XBUS_Init(0) )
    {
        R_XBUS_Config(0u, ( r_xbus_Cfg_t * )&xbus_cfg);
    }
}

/*******************************************************************************
  Function: R_BSP_GFX_Init

  See: r_bsp_gfx_sys.h for details
*/
void R_BSP_SYS_GFX_Init(void)
{
    loc_InitGfxBus( );
}
