
#include "Popup_Alarm.h"
#include "Popup_Alarm_user.h"
#include "PowerManag_User.h"
#include "Popup_Alarm_Handle.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "NM_Config.h"
#include "CAN_CFG.h"
#include "NMUserControl.h"
#include "GUI.h"

void Popups_Alarm_Trigger_HILL_HOLD_MALF(void)
{
    if ( (SYS_OPR_STAT_IGN_ON) && (COF_ESP_EXIST) )
    {
        if ( Get_CAN_CH0_ID_0A18A006_Sig_HhFail( ) == 1 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_HILL_HOLD_MALF);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_HILL_HOLD_MALF, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_HILL_HOLD_MALF, POP_DELAY_MIN);
    }
}

Pop_uint8_t u8PopAlarmKEY = 0;
void        Popups_Alarm_Trigger_KEY(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_KEY, POP_DELAY_MIN);
        u8PopAlarmKEY = 0;
    }
    else
    {
        if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) != CAN_SIG_LOST )
        {
            if ( Get_CAN_CH0_ID_10FF1021_Sig_RequestKeyStillInIndication( ) == 1 )
            {
                Pop_Alarm_Request_Normal(POP_ALARM_KEY);
                u8PopAlarmKEY = 1;
            }
            else
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_KEY, POP_DELAY_MIN);
                u8PopAlarmKEY = 0;
            }
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_KEY, POP_DELAY_MIN);
            u8PopAlarmKEY = 0;
        }
    }
}
Pop_uint8_t u8PopAlarmPositionLight = 0;
void        Popups_Alarm_Trigger_POSITION_LIGHT(void)
{

    if ( SYS_OPR_STAT_IGN_ON )
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_POSITION_LIGHT, POP_DELAY_MIN);
        u8PopAlarmPositionLight = 0;
    }
    else
    {
        if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can10FF1021_Msg_Count) != CAN_SIG_LOST )
        {
            if ( Get_CAN_CH0_ID_10FF1021_Sig_RequestPositionLightStillOnInd( ) == 1 )
            {
                Pop_Alarm_Request_Normal(POP_ALARM_POSITION_LIGHT);
                u8PopAlarmPositionLight = 1;
            }
            else
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_POSITION_LIGHT, POP_DELAY_MIN);
                u8PopAlarmPositionLight = 0;
            }
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_POSITION_LIGHT, POP_DELAY_MIN);
            u8PopAlarmPositionLight = 0;
        }
    }
}

Pop_uint8_t u8PopAlarmESCFailure = 0;
void        Popups_Alarm_Trigger_ESC_FAILURE(void)
{
    if ( (SYS_OPR_STAT_IGN_ON) && (COF_ESP_EXIST) )
    {

        if ( (Get_CAN_CH0_ID_0A18A006_Sig_AsrFail( ) == 1) || (Get_CAN_CH0_ID_0A18A006_Sig_VdcFail( ) == 1) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_ESC_FAILURE);
            u8PopAlarmESCFailure = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_ESC_FAILURE, POP_DELAY_MIN);
            u8PopAlarmESCFailure = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_ESC_FAILURE, POP_DELAY_MIN);
        u8PopAlarmESCFailure = 0;
    }
}
Pop_uint8_t u8PopAlarmESCActive = 0;
Pop_uint8_t u8PopAlarmESCClose  = 0;
Pop_uint8_t u8PopAlarmBsmBtnSts = 0;
/*自检时也需要调用，虽不能触发报警*/
void Popups_Alarm_Trigger_ESC_ATCIVE_CLOSE(void)
{
    if ( (SYS_OPR_STAT_IGN_ON) && (COF_ESP_EXIST) )
    {
        if ( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0A18A006_Msg_Count) != CAN_SIG_LOST) )
        {
            uint8_t u8PopAlarmBsmBtnStsBuf = Get_CAN_CH0_ID_0A18A006_Sig_BsmBtnSts( );

            if ( ((Common_GetIgnOnTime( ) >= SELF_CHECK_TIME)) )
            {
                if ( (u8PopAlarmBsmBtnStsBuf == 0) && ((u8PopAlarmBsmBtnSts == 1) || (u8PopAlarmBsmBtnSts == 0xAA)) )
                {
                    Pop_Alarm_Delete_Normal(POP_ALARM_ESC_CLOSE, POP_DELAY_MIN);
                    Pop_Alarm_Request_Normal(POP_ALARM_ESC_ATCIVE);
                    u8PopAlarmESCActive = 1;
                    u8PopAlarmESCClose  = 0;
                }

                if ( (u8PopAlarmBsmBtnStsBuf == 1) && ((u8PopAlarmBsmBtnSts == 0) || (u8PopAlarmBsmBtnSts == 0xAA)) )
                {
                    Pop_Alarm_Delete_Normal(POP_ALARM_ESC_ATCIVE, POP_DELAY_MIN);
                    Pop_Alarm_Request_Normal(POP_ALARM_ESC_CLOSE);
                    u8PopAlarmESCActive = 0;
                    u8PopAlarmESCClose  = 1;
                }
            }

            u8PopAlarmBsmBtnSts = u8PopAlarmBsmBtnStsBuf;
        }
        else
        {
            u8PopAlarmBsmBtnSts = 0xAA;

            Pop_Alarm_Delete_Normal(POP_ALARM_ESC_CLOSE, POP_DELAY_MIN);
            Pop_Alarm_Delete_Normal(POP_ALARM_ESC_ATCIVE, POP_DELAY_MIN);
            u8PopAlarmESCActive = 0;
            u8PopAlarmESCClose  = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_ESC_CLOSE, POP_DELAY_MIN);
        Pop_Alarm_Delete_Normal(POP_ALARM_ESC_ATCIVE, POP_DELAY_MIN);
        u8PopAlarmESCActive = 0;
        u8PopAlarmESCClose  = 0;
    }
}
Pop_uint8_t u8PopAlarmGearBoxHighTemp = 0;
void        Popups_Alarm_Trigger_GEARBOX_HIGH_TEMP(void)
{
    if ( (SYS_OPR_STAT_IGN_ON) && (COF_GEARBOX_EXIST) )
    {
        if ( (u8DTC0XCEF0E0xx) || (u32RecSA03DTC == 0xCEF0E000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_GEARBOX_HIGH_TEMP);
            u8PopAlarmGearBoxHighTemp = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_HIGH_TEMP, POP_DELAY_MIN);
            u8PopAlarmGearBoxHighTemp = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_HIGH_TEMP, POP_DELAY_MIN);
        u8PopAlarmGearBoxHighTemp = 0;
    }
}

void Popups_Alarm_Trigger_RADAR_FAILURE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FFB078_Msg_Count) == CAN_SIG_LOST) && (Common_GetIgnOnTime( ) >= 8000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_RADAR_FAILURE);
        }
        else
        {    // || (Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRRM_Dis( ) == 0XFE)
            if ( (Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRR_Dis( ) == 0XFE) || (Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRLM_Dis( ) == 0XFE) || (Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRL_Dis( ) == 0XFE) )
            {

                Pop_Alarm_Request_Normal(POP_ALARM_RADAR_FAILURE);
            }
            else
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_RADAR_FAILURE, POP_DELAY_MIN);
            }
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_RADAR_FAILURE, POP_DELAY_MIN);
    }
}

Pop_uint8_t u8PopAlarmGearBoxCaution = 0;
void        Popups_Alarm_Trigger_GEARBOX_CAUTION(void)
{
    // if ( (SYS_OPR_STAT_IGN_ON) && (COF_GEARBOX_EXIST) )
    // {
    //     if ( (Get_CAN_CH0_ID_18FECA03_Sig_AT_AmberWarnLamp( ) == 1) || (Get_CAN_CH0_ID_18EBFF03_Sig_AT_AmberWarnLamp( ) == 1) )
    //     {
    //         Pop_Alarm_Request_Normal(POP_ALARM_GEARBOX_CAUTION);
    //         u8PopAlarmGearBoxCaution = 1;
    //     }
    //     else
    //     {
    //         Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
    //         u8PopAlarmGearBoxCaution = 0;
    //     }
    // }
    // else
    // {
    //     Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
    //     u8PopAlarmGearBoxCaution = 0;
    // }
}

Pop_uint8_t u8PopAlarmGearBoxFailure = 0;
void        Popups_Alarm_Trigger_GEARBOX_FAILURE(void)
{

    if ( COF_GEARBOX_EXIST )
    {

        if ( (SYS_OPR_STAT_IGN_ON) )
        {

            if ( (Get_CAN_CH0_ID_18FECA03_Sig_AT_RedStopLamp( ) == 1) || (Get_CAN_CH0_ID_18EBFF03_Sig_AT_RedStopLamp( ) == 1) )
            {
                Pop_Alarm_Request_Normal(POP_ALARM_GEARBOX_FAILURE);
                u8PopAlarmGearBoxFailure = 1;
                Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
                u8PopAlarmGearBoxCaution = 0;
            }
            else
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_FAILURE, POP_DELAY_MIN);
                u8PopAlarmGearBoxFailure = 0;

                if ( (Get_CAN_CH0_ID_18FECA03_Sig_AT_AmberWarnLamp( ) == 1) || (Get_CAN_CH0_ID_18EBFF03_Sig_AT_AmberWarnLamp( ) == 1) )
                {
                    Pop_Alarm_Request_Normal(POP_ALARM_GEARBOX_CAUTION);
                    u8PopAlarmGearBoxCaution = 1;
                }
                else
                {
                    Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
                    u8PopAlarmGearBoxCaution = 0;
                }
            }
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_FAILURE, POP_DELAY_MIN);
            if ( GetNmBusSleepSt( ) == 1 )
            {
                u8PopAlarmGearBoxFailure = 0;
            }
            Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
            u8PopAlarmGearBoxCaution = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_FAILURE, POP_DELAY_MIN);
        u8PopAlarmGearBoxFailure = 0;
        Pop_Alarm_Delete_Normal(POP_ALARM_GEARBOX_CAUTION, POP_DELAY_MIN);
        u8PopAlarmGearBoxCaution = 0;
    }
}

void Popups_Alarm_Trigger_PARK_IN_P(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (u8DTC0XB8F0E0xx) || (u32RecSA03DTC == 0XB8F0E000) || (u8DTC0XCCF0E0xx) || (u32RecSA03DTC == 0XCCF0E000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_PARK_IN_P);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_PARK_IN_P, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_PARK_IN_P, POP_DELAY_MIN);
    }
}
void Popups_Alarm_Trigger_P_INVALID(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (u8DTC0XB9F0E0xx) || (u32RecSA03DTC == 0xB9F0E000) || (u8DTC0XC1F0E0xx) || (u32RecSA03DTC == 0xC1F0E000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_P_INVALID);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_P_INVALID, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_P_INVALID, POP_DELAY_MIN);
    }
}
Pop_uint8_t u8PopAlarmBreakToShift = 0;
void        Popups_Alarm_Trigger_BRAKE_TO_SHIFT(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (u8DTC0X66F1E0xx) || (u32RecSA03DTC == 0X66F1E000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_BRAKE_TO_SHIFT);
            u8PopAlarmBreakToShift = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_BRAKE_TO_SHIFT, POP_DELAY_MIN);
            u8PopAlarmBreakToShift = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_BRAKE_TO_SHIFT, POP_DELAY_MIN);
        u8PopAlarmBreakToShift = 0;
    }
}
void Popups_Alarm_Trigger_START_IN_P(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (u8DTC0XCD160Bxx) || (u32RecSA03DTC == 0xCD160B00) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_START_IN_P);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_START_IN_P, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_START_IN_P, POP_DELAY_MIN);
    }
}
Pop_uint8_t u8PopAlarmTBoxDismantle = 0;
void        Popups_Alarm_Trigger_TBOX_DISMANTLE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Common_GetIgnOnTime( ) >= 53000 )
        {
            if ( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST) && (MenuData.Lost >= 450) )
            {
                Pop_Alarm_Request_Normal(POP_ALARM_TBOX_DISMANTLE);
                u8PopAlarmTBoxDismantle = 1;
            }
            else
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_TBOX_DISMANTLE, POP_DELAY_MIN);
                u8PopAlarmTBoxDismantle = 0;
            }
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_TBOX_DISMANTLE, POP_DELAY_MIN);
            u8PopAlarmTBoxDismantle = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_TBOX_DISMANTLE, POP_DELAY_MIN);
        u8PopAlarmTBoxDismantle = 0;
    }
}
#define SFBL_MIL  3U
#define SFBL_TIME 600U

uint16_t    u16SafeBeltMileage = 0U;
uint16_t    u16SafeBeltTime    = 0U;
Pop_uint8_t u8SafeBeltTrigger  = 0U;
uint32_t    u32YZHDTest        = 1;
void        Popups_Alarm_Trigger_TSAFE_BELT(void)
{
    uint16_t u16SafeVechiSpeed = Get_DispVechileSpeed( );
    if ( SYS_OPR_STAT_IGN_ON )
    {
        uint16_t u16SafeDoor = 0;

        if ( ((Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_BonnetSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_RHatchSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts( ) == 1))  )
        {
            u16SafeDoor = 1;
        }

        if ( (u8SafeBeltTrigger == 1) && (u16SafeVechiSpeed >= 10) )
        {
            /*hide */
            // if ( 0 )
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_TSAFE_BELT, POP_DELAY_MIN);
            }

            u8SafeBeltTrigger = 2;
        }
        if ( (u16SafeVechiSpeed <= 10) && (u16SafeDoor) )
        {
            u8SafeBeltTrigger  = 0;
            u16SafeBeltMileage = 0;
            u16SafeBeltTime    = 0;
        }

        if ( Line_In_Get_Status(LINE_IN_Safety_Belt) == 1U )
        {
            if ( (u16SafeBeltMileage >= SFBL_MIL) || (u16SafeBeltTime >= SFBL_TIME) || (u16SafeVechiSpeed >= 150) )
            {
                if ( (u16SafeVechiSpeed < 10) )
                {
                    u8SafeBeltTrigger = 1;
                }
                else
                {
                    u8SafeBeltTrigger = 2U;
                }
            }
            if ( (u8SafeBeltTrigger == 2) && (u16SafeVechiSpeed < 10) )
            {
                u8SafeBeltTrigger = 1;
            }
        }
        else
        {
            u8SafeBeltTrigger  = 0;
            u16SafeBeltMileage = 0;
            u16SafeBeltTime    = 0;
        }
    }
    else
    {
        u8SafeBeltTrigger  = 0;
        u16SafeBeltMileage = 0;
        u16SafeBeltTime    = 0;
    }

    if ( u8SafeBeltTrigger == 2 )
    {
        Pop_Alarm_Request_Normal(POP_ALARM_TSAFE_BELT);
    }
    if ( u8SafeBeltTrigger == 0 )
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_TSAFE_BELT, POP_DELAY_MIN);
    }
}
Pop_uint8_t u8PopAlarmTPMS = 0;
void        Popups_Alarm_Trigger_TPMS(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        uint16_t u16PopTriggerBuf = 0U;
        uint16_t u16PopTriggerCal = 0U;

        u16PopTriggerCal = Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection( );    // 压力报警
        if ( (Get_NodeConfig_TPMS( ) == 1) || (Get_NodeConfig_TPMS( ) == 2) )
        {

            if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_SIG_LOST )
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Left_Front_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }

            if ( Left_Rear_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Left_Rear_Inside_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Right_Front_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Right_Rear_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Right_Rear_Inside_Display.Wheel_ID_OutTime == 1 )
            {
                u16PopTriggerBuf = 1U;
            }

            if ( Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelSensorStatus( ) == 0U )    // 传感器丢失
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Get_CAN_CH0_ID_18FEF433_Sig_CTITireStatus( ) == 1U )    // 快速漏气
            {
                u16PopTriggerBuf = 1U;
            }
            if ( Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelEndElectricalFault( ) == 1U )    // 高温报警
            {
                u16PopTriggerBuf = 1U;
            }
            if ( (u16PopTriggerCal == 0) || (u16PopTriggerCal == 4) )    // 压力高//压力低报警
            {
                u16PopTriggerBuf = 1U;
            }

            if ( u16PopTriggerBuf )
            {
                u8PopAlarmTPMS = 1;
            }
            else
            {
                u8PopAlarmTPMS = 0;
            }
        }
        else
        {
            u8PopAlarmTPMS = 0;
        }
    }
    else
    {
        u8PopAlarmTPMS = 0;
    }
    if ( u8PopAlarmTPMS )
    {
        if ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) != CAN_SIG_LOST )&&(CanReceive.Can_18FEF433 == 1))
        {
            if(( Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelSensorStatus( ) == 0U )||
               ( Get_CAN_CH0_ID_18FEF433_Sig_CTITireStatus( ) == 1U )||
               ( Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelEndElectricalFault( ) == 1U ) ||
               ( Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection( ) == 0) ||
               ( Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection( ) == 4))
            {
                Pop_Alarm_Request_Normal(POP_ALARM_TPMS);
            }
        }
        
        if( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_SIG_LOST )||
            ( Left_Front_Display.Wheel_ID_OutTime == 1 )||
            ( Left_Rear_Display.Wheel_ID_OutTime == 1 )||
            ( Left_Rear_Inside_Display.Wheel_ID_OutTime == 1 )||
            ( Right_Front_Display.Wheel_ID_OutTime == 1 )||
            ( Right_Rear_Display.Wheel_ID_OutTime == 1 )||
            ( Right_Rear_Inside_Display.Wheel_ID_OutTime == 1 ))
        {    
            if ( Common_GetIgnOnTime( ) >= 8000 )
            {
                Pop_Alarm_Request_Normal(POP_ALARM_TPMS);
            }
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_TPMS, POP_DELAY_MIN);
    }
}
Pop_uint8_t u8PopAlarmTPMSConfigError = 0;
#define POP_TPMS_CONFIG_TIME 200U
uint16_t u16PopTPMSConfigTimeCount_0x12U = 0U;
uint16_t u16PopTPMSConfigTimeCount_0x13U = 0U;
void     Popups_Alarm_Trigger_TPMS_CONFIG_ERROR(void)
{
    if ( (Get_NodeConfig_TPMS( ) == 1) || (Get_NodeConfig_TPMS( ) == 2) )
    {

        uint8_t u8TireLocation = Get_CAN_CH0_ID_18FEF433_Sig_TireLocation( );
        /*配置为6轮时*/
        if ( Get_NodeConfig_TPMS( ) == 2 )
        {
            if ( SYS_OPR_STAT_IGN_ON )
            {

                if ( (u16PopTPMSConfigTimeCount_0x12U >= POP_TPMS_CONFIG_TIME) || (u16PopTPMSConfigTimeCount_0x13U >= POP_TPMS_CONFIG_TIME) || ((u8TireLocation != 0) && (u8TireLocation != 0x01) && (u8TireLocation != 0x10) && (u8TireLocation != 0x11) && (u8TireLocation != 0x12) && (u8TireLocation != 0x13)) )
                {
                    u8PopAlarmTPMSConfigError = 1;
                }
            }
            else
            {
                if ( u8PopAlarmTPMSConfigError == 1 )
                {
                    if ( (u8TireLocation == 0x12) || (u8TireLocation == 0x13) )
                    {

                        u8PopAlarmTPMSConfigError = 0;
                    }
                }
            }
            if ( u8PopAlarmTPMSConfigError == 1 )
            {
                if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_SIG_LOST )
                {

                    u8PopAlarmTPMSConfigError = 0;
                }
            }
        }
        else /*配置为4轮时*/
        {
            if ( SYS_OPR_STAT_IGN_ON )
            {

                if ( (u8TireLocation != 0) && (u8TireLocation != 0x01) && (u8TireLocation != 0x10) && (u8TireLocation != 0x11) )
                {

                    u8PopAlarmTPMSConfigError = 1;
                }
            }
            else
            {
                if ( u8PopAlarmTPMSConfigError == 1 )
                {
                    if ( (u8TireLocation != 0x12) && (u8TireLocation != 0x13) )
                    {
                        u8PopAlarmTPMSConfigError = 0;
                    }
                }
            }
            if ( u8PopAlarmTPMSConfigError == 1 )
            {
                if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) == CAN_SIG_LOST )
                {

                    u8PopAlarmTPMSConfigError = 0;
                }
            }
        }
    }
    else
    {
        u8PopAlarmTPMSConfigError = 0;
    }

    if ( u8PopAlarmTPMSConfigError )
    {
        Pop_Alarm_Request_Normal(POP_ALARM_TPMS_CONFIG_ERROR);
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_TPMS_CONFIG_ERROR, POP_DELAY_MIN);
    }
}
Pop_uint8_t u8PopAlarmEmissionFailService = 0;
void        Popups_Alarm_Trigger_EMISSION_FAIL_SERVICE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error( ) == 1 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_EMISSION_FAIL_SERVICE);
            u8PopAlarmEmissionFailService = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_SERVICE, POP_DELAY_MIN);
            u8PopAlarmEmissionFailService = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_SERVICE, POP_DELAY_MIN);
        u8PopAlarmEmissionFailService = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaFailChange = 0;
void        Popups_Alarm_Trigger_UREA_FAIL_CHANGE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error( ) == 1 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_FAIL_CHANGE);
            u8PopAlarmUreaFailChange = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_CHANGE, POP_DELAY_MIN);
            u8PopAlarmUreaFailChange = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_CHANGE, POP_DELAY_MIN);
        u8PopAlarmUreaFailChange = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaLowAdd = 0;
void        Popups_Alarm_Trigger_UREA_LOW_ADD(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 2 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_LOW_ADD);
            u8PopAlarmUreaLowAdd = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_ADD, POP_DELAY_MIN);
            u8PopAlarmUreaLowAdd = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_ADD, POP_DELAY_MIN);
        u8PopAlarmUreaLowAdd = 0;
    }
}
Pop_uint8_t u8PopAlarmEmissionFailLimit75 = 0;
void        Popups_Alarm_Trigger_EMISSION_FAIL_LIMIT_75(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error( ) == 2 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_EMISSION_FAIL_LIMIT_75);
            u8PopAlarmEmissionFailLimit75 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_LIMIT_75, POP_DELAY_MIN);
            u8PopAlarmEmissionFailLimit75 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_LIMIT_75, POP_DELAY_MIN);
        u8PopAlarmEmissionFailLimit75 = 0;
    }
}

Pop_uint8_t u8PopAlarmUreaFailLimit75 = 0;
void        Popups_Alarm_Trigger_UREA_FAIL_LIMIT_75(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error( ) == 2 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_FAIL_LIMIT_75);
            u8PopAlarmUreaFailLimit75 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_LIMIT_75, POP_DELAY_MIN);
            u8PopAlarmUreaFailLimit75 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_LIMIT_75, POP_DELAY_MIN);
        u8PopAlarmUreaFailLimit75 = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaLowLimit75 = 0;
void        Popups_Alarm_Trigger_UREA_LOW_LIMIT_75(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 3 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_LOW_LIMIT_75);
            u8PopAlarmUreaLowLimit75 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_LIMIT_75, POP_DELAY_MIN);
            u8PopAlarmUreaLowLimit75 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_LIMIT_75, POP_DELAY_MIN);
        u8PopAlarmUreaLowLimit75 = 0;
    }
}
Pop_uint8_t u8PopAlarmLimit75Service = 0;
void        Popups_Alarm_Trigger_LIMIT_75_SERVICE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error( ) == 3 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_LIMIT_75_SERVICE);
            u8PopAlarmLimit75Service = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_LIMIT_75_SERVICE, POP_DELAY_MIN);
            u8PopAlarmLimit75Service = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_LIMIT_75_SERVICE, POP_DELAY_MIN);
        u8PopAlarmLimit75Service = 0;
    }
}
Pop_uint8_t u8PopAlarmLimit75Change = 0;
void        Popups_Alarm_Trigger_LIMIT_75_CHANGE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error( ) == 3 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_LIMIT_75_CHANGE);
            u8PopAlarmLimit75Change = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_LIMIT_75_CHANGE, POP_DELAY_MIN);
            u8PopAlarmLimit75Change = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_LIMIT_75_CHANGE, POP_DELAY_MIN);
        u8PopAlarmLimit75Change = 0;
    }
}

void Popups_Alarm_Trigger_UREA_LOW_TORQUE_LIMIT_50(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
    }
    else
    {
    }
}
Pop_uint8_t u8PopAlarmUreaLowTqrqueLimit75 = 0;
void        Popups_Alarm_Trigger_UREA_LOW_TORQUE_LIMIT_75(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 4) || (Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 5) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_LOW_TORQUE_LIMIT_75);
            u8PopAlarmUreaLowTqrqueLimit75 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_TORQUE_LIMIT_75, POP_DELAY_MIN);
            u8PopAlarmUreaLowTqrqueLimit75 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_TORQUE_LIMIT_75, POP_DELAY_MIN);
        u8PopAlarmUreaLowTqrqueLimit75 = 0;
    }
}
Pop_uint8_t u8PopAlarmEmissionFailReset20 = 0;
void        Popups_Alarm_Trigger_EMISSION_FAIL_RESET_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error( ) == 4 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_EMISSION_FAIL_RESET_20);
            u8PopAlarmEmissionFailReset20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_RESET_20, POP_DELAY_MIN);
            u8PopAlarmEmissionFailReset20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_RESET_20, POP_DELAY_MIN);
        u8PopAlarmEmissionFailReset20 = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaFailReset20 = 0;
void        Popups_Alarm_Trigger_UREA_FAIL_RESET_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error( ) == 4 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_FAIL_RESET_20);
            u8PopAlarmUreaFailReset20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_RESET_20, POP_DELAY_MIN);
            u8PopAlarmUreaFailReset20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_RESET_20, POP_DELAY_MIN);
        u8PopAlarmUreaFailReset20 = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaLowReset20 = 0;
void        Popups_Alarm_Trigger_UREA_LOW_RESET_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 6 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_LOW_RESET_20);
            u8PopAlarmUreaLowReset20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_RESET_20, POP_DELAY_MIN);
            u8PopAlarmUreaLowReset20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_RESET_20, POP_DELAY_MIN);
        u8PopAlarmUreaLowReset20 = 0;
    }
}
Pop_uint8_t u8PopAlarmEmissionFail20 = 0;
void        Popups_Alarm_Trigger_EMISSION_FAIL_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error( ) == 5 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_EMISSION_FAIL_20);
            u8PopAlarmEmissionFail20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_20, POP_DELAY_MIN);
            u8PopAlarmEmissionFail20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_EMISSION_FAIL_20, POP_DELAY_MIN);
        u8PopAlarmEmissionFail20 = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaFail20 = 0;
void        Popups_Alarm_Trigger_UREA_FAIL_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error( ) == 5 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_FAIL_20);
            u8PopAlarmUreaFail20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_20, POP_DELAY_MIN);
            u8PopAlarmUreaFail20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_FAIL_20, POP_DELAY_MIN);
        u8PopAlarmUreaFail20 = 0;
    }
}
Pop_uint8_t u8PopAlarmUreaLow20 = 0;
void        Popups_Alarm_Trigger_UREA_LOW_20(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text( ) == 7 )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_UREA_LOW_20);
            u8PopAlarmUreaLow20 = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_20, POP_DELAY_MIN);
            u8PopAlarmUreaLow20 = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_UREA_LOW_20, POP_DELAY_MIN);
        u8PopAlarmUreaLow20 = 0;
    }
}
Pop_uint8_t u8PopAlarmFuelSenFail = 0;
void        Popups_Alarm_Trigger_FUEL_SEN_FAIL(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        //&& (Common_GetIgnOnTime( ) >= SELF_CHECK_TIME)
        if ( (GetFuelSensorState( ) == FuelSensorOpenCircuit) && (Common_GetIgnOnTime( ) >= 23000) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_FUEL_SEN_FAIL);
            u8PopAlarmFuelSenFail = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_FUEL_SEN_FAIL, POP_DELAY_MIN);
            u8PopAlarmFuelSenFail = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_FUEL_SEN_FAIL, POP_DELAY_MIN);
        u8PopAlarmFuelSenFail = 0;
    }
}
void Popups_Alarm_Trigger_PAR_FULL_SERVICE_RESET(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( (Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( ) == 2) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_PAR_FULL_SERVICE_RESET);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_PAR_FULL_SERVICE_RESET, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_PAR_FULL_SERVICE_RESET, POP_DELAY_MIN);
    }
}
void Popups_Alarm_Trigger_PAR_FULL_MANUAL_RESET(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( (Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( ) == 4) )
        {

            Pop_Alarm_Request_Normal(POP_ALARM_PAR_FULL_MANUAL_RESET);
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_PAR_FULL_MANUAL_RESET, POP_DELAY_MIN);
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_PAR_FULL_MANUAL_RESET, POP_DELAY_MIN);
    }
}
#define POP_ENG_LUBRICATE_TIME 80U
uint16_t    u16PopEngLubriTimeCount   = 0;
Pop_uint8_t u8PopAlarmEngineLubricate = 0;
void        Popups_Alarm_Trigger_ENGINE_LUBRICATE(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (u16PopEngLubriTimeCount >= POP_ENG_LUBRICATE_TIME) && (Get_CAN_CH0_ID_18FF2100_Sig_EDC_EngOilPrsLow( ) == 1) &&(Get_EngSpeed_Start_Flag( ) == 1U))
        {
            Pop_Alarm_Request_Normal(POP_ALARM_ENGINE_LUBRICATE);
            u8PopAlarmEngineLubricate = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_ENGINE_LUBRICATE, POP_DELAY_MIN);
            u8PopAlarmEngineLubricate = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_ENGINE_LUBRICATE, POP_DELAY_MIN);
        u8PopAlarmEngineLubricate = 0;
    }
}
Pop_uint8_t u8PopAlarmTemp;
void        Popups_Alarm_Trigger_TEMP(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( CanReceive.Can_18FEEE00 == 1 )
        {
            if ( Get_CAN_CH0_ID_18FEEE00_Sig_EngCoolantTemp( ) >= 0xFE )
            {
                u8PopAlarmTemp = 1;
            }
            else
            {
                if ( Get_Coolant_Temp_Cur_Display_Value( ) >= 71 )
                {
                    u8PopAlarmTemp = 1;
                }
                else if ( Get_Coolant_Temp_Cur_Display_Value( ) <= 60 )
                {
                    u8PopAlarmTemp = 0;
                }
                else
                {
                }
            }
        }
        else
        {
            u8PopAlarmTemp = 0;
        }
    }
    else
    {
        u8PopAlarmTemp = 0;
    }
    if ( u8PopAlarmTemp )
    {
        Pop_Alarm_Request_Normal(POP_ALARM_TEMP);
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_TEMP, POP_DELAY_MIN);
    }
}
/*(Get_CAN_CH0_ID_10FF7521_Sig_LHRDoorSts() == 1)*/
Pop_uint8_t u8PopAlarmDoor = 0;
void        Popups_Alarm_Trigger_DOOR(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( ((Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_BonnetSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_RHatchSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts( ) == 1)) && (Common_Get_Act_V_Speed( ) >= 150) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_DOOR);
            u8PopAlarmDoor = 1;
        }
        else
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_DOOR, POP_DELAY_MIN);
            u8PopAlarmDoor = 0;
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_DOOR, POP_DELAY_MIN);
        u8PopAlarmDoor = 0;
    }
}
#define POP_DPF_TIME 600U

uint16_t    u16PopDPFTimeCount = 0;
Pop_uint8_t u8PopAlarmDPF      = 0;
void        Popups_Alarm_Trigger_DPF(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {

        if ( (Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( ) == 1) && (Get_EngSpeed_Start_Flag( ) == 1U) )
        {
            Pop_Alarm_Request_Normal(POP_ALARM_DPF);
            u16PopDPFTimeCount = 0U;
            u8PopAlarmDPF      = 1;
        }
        if ( (Get_EngSpeed_Start_Flag( ) == 0U) )
        {
            Pop_Alarm_Delete_Normal(POP_ALARM_DPF, POP_DELAY_NULL);
            u16PopDPFTimeCount = 0U;
            u8PopAlarmDPF      = 0;
        }
        else
        {
            if ( (u16PopDPFTimeCount >= POP_DPF_TIME) && (Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( ) != 1) )
            {
                Pop_Alarm_Delete_Normal(POP_ALARM_DPF, POP_DELAY_NULL);
                u8PopAlarmDPF = 0;
            }
        }
    }
    else
    {
        Pop_Alarm_Delete_Normal(POP_ALARM_DPF, POP_DELAY_NULL);
        u8PopAlarmDPF = 0;
    }
}
void Popups_Alarm_Trigger_Mileage(Pop_uint8_t u8MileData)
{
    if ( Line_In_Get_Status(LINE_IN_Safety_Belt) == 1U )
    {
        if ( u16SafeBeltMileage < SFBL_MIL )
        {
            u16SafeBeltMileage++;
        }
    }
    else
    {
        u16SafeBeltMileage = 0;
    }
}
void Popups_Alarm_Trigger_Time(void)
{
    // 100ms
    if ( SYS_OPR_STAT_IGN_ON )
    {
        uint8_t u8TireLocation = Get_CAN_CH0_ID_18FEF433_Sig_TireLocation( );
        if ( (Get_EngSpeed_Start_Flag( ) == 1U) && (Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( ) != 1) )
        {
            if ( u16PopDPFTimeCount < POP_DPF_TIME )
            {
                u16PopDPFTimeCount++;
            }
        }
        else
        {
            u16PopDPFTimeCount = 0U;
        }
        if ( (Get_EngSpeed_Start_Flag( ) == 1U) )
        {
            if ( u16PopEngLubriTimeCount < POP_ENG_LUBRICATE_TIME )
            {
                u16PopEngLubriTimeCount++;
            }
        }
        else
        {
            u16PopEngLubriTimeCount = 0U;
        }
        if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FEF433_Msg_Count) != CAN_SIG_LOST )
        {
            if ( (u8TireLocation == 0x12U)  )//在线
            {
                u16PopTPMSConfigTimeCount_0x12U = 0U;
            }
            else//掉线
            {
                if ( u16PopTPMSConfigTimeCount_0x12U < POP_TPMS_CONFIG_TIME )
                {
                    u16PopTPMSConfigTimeCount_0x12U++;
                }
            }

            if ( (u8TireLocation == 0x13U)  )//在线
            {
                u16PopTPMSConfigTimeCount_0x13U = 0U;
            }
            else//掉线
            {
                if ( u16PopTPMSConfigTimeCount_0x13U < POP_TPMS_CONFIG_TIME )
                {
                    u16PopTPMSConfigTimeCount_0x13U++;
                }
            }
        }
        else
        {
            u16PopTPMSConfigTimeCount_0x12U = 0U;
            u16PopTPMSConfigTimeCount_0x13U = 0U;
        }
        if ( Line_In_Get_Status(LINE_IN_Safety_Belt) == 1U )
        {
            if ( Get_DispVechileSpeed( ) >= 30 )
            {
                if ( u16SafeBeltTime < SFBL_TIME )
                {
                    u16SafeBeltTime++;
                }
            }
            else
            {
                // u16SafeBeltTime = 0U;
            }
        }
        else
        {
            u16SafeBeltTime    = 0U;
            u16SafeBeltMileage = 0U;
        }
    }
    else
    {
        u16PopDPFTimeCount        = 0U;
        u16PopEngLubriTimeCount   = 0U;
        u16PopTPMSConfigTimeCount_0x12U = 0U;
        u16PopTPMSConfigTimeCount_0x13U = 0U;
    }

    Pop_Alarm_Handle_Time(1);
    Pop_Alarm_Service( );
}
void Popups_Alarm_Trigger_Delete_All(void)
{

    Pop_Alarm_en_t enPopIndexBuf = 0U;
    for ( enPopIndexBuf = 0U; enPopIndexBuf < POP_ALARM_MAX; enPopIndexBuf++ )
    {
        Pop_Alarm_Delete_Normal(enPopIndexBuf, POP_DELAY_NULL);
    }
}
void Popups_Alarm_Trigger_OFF_Init(void)
{
    u8PopAlarmTPMSConfigError = 0;
    Popups_Alarm_Trigger_Delete_All( );
}
void Popups_Alarm_Trigger_ON_Init(void)
{
    u8SafeBeltTrigger         = 0;
    u16SafeBeltMileage        = 0;
    u16SafeBeltTime           = 0;
    u16PopTPMSConfigTimeCount_0x12U = 0U;
    u16PopTPMSConfigTimeCount_0x13U = 0U;
    u8PopAlarmTPMSConfigError = 0;
    Popups_Alarm_Trigger_Delete_All( );
}
void Popups_Alarm_Trigger_WakeUp_Init(void)
{
    u8PopAlarmGearBoxFailure  = 0;
    u16PopTPMSConfigTimeCount_0x12U = 0U;
    u16PopTPMSConfigTimeCount_0x13U = 0U;
}

void Popups_Alarm_Trigger_Service(void)
{

    if ( SYS_OPR_STAT_HALT )
    {
        return;
    }
    Popups_Alarm_Trigger_ESC_ATCIVE_CLOSE( );

    if ( ((Common_GetIgnOnTime( ) <= SELF_CHECK_TIME) && (SYS_OPR_STAT_IGN_ON)) )
    {
        return;
    }
    Popups_Alarm_Trigger_ESC_FAILURE( );

    Popups_Alarm_Trigger_GEARBOX_HIGH_TEMP( );
    Popups_Alarm_Trigger_GEARBOX_CAUTION( );
    Popups_Alarm_Trigger_RADAR_FAILURE( );
    Popups_Alarm_Trigger_GEARBOX_FAILURE( );
    Popups_Alarm_Trigger_PARK_IN_P( );
    Popups_Alarm_Trigger_P_INVALID( );
    Popups_Alarm_Trigger_BRAKE_TO_SHIFT( );
    Popups_Alarm_Trigger_START_IN_P( );
    Popups_Alarm_Trigger_TBOX_DISMANTLE( );

    Popups_Alarm_Trigger_TSAFE_BELT( );
    Popups_Alarm_Trigger_TPMS( );
    Popups_Alarm_Trigger_TPMS_CONFIG_ERROR( );
    Popups_Alarm_Trigger_EMISSION_FAIL_SERVICE( );
    Popups_Alarm_Trigger_UREA_FAIL_CHANGE( );
    Popups_Alarm_Trigger_UREA_LOW_ADD( );
    Popups_Alarm_Trigger_EMISSION_FAIL_LIMIT_75( );
    Popups_Alarm_Trigger_UREA_FAIL_LIMIT_75( );
    Popups_Alarm_Trigger_UREA_LOW_LIMIT_75( );
    Popups_Alarm_Trigger_LIMIT_75_SERVICE( );
    Popups_Alarm_Trigger_LIMIT_75_CHANGE( );
    Popups_Alarm_Trigger_UREA_LOW_TORQUE_LIMIT_50( );
    Popups_Alarm_Trigger_UREA_LOW_TORQUE_LIMIT_75( );
    Popups_Alarm_Trigger_EMISSION_FAIL_RESET_20( );
    Popups_Alarm_Trigger_UREA_FAIL_RESET_20( );
    Popups_Alarm_Trigger_UREA_LOW_RESET_20( );
    Popups_Alarm_Trigger_EMISSION_FAIL_20( );
    Popups_Alarm_Trigger_UREA_FAIL_20( );
    Popups_Alarm_Trigger_UREA_LOW_20( );
    Popups_Alarm_Trigger_FUEL_SEN_FAIL( );
    Popups_Alarm_Trigger_PAR_FULL_SERVICE_RESET( );
    Popups_Alarm_Trigger_PAR_FULL_MANUAL_RESET( );
    Popups_Alarm_Trigger_ENGINE_LUBRICATE( );
    Popups_Alarm_Trigger_TEMP( );
    Popups_Alarm_Trigger_DOOR( );
    Popups_Alarm_Trigger_DPF( );

    Popups_Alarm_Trigger_POSITION_LIGHT( );
    Popups_Alarm_Trigger_KEY( );
    Popups_Alarm_Trigger_HILL_HOLD_MALF( );

    Pop_Alarm_Service( );
}