#include "Sound_Alarm_handle.h"
#include "Sound_Alarm_User.h"
#include "Buzzer_Play_User.h"

/********************************************************************************************/
const Buzzer_Attribute_st_t stSoundSourceAttribute [ SOUND_SOURCE_MAX ] = {
    {975U, 500U, 50U, 0U, 500U},
    {2074U, 500U, 50U, 0U, 500U},
    {846U, 500U, 50U, 0U, 500U},
    {520U, 500U, 50U, 0U, 500U},
    /************************************************************/
    {1385U, 500U, 50U, 0U, 500U},
    {2074U, 500U, 0U, 0xFFFFU, 0U},
    {2074U, 500U, 500U, 500U, 0U},
    {2074U, 500U, 250U, 250U, 0U},
    {2074U, 500U, 125U, 125U, 0U},
    {2074U, 500U, 63U, 63U, 0U},
    {656U, 500U, 50U, 0U, 4U},
    {625U, 500U, 50U, 0U, 4U},

    {854U, 500U, 50U, 0U, 200U},
    {2032U, 500U, 50U, 0U, 500U},

};
/********************************************************************************************/

const Sound_Variety_Attribute_st_t stSoundVarietyAttribute [ SOUND_VARIETY_MAX ] = {
    {SOUND_SOURCE_0, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_1, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_2, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_3, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_4, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_RADAR_0, 0XFFFFFFFFUL, 0U, SOUND_SOURCE_PLAY_TYPE_LOOP, 0U, 0U, 1U},
    {SOUND_SOURCE_RADAR_1, 1000U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_RADAR_2, 500U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_RADAR_4, 250U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_RADAR_8, 126U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_TICK, 60U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_TOCK, 60U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_5, 250U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_6, 600U, 400U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
    {SOUND_SOURCE_MAX, 100U, 0U, SOUND_SOURCE_PLAY_TYPE_ONCE, 0U, 0U, 1U},
};
const Sound_Alarm_Attribute_st_t stSoundAlarmAttribute [ SOUND_ALARM_MAX ] = {
    /*SOUND_ALARM_VOLUME*/ {SOUND_VARIETY_5, 1U, SOUND_ALARM_TRIGGER_MULTI, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},

    /*SOUND_ALARM_DPF*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_DOOR*/ {SOUND_VARIETY_2, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_LOOP*/ {SOUND_VARIETY_RADAR_0, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_8*/ {SOUND_VARIETY_RADAR_8, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_4*/ {SOUND_VARIETY_RADAR_4, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_2*/ {SOUND_VARIETY_RADAR_2, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_1*/ {SOUND_VARIETY_RADAR_1, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_RADAR_0*/ {SOUND_VARIETY_NO, 0xFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_GEAR_P*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_START_IN_P*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_PARK_IN_P*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_P_INVALID*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_GEARBOX_HIGH_TEMP*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_GEARBOX_FAILURE*/ {SOUND_VARIETY_RADAR_0, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_TEMP*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_ENGINE_LUBRICATE*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_PAR_FULL_MANUAL_RESET*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_PAR_FULL_SERVICE_RESET*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_SPEED_LIMIT*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_2*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_3*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_4*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_5*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_6*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_7*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_8*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_9*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_10*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_11*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_12*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_13*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_14*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_UREA_15*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_TPMS*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_TPMS_CONFIG_ERROR*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_SAFE_BELT*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    
    /*SOUND_ALARM_FUEL_SEN_FAIL*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_START_IN_P_ONCE*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_BRAKE_TO_SHIFT*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_GEARBOX_CAUTION*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_TBOX*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_ESC_FAILURE*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_ESC_ATCIVE*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_ESC_CLOSE*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_HILL_HOLD_MALF*/ {SOUND_VARIETY_1, 1U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},

    /*SOUND_ALARM_UNPLUGGED_KEY*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_LIGHT_LEFT_ON*/ {SOUND_VARIETY_2, 0XFFU, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_RECOVER_CONTINUE, SOUND_ALARM_NUM_FINISH_RESET},
    
    /*SOUND_ALARM_TICK*/ {SOUND_VARIETY_TICK, 1U, SOUND_ALARM_TRIGGER_MULTI, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
    /*SOUND_ALARM_TOCK*/ {SOUND_VARIETY_TOCK, 1U, SOUND_ALARM_TRIGGER_MULTI, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},
   
    /*SOUND_ALARM_LOW_OIL_PRESSURE*/ {SOUND_VARIETY_3, 3U, SOUND_ALARM_TRIGGER_NORMAL, SOUND_ALARM_BREAK_NONE, SOUND_ALARM_NUM_FINISH_RESET},

};
/****************************************************************************************************/
Sound_Operate_Type_en_t Sound_Operate_Process_PlayOnce(Sound_Source_en_t enSoundSourceIndex)
{
    Sound_Operate_Type_en_t enSoundOperateResult = SOUND_OPERATE_SUCCESS;
    if ( Buzzer_Get_Status( ) == 0 )
    {
        if ( enSoundSourceIndex < SOUND_SOURCE_MAX )
        {
            enSoundOperateResult = Buzzer_Start_Play(&stSoundSourceAttribute [ enSoundSourceIndex ]);
        }
    }
    else
    {
        enSoundOperateResult = SOUND_OPERATE_FAIL;
    }
    return enSoundOperateResult;
}
Sound_Operate_Type_en_t Sound_Operate_Process_PlayLoop(Sound_Source_en_t enSoundSourceIndex)
{
    Sound_Operate_Type_en_t enSoundOperateResult = SOUND_OPERATE_SUCCESS;
    if ( Buzzer_Get_Status( ) == 0 )
    {
        if ( enSoundSourceIndex < SOUND_SOURCE_MAX )
        {
            enSoundOperateResult = Buzzer_Start_Play(&stSoundSourceAttribute [ enSoundSourceIndex ]);
        }
    }
    else
    {
        enSoundOperateResult = SOUND_OPERATE_FAIL;
    }
    return enSoundOperateResult;
}
Sound_Operate_Type_en_t Sound_Operate_Process_StopOnce(Sound_Source_en_t enSoundSourceIndex)
{
    Sound_Operate_Type_en_t enSoundOperateResult = SOUND_OPERATE_SUCCESS;
    enSoundOperateResult                         = Buzzer_Stop_Play( );
    return enSoundOperateResult;
}
Sound_Operate_Type_en_t Sound_Operate_Process_StopLoop(Sound_Source_en_t enSoundSourceIndex)
{
    Sound_Operate_Type_en_t enSoundOperateResult = SOUND_OPERATE_SUCCESS;
    enSoundOperateResult                         = Buzzer_Stop_Play( );
    return enSoundOperateResult;
}
Sound_Operate_Type_en_t Sound_Operate_Set_Volume_Handle(Sound_Source_en_t enSoundSourceIndex, Sound_uint8_t u8SoundVolume)
{
    Sound_Operate_Type_en_t enSoundOperateResult = SOUND_OPERATE_SUCCESS;

    return enSoundOperateResult;
}
Sound_Source_Play_Status_en_t Sound_Get_Status_Handle(void)
{
    Sound_Source_Play_Status_en_t enSoundSourceStatus;
    if(Buzzer_Get_Status( ))
    {
        enSoundSourceStatus = 1;
    }
    else
    {
        enSoundSourceStatus = 0;
    }
    return enSoundSourceStatus;
}
/***************************************************************************************************/
Sound_uint8_t u8SoundRAM [ SOUND_RAM_DATA_LEN ];
void          Sound_Alarm_Init_Example(void)
{
    Sound_Alarm_Init_st_t stSoundAlarmInit;
    stSoundAlarmInit.enSoundVarietyLen        = SOUND_VARIETY_MAX;
    stSoundAlarmInit.enSoundAlarmLen          = SOUND_ALARM_MAX;
    stSoundAlarmInit.enSoundAlarmSortord      = SOUND_ALARM_SORTORD_AFTER;
    stSoundAlarmInit.u8SoundDiffPrioNum       = SOUND_DIFF_PRIO_NUM;
    stSoundAlarmInit.u8SoundSamePrioNum       = SOUND_SAME_PRIO_NUM;
    stSoundAlarmInit.u8SoundReserved1         = 0;
    stSoundAlarmInit.u8SoundReserved2         = 0;
    stSoundAlarmInit.pfnSoundOperatePlayOnce  = Sound_Operate_Process_PlayOnce;
    stSoundAlarmInit.pfnSoundOperatePlayLoop  = Sound_Operate_Process_PlayLoop;
    stSoundAlarmInit.pfnSoundOperateStopOnce  = Sound_Operate_Process_StopOnce;
    stSoundAlarmInit.pfnSoundOperateStopLoop  = Sound_Operate_Process_StopLoop;
    stSoundAlarmInit.pfnSoundOperateSetVolume = Sound_Operate_Set_Volume_Handle;
    stSoundAlarmInit.pfnSoundGetStatus        = Sound_Get_Status_Handle;
    Sound_Alarm_Init(u8SoundRAM, stSoundAlarmAttribute, stSoundVarietyAttribute, &stSoundAlarmInit);

    u32SoundEnableSuspend = 1;
}
