#include "GUI.h"
#include "g_includes.h"
#include "Popup_Alarm_Handle.h"
#include "DataProcess.h"
#include "Mileage_user.h"
#include "Key.h"
#include "Key_user.h"
#include "TYW_stdint.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"
#include "imag_Map.h"
#include "api_tft.h"
#include "PowerManag_User.h"
#include "MSG_POP_PIC.h"
#include "LCDFont.h"


// uint8_t g_u8DrawGraphEn = 0U;
 uint8_t g_u8DrawGraphOnce = 0U;
void Draw_Graph_Engine(void)
{ /* Task 50ms */

    if ( SYS_OPR_STAT_IGN_ON )
    {
        Draw_Graph_main( );
        // Draw_Graph_En_Set(1);
        // g_u8DrawGraphOnce = 0U;
             g_u8DrawGraphOnce = 1U;
    }
    else
    {
        //if ( Common_GetIgnOffTime( ) <= 5000 )
        //{
        //    Draw_Graph_main( );
        //     g_u8DrawGraphOnce = 1U;
        //}
        //else
        //{
        //     if(g_u8DrawGraphOnce == 1)
        //    {
        //     	g_u8DrawGraphOnce = 0U;
        //        // GUI_Animation_BG();
        //         Draw_Graph_main( );
        //        // g_u8DrawGraphOnce = 1U;
        //    }
        //}
        if((Pop_Alarm_Get_Current() == POP_ALARM_POSITION_LIGHT)||(Pop_Alarm_Get_Current() == POP_ALARM_KEY))
        {            
            Draw_Graph_main( );
            g_u8DrawGraphOnce = 1U;        
        }
        else
        {
            if ( Common_GetIgnOffTime( ) <= 20000 )
            {
                Draw_Graph_main( );
                 g_u8DrawGraphOnce = 1U;
            }
            else
            {
                 if(g_u8DrawGraphOnce == 1)
                {
                 	g_u8DrawGraphOnce = 0U;
                    // GUI_Animation_BG();
                     Draw_Graph_main( );
                    // g_u8DrawGraphOnce = 1U;
                }
            }
        }
    }
}

// void Draw_Graph_En_Set(uint8_t u8Enable)
// {
// 	g_u8DrawGraphEn = u8Enable;
// }

// uint8_t Draw_Graph_En_Get(void)
// {
// 	return g_u8DrawGraphEn;
// }


/************************************************************************************************************/

_Page_Infor                       PageInforGui;
_Page_Infor                       DisplayInfor_BackUp;
_GUIBackUp                        GUIBackUp;
Menu_Item_en_t                    MenuCur;
Menu_Item_en_t                    MenuCur_Back;
extern Urea_Limited_Torque_Struct Urea_Limited_Torque;
extern Urea_Limited_Vehicle_Speed_Struct Urea_Limited_Vehicle_Speed;
const uint8_t *Number_14_white_List [] = {
    Number_14_White_0_X0_Y0,
    Number_14_White_1_X0_Y0,
    Number_14_White_2_X0_Y0,
    Number_14_White_3_X0_Y0,
    Number_14_White_4_X0_Y0,
    Number_14_White_5_X0_Y0,
    Number_14_White_6_X0_Y0,
    Number_14_White_7_X0_Y0,
    Number_14_White_8_X0_Y0,
    Number_14_White_9_X0_Y0,
    Number_14_White_heng_X0_Y0,
    Number_14_White_point_X0_Y0,
    Number_14_White_point2_X0_Y0,
};
const uint8_t *Number_17_white_List [] = {
    Number_17_White_0_X0_Y0,
    Number_17_White_1_X0_Y0,
    Number_17_White_2_X0_Y0,
    Number_17_White_3_X0_Y0,
    Number_17_White_4_X0_Y0,
    Number_17_White_5_X0_Y0,
    Number_17_White_6_X0_Y0,
    Number_17_White_7_X0_Y0,
    Number_17_White_8_X0_Y0,
    Number_17_White_9_X0_Y0,
    Number_17_White_heng_X0_Y0,
    Number_17_White_point_X0_Y0,
    Number_17_White_point2_X0_Y0,
    Number_17_White_point3_X0_Y0,
};
const uint8_t *Number_18_white_List [] = {
    Number_18_White_0_X0_Y0,
    Number_18_White_1_X0_Y0,
    Number_18_White_2_X0_Y0,
    Number_18_White_3_X0_Y0,
    Number_18_White_4_X0_Y0,
    Number_18_White_5_X0_Y0,
    Number_18_White_6_X0_Y0,
    Number_18_White_7_X0_Y0,
    Number_18_White_8_X0_Y0,
    Number_18_White_9_X0_Y0,
    Number_18_White_heng_X0_Y0,
    Number_18_White_point_X0_Y0,
    Number_18_White_point2_X0_Y0,
    Number_18_White_point3_X0_Y0,
};
const uint8_t *Number_30_white_List [] = {
    Number_30_White_0_X0_Y0,
    Number_30_White_1_X0_Y0,
    Number_30_White_2_X0_Y0,
    Number_30_White_3_X0_Y0,
    Number_30_White_4_X0_Y0,
    Number_30_White_5_X0_Y0,
    Number_30_White_6_X0_Y0,
    Number_30_White_7_X0_Y0,
    Number_30_White_8_X0_Y0,
    Number_30_White_9_X0_Y0,
    Number_30_White_heng_X0_Y0,
    Number_30_White_point_X0_Y0,
    Number_30_White_point2_X0_Y0,
};

uint8_t  Clear_Flag;
uint8_t  Animation     = 0;
uint8_t  GUI_Power_Off = 0;
uint8_t  ALARMTEST;
uint8_t  PopupAlarm;
uint8_t  GUI_Power;
uint16_t PageType;
uint32_t u32GUIpop = 0;
uint8_t u8Picture_Display = 0;
uint8_t u8Controlled_Display = 0;
/*u8Controlled : 0 诊断不可控     3 诊断可控   */
/*u8Picture    : 诊断可控时，具体显示哪张图片   */
void Display_Diag_Ctrl(uint8_t u8Controlled, uint8_t u8Picture)
{
    if ( u8Controlled == 3 )
    {
       u8Controlled_Display = u8Controlled;  
       u8Picture_Display    = u8Picture;
    }
    else
    {
        u8Controlled_Display = 0;
        u8Picture_Display    = 0;
    }
}
void Display_Ctrl_Init(void)
{
    u8Controlled_Display = 0;
    u8Picture_Display    = 0;
}
void Display_Ctrl_OFF_Init(void)
{
    u8Controlled_Display = 0;
    u8Picture_Display    = 0;
}
void GUI_Service(void)
{
    if (SYS_OPR_STAT_RUN )    
    {

        PopupAlarm = Pop_Alarm_Get_Current( );
        MenuCur    = Menu_Get_Current_Cursor_Information( );
        if ( SYS_OPR_STAT_IGN_ON )
        {
            if ( Common_GetIgnOnTime( ) <= SELF_CHECK_TIME )
            {
                GUI_Display_PowerOn( );
                u32GUIpop=0;
            }
            else
            {                
                if (u32GUIpop==0)
                {
                    u32GUIpop=1;
                    Popups_Alarm_Trigger_Service();
                    PopupAlarm = Pop_Alarm_Get_Current( );
                }
                
                if ( PopupAlarm < POP_ALARM_MAX )
                {
                    PageInforGui.PageType = Page_Alarm;
                }
                else
                {
                    PageInforGui.PageType = Page_Menu;
                }

                if ( u8Controlled_Display == 3 )
                {
                    switch( u8Picture_Display )
                    {            
                        case 1 :
                        {
                            Draw_Image_Local(( uint8_t * )Kai_04_1_X0_Y0, 0, 0);
                            Draw_Image_Local(( uint8_t * )Kai_04_2_X0_Y160, 0, 160);
                            break;
                        }                
                        case 2 :
                        {
                            Draw_Image_Local(( uint8_t * )Kai_02_1_X0_Y0, 0, 0);
                            Draw_Image_Local(( uint8_t * )Kai_02_2_X0_Y160, 0, 160);
                            break;
                        }     
                        case 3 :
                        {
                            Draw_Image_Local(( uint8_t * )Kai_03_1_X0_Y0, 0, 0);
                            Draw_Image_Local(( uint8_t * )Kai_03_2_X0_Y160, 0, 160);
                            break;
                        }     
                        case 4 :
                        {
                            Draw_Image_Local(( uint8_t * )Kai_01_1_X0_Y0, 0, 0);
                            Draw_Image_Local(( uint8_t * )Kai_01_2_X0_Y160, 0, 160);
                            break;
                        }    
                        default :
                            break;
                    }
                }
                else
                {
                    GUI_Display_BackGround( );

				    if (PageInforGui.PageType == Page_Alarm)
				    {
				    	GUI_PopAlarm_Display(PopupAlarm);
				    }
				    else if (PageInforGui.PageType == Page_Menu)
				    {
				    	if ((MenuCur >= MENU_ITEM_ECU_TRIP) && (MenuCur <= MENU_ITEM_ECU_TPMS))
				    	{
				    		GUI_ECU_Display();
				    	}
				    	if ((MenuCur >= MENU_ITEM_SET_Backlight) && (MenuCur <= MENU_ITEM_SET_TimeMin))
				    	{
				    		GUI_SET_Display();
				    	}
				    }
                }
                
			
				
			}
		}
		else 
		{	
			GUI_PopAlarm_IGOFF();            

			if (Common_GetIgnOffTime() <= 20000)
			{
				GUI_BJ_TIME_MIDDLE_Display(RTC_HOUR, RTC_MINUTE);				
			}			
		}			
	}
	
	
}
/************************************************************************************************/

/************************************************************************************************/
void GUI_Display_PowerOn(void)
{
    Draw_Image_Local(( uint8_t * )Kai_tu_01_X38_Y122, 39, 122);
    Draw_Image_Local(( uint8_t * )Kai_V_X175_Y287, 175, 287);
    Draw_Image_Local(( uint8_t * )Number_17_White_0_X0_Y0, 189, 287);
    Draw_Image_Local(( uint8_t * )Number_17_White_point3_X0_Y0, 200, 287);
    Draw_Image_Local(( uint8_t * )Number_17_White_5_X0_Y0, 206, 287);
}
/***********************************************************************************************************************/
uint16 u16LJSfueltesk[10];
void GUI_Display_BackGround(void)
{	
	Gui_Temp_Display(Get_Coolant_Temp_Value());
	Gui_Fuel_Display(Get_Fuel_curPosition(),MinFuelMeter.Icon); 
	Gui_UREA_Display(Get_Urea_curPosition(), Urea_st.Icon);  
	GUI_BJ_ODO_Display(Mile_Get_Index_Value(MILE_INDEX_ODO));  
	GUI_BJ_TIME_Display(RTC_HOUR, RTC_MINUTE);  
    if(Get_NodeConfig_GearBoxType() == 1)
    {
        GUI_BJ_Gear_Display(Gear.Mode, Gear.Valid); 
    }
    if(Maint_Get_Remain_Flag( ))
    {
        //Draw_Image_Local(( uint8_t * )ECU_Unit_CN_09_X75_Y192, 75, 192); 
        Draw_Image_Local(( uint8_t * )Dang_ban_X125_Y276, 125, 276); 
    }
	 	
}
/**********************************************************************************************************************/
const unsigned char *u32TempDisplay[]={
	Temp_zoutiao_01_00, Temp_zoutiao_01_01, Temp_zoutiao_01_02, Temp_zoutiao_01_03, Temp_zoutiao_01_04,
	Temp_zoutiao_01_05, Temp_zoutiao_01_06, Temp_zoutiao_01_07, Temp_zoutiao_01_08, Temp_zoutiao_01_09, 
	Temp_zoutiao_01_10, Temp_zoutiao_01_11, Temp_zoutiao_01_12, Temp_zoutiao_01_13, Temp_zoutiao_01_14, 
	Temp_zoutiao_01_15, Temp_zoutiao_01_16, Temp_zoutiao_01_17, Temp_zoutiao_01_18, Temp_zoutiao_01_19, 
	Temp_zoutiao_01_20, Temp_zoutiao_01_21, Temp_zoutiao_01_22, Temp_zoutiao_01_23, Temp_zoutiao_01_24, 
	Temp_zoutiao_01_25, Temp_zoutiao_01_26, Temp_zoutiao_01_27, Temp_zoutiao_01_28, Temp_zoutiao_01_29, 
	Temp_zoutiao_01_30, Temp_zoutiao_01_31, Temp_zoutiao_01_32, Temp_zoutiao_01_33, Temp_zoutiao_01_34, 
	Temp_zoutiao_01_35, Temp_zoutiao_01_36, Temp_zoutiao_01_37, Temp_zoutiao_01_38, Temp_zoutiao_01_39, 
	Temp_zoutiao_01_40, Temp_zoutiao_01_41, Temp_zoutiao_01_42, Temp_zoutiao_01_43, Temp_zoutiao_01_44, 
	Temp_zoutiao_01_45, Temp_zoutiao_01_46, Temp_zoutiao_01_47, Temp_zoutiao_01_48, Temp_zoutiao_01_49, 
	Temp_zoutiao_01_50, Temp_zoutiao_01_51, Temp_zoutiao_01_52, Temp_zoutiao_01_53, Temp_zoutiao_01_54, 
	Temp_zoutiao_01_55, Temp_zoutiao_01_56, Temp_zoutiao_01_57, Temp_zoutiao_01_58, Temp_zoutiao_01_59, 
	Temp_zoutiao_01_60, Temp_zoutiao_01_61, Temp_zoutiao_01_62, Temp_zoutiao_01_63, Temp_zoutiao_01_64, 
	Temp_zoutiao_01_65, Temp_zoutiao_01_66, Temp_zoutiao_01_67, Temp_zoutiao_01_68, Temp_zoutiao_01_69, 
	Temp_zoutiao_01_70, Temp_zoutiao_01_71, Temp_zoutiao_01_72, Temp_zoutiao_01_73, Temp_zoutiao_01_74, 
	Temp_zoutiao_01_75, Temp_zoutiao_01_76, Temp_zoutiao_01_77, Temp_zoutiao_01_78, Temp_zoutiao_01_79, 
	Temp_zoutiao_01_80, Temp_zoutiao_01_81, Temp_zoutiao_01_82, Temp_zoutiao_01_83, Temp_zoutiao_01_84, 
	Temp_zoutiao_01_85, 

};


uint16_t GUI_Coolant_dest = 0;
uint16_t GUI_Coolant_Cur  = 0;
uint16_t TempDisplayNo;
void Gui_Temp_Display(uint16_t Tempp)
{
	GUI_Coolant_dest = Gui_Temp_Data_Process(Tempp);
	if ( GUI_Coolant_Cur < GUI_Coolant_dest )
	{
		GUI_Coolant_Cur++;
		if ( GUI_Coolant_Cur > 85 )
		{
			GUI_Coolant_Cur = 85;
		}
	}
	else if ( GUI_Coolant_Cur > GUI_Coolant_dest )
	{
		GUI_Coolant_Cur--;
	}
	else
	{
		GUI_Coolant_Cur = GUI_Coolant_dest;
	}
	
	Draw_Image_Local((uint8_t *)temp_icon_01_X11_Y15,                 11,   15);
		
	Draw_Image_Local((uint8_t *)temp_C_X40_Y12,                       40,   12);
	Draw_Image_Local((uint8_t *)temp_H_X217_Y12,                      217,  12);
	Draw_Image_Local((uint8_t *)(u32TempDisplay[GUI_Coolant_Cur]),    39,   27);
}


uint16_t Gui_Temp_Data_Process(uint16_t TempValue)
{
    if(Get_Coolant_Temp_Symbol() == Positive)	
    {
        //TempValue = TempValue ;//+ 30;
        if (TempValue <= 30)
        {
            GUI_Coolant_dest = 0;
        }
        else if (TempValue <= 69)
	    {
	    	GUI_Coolant_dest = TempValue - 30;        
	    }	
	    else if (TempValue <= 96)
	    {
	    	GUI_Coolant_dest = 39;
	    }
	    else if (TempValue <= 103)
	    {
	    	GUI_Coolant_dest = 39 + 3 * (TempValue-96);
	    }	
	    else if (TempValue <= 105)
	    {
	    	GUI_Coolant_dest = 60 + 5 * (TempValue-103);
	    }
	    else if (TempValue <= 120)
	    {
	    	GUI_Coolant_dest = 70 + (TempValue-105);
	    }
	    else
	    {
	    	GUI_Coolant_dest = 85;
	    }
    }
    else
    {
        GUI_Coolant_dest = 0;
    }
	

	return GUI_Coolant_dest;
}
uint8_t Get_Coolant_Temp_Cur_Display_Value(void )
{
    return GUI_Coolant_Cur;
}
/************************************************************************************************/
const unsigned char *u32FuelDisplay[]={
	Fuel_zoutiao_02_00, Fuel_zoutiao_02_01, Fuel_zoutiao_02_02, Fuel_zoutiao_02_03, Fuel_zoutiao_02_04, 
	Fuel_zoutiao_02_05, Fuel_zoutiao_02_06, Fuel_zoutiao_02_07, Fuel_zoutiao_02_08, Fuel_zoutiao_02_09, 
	Fuel_zoutiao_02_10, Fuel_zoutiao_02_11, Fuel_zoutiao_02_12, Fuel_zoutiao_02_13, Fuel_zoutiao_02_14, 
	Fuel_zoutiao_02_15, Fuel_zoutiao_02_16, Fuel_zoutiao_02_17, Fuel_zoutiao_02_18, Fuel_zoutiao_02_19, 
	Fuel_zoutiao_02_20, Fuel_zoutiao_02_21, Fuel_zoutiao_02_22, Fuel_zoutiao_02_23, Fuel_zoutiao_02_24, 
	Fuel_zoutiao_02_25, Fuel_zoutiao_02_26, Fuel_zoutiao_02_27, Fuel_zoutiao_02_28, Fuel_zoutiao_02_29, 
	Fuel_zoutiao_02_30, Fuel_zoutiao_02_31, Fuel_zoutiao_02_32, Fuel_zoutiao_02_33, Fuel_zoutiao_02_34, 
	Fuel_zoutiao_02_35, Fuel_zoutiao_02_36, Fuel_zoutiao_02_37, Fuel_zoutiao_02_38, Fuel_zoutiao_02_39, 
	Fuel_zoutiao_02_40, Fuel_zoutiao_02_41, Fuel_zoutiao_02_42, Fuel_zoutiao_02_43, Fuel_zoutiao_02_44, 
	Fuel_zoutiao_02_45, Fuel_zoutiao_02_46, Fuel_zoutiao_02_47, Fuel_zoutiao_02_48, Fuel_zoutiao_02_49, 
	Fuel_zoutiao_02_50,	Fuel_zoutiao_02_51,	Fuel_zoutiao_02_52,	Fuel_zoutiao_02_53,	Fuel_zoutiao_02_54,
	Fuel_zoutiao_02_55,	Fuel_zoutiao_02_56,	Fuel_zoutiao_02_57,	Fuel_zoutiao_02_58,	Fuel_zoutiao_02_59,
	Fuel_zoutiao_02_60,	Fuel_zoutiao_02_61,	Fuel_zoutiao_02_62,	Fuel_zoutiao_02_63,	Fuel_zoutiao_02_64,
	Fuel_zoutiao_02_65,	Fuel_zoutiao_02_66,	Fuel_zoutiao_02_67,	Fuel_zoutiao_02_68,	Fuel_zoutiao_02_69,
	Fuel_zoutiao_02_70,	Fuel_zoutiao_02_71,	Fuel_zoutiao_02_72,	Fuel_zoutiao_02_73,	Fuel_zoutiao_02_74,
	Fuel_zoutiao_02_75,	Fuel_zoutiao_02_76,	Fuel_zoutiao_02_77,	Fuel_zoutiao_02_78,	Fuel_zoutiao_02_79,
	Fuel_zoutiao_02_80,	
	};
uint16_t FuelDisplayNo;
void Gui_Fuel_Display(uint16_t Fuell, uint8_t Icon)
{
    if ( Fuell <= 10 )
    {
        FuelDisplayNo = 0;
    }
    else if ( Fuell <= 90 )
    {
        FuelDisplayNo = Fuell - 10;
    }
    else
    {
        FuelDisplayNo = 80;
    }
    if ( Icon )
    {
        Draw_Image_Local(( uint8_t * )Fuel_icon_02_X13_Y235, 13, 235);
    }

    Draw_Image_Local(( uint8_t * )Fuel_E_02_X39_Y230, 39, 230);
    Draw_Image_Local(( uint8_t * )Fuel_F_02_X217_Y230, 217, 230);

    Draw_Image_Local(( uint8_t * )(u32FuelDisplay [ FuelDisplayNo ]), 39, 245);
}
/************************************************************************************************/
void Gui_UREA_Display(uint16_t UREAA, uint8_t Icon)
{
    if ( Icon )
    {
        Draw_Image_Local(( uint8_t * )Fuel_icon_01_X9_Y45, 10, 44);
    }

    Draw_Image_Local(( uint8_t * )Fuel_E_01_X39_Y60, 39, 60);
    Draw_Image_Local(( uint8_t * )Fuel_F_01_X217_Y60, 217, 60);
    switch ( UREAA )
    {
        case 0:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_1_X39_Y45, 39, 45);
            break;
        case 1:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_2_X39_Y45, 39, 45);
            break;
        case 2:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_3_X39_Y45, 39, 45);
            break;
        case 3:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_4_X39_Y45, 39, 45);
            break;
        case 4:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_5_X39_Y45, 39, 45);
            break;
        case 5:
            Draw_Image_Local(( uint8_t * )Fuel_zoutiao_01_6_X39_Y45, 39, 45);
            break;

        default:
            break;
    }
}
/************************************************************************************************/
static const uint16_t Mileage6changxian17PosX [] = {67, 56, 45, 34, 23, 11};
static const uint16_t Mileage5changxian17PosX [] = {67, 56, 45, 34, 23};

void GUI_BJ_ODO_Display(uint32_t Mileage)
{
    uint32_t MileageDisp = 0;
    MileageDisp          = Mileage / 10;
    Draw_Image_Local(( uint8_t * )Chang_km_X78_Y288, 80, 288);
    if ( (Mile_Get_Index_Value(MILE_INDEX_ODO) <= 2000) && (u8MileODORelated [ 8 ] == 0U) )
    {
        Draw_Image_Local(( uint8_t * )Chang_H_X10_Y287, 11, 288);
        Draw_Image_Local_Digit_Draw(MileageDisp, Number_17_white_List, 5, 0, Mileage5changxian17PosX, 288);
    }
    else
    {
        Draw_Image_Local_Digit_Draw(MileageDisp, Number_17_white_List, 6, 0, Mileage6changxian17PosX, 288);
    }
}
/**************************************************************************************************/
static const uint16_t Hour2changxian17PosX []   = {35, 23};
static const uint16_t Minute2changxian17PosX [] = {71, 59};
static const uint16_t Minute3changxian17PosX [] = {107, 95};
void GUI_BJ_TIME_Display(uint8_t Hour, uint8_t Minute)
{
    Draw_Image_Local_Digit_Draw(Hour, Number_17_white_List, 2, 0, Hour2changxian17PosX, 267);
    Draw_Image_Local(( uint8_t * )Number_17_White_point2_X0_Y0, 47, 267);
    Draw_Image_Local_Digit_Draw(Minute, Number_17_white_List, 2, 0, Minute2changxian17PosX, 267);

    //Draw_Image_Local(( uint8_t * )Number_17_White_point2_X0_Y0, 83, 267);
    //Draw_Image_Local_Digit_Draw(RTC_SECOND, Number_17_white_List, 2, 0, Minute3changxian17PosX, 267);
}
/**************************************************************************************************/
void GUI_BJ_Gear_Display(uint8_t Mode, uint8_t Valid)
{
    if ( Valid == 1 )
    {
        switch ( Mode )
        {
            case GEAR_R:
                Draw_Image_Local(( uint8_t * )Dang_R_X157_Y277, 156, 276);
                break;
            case GEAR_N:
                Draw_Image_Local(( uint8_t * )Dang_N_X157_Y277, 156, 276);
                break;
            case GEAR_P:
                Draw_Image_Local(( uint8_t * )Dang_P_X157_Y277, 156, 276);
                break;
            case GEAR_D:
                Draw_Image_Local(( uint8_t * )Dang_D_X157_Y277, 156, 276);
                break;
            case GEAR_1:
                Draw_Image_Local(( uint8_t * )Number_32_White_1_X0_Y0, 156, 276);
                break;
            case GEAR_2:
                Draw_Image_Local(( uint8_t * )Number_32_White_2_X0_Y0, 156, 276);
                break;
            case GEAR_3:
                Draw_Image_Local(( uint8_t * )Number_32_White_3_X0_Y0, 156, 276);
                break;
            case GEAR_4:
                Draw_Image_Local(( uint8_t * )Number_32_White_4_X0_Y0, 156, 276);
                break;
            case GEAR_5:
                Draw_Image_Local(( uint8_t * )Number_32_White_5_X0_Y0, 156, 276);
                break;
            case GEAR_6:
                Draw_Image_Local(( uint8_t * )Number_32_White_6_X0_Y0, 156, 276);
                break;
            case GEAR_7:
                Draw_Image_Local(( uint8_t * )Number_32_White_7_X0_Y0, 156, 276);
                break;
            case GEAR_8:
                Draw_Image_Local(( uint8_t * )Number_32_White_8_X0_Y0, 156, 276);
                break;
            case GEAR_Max:
                Draw_Image_Local(( uint8_t * )Dang_heng_X157_Y289, 157, 289);
                break;
            default:
                break;
        }
    }
    else
    {
        if ( Gear.Blink )
        {
            Draw_Image_Local(( uint8_t * )Dang_heng_X157_Y289, 157, 289);
        }
    }
}
/*******************************************************************************************************/
static const uint16_t Hour2baojing15PosX []   = {63, 52};
static const uint16_t Minute2baojing15PosX [] = {122, 111};
static const uint16_t Hour2baojing16PosX []   = {63, 52};
static const uint16_t Minute2baojing16PosX [] = {122, 111};
static const uint16_t Hour2baojing21PosX []   = {63, 52};
static const uint16_t Minute2baojing21PosX [] = {122, 111};
static const uint16_t Hour2baojing22PosX []   = {63, 52};
static const uint16_t Minute2baojing22PosX [] = {122, 111};

void GUI_PopAlarm_Display(INT16U PopupAlarmDis)
{

    switch ( PopupAlarmDis )
    {
        case POP_ALARM_DPF:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_01_X24_Y139, 24, 139);
                break;
            }
        case POP_ALARM_DOOR:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_01_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_01_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_TEMP:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_02_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_02_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_ENGINE_LUBRICATE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_03_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_03_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_PAR_FULL_MANUAL_RESET:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_02_X24_Y127, 24, 127);
                break;
            }
        case POP_ALARM_PAR_FULL_SERVICE_RESET:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_03_X24_Y127, 24, 127);
                break;
            }
        case POP_ALARM_FUEL_SEN_FAIL:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_04_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_04_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_UREA_LOW_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_2_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_FAIL_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_3_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_EMISSION_FAIL_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_4_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_LOW_RESET_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_5_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_FAIL_RESET_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_6_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_EMISSION_FAIL_RESET_20:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_7_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_LOW_TORQUE_LIMIT_75:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_8_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_LOW_TORQUE_LIMIT_50:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_8_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_LIMIT_75_CHANGE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_12_X43_Y137, 43, 137);
                if ( Urea_Limited_Vehicle_Speed.Valid )
                {
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Vehicle_Speed.Hour, Number_18_white_List, 2, 0, Hour2baojing15PosX, 162);
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Vehicle_Speed.Min, Number_18_white_List, 2, 0, Minute2baojing15PosX, 162);
                }
                else
                {
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 63, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 52, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 122, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 111, 162);
                }
                break;
            }
        case POP_ALARM_LIMIT_75_SERVICE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_13_X43_Y137, 43, 137);
                if ( Urea_Limited_Vehicle_Speed.Valid )
                {
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Vehicle_Speed.Hour, Number_18_white_List, 2, 0, Hour2baojing15PosX, 162);
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Vehicle_Speed.Min, Number_18_white_List, 2, 0, Minute2baojing15PosX, 162);
                }
                else
                {
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 63, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 52, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 122, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 111, 162);
                }
                break;
            }
        case POP_ALARM_UREA_LOW_LIMIT_75:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_9_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_FAIL_LIMIT_75:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_10_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_EMISSION_FAIL_LIMIT_75:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_11_X12_Y146, 12, 146);
                break;
            }
        case POP_ALARM_UREA_LOW_ADD:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_1_X75_Y146, 75, 146);
                break;
            }
        case POP_ALARM_UREA_FAIL_CHANGE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_14_X43_Y137, 43, 137);
                if ( Urea_Limited_Torque.Valid )
                {
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Torque.Hour, Number_18_white_List, 2, 0, Hour2baojing15PosX, 162);
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Torque.Min, Number_18_white_List, 2, 0, Minute2baojing15PosX, 162);
                }
                else
                {
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 63, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 52, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 122, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 111, 162);
                }
                break;
            }
        case POP_ALARM_EMISSION_FAIL_SERVICE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_11_X99_Y85, 99, 85);
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_16_X43_Y137, 43, 137);
                if ( Urea_Limited_Torque.Valid )
                {
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Torque.Hour, Number_18_white_List, 2, 0, Hour2baojing15PosX, 162);
                    Draw_Image_Local_Digit_Draw(Urea_Limited_Torque.Min, Number_18_white_List, 2, 0, Minute2baojing15PosX, 162);
                }
                else
                {
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 63, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 52, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 122, 162);
                    Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 111, 162);
                }
                break;
            }
        case POP_ALARM_TPMS_CONFIG_ERROR:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_05_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_05_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_TPMS:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_05_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_05_2_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_TSAFE_BELT:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_06_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_06_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_TBOX_DISMANTLE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_07_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_07_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_START_IN_P:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_09_X24_Y139, 24, 139);
                break;
            }
        case POP_ALARM_BRAKE_TO_SHIFT:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_07_X24_Y139, 24, 139);
                break;
            }
        case POP_ALARM_P_INVALID:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_06_X24_Y139, 24, 139);
                break;
            }
        case POP_ALARM_PARK_IN_P:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_08_X24_Y139, 24, 139);
                break;
            }
        case POP_ALARM_GEARBOX_FAILURE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_10_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_10_2_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_RADAR_FAILURE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_14_X64_Y142, 64, 139);
                break;
            }
        case POP_ALARM_GEARBOX_CAUTION:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_10_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_10_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_GEARBOX_HIGH_TEMP:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_10_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_10_3_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_ESC_ATCIVE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_16_X23_Y139, 23, 139);
                break;
            }
        case POP_ALARM_ESC_CLOSE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_15_X23_Y139, 23, 139);
                break;
            }
        case POP_ALARM_ESC_FAILURE:
            {
                Draw_Image_Local(( uint8_t * )Alarm_ICON_09_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_09_1_X39_Y172, 39, 172);
                break;
            }
        case POP_ALARM_LDWS_CLOSE:
        {
            Draw_Image_Local(( uint8_t * )Alarm_CN_18_X23_Y139, 23, 139);
            break;
        }
        case POP_ALARM_LDWS_FAILURE:
        {
            Draw_Image_Local(( uint8_t * )Alarm_CN_19_X23_Y139, 23, 139);
            break;
        }
        case POP_ALARM_LDWS_ATCIVE:
        {
            Draw_Image_Local(( uint8_t * )Alarm_CN_17_X23_Y139, 23, 139);
            break;
        }
        case POP_ALARM_LDWS_L_R:
        {
            if(Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWLeftWarning() == 1)
            {
                if ( g_LED.LedBlink_2HZ )
                {
                    Draw_Image_Local(( uint8_t * )Alarm_ICON_12_1_X96_Y101, 91, 101);
                }
                Draw_Image_Local(( uint8_t * )Alarm_ICON_12_2_X94_Y101, 94, 101);
                Draw_Image_Local(( uint8_t * )Alarm_CN_12_X39_Y172, 39, 172);
            }
            else
            {
                if(Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWRightWarning() == 1)
                {
                    if ( g_LED.LedBlink_2HZ )
                    {
                        Draw_Image_Local(( uint8_t * )Alarm_ICON_12_4_X140_Y101, 145, 101);
                    }
                    Draw_Image_Local(( uint8_t * )Alarm_ICON_12_3_X94_Y101, 94, 101);
                    Draw_Image_Local(( uint8_t * )Alarm_CN_12_X39_Y172, 39, 172);
                }
            }
            break;
        }
        case POP_ALARM_HILL_HOLD_MALF:
        {
            Draw_Image_Local(( uint8_t * )Alarm_ICON_08_X94_Y101, 94, 101);
            Draw_Image_Local(( uint8_t * )Alarm_CN_08_1_X39_Y172, 39, 172);
            break;
        }

        default:
            break;
    }
}
/************************************************************************************************************/

void GUI_ECU_Display(void)
{
    if ( MenuCur == MENU_ITEM_ECU_TRIP )
    {
        Gui_TRIP(Mile_Get_Index_Value(MILE_INDEX_TRAP_A));
    }
    else if ( MenuCur == MENU_ITEM_ECU_RANGE )
    {
        Gui_EndMileage(GetRangeValid( ), GetRangeDisValue( ));
    }
    else if ( MenuCur == MENU_ITEM_ECU_INS_FUEL )
    {
        Gui_InstantOilCon(Get_InsFuel_Valid( ), Get_InsFuel_Value( ));
    }
    else if ( MenuCur == MENU_ITEM_ECU_AVER_FUEL )
    {
        Gui_AvgOilCon(GET_AvgFuel_TripA_Valid( ), GET_AvgFuel_TripA_Value_Dis( ), GET_AvgFuel_TripA_500_Valid( ));
    }
    else if ( MenuCur == MENU_ITEM_ECU_AVER_SPEED )
    {
        Gui_AvgSpeed(GetAvgSpeed_Valid( ), GetAvgSpeed( ));
    }
    else if ( MenuCur == MENU_ITEM_ECU_MAINTAIN )
    {
        Gui_Maintenance(Maint_Get_Remain( ));
    }
    else if ( MenuCur == MENU_ITEM_ECU_TPMS )
    {
        Gui_TPMS( );
    }
}
/*************************************************************************************************************/
static const uint16_t TRIP5Digits18PosX [] = {127, 109, 98, 87, 76};
void Gui_TRIP(uint32_t MileageDisp)
{
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_01_X84_Y128, 84, 128);
    Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 139, 171);

    Draw_Image_Local_Digit_Draw(MileageDisp, Number_18_white_List, 5, 3, TRIP5Digits18PosX, 171);
    Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 122, 171);

    if ( MileageDisp > 0 )
    {
        Draw_Image_Local(( uint8_t * )ECU_Unit_CN_07_X67_Y208, 67, 208);
    }
}
/**********************************************************************************************************/
static const uint16_t EndMileage3Digits18PosX [] = {112, 101, 90};
static const uint16_t EndMileage2Digits18PosX [] = {106, 95};
static const uint16_t EndMileage1Digits18PosX [] = {100};
void  Gui_EndMileage(uint8_t Valid, uint16_t EndMileage)
{
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_02_X84_Y128, 84, 128);
    if ( Valid )
    {
        if ( EndMileage > 99 )
        {
            Draw_Image_Local_Digit_Draw(EndMileage, Number_18_white_List, 3, 2, EndMileage3Digits18PosX, 171);
            Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 125, 171);
        }
        else if ( EndMileage > 9 )
        {
            Draw_Image_Local_Digit_Draw(EndMileage, Number_18_white_List, 2, 1, EndMileage2Digits18PosX, 171);
            Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 119, 171);
        }
        else
        {
            Draw_Image_Local_Digit_Draw(EndMileage, Number_18_white_List, 1, 0, EndMileage1Digits18PosX, 171);
            Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 113, 171);
        }
    }
    else
    {
        Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 120, 171);
        Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 107, 171);
        Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 95, 171);
    }
}
/***********************************************************************************************************/
static const uint16_t InstantOilCon2Digits18PosX []  = {114, 94, 82};//{114, 97, 85};
static const uint16_t InstantOilCon1Digits18PosX []  = {109, 88};//{109, 91};
static const uint16_t InstantOilCon22Digits18PosX [] = {89, 69, 57};//{89, 72, 60};
static const uint16_t InstantOilCon11Digits18PosX [] = {84, 63};//{84, 66};
void  Gui_InstantOilCon(uint8_t Valid, uint8_t InstantOilCon)
{
    uint16_t DataVSpeed = Common_Get_Act_V_Speed( );
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_03_X84_Y128, 84, 128);
    if ( Valid )
    {
        if ( InstantOilCon > 99 )
        {
            if ( DataVSpeed >= 500 )
            {
                Draw_Image_Local_Digit_Draw(InstantOilCon, Number_18_white_List, 3, 1, InstantOilCon22Digits18PosX, 171);
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 102, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 83, 171);//83
            }
            else
            {
                Draw_Image_Local_Digit_Draw(InstantOilCon, Number_18_white_List, 3, 1, InstantOilCon2Digits18PosX, 171);
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lh_01_X0_Y0, 127, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 107, 171);//104
            }
        }
        else
        {
            if ( DataVSpeed >= 500 )
            {
                Draw_Image_Local_Digit_Draw(InstantOilCon, Number_18_white_List, 2, 0, InstantOilCon11Digits18PosX, 171);
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 97, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 78, 171);
            }
            else
            {
                Draw_Image_Local_Digit_Draw(InstantOilCon, Number_18_white_List, 2, 0, InstantOilCon1Digits18PosX, 171);
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lh_01_X0_Y0, 122, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 103, 171);//104
            }
        }
    }
    else
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_Lh_01_X0_Y0, 127, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 85, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 97, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 108, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 114, 171);
        }
    }
}
/***********************************************************************************************************/
static const uint16_t AvgOilCon2Digits18PosX [] = {89, 72, 60};
static const uint16_t AvgOilCon1Digits18PosX [] = {84, 66};
void  Gui_AvgOilCon(uint8_t Valid, uint8_t AvgOilCon,uint8_t Valid_M)
{
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_04_X84_Y128, 84, 128);
    if ( Valid )
    {
        if( Valid_M )
        {
            if ( AvgOilCon > 99 )
            {
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 102, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 83, 171);
                Draw_Image_Local_Digit_Draw(AvgOilCon, Number_18_white_List, 3, 1, AvgOilCon2Digits18PosX, 171);
            }
            else
            {
                Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 97, 171);
                Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 78, 171);
                Draw_Image_Local_Digit_Draw(AvgOilCon, Number_18_white_List, 2, 0, AvgOilCon1Digits18PosX, 171);
            }
        }
        else
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 103, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 60, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 72, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 85, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 91, 171);
        }
        
    }
   
    else
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_Lkm_01_X0_Y0, 103, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 60, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 72, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_point3_X0_Y0, 85, 171);
            Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 91, 171);
        }
    }
}
/*********************************************************************************************************/
static const uint16_t AvgSpeed3Digits18PosX [] = {104, 92, 80};
static const uint16_t AvgSpeed2Digits18PosX [] = {98, 86};
static const uint16_t AvgSpeed1Digits18PosX [] = {92};
void  Gui_AvgSpeed(uint8_t Valid, uint8_t AvgSpeed)
{
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_05_X84_Y128, 84, 128);
    if ( Valid )
    {
        if ( AvgSpeed > 99 )
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_kmh_01_X0_Y0, 116, 171);
            Draw_Image_Local_Digit_Draw(AvgSpeed, Number_18_white_List, 3, 2, AvgSpeed3Digits18PosX, 171);
        }
        else if ( AvgSpeed > 9 )
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_kmh_01_X0_Y0, 110, 171);
            Draw_Image_Local_Digit_Draw(AvgSpeed, Number_18_white_List, 2, 1, AvgSpeed2Digits18PosX, 171);
        }
        else
        {
            Draw_Image_Local(( uint8_t * )ECU_Unit_kmh_01_X0_Y0, 105, 171);
            Draw_Image_Local_Digit_Draw(AvgSpeed, Number_18_white_List, 1, 0, AvgSpeed1Digits18PosX, 171);
        }
    }
    else
    {
        Draw_Image_Local(( uint8_t * )ECU_Unit_kmh_01_X0_Y0, 116, 171);
        Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 104, 171);
        Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 92, 171);
        Draw_Image_Local(( uint8_t * )Number_18_White_heng_X0_Y0, 80, 171);
    }
}
/**********************************************************************************************************/
static const uint16_t Maintenance5Digits18PosX [] = {178, 167, 156, 145, 134};
void  Gui_Maintenance(uint16_t Maintenance)
{
    Draw_Image_Local(( uint8_t * )ECU_Unit_iocn_01_X101_Y80, 101, 80);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_06_X84_Y128, 84, 128);
    Draw_Image_Local(( uint8_t * )ECU_Unit_CN_08_X21_Y159, 21, 159);    
    Draw_Image_Local(( uint8_t * )ECU_Unit_km_01_X0_Y0, 191, 163);
    Draw_Image_Local_Digit_Draw(Maintenance, Number_18_white_List, 5, 4, Maintenance5Digits18PosX, 163);
    if(Maint_Get_Remain_Flag( ))
    {
        Draw_Image_Local(( uint8_t * )ECU_Unit_CN_09_X75_Y192, 75, 192); 
        //Draw_Image_Local(( uint8_t * )Dang_ban_X125_Y276, 125, 276); 
    }
}
/************************************************************************************************************/
static const uint16_t TPMS3Digits18PosX1 []   = {67, 58, 49};
static const uint16_t TPMS2Digits18PosX1 []   = {62, 53};
static const uint16_t TPMS1Digits18PosX1 []   = {58};
static const uint16_t TPMS2Digits18PosX10 []  = {67, 58};
static const uint16_t TPMS1Digits18PosX10 []  = {62};
static const uint16_t TPMS3Digits18PosX2 []   = {182, 173, 164};
static const uint16_t TPMS2Digits18PosX2 []   = {177, 168};
static const uint16_t TPMS1Digits18PosX2 []   = {173};
static const uint16_t TPMS2Digits18PosX20 []  = {182, 173};
static const uint16_t TPMS1Digits18PosX20 []  = {177};
static const uint16_t TPMS3Digits18PosX3 []   = {58, 49, 40};
static const uint16_t TPMS2Digits18PosX3 []   = {53, 44};
static const uint16_t TPMS1Digits18PosX3 []   = {49};
static const uint16_t TPMS2Digits18PosX30 []  = {58, 49};
static const uint16_t TPMS1Digits18PosX30 []  = {53};
static const uint16_t TPMS3Digits18PosX31 []  = {67, 58, 49};
static const uint16_t TPMS2Digits18PosX31 []  = {62, 53};
static const uint16_t TPMS1Digits18PosX31 []  = {58};
static const uint16_t TPMS2Digits18PosX301 [] = {67, 58};
static const uint16_t TPMS1Digits18PosX301 [] = {62};
static const uint16_t TPMS3Digits18PosX4 []   = {191, 182, 173};
static const uint16_t TPMS2Digits18PosX4 []   = {186, 177};
static const uint16_t TPMS1Digits18PosX4 []   = {182};
static const uint16_t TPMS2Digits18PosX40 []  = {191, 182};
static const uint16_t TPMS1Digits18PosX40 []  = {186};
static const uint16_t TPMS3Digits18PosX41 []  = {182, 173, 164};
static const uint16_t TPMS2Digits18PosX41 []  = {177, 168};
static const uint16_t TPMS1Digits18PosX41 []  = {173};
static const uint16_t TPMS2Digits18PosX401 [] = {182, 173};
static const uint16_t TPMS1Digits18PosX401 [] = {177};
static const uint16_t TPMS3Digits18PosX5 []   = {99, 90, 81};
static const uint16_t TPMS2Digits18PosX5 []   = {94, 85};
static const uint16_t TPMS1Digits18PosX5 []   = {90};
static const uint16_t TPMS2Digits18PosX50 []  = {99, 90};
static const uint16_t TPMS1Digits18PosX50 []  = {94};
static const uint16_t TPMS3Digits18PosX6 []   = {149, 140, 131};
static const uint16_t TPMS2Digits18PosX6 []   = {144, 135};
static const uint16_t TPMS1Digits18PosX6 []   = {140};
static const uint16_t TPMS2Digits18PosX60 []  = {149, 140};
static const uint16_t TPMS1Digits18PosX60 []  = {144};

void  Gui_TPMS(void)
{
    if ( Get_NodeConfig_TPMS( ) == 1 )
    {
        if ( TPMS_Info.Pop_Check == 1 )
        {
            Draw_Image_Local(( uint8_t * )Alarm_CN_10_X24_Y139, 24, 139);
        }
        else
        {
            Draw_Image_Local(( uint8_t * )TPMS_kuang_01_1_X88_Y70, 89, 90);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 48, 117);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 163, 117);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 48, 184);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 163, 184);
            if ( TPMS_Info.TPMS_Valid != 0 )
            {
                Draw_Image_Local(( uint8_t * )ECU_Unit_Ckpa_01_X107_Y119, 107, 139);
            }
            GUI_TPMS_Left_Front_Display_FOUR(Left_Front_Display);
            GUI_TPMS_Left_Rear_Display_FOUR(Left_Rear_Display);
            GUI_TPMS_Right_Front_Display_FOUR(Right_Front_Display);
            GUI_TPMS_Right_Rear_Display_FOUR(Right_Rear_Display);
        }
    }
    else if ( Get_NodeConfig_TPMS( ) == 2 )
    {
        if ( TPMS_Info.Pop_Check == 1 )
        {
            Draw_Image_Local(( uint8_t * )Alarm_CN_10_X24_Y139, 24, 139);
        }
        else
        {
            Draw_Image_Local(( uint8_t * )TPMS_kuang_01_1_X88_Y70, 89, 70);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 48, 97);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 163, 97);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 39, 164);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 172, 164);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 80, 212);
            Draw_Image_Local(( uint8_t * )TPMS_heng_01_X0_Y0, 130, 212);
            if ( TPMS_Info.TPMS_Valid != 0 )
            {
                Draw_Image_Local(( uint8_t * )ECU_Unit_Ckpa_01_X107_Y119, 107, 119);
            }
            GUI_TPMS_Left_Front_Display(Left_Front_Display);
            GUI_TPMS_Left_Rear_Display(Left_Rear_Display);
            GUI_TPMS_Left_Rear_Inside_Display(Left_Rear_Inside_Display);
            GUI_TPMS_Right_Front_Display(Right_Front_Display);
            GUI_TPMS_Right_Rear_Display(Right_Rear_Display);
            GUI_TPMS_Right_Rear_Inside_Display(Right_Rear_Inside_Display);
        }
    }
}

void GUI_TPMS_Left_Front_Display_FOUR(_TPMS_Display_Infor LeftFront)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 107);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
        }
    }
    else
    {
        if( Left_Front_Display.Wheel_ID_OutTime == 1 )
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 107);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
            }
        }
        else
        {        
            if ( Left_Front_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 81, 103);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
            }
            else
            {
                if ( Left_Front_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 81, 103);    // Tyrepress
                    }
                    if ( LeftFront.Temp_Valid )
                    {
                        if ( LeftFront.Temp_Symbol == Positive )
                        {
                            if ( LeftFront.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 122);
                            }
                            else if ( LeftFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 122);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 122);
                            }
                        }
                        else
                        {
                            if ( LeftFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 122);
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 122);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 122);
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 122);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
                    }
                    if ( LeftFront.Press_Valid )
                    {
                        if ( LeftFront.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 104);
                        }
                        else if ( LeftFront.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 104);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 104);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);
                    }
                }
                else
                {
                    if ( Left_Front_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 107);
                        }

                        if ( LeftFront.Temp_Valid )
                        {
                            if ( LeftFront.Temp_Symbol == Positive )
                            {
                                if ( LeftFront.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 122);
                                    }
                                }
                                else if ( LeftFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 122);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 122);
                                    }
                                }
                            }
                            else
                            {
                                if ( LeftFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 122);
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 122);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 122);
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 122);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
                        }
                    }
                    else
                    {
                        if ( LeftFront.Temp_Valid )
                        {
                            if ( LeftFront.Temp_Symbol == Positive )
                            {
                                if ( LeftFront.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 122);
                                }
                                else if ( LeftFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 122);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 122);
                                }
                            }
                            else
                            {
                                if ( LeftFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 122);
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 122);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 122);
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 122);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 122);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 122);
                        }
                    }
                    if ( (Left_Front_Display.Press_St == 0) || (Left_Front_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 107);
                        }
                        if ( LeftFront.Press_Valid )
                        {
                            if ( LeftFront.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 104);
                                }
                            }
                            else if ( LeftFront.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 104);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 104);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);
                        }
                    }
                    else
                    {
                        if ( LeftFront.Press_Valid )
                        {
                            if ( LeftFront.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 104);
                            }
                            else if ( LeftFront.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 104);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 104);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 104);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 104);
                        }
                    }
                    if ( (Left_Front_Display.Temp_St != 1) && (Left_Front_Display.Press_St != 0) && (Left_Front_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 107);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Left_Rear_Display_FOUR(_TPMS_Display_Infor LeftRear)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 80, 172);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 171);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 171);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
        }
    }
    else
    {
        if(Left_Rear_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 80, 172);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 171);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 171);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
            }
        }
        else
        {
            if ( Left_Rear_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 80, 168);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 171);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 171);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
            }
            else
            {
                if ( Left_Rear_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 80, 168);    // Tyrepress
                    }
                    if ( LeftRear.Temp_Valid )
                    {
                        if ( LeftRear.Temp_Symbol == Positive )
                        {
                            if ( LeftRear.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 189);
                            }
                            else if ( LeftRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 189);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 189);
                            }
                        }
                        else
                        {
                            if ( LeftRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 189);
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX301, 189);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 189);
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX301, 189);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
                    }
                    if ( LeftRear.Press_Valid )
                    {
                        if ( LeftRear.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 171);
                        }
                        else if ( LeftRear.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 171);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 171);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
                    }
                }
                else
                {
                    if ( Left_Rear_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 80, 172);
                        }

                        if ( LeftRear.Temp_Valid )
                        {
                            if ( LeftRear.Temp_Symbol == Positive )
                            {
                                if ( LeftRear.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 189);
                                    }
                                }
                                else if ( LeftRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 189);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 189);
                                    }
                                }
                            }
                            else
                            {
                                if ( LeftRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 189);
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX301, 189);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 189);
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX301, 189);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
                        }
                    }
                    else
                    {
                        if ( LeftRear.Temp_Valid )
                        {
                            if ( LeftRear.Temp_Symbol == Positive )
                            {
                                if ( LeftRear.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 189);
                                }
                                else if ( LeftRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 189);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 189);
                                }
                            }
                            else
                            {
                                if ( LeftRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 189);
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX301, 189);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 189);
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX301, 189);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 189);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 189);
                        }
                    }
                    if ( (Left_Rear_Display.Press_St == 0) || (Left_Rear_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 80, 172);
                        }
                        if ( LeftRear.Press_Valid )
                        {
                            if ( LeftRear.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 171);
                                }
                            }
                            else if ( LeftRear.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 171);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 171);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 171);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 171);
                        }
                    }
                    else
                    {
                        if ( LeftRear.Press_Valid )
                        {
                            if ( LeftRear.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX31, 171);
                            }
                            else if ( LeftRear.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX31, 171);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX31, 171);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 171);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 171);
                        }
                    }
                    if ( (Left_Rear_Display.Temp_St != 1) && (Left_Rear_Display.Press_St != 0) && (Left_Rear_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 80, 172);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Right_Front_Display_FOUR(_TPMS_Display_Infor RightFront)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 107);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
        }
    }
    else
    {
        if(Right_Front_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 107);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
            }
        }
        else
        {
            if ( Right_Front_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 143, 103);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
            }
            else
            {
                if ( Right_Front_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 143, 103);    // Tyrepress
                    }
                    if ( RightFront.Temp_Valid )
                    {
                        if ( RightFront.Temp_Symbol == Positive )
                        {
                            if ( RightFront.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 122);
                            }
                            else if ( RightFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 122);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 122);
                            }
                        }
                        else
                        {
                            if ( RightFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 122);
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 122);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 122);
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 122);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);
                    }
                    if ( RightFront.Press_Valid )
                    {
                        if ( RightFront.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 104);
                        }
                        else if ( RightFront.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 104);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 104);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);
                    }
                }
                else
                {
                    if ( Right_Front_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 107);
                        }

                        if ( RightFront.Temp_Valid )
                        {
                            if ( RightFront.Temp_Symbol == Positive )
                            {
                                if ( RightFront.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 122);
                                    }
                                }
                                else if ( RightFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 122);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 122);
                                    }
                                }
                            }
                            else
                            {
                                if ( RightFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 122);
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 122);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 122);
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 122);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
                        }
                    }
                    else
                    {
                        if ( RightFront.Temp_Valid )
                        {
                            if ( RightFront.Temp_Symbol == Positive )
                            {
                                if ( RightFront.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 122);
                                }
                                else if ( RightFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 122);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 122);
                                }
                            }
                            else
                            {
                                if ( RightFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 122);
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 122);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 122);
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 122);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 122);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 122);
                        }
                    }
                    if ( (Right_Front_Display.Press_St == 0) || (Right_Front_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 107);
                        }
                        if ( RightFront.Press_Valid )
                        {
                            if ( RightFront.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 104);
                                }
                            }
                            else if ( RightFront.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 104);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 104);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);
                        }
                    }
                    else
                    {
                        if ( RightFront.Press_Valid )
                        {
                            if ( RightFront.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 104);
                            }
                            else if ( RightFront.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 104);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 104);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 104);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 104);
                        }
                    }
                    if ( (Right_Front_Display.Temp_St != 1) && (Right_Front_Display.Press_St != 0) && (Right_Front_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 107);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Right_Rear_Display_FOUR(_TPMS_Display_Infor RightRear)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 172);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 171);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 171);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
        }
    }
    else
    {
        if(Right_Rear_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 172);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 171);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 171);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
            }
        }
        else
        {
            if ( Right_Rear_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 143, 168);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 171);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 171);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
            }
            else
            {
                if ( Right_Rear_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 143, 168);    // Tyrepress
                    }
                    if ( RightRear.Temp_Valid )
                    {
                        if ( RightRear.Temp_Symbol == Positive )
                        {
                            if ( RightRear.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 189);
                            }
                            else if ( RightRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 189);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 189);
                            }
                        }
                        else
                        {
                            if ( RightRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 189);
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX401, 189);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 189);
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX401, 189);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
                    }
                    if ( RightRear.Press_Valid )
                    {
                        if ( RightRear.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 171);
                        }
                        else if ( RightRear.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 171);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 171);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
                    }
                }
                else
                {
                    if ( Right_Rear_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 172);
                        }

                        if ( RightRear.Temp_Valid )
                        {
                            if ( RightRear.Temp_Symbol == Positive )
                            {
                                if ( RightRear.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 189);
                                    }
                                }
                                else if ( RightRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 189);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 189);
                                    }
                                }
                            }
                            else
                            {
                                if ( RightRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 189);
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX401, 189);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 189);
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX401, 189);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
                        }
                    }
                    else
                    {
                        if ( RightRear.Temp_Valid )
                        {
                            if ( RightRear.Temp_Symbol == Positive )
                            {
                                if ( RightRear.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 189);
                                }
                                else if ( RightRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 189);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 189);
                                }
                            }
                            else
                            {
                                if ( RightRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 189);
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX401, 189);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 189);
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX401, 189);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 189);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 189);
                        }
                    }
                    if ( (Right_Rear_Display.Press_St == 0) || (Right_Rear_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 172);
                        }
                        if ( RightRear.Press_Valid )
                        {
                            if ( RightRear.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 171);
                                }
                            }
                            else if ( RightRear.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 171);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 171);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 171);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 171);
                        }
                    }
                    else
                    {
                        if ( RightRear.Press_Valid )
                        {
                            if ( RightRear.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX41, 171);
                            }
                            else if ( RightRear.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX41, 171);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX41, 171);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 171);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 171);
                        }
                    }
                    if ( (Right_Rear_Display.Temp_St != 1) && (Right_Rear_Display.Press_St != 0) && (Right_Rear_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 172);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Left_Front_Display(_TPMS_Display_Infor LeftFront)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 87);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
        }
    }
    else
    {
        if(Left_Front_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 87);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
            }        
        }
        else
        {
            if ( Left_Front_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 81, 83);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
            }
            else
            {
                if ( Left_Front_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 81, 83);    // Tyrepress
                    }
                    if ( LeftFront.Temp_Valid )
                    {
                        if ( LeftFront.Temp_Symbol == Positive )
                        {
                            if ( LeftFront.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 102);
                            }
                            else if ( LeftFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 102);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 102);
                            }
                        }
                        else
                        {
                            if ( LeftFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 102);
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 102);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 102);
                                Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 102);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
                    }
                    if ( LeftFront.Press_Valid )
                    {
                        if ( LeftFront.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 84);
                        }
                        else if ( LeftFront.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 84);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 84);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);
                    }
                }
                else
                {
                    if ( Left_Front_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 87);
                        }

                        if ( LeftFront.Temp_Valid )
                        {
                            if ( LeftFront.Temp_Symbol == Positive )
                            {
                                if ( LeftFront.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 102);
                                    }
                                }
                                else if ( LeftFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 102);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 102);
                                    }
                                }
                            }
                            else
                            {
                                if ( LeftFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 102);
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 102);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 102);
                                        Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 102);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
                        }
                    }
                    else
                    {
                        if ( LeftFront.Temp_Valid )
                        {
                            if ( LeftFront.Temp_Symbol == Positive )
                            {
                                if ( LeftFront.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 102);
                                }
                                else if ( LeftFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 102);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 102);
                                }
                            }
                            else
                            {
                                if ( LeftFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 49, 102);
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX10, 102);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 53, 102);
                                    Draw_Image_Local_Digit_Draw(LeftFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX10, 102);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 102);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 102);
                        }
                    }
                    if ( (Left_Front_Display.Press_St == 0) || (Left_Front_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 87);
                        }
                        if ( LeftFront.Press_Valid )
                        {
                            if ( LeftFront.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 84);
                                }
                            }
                            else if ( LeftFront.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 84);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 84);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);
                        }
                    }
                    else
                    {
                        if ( LeftFront.Press_Valid )
                        {
                            if ( LeftFront.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX1, 84);
                            }
                            else if ( LeftFront.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX1, 84);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX1, 84);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 64, 84);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 52, 84);
                        }
                    }
                    if ( (Left_Front_Display.Temp_St != 1) && (Left_Front_Display.Press_St != 0) && (Left_Front_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 81, 87);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Left_Rear_Display(_TPMS_Display_Infor LeftRear)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 72, 151);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 151);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 151);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
        }
    }
    else
    {
        if(Left_Rear_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 72, 151);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 151);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 151);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
            }
        }
        else
        {
            if ( Left_Rear_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 72, 148);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 151);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 151);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
            }
            else
            {
                if ( Left_Rear_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 72, 148);    // Tyrepress
                    }
                    if ( LeftRear.Temp_Valid )
                    {
                        if ( LeftRear.Temp_Symbol == Positive )
                        {
                            if ( LeftRear.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 169);
                            }
                            else if ( LeftRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 169);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 169);
                            }
                        }
                        else
                        {
                            if ( LeftRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 40, 169);
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX30, 169);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 44, 169);
                                Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX30, 169);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
                    }
                    if ( LeftRear.Press_Valid )
                    {
                        if ( LeftRear.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 151);
                        }
                        else if ( LeftRear.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 151);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 151);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
                    }
                }
                else
                {
                    if ( Left_Rear_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 72, 151);
                        }

                        if ( LeftRear.Temp_Valid )
                        {
                            if ( LeftRear.Temp_Symbol == Positive )
                            {
                                if ( LeftRear.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 169);
                                    }
                                }
                                else if ( LeftRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 169);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 169);
                                    }
                                }
                            }
                            else
                            {
                                if ( LeftRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 40, 169);
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX30, 169);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 44, 169);
                                        Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX30, 169);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
                        }
                    }
                    else
                    {
                        if ( LeftRear.Temp_Valid )
                        {
                            if ( LeftRear.Temp_Symbol == Positive )
                            {
                                if ( LeftRear.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 169);
                                }
                                else if ( LeftRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 169);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 169);
                                }
                            }
                            else
                            {
                                if ( LeftRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 40, 169);
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX30, 169);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 44, 169);
                                    Draw_Image_Local_Digit_Draw(LeftRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX30, 169);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 169);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 169);
                        }
                    }
                    if ( (Left_Rear_Display.Press_St == 0) || (Left_Rear_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 72, 151);
                        }
                        if ( LeftRear.Press_Valid )
                        {
                            if ( LeftRear.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 151);
                                }
                            }
                            else if ( LeftRear.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 151);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 151);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 151);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 151);
                        }
                    }
                    else
                    {
                        if ( LeftRear.Press_Valid )
                        {
                            if ( LeftRear.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX3, 151);
                            }
                            else if ( LeftRear.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX3, 151);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX3, 151);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 43, 151);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 55, 151);
                        }
                    }
                    if ( (Left_Rear_Display.Temp_St != 1) && (Left_Rear_Display.Press_St != 0) && (Left_Rear_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 72, 151);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Left_Rear_Inside_Display(_TPMS_Display_Infor LeftRearInside)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 91, 151);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 199);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 199);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
        }
    }
    else
    {
        if(Left_Rear_Inside_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 91, 151);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 199);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 199);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
            }
        }
        else
        {        
            if ( Left_Rear_Inside_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 91, 148);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 199);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 199);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
            }
            else
            {
                if ( Left_Rear_Inside_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 91, 148);    // Tyrepress
                    }
                    if ( LeftRearInside.Temp_Valid )
                    {
                        if ( LeftRearInside.Temp_Symbol == Positive )
                        {
                            if ( LeftRearInside.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 217);
                            }
                            else if ( LeftRearInside.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 217);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 217);
                            }
                        }
                        else
                        {
                            if ( LeftRearInside.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 81, 217);
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX50, 217);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 85, 217);
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX50, 217);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
                    }
                    if ( LeftRearInside.Press_Valid )
                    {
                        if ( LeftRearInside.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 199);
                        }
                        else if ( LeftRearInside.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 199);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 199);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
                    }
                }
                else
                {
                    if ( Left_Rear_Inside_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 91, 151);
                        }

                        if ( LeftRearInside.Temp_Valid )
                        {
                            if ( LeftRearInside.Temp_Symbol == Positive )
                            {
                                if ( LeftRearInside.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 217);
                                    }
                                }
                                else if ( LeftRearInside.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 217);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 217);
                                    }
                                }
                            }
                            else
                            {
                                if ( LeftRearInside.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 81, 217);
                                        Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX50, 217);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 85, 217);
                                        Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX50, 217);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
                        }
                    }
                    else
                    {
                        if ( LeftRearInside.Temp_Valid )
                        {
                            if ( LeftRearInside.Temp_Symbol == Positive )
                            {
                                if ( LeftRearInside.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 217);
                                }
                                else if ( LeftRearInside.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 217);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 217);
                                }
                            }
                            else
                            {
                                if ( LeftRearInside.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 81, 217);
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX50, 217);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 85, 217);
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX50, 217);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 217);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 217);
                        }
                    }
                    if ( (Left_Rear_Inside_Display.Press_St == 0) || (Left_Rear_Inside_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 91, 151);
                        }
                        if ( LeftRearInside.Press_Valid )
                        {
                            if ( LeftRearInside.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 199);
                                }
                            }
                            else if ( LeftRearInside.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 199);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 199);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 86, 199);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 199);
                        }
                    }
                    else
                    {
                        if ( LeftRearInside.Press_Valid )
                        {
                            if ( LeftRearInside.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX5, 199);
                            }
                            else if ( LeftRearInside.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX5, 199);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(LeftRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX5, 199);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 84, 199);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 96, 199);
                        }
                    }
                    if ( (Left_Rear_Inside_Display.Temp_St != 1) && (Left_Rear_Inside_Display.Press_St != 0) && (Left_Rear_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 91, 151);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Right_Front_Display(_TPMS_Display_Infor RightFront)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 85);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
        }
    }
    else
    {
        if(Right_Front_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 85);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
            }
        }
        else
        {
            if ( Right_Front_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 143, 83);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
            }
            else
            {
                if ( Right_Front_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 143, 83);    // Tyrepress
                    }
                    if ( RightFront.Temp_Valid )
                    {
                        if ( RightFront.Temp_Symbol == Positive )
                        {
                            if ( RightFront.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 102);
                            }
                            else if ( RightFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 102);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 102);
                            }
                        }
                        else
                        {
                            if ( RightFront.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 102);
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 102);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 102);
                                Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 102);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
                    }
                    if ( RightFront.Press_Valid )
                    {
                        if ( RightFront.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 84);
                        }
                        else if ( RightFront.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 84);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 84);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);
                    }
                }
                else
                {
                    if ( Right_Front_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 85);
                        }

                        if ( RightFront.Temp_Valid )
                        {
                            if ( RightFront.Temp_Symbol == Positive )
                            {
                                if ( RightFront.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 102);
                                    }
                                }
                                else if ( RightFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 102);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 102);
                                    }
                                }
                            }
                            else
                            {
                                if ( RightFront.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 102);
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 102);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 102);
                                        Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 102);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
                        }
                    }
                    else
                    {
                        if ( RightFront.Temp_Valid )
                        {
                            if ( RightFront.Temp_Symbol == Positive )
                            {
                                if ( RightFront.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 102);
                                }
                                else if ( RightFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 102);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 102);
                                }
                            }
                            else
                            {
                                if ( RightFront.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 164, 102);
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX20, 102);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 168, 102);
                                    Draw_Image_Local_Digit_Draw(RightFront.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX20, 102);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 102);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 102);
                        }
                    }
                    if ( (Right_Front_Display.Press_St == 0) || (Right_Front_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 85);
                        }
                        if ( RightFront.Press_Valid )
                        {
                            if ( RightFront.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 84);
                                }
                            }
                            else if ( RightFront.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 84);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 84);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);
                        }
                    }
                    else
                    {
                        if ( RightFront.Press_Valid )
                        {
                            if ( RightFront.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX2, 84);
                            }
                            else if ( RightFront.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX2, 84);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightFront.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX2, 84);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 179, 84);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 167, 84);
                        }
                    }
                    if ( (Right_Front_Display.Temp_St != 1) && (Right_Front_Display.Press_St != 0) && (Right_Front_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 143, 85);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Right_Rear_Display(_TPMS_Display_Infor RightRear)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 153, 151);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 151);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 151);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
        }
    }
    else
    {
        if(Right_Rear_Display.Wheel_ID_OutTime == 1)
        {
           if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 153, 151);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 151);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 151);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
            } 
        }
        else
        {
            if ( Right_Rear_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 153, 148);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 151);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 151);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
            }
            else
            {
                if ( Right_Rear_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 153, 148);    // Tyrepress
                    }
                    if ( RightRear.Temp_Valid )
                    {
                        if ( RightRear.Temp_Symbol == Positive )
                        {
                            if ( RightRear.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 169);
                            }
                            else if ( RightRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 169);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 169);
                            }
                        }
                        else
                        {
                            if ( RightRear.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 173, 169);
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX40, 169);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 177, 169);
                                Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX40, 169);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
                    }
                    if ( RightRear.Press_Valid )
                    {
                        if ( RightRear.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 151);
                        }
                        else if ( RightRear.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 151);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 151);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
                    }
                }
                else
                {
                    if ( Right_Rear_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 153, 151);
                        }

                        if ( RightRear.Temp_Valid )
                        {
                            if ( RightRear.Temp_Symbol == Positive )
                            {
                                if ( RightRear.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 169);
                                    }
                                }
                                else if ( RightRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 169);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 169);
                                    }
                                }
                            }
                            else
                            {
                                if ( RightRear.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 173, 169);
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX40, 169);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 177, 169);
                                        Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX40, 169);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
                        }
                    }
                    else
                    {
                        if ( RightRear.Temp_Valid )
                        {
                            if ( RightRear.Temp_Symbol == Positive )
                            {
                                if ( RightRear.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 169);
                                }
                                else if ( RightRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 169);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 169);
                                }
                            }
                            else
                            {
                                if ( RightRear.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 173, 169);
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX40, 169);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 177, 169);
                                    Draw_Image_Local_Digit_Draw(RightRear.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX40, 169);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 169);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 169);
                        }
                    }
                    if ( (Right_Rear_Display.Press_St == 0) || (Right_Rear_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 153, 151);
                        }
                        if ( RightRear.Press_Valid )
                        {
                            if ( RightRear.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 151);
                                }
                            }
                            else if ( RightRear.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 151);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 151);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 151);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 151);
                        }
                    }
                    else
                    {
                        if ( RightRear.Press_Valid )
                        {
                            if ( RightRear.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX4, 151);
                            }
                            else if ( RightRear.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX4, 151);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRear.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX4, 151);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 176, 151);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 188, 151);
                        }
                    }
                    if ( (Right_Rear_Display.Temp_St != 1) && (Right_Rear_Display.Press_St != 0) && (Right_Rear_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 153, 151);
                    }
                }
            }
        }
    }
}
void GUI_TPMS_Right_Rear_Inside_Display(_TPMS_Display_Infor RightRearInside)
{
    if ( TPMS_Info.TPMS_Valid == 0 )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 134, 152);            // Tyre

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 199);    // Press
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 199);

            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);    // temp
            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
        }
    }
    else
    {
        if(Right_Rear_Inside_Display.Wheel_ID_OutTime == 1)
        {
            if ( g_LED.LedBlink_1HZ )
            {
                Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 134, 152);            // Tyre

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 199);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 199);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
            }
        }
        else
        {
            if ( Right_Rear_Inside_Display.Sensor_Loss == 0 )
            {
                if ( g_LED.LedBlink_1HZ )
                {
                    Draw_Image_Local(( uint8_t * )TPMS_Tyre_03_3_X71_Y148, 134, 148);    // TyreSensor
                }

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 199);    // Press
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 199);

                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);    // temp
                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
            }
            else
            {
                if ( Right_Rear_Inside_Display.Fast_Press == 1 )
                {
                    if ( g_LED.LedBlink_1HZ )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_02_3_X71_Y148, 134, 148);    // Tyrepress
                    }
                    if ( RightRearInside.Temp_Valid )
                    {
                        if ( RightRearInside.Temp_Symbol == Positive )
                        {
                            if ( RightRearInside.Temp_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 217);
                            }
                            else if ( RightRearInside.Temp_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 217);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 217);
                            }
                        }
                        else
                        {
                            if ( RightRearInside.Temp_Value >= 10 )
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 131, 217);
                                Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX60, 217);
                            }
                            else
                            {
                                Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 135, 217);
                                Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX60, 217);
                            }
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
                    }
                    if ( RightRearInside.Press_Valid )
                    {
                        if ( RightRearInside.Press_Value >= 100 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 199);
                        }
                        else if ( RightRearInside.Press_Value >= 10 )
                        {
                            Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 199);
                        }
                        else
                        {
                            Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 199);
                        }
                    }
                    else
                    {
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);
                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
                    }
                }
                else
                {
                    if ( Right_Rear_Inside_Display.Temp_St == 1 )    // high temp warning
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 134, 152);
                        }

                        if ( RightRearInside.Temp_Valid )
                        {
                            if ( RightRearInside.Temp_Symbol == Positive )
                            {
                                if ( RightRearInside.Temp_Value >= 100 )
                                {

                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 217);
                                    }
                                }
                                else if ( RightRearInside.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 217);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 217);
                                    }
                                }
                            }
                            else
                            {
                                if ( RightRearInside.Temp_Value >= 10 )
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 131, 217);
                                        Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX60, 217);
                                    }
                                }
                                else
                                {
                                    if ( g_LED.LedBlink_1HZ )
                                    {
                                        Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 135, 217);
                                        Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX60, 217);
                                    }
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
                        }
                    }
                    else
                    {
                        if ( RightRearInside.Temp_Valid )
                        {
                            if ( RightRearInside.Temp_Symbol == Positive )
                            {
                                if ( RightRearInside.Temp_Value >= 100 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 217);
                                }
                                else if ( RightRearInside.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 217);
                                }
                                else
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 217);
                                }
                            }
                            else
                            {
                                if ( RightRearInside.Temp_Value >= 10 )
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 131, 217);
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX60, 217);
                                }
                                else
                                {
                                    Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 135, 217);
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Temp_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX60, 217);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 217);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 217);
                        }
                    }
                    if ( (Right_Rear_Inside_Display.Press_St == 0) || (Right_Rear_Inside_Display.Press_St == 4) )
                    {
                        if ( g_LED.LedBlink_1HZ )
                        {
                            Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 134, 152);
                        }
                        if ( RightRearInside.Press_Valid )
                        {
                            if ( RightRearInside.Press_Value >= 100 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 199);
                                }
                            }
                            else if ( RightRearInside.Press_Value >= 10 )
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 199);
                                }
                            }
                            else
                            {
                                if ( g_LED.LedBlink_1HZ )
                                {
                                    Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 199);
                                }
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 199);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 199);
                        }
                    }
                    else
                    {
                        if ( RightRearInside.Press_Valid )
                        {
                            if ( RightRearInside.Press_Value >= 100 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 3, 2, TPMS3Digits18PosX6, 199);
                            }
                            else if ( RightRearInside.Press_Value >= 10 )
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 2, 1, TPMS2Digits18PosX6, 199);
                            }
                            else
                            {
                                Draw_Image_Local_Digit_Draw(RightRearInside.Press_Value, Number_14_white_List, 1, 0, TPMS1Digits18PosX6, 199);
                            }
                        }
                        else
                        {
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 134, 199);
                            Draw_Image_Local(( uint8_t * )Number_14_White_heng_X0_Y0, 146, 199);
                        }
                    }
                    if ( (Right_Rear_Inside_Display.Temp_St != 1) && (Right_Rear_Inside_Display.Press_St != 0) && (Right_Rear_Inside_Display.Press_St != 4) )
                    {
                        Draw_Image_Local(( uint8_t * )TPMS_Tyre_01_X0_Y0, 134, 152);
                    }
                }
            }
        }
    }
}

/************************************************************************************************************/
void GUI_SET_Display(void)
{
    if ( MenuCur == MENU_ITEM_SET_Backlight )
    {
        Gui_Backlight(g_Light.Duty);
    }
    else if ( MenuCur == MENU_ITEM_SET_Sound )
    {
        Gui_Volume(MenuData.Sound);
    }
    else if ( (MenuCur == MENU_ITEM_SET_TimeHour) || (MenuCur == MENU_ITEM_SET_TimeMin) )
    {
        GUI_Clock_Display(MenuData.Hour, MenuData.Minute);
    }
}
/************************************************************************************************************/
void Gui_Backlight(INT8U Backlight)
{
    Draw_Image_Local(( uint8_t * )Set_icon_01_X103_Y76, 103, 76);
    Draw_Image_Local(( uint8_t * )Set_CN_01_X85_Y128, 85, 128);
    if ( g_Light.Duty == 0 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_1_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_0_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 150 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_2_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_1_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 200 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_3_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_2_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 250 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_4_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_3_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 300 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_5_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_4_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 350 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_6_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_5_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 400 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_7_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_6_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 450 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_8_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_7_X0_Y0, 114, 191);
    }
    else if ( g_Light.Duty == 500 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_01_9_X35_Y169, 35, 169);
        Draw_Image_Local(( uint8_t * )Number_18_White_8_X0_Y0, 114, 191);
    }
}
/***********************************************************************************************************/
void Gui_Volume(INT8U Volume)
{
    Draw_Image_Local(( uint8_t * )Set_icon_01_X103_Y76, 103, 76);
    Draw_Image_Local(( uint8_t * )Set_CN_02_X85_Y128, 85, 128);
    if ( MenuData.Sound == 1 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_02_1_X34_Y169, 34, 169);
        Draw_Image_Local(( uint8_t * )Set_CN_02_4_X111_Y186, 111, 186);
    }
    else if ( MenuData.Sound == 2 )
    {
        Draw_Image_Local(( uint8_t * )Set_CN_02_2_X34_Y169, 34, 169);
        Draw_Image_Local(( uint8_t * )Set_CN_02_5_X111_Y186, 111, 186);
    }
    else
    {
        Draw_Image_Local(( uint8_t * )Set_CN_02_3_X34_Y169, 34, 169);
        Draw_Image_Local(( uint8_t * )Set_CN_02_6_X111_Y186, 111, 186);
    }
}
/***********************************************************************************************************/
static const uint16_t TimeHourDigits18PosX []   = {105, 94};
static const uint16_t TimeMinuteDigits18PosX [] = {134, 123};
void GUI_Clock_Display(INT8U HOUR, INT8U Minute)
{
    Draw_Image_Local(( uint8_t * )Set_icon_01_X103_Y76, 103, 76);
    Draw_Image_Local(( uint8_t * )Set_CN_03_X85_Y128, 85, 128);
    Draw_Image_Local(( uint8_t * )Number_18_White_point2_X0_Y0, 114, 168);
    if ( MenuCur == MENU_ITEM_SET_TimeHour )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local_Digit_Draw(HOUR, Number_18_white_List, 2, 0, TimeHourDigits18PosX, 168);
        }
        Draw_Image_Local_Digit_Draw(Minute, Number_18_white_List, 2, 0, TimeMinuteDigits18PosX, 168);
    }
    if ( MenuCur == MENU_ITEM_SET_TimeMin )
    {
        if ( g_LED.LedBlink_1HZ )
        {
            Draw_Image_Local_Digit_Draw(Minute, Number_18_white_List, 2, 0, TimeMinuteDigits18PosX, 168);
        }
        Draw_Image_Local_Digit_Draw(HOUR, Number_18_white_List, 2, 0, TimeHourDigits18PosX, 168);
    }
}
/***********************************************************************************************************/
void GUI_PopAlarm_IGOFF(void)
{
    uint16_t PopupAlarmOFF = 0;
    if ( u8PopAlarmKEY && u8PopAlarmPositionLight )
    {
        PopupAlarmOFF = 1u;
    }
    else if ( u8PopAlarmKEY )
    {
        PopupAlarmOFF = 2u;
    }
    else if ( u8PopAlarmPositionLight )
    {
        PopupAlarmOFF = 3u;
    }

    switch ( PopupAlarmOFF )
    {
        case 1:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_11_X38_Y212, 38, 212);
                PowerIgnOffTimeLine = 0;
                break;
            }
        case 2:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_13_X38_Y212, 38, 212);
                PowerIgnOffTimeLine = 0;
                break;
            }
        case 3:
            {
                Draw_Image_Local(( uint8_t * )Alarm_CN_12_X38_Y212, 38, 212);
                PowerIgnOffTimeLine = 0;
                break;
            }
        default:
            break;
    }
}
/***********************************************************************************************************/
static const uint16_t Hour2kaiji30PosX []   = {97, 78};
static const uint16_t Minute2kaiji30PosX [] = {145, 126};
void GUI_BJ_TIME_MIDDLE_Display(uint8_t Hour, uint8_t Minute)
{
    Draw_Image_Local_Digit_Draw(Hour, Number_30_white_List, 2, 0, Hour2kaiji30PosX, 112);
    Draw_Image_Local_Digit_Draw(Minute, Number_30_white_List, 2, 0, Minute2kaiji30PosX, 112);
    Draw_Image_Local(( uint8_t * )Number_30_White_point2_X0_Y0, 116, 110);
}
/***********************************************************************************************************/

/***********************************************************************************************************/

/***********************************************************************************************************/

/***********************************************************************************************************/

/***********************************************************************************************************/

/***********************************************************************************************************/

/***********************************************************************************************************/
