#include "UDS_14Service_Filter.h"
#include "UDS_ISO14229_Server.h"
/**
  *14服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *14服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *14服务解锁等级验证lu
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}

/**
  *14服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *14服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC31(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.S14Detail.Parameter == 0xFFFFFFu)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = requestOutOfRange;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    return NRC;
}

/**
  *14服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC13_TotalLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC != 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *14服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_14Service_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() > 5u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else if(getESpeed() > 400u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x14u, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}
