#include "UDS_2EService_Main.h"
//#include "Maintenance.h"

/**
  *2E服务函数入口
  *@param A_TA_type 收到数据的地址
  *@param A_Length 收到数据的长度
  *@param A_Data 收到数据的数据
  */
void UDS_Service_2E_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[])
{
    uint8_t NRC = positiveResponse;
    setDiagMSG(A_TA_type, A_Length, A_Data);
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC11();                                            /*2E服务是否支持功能寻址*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC7F();                                            /*2E服务会话是否支持验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC33();                                            /*2E服务解锁等级验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC13_MinLengthCheck();                             /*2E服务最小长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC13_TotalLengthCheck();                           /*2E服务总长度长度验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC31();                                            /*2E服务超出请求范围验证*/
    }
    if(NRC == positiveResponse)
    {
        NRC = UDS_2EService_NRC22();                                            /*2E服务条件验证*/
    }
    if(NRC == positiveResponse)
    {
        UDS_2EService_DID();                                                    /*2E服务DID判断*/
    }
    clearDiagMSG();                                                             /*清除诊断信息*/
}

/**
  *2E服务子功能
  */
void UDS_2EService_DID(void)
{
    switch(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L))/*2E服务DID判断*/
    {
        case 0xF190:
            UDS_2EService_DID_F190( );
        break;
        case 0xF1B0:
            UDS_2EService_DID_F1B0( );
        break;
        case 0xF1B1:
            UDS_2EService_DID_F1B1( );
        break;
        case 0xF1B7:
            UDS_2EService_DID_F1B7( );
        break;
        case 0xF1B8:
            UDS_2EService_DID_F1B8( );
        break;
        case 0xF1BF:
            UDS_2EService_DID_F1BF( );
        break;
        case 0xF1C5:
            UDS_2EService_DID_F1C5( );
        break;
        case 0xF1C6:
            UDS_2EService_DID_F1C6( );
        break;
        case 0xF010:
            UDS_2EService_DID_F010( );
        break;
        case 0xCF03:
            UDS_2EService_DID_CF03( );
        break;
        case 0x1E00:
            UDS_2EService_DID_1E00( );
        break;
        case 0x1E01:
            UDS_2EService_DID_1E01( );
        break;
        case 0xF18B:
            UDS_2EService_DID_F18B( );
        break;
        case 0xF18C:
            UDS_2EService_DID_F18C( );
        break;
        default:
        break;
    }
}

/**
  *2E服务DIDF190
  *VIN（车辆识别代码）
  */
void UDS_2EService_DID_F190(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F190, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F190));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1B0
  *VanOrGan
  */
void UDS_2EService_DID_F1B0(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1B0, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1B0));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1B1
  *CustomerCode
  */
void UDS_2EService_DID_F1B1(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1B1, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1B1));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1B7
  *EOLProgrammingDate
  */
void UDS_2EService_DID_F1B7(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1B7, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1B7));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1B8
  *EOLTesterCode
  */
void UDS_2EService_DID_F1B8(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1B8, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1B8));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1BF
  *EOLProgrammingToolVersion
  */
void UDS_2EService_DID_F1BF(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1BF, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1BF));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1C5
  *PlantTraceabilityInformations
  */
void UDS_2EService_DID_F1C5(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1C5, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1C5));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF1C5
  *TeleservicesTraceabilityInformations
  */
void UDS_2EService_DID_F1C6(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F1C6, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F1C6));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF010
  *EOL DataIdentifier
（下线配置）
--见4.3.DIDs_Config页
  */
void UDS_2EService_DID_F010(void)
{
    uint8_t enResult = 1;
    memcpy(EOLToDFlashInfo.DID_F010, DiagMSG.msgData.DidDetail.Data, sizeof(EOLToDFlashInfo.DID_F010));
    enResult = write2EData(WriteEOLData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDCF03
  *Odometer
（里程)
*/
void UDS_2EService_DID_CF03(void)
{
    uint8_t enResult = 1;
    uint8_t i;
    uint32_t odo = 0;
    uint32_t m32 = 0;
    uint8_t NRC = positiveResponse;
    if(u8MileODORelated[8] == 0)
    {
        memcpy(Ser2EToDFlashInfo.DID_CF03, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_CF03));
        for(i = 0; i < 4;i++)
        {
            odo = odo << 8 | DiagMSG.msgData.DidDetail.Data[i];
        }
        odo = odo * 10;
        Mileage_Modify_Index_Value(MILE_INDEX_ODO, odo);
    }
    else
    {
        for(i = 0; i < 4;i++)
        {
            m32 = (m32 << 8) | DiagMSG.msgData.DidDetail.Data[i];
        }
        if((Mile_Get_Index_Value(MILE_INDEX_ODO) / 10) > m32)
        {
            NRC = requestOutOfRange;
        }
        else if(Ser2EToDFlashInfo.WriteODOCnt >= 2)
        {
            NRC = requestOutOfRange;
        }
        else
        {
            Ser2EToDFlashInfo.WriteODOCnt++;
            enResult = write2EData(Write2EData);
            for(i = 0; i < 4;i++)
            {
                odo = odo << 8 | DiagMSG.msgData.DidDetail.Data[i];
            }
            odo = odo * 10;
            Mileage_Modify_Index_Value(MILE_INDEX_ODO, odo);
        }
    }
    if(NRC == positiveResponse)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
}

/**
  *2E服务DID1E00
  *Maintenance 
（保养配置）
*/
void UDS_2EService_DID_1E00(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_1E00, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_1E00));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DID1E01
  *CarCfg3
（ABS9.0诊断配置）
*/
void UDS_2EService_DID_1E01(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_1E01, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_1E01));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF18B
  *天有为添加电控单元制作日期
*/
void UDS_2EService_DID_F18B(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F18B, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F18B));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

/**
  *2E服务DIDF18C
  *天有为添加（供应商电控单元序列号）
*/
void UDS_2EService_DID_F18C(void)
{
    uint8_t enResult = 1;
    memcpy(Ser2EToDFlashInfo.DID_F18C, DiagMSG.msgData.DidDetail.Data, sizeof(Ser2EToDFlashInfo.DID_F18C));
    enResult = write2EData(Write2EData);
    if(enResult == 0)
    {
       UDS_Service_Response(0x2Eu, POSITIVE_RSP, DIAG_ID_Tx, 2u, DiagMSG.msgData.Data);
    }
    else
    {
        enResult = generalProgrammingFailure;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&enResult);
    }
}

