#ifndef _CAN_APP_TX_H_
#define _CAN_APP_TX_H_




//#include "TYW_stdint.h"
#include "g_includes.h"
typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IC_TotalDistance_L  : 8;
        uint8_t IC_TotalDistance_ML : 8;
        uint8_t IC_TotalDistance_MH : 8;
        uint8_t IC_TotalDistance_H  : 8;
        uint8_t IC_TriplDistance_L  : 8;
        uint8_t IC_TriplDistance_ML : 8;
        uint8_t IC_TriplDistance_MH : 8;
        uint8_t IC_TriplDistance_H  : 8;
    } Sig;
} CANMsg18FEC1EEUnion;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Res0 : 8;
        uint8_t FuelLevel : 8;
        uint8_t Res1 : 8;
        uint8_t Res2 : 8;

        uint8_t Res3 : 8;
        uint8_t Res4 : 8;
        uint8_t Res5 : 8;
        uint8_t Res6 : 8;
    } Sig;
} CANMsg18FEFC17Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Seatbeltsts               : 2;
        uint8_t Res0                      : 4;
        uint8_t HandBrakeSts              : 2;

        uint8_t AirBaglampFailSts         : 2;
        uint8_t HydraulicBrakePressureSts : 2;
        uint8_t EngineWaterLevel          : 2;
        uint8_t BrakePadWearSts           : 2;

        uint8_t LowFuelWarningSts         : 2;
        uint8_t AirFilterblockingSts      : 2;
        uint8_t FuelFilterblockingSts     : 2;
        uint8_t Res1                      : 2;

        uint8_t k_value_L                 : 8;
        uint8_t k_value_M                 : 8;
        uint8_t k_value_H                 : 8;

        uint8_t fueltank                  : 8;
        uint8_t IC_Reserved_2             : 8;
    } Sig;
} CANMsg10FF4117Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Driver1WorkingState          : 3;
        uint8_t Driver2WorkingState          : 3;
        uint8_t DriveRecognize               : 2;
  
        uint8_t Res0                         : 8;
  
        uint8_t Res1                         : 8;
  
        uint8_t SystemEvent                  : 2;
        uint8_t HandlingInformation          : 2;
        uint8_t TachographPerformance        : 2;
        uint8_t Res2                         : 2;

        uint8_t TachographOutputShaftSpeed_L : 8;
        uint8_t TachographOutputShaftSpeed_H : 8;

        uint8_t TachographVehicleSpeed_L     : 8;
        uint8_t TachographVehicleSpeed_H     : 8;
    } Sig;
} CANMsg0CFE6CEEUnion;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Res0             : 1;
        uint8_t CcValData        : 1;
        uint8_t CcFail           : 1;
        uint8_t ResSw            : 1;
        uint8_t CcCoastDecelSw   : 1;
        uint8_t CcAccelSw        : 1;
        uint8_t CcSetSw          : 1;
        uint8_t CcOn_OffSts      : 1;

        uint8_t CcDataIntegr     : 8;

        uint8_t Res1             : 2;
        uint8_t BcmcmdMsgSafCnt  : 2;
        uint8_t Res2             : 1;
        uint8_t BrkPedNoSw       : 1;
        uint8_t BrkPedNcSw       : 1;
        uint8_t CrkReqSts        : 1;

        
        uint8_t Res3 : 8;
        uint8_t Res4 : 8;
        uint8_t Res5 : 8;
        uint8_t Res6 : 8;
        uint8_t Res7 : 8;
    } Sig;
} CANMsg0810A000Union;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t VdcLampFail        : 2;
        uint8_t AsrLampFail        : 2;
        uint8_t EbdLampFail        : 2;
        uint8_t AbsLampFail        : 2;

        uint8_t Res0               : 2;
        uint8_t ComprAcReqSts      : 1;
        uint8_t LowBeamSts         : 1;
        uint8_t Res1               : 4;

        uint8_t Res2               : 3;
        uint8_t DoorStsDriv        : 1;
        uint8_t KeySts             : 4;

        uint8_t ExtTemp            : 8;

        uint8_t Res3               : 1;//32
        uint8_t RechargeSts        : 1;//33
        uint8_t Res4               : 1;//34
        uint8_t DrivStyleSts       : 3;//35
        uint8_t Res5               : 1;//38
        uint8_t ExtTempFai         : 1;//39

        uint8_t Res6 : 8;

        uint8_t Res7               : 4;
        uint8_t RearHeatWndSts     : 1;
        uint8_t HandBrkSts         : 1;
        uint8_t BrkFluidLevSts     : 1;
        uint8_t BrkPadWearSts      : 1;

        uint8_t Res8 : 8;

    } Sig;
} CANMsg0A18A000Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t IC_Destination_Address   : 8;

        uint8_t IC_NMAlive        : 1;
        uint8_t IC_NMRing         : 1;
        uint8_t IC_NMLimphome     : 1;
        uint8_t Res0              : 1;
        uint8_t IC_NMSleepIndication         : 1;
        uint8_t IC_NMSleepAck     : 1;
        uint8_t Res1              : 2;

        uint8_t IC_DataField_1    : 8;
        uint8_t IC_DataField_2    : 8;
        uint8_t IC_DataField_3    : 8;
        uint8_t IC_DataField_4    : 8;
        uint8_t IC_DataField_5    : 8;
        uint8_t IC_DataField_6    : 8;
        
    } Sig;
} CANMsg18FFA017Union;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Emergencylightsrequest          : 1;
        uint8_t LHSIndicatorlightsstatus        : 1;
        uint8_t RHSIndicatorlightsstatus        : 1;
        uint8_t LHSIndicatorlightsrequest       : 1;
        uint8_t RHSIndicatorlightsrequest       : 1;
        uint8_t Highbeamflashlightsrequest      : 1;
        uint8_t Highbeamlightsrequest           : 1;
        uint8_t LowBeamlightsrequest            : 1;

        uint8_t Ignitionkey                     : 1;
        uint8_t Reverselightsrequest            : 1;
        uint8_t Stoplightsrequest               : 1;
        uint8_t Additionallightsrequest         : 1;
        uint8_t Workinglightsrequest            : 1;
        uint8_t Position_parkinglightsrequest   : 1;
        uint8_t Rearfoglightsrequest            : 1;
        uint8_t Frontfoglightsrequest           : 1;

        uint8_t Airfilterblocked                : 1;
        uint8_t Oilfilterblocked                : 1;
        uint8_t Dieselfilterblocked             : 1;
        uint8_t Enginestatus                    : 1;
        uint8_t CDLdriverdoorlockfeedback       : 1;
        uint8_t CDLpassengerdoorlockfeedback    : 1;
        uint8_t Driverdooropenswitch            : 1;
        uint8_t Passengerdooropenswitch         : 1;
 
        uint8_t Res0                            : 1;
        uint8_t Hatchstatusfeedback             : 1;
        uint8_t LHRdoorstatusfeedback           : 1;
        uint8_t RHRdoorstatusfeedback           : 1;
        uint8_t Hatchstatus                     : 1;
        uint8_t LHRdoorstatus                   : 1;
        uint8_t RHRdoorstatus                   : 1;
        uint8_t Longdifferentiallocktransferbox : 1;
 
        uint8_t VPSRFTxUnlockButtonCntrl        : 4;
        uint8_t VPSRFTxLockButtonCntrl          : 4;
 
        uint8_t KeySts_1                        : 4;
        uint8_t VPSRFTxTrunkUnlockButtonCntrl   : 4;
 
        uint8_t Ambientairtemperature           : 8;
 
        uint8_t HandBrakeSts_1                  : 1;
        uint8_t BatteryVoltageLevel             : 7;

    } Sig;
} CANMsg18FFC321Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Res0                  : 8;

        uint8_t MainBrkSw             : 2;
        uint8_t RedundantBrkSw        : 2;
        uint8_t Res1                  : 2;
        uint8_t MechPTOEngaed         : 2;

        uint8_t Res2                  : 8;

        uint8_t Res3                  : 2;
        uint8_t SecondSpeedLimRequest : 2;
        uint8_t Res4                  : 4;

        uint8_t Res5                  : 2;
        uint8_t AuxEneShutdowSw       : 2;
        uint8_t Res6                  : 4;

        uint8_t Res7                  : 8;
        uint8_t Res8                  : 8;
        uint8_t Res9                  : 8;
    } Sig;
} CANMsg18FF6121Union;

typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t Seconds               : 8;

        uint8_t Minutes               : 8;

        uint8_t Hours                 : 8;

        uint8_t Month                 : 8;

        uint8_t Day                   : 8;

        uint8_t Year                  : 8;

        uint8_t LocalMinuteOffset     : 8;

        uint8_t LocalHourOffset       : 8;
    } Sig;
} CANMsg18FEE6EEUnion;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t ILLUMINATION       : 8;

        uint8_t Res0               : 8;

        uint8_t Res1               : 8;

        uint8_t Res2               : 8;

        uint8_t Res3               : 8;

        uint8_t Res4               : 8;

        uint8_t Res5               : 8;

        uint8_t Res6               : 8;
    } Sig;
} CANMsg18D00017Union;


typedef union
{
    uint8_t Msg [ 8 ];
    struct
    {
        uint8_t LaneDepWarnEnaCmd  : 2;
        uint8_t Res0               : 6;

        uint8_t Res1               : 8;

        uint8_t Res2               : 8;

        uint8_t Res3               : 8;

        uint8_t Res4               : 8;

        uint8_t Res5               : 8;

        uint8_t Res6               : 8;

        uint8_t Res7               : 8;
        
    } Sig;
} CANMsg18A97121Union;

#endif
