

#include "MotorDriver.h"
#include "Gauges.h"
#include "g_includes.h"

void GaugesInfo_Init(void)
{
    GaugesInfo [ RevMotorNum ].Parameter_Num           = 8;    // Es
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 0 ] = 0;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 1 ] = 1000;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 2 ] = 1500;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 3 ] = 2000;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 4 ] = 2500;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 5 ] = 3000;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 6 ] = 4000;
    GaugesInfo [ RevMotorNum ].Physical_Quantity [ 7 ] = 5000;

    GaugesInfo [ RevMotorNum ].MicroStep [ 0 ] = 0;
    GaugesInfo [ RevMotorNum ].MicroStep [ 1 ] = 581;
    GaugesInfo [ RevMotorNum ].MicroStep [ 2 ] = 865;
    GaugesInfo [ RevMotorNum ].MicroStep [ 3 ] = 1149;
    GaugesInfo [ RevMotorNum ].MicroStep [ 4 ] = 1436;
    GaugesInfo [ RevMotorNum ].MicroStep [ 5 ] = 1721;
    GaugesInfo [ RevMotorNum ].MicroStep [ 6 ] = 2299;
    GaugesInfo [ RevMotorNum ].MicroStep [ 7 ] = 2879;

    GaugesInfo [ VehMotorNum ].Parameter_Num           = 8;    // Vs
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 0 ] = 0;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 1 ] = 30;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 2 ] = 50;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 3 ] = 80;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 4 ] = 100;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 5 ] = 120;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 6 ] = 140;
    GaugesInfo [ VehMotorNum ].Physical_Quantity [ 7 ] = 180;

    GaugesInfo [ VehMotorNum ].MicroStep [ 0 ] = 0;
    GaugesInfo [ VehMotorNum ].MicroStep [ 1 ] = 489;
    GaugesInfo [ VehMotorNum ].MicroStep [ 2 ] = 805;
    GaugesInfo [ VehMotorNum ].MicroStep [ 3 ] = 1286;
    GaugesInfo [ VehMotorNum ].MicroStep [ 4 ] = 1632;
    GaugesInfo [ VehMotorNum ].MicroStep [ 5 ] = 1957;
    GaugesInfo [ VehMotorNum ].MicroStep [ 6 ] = 2278;
    GaugesInfo [ VehMotorNum ].MicroStep [ 7 ] = 2917;
}

void Gauges_Sleep_Init(void)
{
    bsp_MotorDriverOff();
}

void Gauges_KL30_Init(void)
{
    GaugesInfo_Init( );
    Gauges_Variate_Init_Once( );
    bsp_MeterConfig( );
    bsp_SetMotorMode(VehMotorNum, MaxReset);
    bsp_SetMotorMode(RevMotorNum, MaxReset);
}
void Gauges_KL15ON_Init(void)
{
    Gauges_IGStatus_Set(1);
}
void Gauges_KL15OFF_Init(void)
{
    Gauges_IGStatus_Set(0);
}

void Gauges_Wake_Up_Init(void)
{
    bsp_MeterConfig( );
}

void Gauges_Management_Service(void)
{
    INT16U PhysicalData2     = 0;
    INT16U PhysicalData3     = 0;
    INT16U Moter2_Set_Status = 0;
    INT16U Moter3_Set_Status = 0;
    if ( SYS_OPR_STAT_RUN )
    {
        PhysicalData2 = Get_DispEngineSpeed();
        PhysicalData3 = DataVSpeedDisp / 10;
    }
    else
    {
        PhysicalData2 = 0U;
        PhysicalData3 = 0U;
    }

    if ( SYS_OPR_STAT_IGN_ON )
    {
        Moter3_Set_Status = Gauges_Parameter_Set_Motor(VehMotorNum, PhysicalData3);
        Moter2_Set_Status = Gauges_Parameter_Set_Motor(RevMotorNum, PhysicalData2);
        // MeterPostion[RevMotorNum].destPosition = Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed();
        // MeterPostion[VehMotorNum].destPosition = Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP();
    }
}
