#ifndef _LCD_BUS_INTERFACE_H_
#define _LCD_BUS_INTERFACE_H_

#define wait_1us    120
#define wait_5us    5 * wait_1us
#define wait_10us   10 * wait_1us
#define wait_50us   50 * wait_1us
#define wait_120us  120 * wait_1us
#define wait_150us  150 * wait_1us
#define wait_500us  500 * wait_1us
#define wait_2000us 2000 * wait_1us
#define wait_20ms   10 * wait_2000us

typedef enum
{
    Notidle = 0,
    Idle
} LCDBUS_opr_t;

extern uint8_t LCDBUS_Init;

//#define GPIO_STB_PROTECTED_WRITE(preg, pstatus, reg, value) \
//    do                                                      \
//    {                                                       \
//        (preg) = 0xA5U;                                     \
//        (reg) = (value);                                    \
//        (reg) = ~(value);                                   \
//        (reg) = (value);                                    \
//    } while ((pstatus) == 1U)

#define WRITE_REG(SIZE, ADDR, VALUE)                      \
    {                                                     \
        *(( volatile uint##SIZE##_t * )(ADDR)) = (VALUE); \
    }
#define READ_REG(SIZE, ADDR) (*(( volatile uint##SIZE##_t * )((ADDR))))

extern void         Eic_Disable(void);
extern void         LCD_BUS_Init(void);
extern void         LCD_BUS_DeInit(void);
extern void         Lcbi_WriteData8(uint8_t Value);
extern void         Lcbi_WriteControl(uint8_t Reg);
extern void         Lcbi_WriteControlData(uint8_t Reg, uint8_t Para [], uint8_t ParaLen);
extern LCDBUS_opr_t LCDBUS_GetOperationStatus(void);
extern void LCDBUS_Check_RealTime(void);
extern void LCDBUS_Monitor_Time_ISR(void);

#endif
