#ifndef CAN_CH0_CAN_COMMUNICATION_MATRIX_H_
#define CAN_CH0_CAN_COMMUNICATION_MATRIX_H_

#include "TYW_stdint.h"
#include "CAN_Lib.h"
#include "g_includes.h"

extern st_CanMsgOp CAN_CH0_CanMsgOp;

extern st_CanMsgTxOp CAN_CH0_CanMsgTxOp;
#define CAN_MSG_LOST     0x55
#define CAN_CH0 &CAN_CH0_CanMsgOp
typedef enum
{
    CAN_CH0_ID_can0CF00400_Msg_Count,
    CAN_CH0_ID_can18FEF200_Msg_Count,
    CAN_CH0_ID_can18FEEE00_Msg_Count,
    CAN_CH0_ID_can18FEF100_Msg_Count,
    CAN_CH0_ID_can18FF2100_Msg_Count,
    CAN_CH0_ID_can18FD0700_Msg_Count,
    CAN_CH0_ID_can18FEFF00_Msg_Count,
    CAN_CH0_ID_can18FEE400_Msg_Count,
    CAN_CH0_ID_can18FECA00_Msg_Count,
    CAN_CH0_ID_can18FD7C00_Msg_Count,
    CAN_CH0_ID_can18FF4C00_Msg_Count,
    CAN_CH0_ID_can10FF1021_Msg_Count,
    CAN_CH0_ID_can10FF7521_Msg_Count,
    CAN_CH0_ID_can18FEF433_Msg_Count,
    CAN_CH0_ID_can18FF9CF1_Msg_Count,
    CAN_CH0_ID_can18FECA03_Msg_Count,
    CAN_CH0_ID_can0A18A006_Msg_Count,
    CAN_CH0_ID_can18FF4453_Msg_Count,
    CAN_CH0_ID_can18FFA8EE_Msg_Count,
    CAN_CH0_ID_can18FFB078_Msg_Count,
    CAN_CH0_ID_can18FE4A03_Msg_Count,
    CAN_CH0_ID_can18F00503_Msg_Count,
    CAN_CH0_ID_can18FF9DF1_Msg_Count,
    //CAN_CH0_ID_NM18FFA000_Msg_Count,
    CAN_CH0_ID_can18ECFF03_Msg_Count,
    CAN_CH0_ID_can18EBFF03_Msg_Count,
    CAN_CH0_ID_can18EBFF00_Msg_Count,
    CAN_CH0_ID_can18ECFF00_Msg_Count,
    CAN_CH0_ID_can18FE5BE8_Msg_Count,
    CAN_CH0_ID_can10F007E8_Msg_Count,

    CAN_CH0_ID_TOTAL_MAX,
} CAN_CH0_CAN_MSG_ID_t;

typedef enum
{

    CAN_CH0_ID_SEND_TOTAL,
} CAN_CH0_CAN_MSG_SEND_ID_t;

extern const st_CANMsgAttribute CAN_CH0_CAN_MSG_CONST_ARRAY[CAN_CH0_ID_TOTAL_MAX] ;
//extern const st_CAN_SendAttribute    CAN_CH0_CANSendAttr[CAN_CH0_ID_SEND_TOTAL] ;

#define  CAN_CH0_ID_can0CF00400_Msg    0x0CF00400ul
#define  CAN_CH0_ID_can18FEF200_Msg    0x18FEF200ul
#define  CAN_CH0_ID_can18FEEE00_Msg    0x18FEEE00ul
#define  CAN_CH0_ID_can18FEF100_Msg    0x18FEF100ul
#define  CAN_CH0_ID_can18FF2100_Msg    0x18FF2100ul
#define  CAN_CH0_ID_can18FD0700_Msg    0x18FD0700ul
#define  CAN_CH0_ID_can18FEFF00_Msg    0x18FEFF00ul
#define  CAN_CH0_ID_can18FEE400_Msg    0x18FEE400ul
#define  CAN_CH0_ID_can18FECA00_Msg    0x18FECA00ul
#define  CAN_CH0_ID_can18FD7C00_Msg    0x18FD7C00ul
#define  CAN_CH0_ID_can18FF4C00_Msg    0x18FF4C00ul
#define  CAN_CH0_ID_can10FF1021_Msg    0x10FF1021ul
#define  CAN_CH0_ID_can10FF7521_Msg    0x10FF7521ul
#define  CAN_CH0_ID_can18FEF433_Msg    0x18FEF433ul
#define  CAN_CH0_ID_can18FF9CF1_Msg    0x18FF9CF1ul
#define  CAN_CH0_ID_can18FECA03_Msg    0x18FECA03ul
#define  CAN_CH0_ID_can0A18A006_Msg    0x0A18A006ul
#define  CAN_CH0_ID_can18FF4453_Msg    0x18FF4453ul
#define  CAN_CH0_ID_can18FFA8EE_Msg    0x18FFA8EEul
#define  CAN_CH0_ID_can18FFB078_Msg    0x18FFB078ul
#define  CAN_CH0_ID_can18FE4A03_Msg    0x18FE4A03ul
#define  CAN_CH0_ID_can18F00503_Msg    0x18F00503ul
#define  CAN_CH0_ID_can18FF9DF1_Msg    0x18FF9DF1ul
//#define  CAN_CH0_ID_NM18FFA000_Msg     0x18FFA000ul
#define  CAN_CH0_ID_can18ECFF03_Msg    0x18ECFF03ul
#define  CAN_CH0_ID_can18EBFF03_Msg    0x18EBFF03ul
#define  CAN_CH0_ID_can18EBFF00_Msg    0x18EBFF00ul   
#define  CAN_CH0_ID_can18ECFF00_Msg    0x18ECFF00ul
#define  CAN_CH0_ID_can18FE5BE8_Msg     0x18FE5BE8ul
#define  CAN_CH0_ID_can10F007E8_Msg     0x10F007E8ul

extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngDemandPercentTorque(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngStarterMode(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_SrcAddrssOfCtrllngDvcForEngCtrl(void);
extern uint16_t Get_CAN_CH0_ID_0CF00400_Sig_EngSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_ActualEngPercentTorque(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_DriversDemandEngPercentTorque(void);
extern uint8_t  Get_CAN_CH0_ID_0CF00400_Sig_EngTorqueMode_EDC_EEC1(void);
extern uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngAverageFuelEconomy(void);
extern uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngInstantaneousFuelEconomy(void);
extern uint16_t Get_CAN_CH0_ID_18FEF200_Sig_EngFuelRate(void);
extern uint16_t Get_CAN_CH0_ID_18FEEE00_Sig_EngineOilTemp1(void);
extern uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_EngFuelTemp1(void);
extern uint8_t  Get_CAN_CH0_ID_18FEEE00_Sig_EngCoolantTemp(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_EngTestModeSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_Idle_decrement_sw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_Idle_increment_sw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_PTO_Sts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSetSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlAccelSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlResSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlCoastSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlSetSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CltSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_BrkSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlEnableSw(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF100_Sig_CruiseCtrlActive(void);
extern uint16_t Get_CAN_CH0_ID_18FEF100_Sig_WheelBasedVehSpeed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_AirC_stPsCmpr(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_FuelFiltHeat(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_EngOilPrsLow(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_OilLifeMonSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_MaxVehSpeedLimSetp(void);
extern uint8_t  Get_CAN_CH0_ID_18FF2100_Sig_EDC_SpeedLimSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FD0700_Sig_OBD_MIL_LampSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FEFF00_Sig_EDC_WaterInFuelInd1(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EDC_PrtctSysShutdEngine(void);
extern uint8_t  Get_CAN_CH0_ID_18FEE400_Sig_EDC_WaittoStartLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNConversionMethodABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_OccurrenceCountABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FMIABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNLastBitABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNSecondByteABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_SPNFirstByteABS(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_FlashMil(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_Mil(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_RedStopLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_AmberWarnLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA00_Sig_ProtLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampInhibSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Vehicle_Speed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Vehicle_Speed(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Minutes_Before_Limited_Torque(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Hours_Before_Limited_Torque(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Tank_Fluid_Level(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_lamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Quality_Error(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_System_Error(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4C00_Sig_EMS_Urea_Level_Text(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RequestKeyStillInIndication(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RequestPositionLightStillOnInd(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHRearFogLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHRearFogLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RightTurnLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LeftTurnLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHStopLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHStopLightFailSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HazardLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHTurnSignalSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHTurnSignalSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_FrontFogLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RearFogLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HeatedMirrorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_ReverseSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_RHParkTailLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LHParkTailLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_HighBeamSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_LowBeamSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_BrakePedalSts_Rev(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_EngineSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_VehicleSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF1021_Sig_StopLightSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_AirbagFail(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_TPMSSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_KeySts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_wiper(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_WishWashSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_BonnetSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_RHatchSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_LHRDoorSts(void);
extern uint8_t  Get_CAN_CH0_ID_10FF7521_Sig_CeilingLightSts_Rev(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TirePressureThresholdDetection(void);
extern uint16_t Get_CAN_CH0_ID_18FEF433_Sig_TireAirLeakageRate(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelEndElectricalFault(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTITireStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_CTIWheelSensorStatus(void);
extern uint16_t Get_CAN_CH0_ID_18FEF433_Sig_TireTemperature(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TirePressure(void);
extern uint8_t  Get_CAN_CH0_ID_18FEF433_Sig_TireLocation(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_BatterySts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_MemorySts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_VhctypmtchSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_CmmnctCANSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_GPSSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9CF1_Sig_CmmnctSts(void);
extern uint16_t Get_CAN_CH0_ID_18FECA03_Sig_Spn02ETC(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_SPNConversionMethod01ETC(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_OccurrenceCount01ETC(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_FMI01ETC(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_SpnHigh01ETC(void);
extern uint16_t Get_CAN_CH0_ID_18FECA03_Sig_Spn01ETC(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AT_RedStopLamp(void);
extern uint8_t  Get_CAN_CH0_ID_18FECA03_Sig_AT_AmberWarnLamp(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_HhFail(void);
extern uint16_t Get_CAN_CH0_ID_0A18A006_Sig_PulseCntRhr(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VehSpeedFail_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_PulseCntFailLhr(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_PulseCntFailRhr(void);
extern uint16_t Get_CAN_CH0_ID_0A18A006_Sig_PulseCntLhr(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_BsmBtnSts(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcCtrlSts(void);
extern uint16_t Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AbsFail(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_EbdFail(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AsrFail(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcFail(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_AsrEldInterv(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_VdcInterv(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_Des_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_0A18A006_Sig_Eol_ESP(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutPedestrSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutRolloverSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutRearSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutDrivSideSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutPassSideSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFront2LevSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFront1LevSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_CrashOutFrontPtSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_AirbagFail(void);
extern uint8_t  Get_CAN_CH0_ID_18FF4453_Sig_PassBagSts(void);
extern uint8_t  Get_CAN_CH0_ID_18FFA8EE_Sig_SelfCheckingStatus(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRR_Dis(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRRM_Dis(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRLM_Dis(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorRL_Dis(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorR_Configure(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice(void);
extern uint8_t  Get_CAN_CH0_ID_18FFB078_Sig_PAM_SensorR_Sts(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmMode5Ind(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmMode1Ind(void);
extern uint8_t  Get_CAN_CH0_ID_18FE4A03_Sig_TransmEngCrkEna(void);
extern uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransmCurRng(void);
extern uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransmReqRng(void);
extern uint8_t  Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear(void);
extern uint16_t Get_CAN_CH0_ID_18F00503_Sig_TransActualGearRatio(void);
extern uint8_t  Get_CAN_CH0_ID_18F00503_Sig_TransSelectedGear(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_LocalHrOfs_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_LocalMinOfs_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX(void);
extern uint8_t  Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX(void);
//extern uint8_t  Get_CAN_CH0_ID_18FFA000_Sig_NM(void);
extern uint8_t  Get_CAN_CH0_ID_18ECFF03_Sig_test(void);
extern uint8_t  Get_CAN_CH0_ID_18EBFF03_Sig_test(void);
extern uint8_t  Get_CAN_CH0_ID_18EBFF00_Sig_test(void);
extern uint8_t  Get_CAN_CH0_ID_18ECFF00_Sig_test(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Departure_Indication_Enable_Status(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Tracking_Status_Left_Side(void);
extern uint8_t  Get_CAN_CH0_ID_18FE5BE8_Sig_Lane_Tracking_Status_Right_Side(void);
extern uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWLeftWarning(void);
extern uint8_t  Get_CAN_CH0_ID_10F007E8_Sig_ADAS_LDWRightWarning(void);

extern uint8_t  Co_Can_ConvertSubID_CAN_CH0(uint32_t MsgID);

#endif
