/**************************************************************************/ /**
                                                                              * \file     Sys_Tick.h
                                                                              * \brief    System tick timer header file
                                                                              * \details
                                                                              * \author   Zhang Xuan
                                                                              * \version  V1.0.0
                                                                              * \date     19-Jul-2018
                                                                              * \par      History:
                                                                              *           V1.0.0 Initial release
                                                                              * \par      Copyright:
                                                                              *           (c) Heilongjiang TYW Electronics co., LTD
                                                                              ******************************************************************************/

#ifndef _SYS_TICK_H_
#define _SYS_TICK_H_

/* Includes ------------------------------------------------------------------*/

/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern
{
#endif

    /* Exported types ------------------------------------------------------------*/
    typedef enum
    {
        SYS_TICK_50us_CB = 0U,
        SYS_TICK_1ms_CB,
        SYS_TICK_100ms_CB,
    } Sys_Tick_Call_Back_Type_en_t;

/* Exported constants --------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/
#define SYS_TICK_INT_INTERVAL       (50UL) /* 50us */
#define SYS_TICK_CALL_BACK_TYPE_NUM (3U)

    /* 50us rolling counter */
    extern volatile uint16_t g_u16SysRollingCounter50us;
#define SYS_ROLLING_COUNTER_50us g_u16SysRollingCounter50us

    /* 1ms rolling counter */
    extern volatile uint16_t g_u16SysRollingCounter1ms;
#define SYS_ROLLING_COUNTER_1ms g_u16SysRollingCounter1ms

/* Interrupt service routine adaptor */
#define R_AWOT_TintIsr(i) Sys_Tick_Timer_ISR( )

    /* Exported functions ------------------------------------------------------- */

    extern void Sys_Tick_Timer_Start(void);
    extern void Sys_Tick_Timer_Stop(void);
    extern void Sys_Tick_Timer_Call_Back_Reg(Sys_Tick_Call_Back_Type_en_t enType, void (*pfnIsr)(void));
    extern void Sys_Tick_Timer_ISR(void);

#ifdef __cplusplus
}
#endif

#endif /* _GPIO_H_ */
