#ifndef RTE_GPIO_H__
#define RTE_GPIO_H__
#include "dr7f701401.dvf.h"

#define GPIO_DIR_PORT17_PIN0   PORT_ISOPM17_0     // SDB_LED_DRIVER
#define GPIO_DIR_PORT16_PIN10  PORT_ISOPM16_10    // SCL_LED_DRIVER
#define GPIO_DIR_PORT16_PIN11  PORT_ISOPM16_11    // SDA_LED_DRIVER
#define GPIO_OUT_PORT17_PIN0   PORT_ISOP17_0
#define GPIO_OUT_PORT16_PIN10  PORT_ISOP16_10
#define GPIO_OUT_PORT16_PIN11  PORT_ISOP16_11     // 输出
#define GPIO_IN_PORT16_PIN11   PORT_ISOPPR16_11
#define GPIO_IN_PORT0_PIN0     PORT_AWOPPR0_0     // 15
#define GPIO_IN_PORT10_PIN4    PORT_ISOPPR10_4    // 30
#define KL30_WakeUp_In         GPIO_IN_PORT10_PIN4
#define Handbrake_IN           PORT_ISOPPR11_2
#define Fuel_Warmwind_IN       PORT_ISOPPR11_0
#define Block_Diesel_Filter_IN PORT_ISOPPR10_8
#define AIRBAG_IN_POSITIVE     PORT_ISOPPR10_9
#define AIRBAG_IN_NEGATIVE     PORT_ISOPPR11_1
#define Brake_Fault_IN         PORT_ISOPPR11_3
#define Fuel_Alarm_IN          PORT_ISOPPR10_10
#define Safety_Belt_IN         PORT_ISOPPR10_7
#define Start_Detect_IN        PORT_ISOPPR10_6
#define KEY0_MCU_IN            PORT_ISOPPR17_3
#define KEY1_MCU_IN            PORT_ISOPPR17_2
#define CAN_STB_OUT            PORT_AWOP0_3
#define Buzzer_CT_X1_OUT       PORT_ISOP16_8
#define Buzzer_CT_X2_OUT       PORT_ISOP16_7
#define Buzzer_CT_X3_OUT       PORT_ISOP16_6
#define Buzzer_PWM             PORT_ISOP16_9
#define SDB_LED_DRIVER         PORT_ISOP17_0
#define SDA_LED_DRIVER         PORT_ISOP16_11
#define SCL_LED_DRIVER         PORT_ISOP16_10
#define EEPROM_SCL             PORT_ISOP44_3
#define EEPROM_SDA             PORT_ISOP44_2
#define FUEL_CTR             PORT_ISOP10_5
#define GPIO_OUT_PORT45_PIN05 PORT_ISOP45_5   //屏幕RESET



extern void RTE_GPIO_Sleep_Init(void);
extern void RTE_GPIO_KL30_Init(void);
#endif
