
#include "CAN_Lib.h"
#include "CAN_APP.h"
#include "CAN_APP_TX.h"
#include "DataProcess.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"


#include "Analog_Signals.h"


#include "Line_In.h"

#include "Key.h"
#include "g_includes.h"


/*uint8_t CrcCheckSum(uint8_t *data, uint8_t len)
{
    uint8_t crc        = 0xff;
    uint8_t CRC_POLY   = 0x2f;
    uint8_t crcxor     = 0xff;
    uint8_t bit_index  = 0;
    uint8_t byte_index = 0;

    for ( byte_index = 0; byte_index < len; ++byte_index )
    {
        crc ^= data [ byte_index ];
        for ( bit_index = 0; bit_index < 8; ++bit_index )
        {
            if ( (crc & 0x80) != 0 )
                crc = (crc << 1) ^ CRC_POLY;
            else
                crc = (crc << 1);
        }
    }

    crc = crc ^ crcxor;

    return crc;
}*/

void Can_Set_Buff_18FEC1EE(canlib_uint8_t CopyData [])
{
    uint32_t             odo_Val, trip_Val;
    CANMsg18FEC1EEUnion *p18FEC1EE;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18FEC1EE = ( CANMsg18FEC1EEUnion * )CopyData;
    if ( p18FEC1EE != ( void * )0 )
    {
        odo_Val        = Mile_Get_Index_Value(MILE_INDEX_ODO)*20u;
        trip_Val       = Mile_Get_Index_Value(MILE_INDEX_TRAP_A)*20u;
        CopyData [ 0 ] = ( canlib_uint8_t )((odo_Val >> 0) & 0x000000FFul);
        CopyData [ 1 ] = ( canlib_uint8_t )((odo_Val >> 8) & 0x000000FFul);
        CopyData [ 2 ] = ( canlib_uint8_t )((odo_Val >> 16) & 0x000000FFul);
        CopyData [ 3 ] = ( canlib_uint8_t )((odo_Val >> 24) & 0x000000FFul);

        CopyData [ 4 ] = ( canlib_uint8_t )((trip_Val >> 0) & 0x000000FFul);
        CopyData [ 5 ] = ( canlib_uint8_t )((trip_Val >> 8) & 0x000000FFul);
        CopyData [ 6 ] = ( canlib_uint8_t )((trip_Val >> 16) & 0x000000FFul);
        CopyData [ 7 ] = ( canlib_uint8_t )((trip_Val >> 24) & 0x000000FFul);
    }
}

void Can_Set_Buff_18FEFC17(canlib_uint8_t CopyData [])
{
    CANMsg18FEFC17Union *p18FEFC17;
    uint16_t              IC_FuelLevel        = 0u;
    uint8_t              i = 0;

    IC_FuelLevel = GetFuelCapacity_Val(); 
    IC_FuelLevel *= 5;
    IC_FuelLevel /= 2;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18FEFC17 = ( CANMsg18FEC1EEUnion * )CopyData;
    if ( p18FEFC17 != ( void * )0 )
    {
        CopyData [ 0 ] = 0xffu;
        p18FEFC17->Sig.FuelLevel = IC_FuelLevel;
        CopyData [ 2 ] = 0xffu;
        CopyData [ 3 ] = 0xffu;
        CopyData [ 4 ] = 0xffu;
        CopyData [ 5 ] = 0xffu;
        CopyData [ 6 ] = 0xffu;
        CopyData [ 7 ] = 0xffu;
    }
}

void Can_Set_Buff_10FF4117(canlib_uint8_t CopyData [])
{
    CANMsg10FF4117Union *p10FF4117;
    uint16_t             IC_LowFuelWarningSts        = 0u;
    uint8_t              i = 0;
    IC_LowFuelWarningSts = Get_LowFuelWarningSts();
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p10FF4117 = ( CANMsg10FF4117Union * )CopyData;
    if ( p10FF4117 != ( void * )0 )
    {
        
        if(Line_In_Get_Status (LINE_IN_Safety_Belt) == 1) 
        {
            p10FF4117->Sig.Seatbeltsts = 1;
        }
        else
        {
            p10FF4117->Sig.Seatbeltsts = 0;
        }
        
        if(Line_In_Get_Status (LINE_IN_Handbrake) == 1) 
        {
            p10FF4117->Sig.HandBrakeSts = 1;
        }
        else
        {
            p10FF4117->Sig.HandBrakeSts = 0;
        }

        if(Common_GetIgnOnTime() < SELF_CHECK_TIME)
        {
            p10FF4117->Sig.AirBaglampFailSts = 0;
        }
        else
        {
            if(Get_TelltalesLedSts(m_LED_AIRBAG_Lamp) == 1)
            {
                p10FF4117->Sig.AirBaglampFailSts = 2;
            }
            else
            {
                p10FF4117->Sig.AirBaglampFailSts = 0;
            }
        }
        

        if (SYS_OPR_STAT_IGN_ON)
        {
            if(Common_GetIgnOnTime() >= SELF_CHECK_TIME)
            {
                p10FF4117->Sig.LowFuelWarningSts = IC_LowFuelWarningSts;
            }
            else
            {
                p10FF4117->Sig.LowFuelWarningSts = 1;
            }
        }
        else
        {
            p10FF4117->Sig.LowFuelWarningSts = 0;
        }
        
        p10FF4117->Sig.HydraulicBrakePressureSts = 3;
        p10FF4117->Sig.EngineWaterLevel = 3;
        p10FF4117->Sig.BrakePadWearSts = 3;
        p10FF4117->Sig.AirFilterblockingSts = 3;
        p10FF4117->Sig.FuelFilterblockingSts = 1;
        p10FF4117->Sig.k_value_L = 0;
        p10FF4117->Sig.k_value_M = 0;
        p10FF4117->Sig.k_value_H = 0;
        p10FF4117->Sig.fueltank = 0;
        p10FF4117->Sig.IC_Reserved_2 = 0;
    }
}

void Can_Set_Buff_0CFE6CEE(canlib_uint8_t CopyData [])
{
    CANMsg0CFE6CEEUnion *p0CFE6CEE;
    uint32_t             vSpeed_Val = 0;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }

    p0CFE6CEE = ( CANMsg0CFE6CEEUnion * )CopyData;
    if ( p0CFE6CEE != ( void * )0 )
    {
        if (SYS_OPR_STAT_IGN_ON)
        {
            if ( (DataVSpeedValid) && (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_NORMAL) )
            {
                vSpeed_Val =  Get_CAN_CH0_ID_0A18A006_Sig_VehSpeed_ESP();
                vSpeed_Val = vSpeed_Val << 4;
                if(vSpeed_Val <= 0xf0)
                {
                    vSpeed_Val = 0;
                }

                if(vSpeed_Val >= 0xB400)
                {
                    vSpeed_Val = 0xB400;
                }

                CopyData [ 6 ] = ( canlib_uint8_t )(vSpeed_Val & 0x00FF);
                CopyData [ 7 ] = ( canlib_uint8_t )((vSpeed_Val >> 8) & 0x00ffu);
            }
            else
            {
                CopyData [ 6 ] = 0x00u;
                CopyData [ 7 ] = 0x00u;
            }
        }
        else
        {
            CopyData [ 6 ] = 0x00u;
            CopyData [ 7 ] = 0x00u;
        }

        p0CFE6CEE->Sig.Driver1WorkingState = 7;
        p0CFE6CEE->Sig.Driver2WorkingState = 7;

        p0CFE6CEE->Sig.DriveRecognize = 3;
        p0CFE6CEE->Sig.SystemEvent = 3;
        p0CFE6CEE->Sig.HandlingInformation = 3;
        p0CFE6CEE->Sig.TachographPerformance = 3;

        p0CFE6CEE->Sig.TachographOutputShaftSpeed_L = 0xff;
        p0CFE6CEE->Sig.TachographOutputShaftSpeed_H = 0xff;
    }
}

void Can_Set_Buff_0810A000(canlib_uint8_t CopyData [])
{
    CANMsg0810A000Union *p0810A000;
    uint8_t             i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }

    p0810A000 = ( CANMsg0810A000Union * )CopyData;
    if ( p0810A000 != ( void * )0 )
    {
        if(CAN_MSG_Status(CAN_CH0, CAN_CH0_ID_can18FEF100_Msg_Count) == CAN_MSG_LOST)
        {
            p0810A000->Sig.BrkPedNoSw = 0;
            p0810A000->Sig.BrkPedNcSw = 1;
        }
        else
        {
            if((Get_CAN_CH0_ID_18FEF100_Sig_BrkSw() == 1)||
               (Get_CAN_CH0_ID_18FEF100_Sig_BrkSw() == 2)||
               (Get_CAN_CH0_ID_18FEF100_Sig_BrkSw() == 3))
            {
                p0810A000->Sig.BrkPedNoSw = 1;
                p0810A000->Sig.BrkPedNcSw = 0;
            }
            else 
            {
                p0810A000->Sig.BrkPedNoSw = 0;
                p0810A000->Sig.BrkPedNcSw = 1;
            }
        }
        p0810A000->Sig.CcValData = 0;
        p0810A000->Sig.CcFail = 0;
        p0810A000->Sig.ResSw = 0;
        p0810A000->Sig.CcCoastDecelSw = 0;
        p0810A000->Sig.CcAccelSw = 0;
        p0810A000->Sig.CcSetSw = 0;
        p0810A000->Sig.CcOn_OffSts = 0;
        p0810A000->Sig.CcDataIntegr = 0;
        p0810A000->Sig.BcmcmdMsgSafCnt = 0;
        p0810A000->Sig.CrkReqSts = 0;
    }
}


void Can_Set_Buff_0A18A000(canlib_uint8_t CopyData [])
{
    CANMsg0A18A000Union *p0A18A000;
    uint8_t             i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }

    p0A18A000 = ( CANMsg0A18A000Union * )CopyData;
    if ( p0A18A000 != ( void * )0 )
    {
        if (SYS_OPR_STAT_IGN_ON)
        {
            if(Line_In_Get_Status (LINE_IN_Start_Detect) == 1) 
            {
                p0A18A000->Sig.KeySts = 0x0C;
            }
            else
            {
                p0A18A000->Sig.KeySts = 0x04;
            }

            if (Common_GetIgnOnTime() <= 3000)
            {
                p0A18A000->Sig.EbdLampFail = 2;
                p0A18A000->Sig.AbsLampFail = 2;
            }
            else
            {
                if( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can0A18A006_Msg_Count) == CAN_SIG_LOST )
                {
                    p0A18A000->Sig.EbdLampFail = 2;
                    p0A18A000->Sig.AbsLampFail = 2;
                }
                else
                {
                    if(Get_CAN_CH0_ID_0A18A006_Sig_EbdFail() == 1)
                    {
                        p0A18A000->Sig.EbdLampFail = 2;
                    }
                    else
                    {
                        p0A18A000->Sig.EbdLampFail = 0;
                    }

                    if(Get_CAN_CH0_ID_0A18A006_Sig_AbsFail() == 1)
                    {
                        p0A18A000->Sig.AbsLampFail = 2;
                    }
                    else
                    {
                        p0A18A000->Sig.AbsLampFail = 0;
                    }
                }
            }  
        }
        else
        {
            p0A18A000->Sig.KeySts = 1;
            p0A18A000->Sig.EbdLampFail = 0;
            p0A18A000->Sig.AbsLampFail = 0;
        }

        if(Line_In_Get_Status (LINE_IN_Handbrake) == 1) 
        {
            p0A18A000->Sig.HandBrkSts = 1;
        }
        else
        {
            p0A18A000->Sig.HandBrkSts = 0;
        }

        p0A18A000->Sig.VdcLampFail = 3;
        p0A18A000->Sig.AsrLampFail = 3;
        p0A18A000->Sig.ComprAcReqSts = 1;
        p0A18A000->Sig.LowBeamSts = 1;
        p0A18A000->Sig.DoorStsDriv = 1;
        p0A18A000->Sig.ExtTemp = 0xff;
        p0A18A000->Sig.RechargeSts = 1;
        p0A18A000->Sig.DrivStyleSts = 7;
    }
}

void Can_Set_Buff_18FFC321(canlib_uint8_t CopyData [])
{
    CANMsg18FFC321Union *p18FFC321;
    uint8_t             i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }

    p18FFC321 = ( CANMsg18FFC321Union * )CopyData;
    if ( p18FFC321 != ( void * )0 )
    {
        if (SYS_OPR_STAT_IGN_ON)
        {
            if(Line_In_Get_Status (LINE_IN_Start_Detect) == 1) 
            {
                p18FFC321->Sig.KeySts_1 = 0x0C;
            }
            else
            {
                p18FFC321->Sig.KeySts_1 = 0x04;
            }
        }
        else
        {
            p18FFC321->Sig.KeySts_1 = 1;
        }

        if(Line_In_Get_Status (LINE_IN_Handbrake) == 1) 
        {
            p18FFC321->Sig.HandBrakeSts_1 = 1;
        }
        else
        {
            p18FFC321->Sig.HandBrakeSts_1 = 0;
        }

        p18FFC321->Sig.Emergencylightsrequest = 1;
        p18FFC321->Sig.LHSIndicatorlightsstatus = 1;
        p18FFC321->Sig.RHSIndicatorlightsstatus = 1;
        p18FFC321->Sig.LHSIndicatorlightsrequest = 1;
        p18FFC321->Sig.RHSIndicatorlightsrequest = 1;
        p18FFC321->Sig.Highbeamflashlightsrequest = 1;
        p18FFC321->Sig.Highbeamlightsrequest = 1;
        p18FFC321->Sig.LowBeamlightsrequest = 1;
        p18FFC321->Sig.Ignitionkey = 1;

        p18FFC321->Sig.Reverselightsrequest = 0;

        p18FFC321->Sig.Stoplightsrequest = 1;
        p18FFC321->Sig.Additionallightsrequest = 1;
        p18FFC321->Sig.Workinglightsrequest = 1;
        p18FFC321->Sig.Position_parkinglightsrequest = 1;
        p18FFC321->Sig.Rearfoglightsrequest = 1;
        p18FFC321->Sig.Frontfoglightsrequest = 1;
        p18FFC321->Sig.Airfilterblocked = 1;
        p18FFC321->Sig.Oilfilterblocked = 1;
        p18FFC321->Sig.Dieselfilterblocked = 1;
        p18FFC321->Sig.Enginestatus = 1;
        p18FFC321->Sig.CDLdriverdoorlockfeedback = 1;
        p18FFC321->Sig.CDLpassengerdoorlockfeedback = 1;
        p18FFC321->Sig.Driverdooropenswitch = 1;
        p18FFC321->Sig.Passengerdooropenswitch = 1;
        p18FFC321->Sig.Hatchstatusfeedback = 1;
        p18FFC321->Sig.LHRdoorstatusfeedback = 1;
        p18FFC321->Sig.RHRdoorstatusfeedback = 1;
        p18FFC321->Sig.Hatchstatus = 1;
        p18FFC321->Sig.LHRdoorstatus = 1;
        p18FFC321->Sig.RHRdoorstatus = 1;
        p18FFC321->Sig.Longdifferentiallocktransferbox = 1;

        p18FFC321->Sig.VPSRFTxUnlockButtonCntrl = 15;
        p18FFC321->Sig.VPSRFTxLockButtonCntrl = 15;
        p18FFC321->Sig.VPSRFTxTrunkUnlockButtonCntrl = 15;

        p18FFC321->Sig.Ambientairtemperature = 255;

        p18FFC321->Sig.BatteryVoltageLevel = 127;
    }
}

void Can_Set_Buff_18FF6121(canlib_uint8_t CopyData [])
{
    CANMsg18FF6121Union *p18FF6121;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18FF6121 = ( CANMsg18FF6121Union * )CopyData;
    if ( p18FF6121 != ( void * )0 )
    {
        p18FF6121->Sig.MainBrkSw = 3;
        p18FF6121->Sig.RedundantBrkSw = 3;
        p18FF6121->Sig.MechPTOEngaed = 3;
        p18FF6121->Sig.SecondSpeedLimRequest = 3;
        p18FF6121->Sig.AuxEneShutdowSw = 3;
    }
}

uint16_t LocalMinOfs_TBOX = 0;
uint16_t LocalHrOfs_TBOX = 0;
void Can_Set_Buff_18FEE6EE(canlib_uint8_t CopyData [])
{
    CANMsg18FEE6EEUnion *p18FEE6EE;
   
    uint8_t              i = 0; 
    
    LocalMinOfs_TBOX = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalMinOfs_TBOX();
    LocalHrOfs_TBOX = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalHrOfs_TBOX();
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18FEE6EE = ( CANMsg18FEE6EEUnion * )CopyData;
    if ( p18FEE6EE != ( void * )0 )
    {
        p18FEE6EE->Sig.Year = (RTC_YEAR+15);
        p18FEE6EE->Sig.Month = RTC_MONTH;
        p18FEE6EE->Sig.Day = (RTC_DATE*4);
        p18FEE6EE->Sig.Hours = RTC_HOUR;
        p18FEE6EE->Sig.Minutes = RTC_MINUTE;
        p18FEE6EE->Sig.Seconds = (RTC_SECOND*4);

        if(/*(Get_CAN_CH0_ID_18FF9CF1_Sig_TBOXFILSts() == 1)||*/
		   ((CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9DF1_Msg_Count) == CAN_SIG_LOST)||
           (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF9CF1_Msg_Count) == CAN_SIG_LOST)||
	   	   (CanReceive.Can_18FF9DF1 != 1)||(CanReceive.Can_18FF9CF1 != 1)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Sec_TBOX() > 0XEC) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Min_TBOX() > 0X3B) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Hr_TBOX() > 0X17) || 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() > 0x0C)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Month_TBOX() < 1)|| 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() > 0x7C)||
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Day_TBOX() < 1)|| 
	   	   (Get_CAN_CH0_ID_18FF9DF1_Sig_Yr_TBOX() > 0xFA)))
        {
            p18FEE6EE->Sig.LocalMinuteOffset = 125;
            p18FEE6EE->Sig.LocalHourOffset = 125;
        }
        else
        {
            if((LocalMinOfs_TBOX > 0xb8)||(LocalMinOfs_TBOX < 0x42))
            {
                p18FEE6EE->Sig.LocalHourOffset = 125;
                p18FEE6EE->Sig.LocalMinuteOffset = 125;
            }
            else
            {
                p18FEE6EE->Sig.LocalMinuteOffset = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalMinOfs_TBOX();
            }
            
            if((LocalHrOfs_TBOX > 0x94)||(LocalHrOfs_TBOX < 0x66))
            {
                p18FEE6EE->Sig.LocalHourOffset = 125;
                p18FEE6EE->Sig.LocalMinuteOffset = 125;
            }
            else
            {
                p18FEE6EE->Sig.LocalHourOffset = Get_CAN_CH0_ID_18FF9DF1_Sig_LocalHrOfs_TBOX();
            }
        }
    }
}

void Can_Set_Buff_18D00017(canlib_uint8_t CopyData [])
{
    CANMsg18D00017Union *p18D00017;
    uint16_t              IC_ILLUMINATION = 0;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18D00017 = ( CANMsg18D00017Union * )CopyData;
    if ( p18D00017 != ( void * )0 )
    {
        if((Get_TelltalesLedSts(m_LED_Park_Lamp) == 1) || (Get_Enter_night_mode_sta() == 1))
        {
            if(g_nightLight.Duty == 150)
            {
                IC_ILLUMINATION = 15;
            }
            else if(g_nightLight.Duty == 250)
            {
                IC_ILLUMINATION = 25;
            }
            else if(g_nightLight.Duty == 350)
            {
                IC_ILLUMINATION = 35;
            }
            else if(g_nightLight.Duty == 450)
            {
                IC_ILLUMINATION = 45;
            }
            else if(g_nightLight.Duty == 550)
            {
                IC_ILLUMINATION = 55;
            }
            else if(g_nightLight.Duty == 650)
            {
                IC_ILLUMINATION = 65;
            }
            else if(g_nightLight.Duty == 750)
            {
                IC_ILLUMINATION = 75;
            }
            else if(g_nightLight.Duty == 850)
            {
                IC_ILLUMINATION = 85;
            }
            else
            {
                IC_ILLUMINATION = 0;
            }
        }
        else
        {
            if(g_Light.Duty == 150)
            {
                IC_ILLUMINATION = 15;
            }
            else if(g_Light.Duty == 250)
            {
                IC_ILLUMINATION = 25;
            }
            else if(g_Light.Duty == 350)
            {
                IC_ILLUMINATION = 35;
            }
            else if(g_Light.Duty == 450)
            {
                IC_ILLUMINATION = 45;
            }
            else if(g_Light.Duty == 550)
            {
                IC_ILLUMINATION = 55;
            }
            else if(g_Light.Duty == 650)
            {
                IC_ILLUMINATION = 65;
            }
            else if(g_Light.Duty == 750)
            {
                IC_ILLUMINATION = 75;
            }
            else if(g_Light.Duty == 850)
            {
                IC_ILLUMINATION = 85;
            }
            else
            {
                IC_ILLUMINATION = 0;
            }
        }
        p18D00017->Sig.ILLUMINATION = (IC_ILLUMINATION*10)/4;
    }
}

void Can_Set_Buff_18A97121(canlib_uint8_t CopyData [])
{
    CANMsg18A97121Union *p18A97121;
    uint8_t              i = 0;
    for ( i = 0; i < 8; i++ )
    {
        CopyData [ i ] = 0xFFU;
    }
    p18A97121 = ( CANMsg18A97121Union * )CopyData;
    if ( p18A97121 != ( void * )0 )
    {
        if((Get_NodeConfig_LWDS() == 1)&&(MenuData.Ldws == 2))
        {
            p18A97121->Sig.LaneDepWarnEnaCmd = 1;
        }
        else
        {
            p18A97121->Sig.LaneDepWarnEnaCmd = 0;
        }
    }
}




