#ifndef __UDS_2FSERVICE_Main_H
#define __UDS_2FSERVICE_Main_H

#include "TYW_stdint.h"
#include "UDS_2FService_Filter.h"
#include "UDS_2FService_Internal.h"
typedef union 
{
  uint8_t Data[4];
  struct 
  {
    /* data */
    uint8_t  OverSpeed   : 1;
    uint8_t TboxAlarm    : 1;
    uint8_t ExhaustBrake : 1;
    uint8_t EOBD         : 1;
    uint8_t urea         : 1;
    uint8_t Airbag       : 1;
    uint8_t reserved     : 2;

    uint8_t AirMatic           : 1;
    uint8_t DoorOpen          : 1; 
    uint8_t LowOilPressure    : 1; 
    uint8_t LowFuelAlarm      : 1; 
    uint8_t PreheatIndicator  : 1; 
    uint8_t ABSAlarm           : 1; 
    uint8_t CruiseInstructions    : 1; 
    uint8_t DPF                 : 1; 

    uint8_t EDC         : 1;
    uint8_t BrakeFault    : 1;
    uint8_t FrontForg   : 1;
    uint8_t HighBeam    : 1;
    uint8_t SmallLight    : 1;
    uint8_t DriverSeatBelt    : 1;
    uint8_t RearForg    : 1;
    uint8_t RightTurn   : 1;

    uint8_t LeftTurn    : 1;
    uint8_t EBDAlarm    : 1;
    uint8_t HandBreak   : 1;
    uint8_t TPMSAlarm   : 1;
    uint8_t Heater    : 1;
    uint8_t CoolantAlarm    : 1;
    uint8_t ChaiLv    : 1;
    uint8_t reserved1   : 1;
  }_3F80;
}_2FDID3F80;

 extern _2FDID3F80 LEDContrl;
 extern uint8_t DiagVSpeedValue[2];
 extern uint8_t DiagESpeedValue[2];
 extern uint8_t DiagBackLight;
 extern uint8_t DiagLCD;
 extern uint8_t DiagBuzzer;

void UDS_Service_2F_Indication(uint32_t A_TA_type, uint16_t A_Length, uint8_t A_Data[]);
void UDS_2FService_DID(void);
void UDS_2FService_DID_3F80(void);
void UDS_2FService_DID_3F81(void);
void UDS_2FService_DID_3F82(void);
void UDS_2FService_DID_3F83(void);
void UDS_2FService_DID_3F84(void);
void UDS_2FService_DID_3F85(void);

#endif