#include "UDS_2EService_Filter.h"
uint8_t GetDIDF199DataType(uint8_t* P);
const uint16_t S2EDLC[] = {17u,     9u,      25u,     3u,      6u,      2u,      42u,     51u,     8u,      4u,      5u,      16u,     8u,      14u,  };
const uint16_t S2EDID[] = {0xF190u, 0xF1B0u, 0xF1B1u, 0xF1B7u, 0xF1B8u, 0xF1BFu, 0xF1C5u, 0xF1C6u, 0xF010u, 0xCF03u, 0x1E00u, 0x1E01u, 0xF18Bu, 0xF18Cu,};


/**
  *2E服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2E服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel() == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *2E服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2E服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC31(void)
{
    uint8_t i;
    uint8_t j;
    uint8_t NRC = positiveResponse;
    uint8_t temp[10];
    uint32_t m32;
    uint16_t m16;
    if(getSessionType() != 0x60)
    {
        for(i = 0u; i < (DIM(S2EDID) - 2); ++i)
        {
            if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID[i])
            {

                NRC = positiveResponse;
                if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x1E00)
                {
                    m16 = DiagMSG.msgData.DidDetail.Data[0];
                    m16 = (m16 << 8) | DiagMSG.msgData.DidDetail.Data[1];
                    if((m16 < 1000) || (m16 > 10000))
                    {
                        NRC = requestOutOfRange;
                    }
                    if(NRC == positiveResponse)
                    {
                        m16 = DiagMSG.msgData.DidDetail.Data[2];
                        m16 = (m16 << 8) | DiagMSG.msgData.DidDetail.Data[3];
                        if((m16 <3000) || (m16 > 20000))
                        {
                            NRC = requestOutOfRange;
                        }
                    }
                    break;
                }
                else
                {
                    break;
                }
                
            }
            else
            {
                NRC = requestOutOfRange;
            }
        }
    }
    else
    {
        for(i = (DIM(S2EDID) - 2); i < DIM(S2EDID); ++i)
        {
            if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID[i])
            {

                NRC = positiveResponse;
                break;
            }
            else
            {
                NRC = requestOutOfRange;
            }
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *2E服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    for(i = 0u; i < DIM(S2EDID); ++i)
    {
        if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2EDID[i])
        {
            if(DiagMSG.msgDLC != S2EDLC[i]+ 2u)
            {
                NRC = incorrectMessageLength;
                UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
            }
            else
            {
                NRC = positiveResponse;
            }
            break;
        }
    }
    return NRC;
}

/**
  *2E服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_2EService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    if(getSpeed() > 5u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else if(getESpeed() > 400u)
    {
        NRC = conditionsNotCorrect;
        UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    
    /*if(NRC == positiveResponse)
    {
      if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x6208u)
      {
        if(Services_Read_ODO_ClearCnt1()>=10000u)
        {
          NRC = conditionsNotCorrect;
          UDS_Service_Response(0x2Eu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
        else
        {
          NRC = positiveResponse;
        }
        
      }
    } */
    return NRC;
}

uint8_t GetDIDF199DataType(uint8_t* P) 
{
    uint8_t i=0u;
    uint8_t temp=0u;
    uint8_t NRC = (uint8_t)P[0u];
    uint8_t dlc = (uint8_t)P[1u];
    uint16_t YEAR;
    uint16_t YEAR1;
    uint16_t YEAR2;
    uint16_t YEAR3;
    uint16_t YEAR4;
    if(dlc>4u)
    {
       dlc=4u;
    }
    if (NRC==0x31u)
    {
       for(i=0u;i<dlc;i++)
       {  
          temp=P[2u+i];
          if(CODING_BCD!=(Check_BCD_Format(temp)))
          {
            break;
          }
          else
          {   
            if (i==2u)
            {
                if(Check_MM_Format(temp)==UDSLib_FALSE)
                {
                   break; 
                }
            }
            if(i==3u)
            {    
                if((P[4]==0x4u)||(P[4]==0x6u)||(P[4]==0x9u)||(P[4]==0x11u)) 
                {
                    if(Check_DD_Format(temp,30u)==UDSLib_FALSE)
                    {
                        break;  
                    }
                }
                else if (P[4]==2u)
                {
                    YEAR1=(P[2] & 0xF0u)>>4u;
                    YEAR2=(P[2] & 0x0Fu)>>0u;
                    YEAR3=(P[3] & 0xF0u)>>4u;
                    YEAR4=(P[3] & 0x0Fu)>>0u;
                    YEAR= ((uint16_t)YEAR1)*1000+
                            (((uint16_t)YEAR2)*100)+
                            (((uint16_t)YEAR3)*10)+
                            ((uint16_t)YEAR4);

                    if(Check_LeapYear_(YEAR))
                    {
                        if(Check_DD_Format(temp,29u)==UDSLib_FALSE)
                        {
                            break;  
                        }
                    }
                    else
                    {
                        if(Check_DD_Format(temp,28u)==UDSLib_FALSE)
                        {
                            break;  
                        }
                    }
                }
                else
                {
                    if(Check_DD_Format(temp,31u)==UDSLib_FALSE)
                    {
                        break;  
                    }
                }    
            }
 
          }   
       }
       if (i==dlc)
       {
           NRC=0x00u;
       }
 
    }

    return NRC;
} 