#include <string.h>
#include "UDS_Common.h"
#include "RTE_Memory.h"
#include "Internal_EEPROM.h"
#include "Analog_Signals.h"
#include "rh850_macros.h"
#include "PowerManag_User.h"
#include "CAN_CFG.h"
uint8_t  SessionType = DefaultSession;

uint16_t S3_ServerCnt = S3_SERVER;
uint8_t  S3_ServerClear = 0u;
uint8_t  S3_ServerTimeOut = 1u;

uint8_t  UDSKL15Status = 0u;
uint8_t  UDSSleepStatus = 0u;

uint16_t UDSTimer10ms = 0u;

uint8_t  S31DID62F3RequestStatus = 0u;
uint8_t  S31DID0203RequestFlag = 0u;

uint8_t  isDTCOpen = 1u;
uint8_t  isReceive = 1u;
uint8_t  isEnable = 0u;
uint16_t enableTimer = 0u;
uint16_t enableMaxTimer = KL15DTCEnableTimer;

DiagMSGUnion DiagMSG;
DiagFlagUnion DiagFlag;
Ser27_FlowCtrlUnion Ser27_FlowCtrl;
Ser27_FlowCtrlCntUnion Ser27_FlowCtrlCnt;
BootToDFlashInfoUnion BootToDFlashInfo;
Ser2EToDFlashInfoUnion Ser2EToDFlashInfo;
EOLToDFlashInfoUnion EOLToDFlashInfo;
DTCToDFlashInfoUnion DTCToDFlashInfo;
ServiceToDflashInfoUnion ServiceToDflashInfo;
void UDS_Para_KL30Init(void)
{
    SessionType = DefaultSession;

    S3_ServerCnt = S3_SERVER;
    S3_ServerClear = 0u;
    S3_ServerTimeOut = 1u;
    UDSKL15Status = 0u;
    UDSSleepStatus = 0u;
    UDSTimer10ms = 0u;
    S31DID62F3RequestStatus = 0u;
    isDTCOpen = 1u;
    isReceive = 1u;
    isEnable = 0u;
    enableTimer = 0u;
    enableMaxTimer = KL15DTCEnableTimer;
}
/**
  *设置会话类型
  *@param status 会话类型
  */
void setSessionType(uint8_t status)
{
    if ((status == DefaultSession) || (status == ProgrammingSession) || (status == ExtendedDiagnosticSession))
    {
        SessionType = status;
    }
    else if(status == 0x60)
    {
        SessionType = 0x60;
    }
    else
    {
        SessionType = DefaultSession;
    }
}

/**
  *获取会话类型
  *@return 当前会话类型
  */
uint8_t getSessionType(void)
{
    return SessionType;
}

/**
  *设置诊断信息
  *@param Identifier 收到的诊断报文ID
  *@param dlc 收到的诊断报文长度
  *@param Data 收到的诊断报文数据
  */
void setDiagMSG(uint32_t Identifier, uint16_t dlc, uint8_t Data[])
{
    uint16_t i;
    DiagMSG.msgID = Identifier;
    DiagMSG.msgDLC = dlc;
    for (i = 0u; i < dlc; ++i)
    {
        DiagMSG.msgData.Data[i] = Data[i];
    }
}

/**
  *清除诊断信息
  */
void clearDiagMSG(void)
{
    uint16_t i;
    DiagMSG.msgID = 0u;
    DiagMSG.msgDLC = 0u;
    for (i = 0u; i < DIM(DiagMSG.msgData.Data); ++i)
    {
        DiagMSG.msgData.Data[i] = 0u;
    }
}

/**
  *获取当前车速
  *@return 返回当前车速
  */
uint16_t getSpeed(void)
{
    uint16_t VSpeed = Common_Get_Act_V_Speed();
    if(VSpeed == 0xFFFFu)
    {  
        VSpeed = 0u;
    }
    if(Get_DIAG_Vehicle_Speedsts() == 3)
    {
        VSpeed = 0;
    }
    return (VSpeed / 10u);
}

/**
  *获取当前转速
  *@return 返回当前转速
  */
uint16_t getESpeed(void)
{
    uint16_t ESpeed = Get_DispEngineSpeed();
    if(Get_DIAG_Engine_Speedsts() == 3)
    {
        ESpeed = 0;
    }
    return ESpeed;
}

/**
  *获取当前30电压
  *@return 返回当前30电压
  */
uint16_t getKL30Voltage(void)
{
    return (ADC_Read_Signal(ADC_CH_KL30_VOLTAGE) + 100);
}

/**
  *获取15电状态
  *@return 15点状态 0为IGN OFF,1为IGN ON
  */
uint8_t getKL15Status(void)
{
    return PoMa_Read_KL15_Line();
}

/**
  *获取当前安全级别
  *@return 返回当前安全级别
  */
uint8_t getSecurityLevel(void)
{
    return Ser27_FlowCtrl.LV1SafetyStatus;
}

/**
  *重置安全等级
  */
void Ser27_ChangeSessionHandle(void)
{
    Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
    Ser27_FlowCtrl.LV1Key[0]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[1]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[2]  = 0x00u;
    Ser27_FlowCtrl.LV1Key[3]  = 0x00u;
    Ser27_FlowCtrl.LV1SafetyStatus = NormalKeyLock;
    Ser27_FlowCtrl.LV1Seed[0] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[1] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[2] = 0x00u;
    Ser27_FlowCtrl.LV1Seed[3] = 0x00u;
}

/**
  *复位函数
  */
void UDS_RESET(void)
{
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, disableRxAndTx);
    UDS_Delay(60000u);
    hardware_reset();
}

/**
  *诊断延时
  *@param count 延时次数
  */
void UDS_Delay(uint16_t count)
{
    uint16_t tmpcnt;
    tmpcnt = count;
    WDT_Clear();
    while (tmpcnt--)
    {
        nop();
    }
    WDT_Clear();
}

/**
  *发送诊断11服务正反馈
  */
void UDS_S11_Sand(uint8_t subid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x02u;
    canMag.Msg[1] = 0x51u;
    canMag.Msg[2] = subid;
    canMag.Msg[3] = FILLER_BYTE;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 12u;
    Can_Write(&canMag);
}

/**
  *诊断11服务正反馈确认
  */
void UDS_S11_Confirm(void)
{
    UDS_RESET();
}

/**
  *发送诊断78负反馈
  */
void UDS_NRC78_Sand(uint8_t sid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x03u;
    canMag.Msg[1] = 0x7Fu;
    canMag.Msg[2] = sid;
    canMag.Msg[3] = 0x78u;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 12u;
    Can_Write(&canMag);
}

/**
  *发送诊断78负反馈
  */
void UDS_14_SendRsp(uint8_t sid)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x01u;
    canMag.Msg[1] = 0x54u;
    canMag.Msg[2] = FILLER_BYTE;
    canMag.Msg[3] = FILLER_BYTE;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 14u;
    Can_Write(&canMag);
}

/**
  *发送负反馈
  */
void UDS_SendNRCRsp(uint8_t sid,uint8_t status)
{
    _CAN_Msg canMag;
    canMag.MsgID = DIAG_ID_Tx;
    canMag.Msg[0] = 0x03u;
    canMag.Msg[1] = 0x7fu;
    canMag.Msg[2] = sid;
    canMag.Msg[3] = status;
    canMag.Msg[4] = FILLER_BYTE;
    canMag.Msg[5] = FILLER_BYTE;
    canMag.Msg[6] = FILLER_BYTE;
    canMag.Msg[7] = FILLER_BYTE;
    canMag.MsgDLC = 8u;
    canMag.MsgPro = 15u;
    Can_Write(&canMag);
}

/**
  *诊断50us任务
  */
void UDS_50us_Service(void)
{
    //if(UDSSleepStatus == 1u)
    {
        ++UDSTimer10ms;
    }
}

/**
  *诊断10ms任务
  */
void UDS_10ms_Service(void)
{
    uint16_t count;
    UDS_KL15_init( );
    if(UDSTimer10ms >= 200u)
    {
        count = UDSTimer10ms / 200u;
        UDSTimer10ms %= 200u;
        enableDTCTimer(count * 10u);
        MsgLostTimer(count * 10u);
        TestDTC(count * 10u);
        S3_Service(count * 10u);
        Ser27_ErrDelayTimerService(count * 10u);
    }
}

/**
  *诊断KL15init
  */
void UDS_KL15_init(void)
{
    uint8_t KL15Status = getKL15Status();
    if(UDSKL15Status == 0u)
    {
        if((KL15Status == 1u))
        {
            UDSKL15Status = 1u;
            UDSSleepStatus = 1u;
            setDTCEnableTimer(KL15DTCEnableTimer);
            S3_ServiceTimeOut();
            DTCAgeing();
        }
    }
    else
    {
        if(KL15Status == 0u)
        {
            UDSKL15Status = 0u;
            setDTCEnableTimer(KL15DTCEnableTimer);
        }
    }
}

void UDS_Slepp(void)
{
    UDSSleepStatus = 0u;
    UDSTimer10ms = 0u;
}

/**
  *报文掉线计时器
  *@param timer 计时器增加的时间，单位：ms
  */
void MsgLostTimer(uint16_t timer)
{
    uint8_t i;
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((isEnable == 1u) && (isReceive == 1u) && (UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if(msgList[i][3u] < 10u * msgList[i][2u])
            {
                msgList[i][3u] += timer;
            }
        }
    }
}

/**
  *收到报文清除计时器
  *@param MsgID 报文ID
  *@param DLC   报文长度
  */
void ReceivedMsg(uint32_t MsgID, uint8_t DLC)
{
    uint8_t i;
    if(isReceive == 1u)
    {
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            if((MsgID == msgList[i][0u]) && (DLC == msgList[i][1u]))
            {
                msgList[i][3] = 0u;
                break;
            }
        }
    }
}

/**
  *S3服务
  */
void S3_Service(uint16_t timer)
{
    if (S3_ServerClear == 1u)
    {
        S3_ServerClear = 0u;
        S3_ServerCnt = 0u;
        S3_ServerTimeOut = 0u;
    }
    else
    {
        if (S3_ServerCnt < S3_SERVER)
        {
            S3_ServerCnt += timer;
        }
        else
        {
            if (S3_ServerTimeOut == 0u)
            {
                S3_ServerTimeOut = 1u;
                S3_ServiceTimeOut();
            }
        }
    }
}

/**
  *S3重置服务
  */
void S3_ServiceClear(void)
{
    S3_ServerClear = 1u;
}

/**
  *S3等待服务
  */
void S3_ServiceWait(void)
{
    S3_ServerClear = 0u;
    S3_ServerCnt = S3_SERVER;
    S3_ServerTimeOut = 1u;
}

/**
  *S3超时服务
  */
void S3_ServiceTimeOut(void)
{
    /*10服务重置*/
    setSessionType(DefaultSession);
    /*27服务重置*/
    Ser27_ChangeSessionHandle();
    /*28服务重置*/
    ControlMessageCommunication(networkManagementMsgAndnormalMsg, enableRxAndTx);
    /*2F服务重置*/
    UDS_10Service_S2FInit();
    /*31服务重置*/
    UDS_10Service_S31Init();
    /*85服务重置*/
    OpenDTCTest();
    /*诊断发送重置*/
    clearDiagMSG();
}

/**
  *27服务10s延时
  */
 uint8_t DelayTimerFlag = 0;
void Ser27_ErrDelayTimerService(uint16_t timer)
{
    if ( ( Ser27_FlowCtrl.LV1DelayCtrl == SER27_ERR_DELAY_TIMER_EN ) )
    {
        if (Ser27_FlowCtrl.LV1DelayTimer < 0xfff0u )
        {
            Ser27_FlowCtrl.LV1DelayTimer += timer;
            if (Ser27_FlowCtrl.LV1DelayTimer >= SER27_ERR_DELAY_TIMEOUT)
            {
                if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
                {
                    Ser27_FlowCtrlCnt.LV1ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                    DelayTimerFlag = 1;
                }
                if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
                {
                    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt  = SER27_MAX_REQ_SEED_NUM - 1u;
                }
                Ser27_FlowCtrl.LV1Ctrl = SER27_CLEAR_REQ_SEEDED;
                Ser27_FlowCtrl.LV1DelayTimer = 0u;
                Ser27_FlowCtrl.LV1DelayCtrl = 0u;
                /*调用向DFlash写入函数。*/
                DFlash_WriteData(WriteSer27Addr, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) , WriteFDL);
            }
        }
    }
}

/**
  *控制报文通信
  *@param Type 控制报文的类型
  *@param Status 控制的标志位
  */
void ControlMessageCommunication(uint8_t Type, uint8_t Status)
{
    if ((uint8_t)(Type & normalMsg) == normalMsg)
    {
        if ((uint8_t)(Status & enableRxAndDisableTx) == enableRxAndDisableTx)
        {
            //CAN_TX_DiagCtrlEnable(&CAN_CH0_CanMsgTxOp,CAN_N_TX_Disable);
            CAN_SET_APP_SEND(1);
            
        }
        else
        {
            CAN_SET_APP_SEND(0);
            //CAN_TX_DiagCtrlEnable(&CAN_CH0_CanMsgTxOp,CAN_N_TX_Enable);
            //CAN_TX_DiagCtrlRelease(&CAN_CH0_CanMsgTxOp);
        }//
        if ((uint8_t)(Status & disableRxAndEnableTx) == disableRxAndEnableTx)
        {
            CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Disable);
            isReceive = 0u;
        }
        else
        {
            isReceive = 1u;
            CAN_RX_SetEnable(&CAN_CH0_CanMsgOp, CAN_N_RX_Enable);
            //CAN_RX_DiagCtrlEnable(&CAN_CH0_CanMsgOp,CAN_N_RX_Enable);
            //CAN_RX_DiagCtrlRelease(&CAN_CH0_CanMsgOp);
        }
    }
    if ((uint8_t)(Type & networkManagementMsg) == networkManagementMsg)
    {
        if ((uint8_t)(Status & enableRxAndDisableTx) == enableRxAndDisableTx)
        {
            CAN_SET_NM_SEND(1);
            //CAN_SET_NM_SEND(1u);
        }
        else
        {
            CAN_SET_NM_SEND(0);
            //CAN_SET_NM_SEND(0u);
        }
        if ((uint8_t)(Status & disableRxAndEnableTx) == disableRxAndEnableTx)
        {
            CAN_SET_NM_REC(1);
            //CAN_SET_NM_REC(1u);
        }
        else
        {
            CAN_SET_NM_REC(0);
            //CAN_SET_NM_REC(0u);
        }
    }
}

/**
  *DTC使能定时
  */
void enableDTCTimer(uint16_t Timer)
{
    uint8_t BUS_OFF_Status = getBusoffStatus();
    if((UDSKL15Status == 1u) && (BUS_OFF_Status == 0u) && (HVoltageStatus == 0u) && (LVoltageStatus == 0u))
    {
        if(isEnable == 0u)
        {
            if(enableTimer >= enableMaxTimer)
            {
                isEnable = 1u;
                enableTimer = 0u;
            }
            else
            {
                enableTimer += Timer;
            }
        }
    }
}

/**
  *DTC是否使能
  *@return DTC使能状态 0为未使能,1为使能
  */
uint8_t isDTCEnable(void)
{
    return isEnable;
}

/**
  *设置DTC使能时间
  */
void setDTCEnableTimer(uint16_t Timer)
{
    uint8_t i;
    if(isEnable == 1u)
    {
        isEnable = 0u;
        enableTimer = 0u;
        enableMaxTimer = Timer;
        for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
        {
            msgList[i][3] = 0u;
        }
    }
    else
    {
        if(enableMaxTimer == Timer)
        {
            enableTimer = 0u;
        }
        else
        {
            if(enableMaxTimer < enableTimer + Timer)
            {
                enableMaxTimer = enableTimer + Timer;
            }
        }
    }
}

/**
  *开启DTC检测
  */
void OpenDTCTest(void)
{
    isDTCOpen = 1u;
}

/**
  *关闭DTC检测
  */
void CloseDTCTest(void)
{
    isDTCOpen = 0u;
}

/**
  *DTC是否开启
  *@return DTC状态 0关闭,1开启
  */
uint8_t DTCTestIsOpen(void)
{
    return isDTCOpen;
}

/**
  *DTC老化
  */
void DTCAgeing(void)
{
    uint8_t i;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus |= (DTCNoTestThisCycle);
        if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCErrorThisCycle) != DTCErrorThisCycle)
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCPending);
            DTCToDFlashInfo.DTC[i].DTCPendingCount = 0u;
            if ((uint8_t)(DTCToDFlashInfo.DTC[i].DTCStatus & DTCConfirmed) == DTCConfirmed)
            {
                DTCToDFlashInfo.DTC[i].DTCAgeing++;
                if (DTCToDFlashInfo.DTC[i].DTCAgeing >= AgeingCount)
                {
                    DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCConfirmed);
                }
            }
        }
        else
        {
            DTCToDFlashInfo.DTC[i].DTCStatus &= (~DTCErrorThisCycle);
        }
        DTCToDFlashInfo.DTC[i].DTCStatus &= DTCNoError;
    }
}

/**
  *读取所有的诊断信息
  */   
void FDL_Init(void);
void ReadAllDFlashData(void)
{
    FDL_Init();
    ReadDFlashData_fdl(WriteProgramValidFlagAddr, (uint32_t *)&DiagFlag.Flag         , sizeof(DiagFlag)          , AllFlagInit);
    ReadDFlashData_fdl(WriteSer27Addr, (uint32_t *)&Ser27_FlowCtrlCnt.Flag, sizeof(Ser27_FlowCtrlCnt) , Ser27ToDFlashInfoInit);
    ReadDFlashData_fdl(WriteBootDataAddr, (uint32_t *)&BootToDFlashInfo.Flag , sizeof(BootToDFlashInfo)  , BootToDFlashInfoInit);
    ReadDFlashData_fdl(WriteSer2EDataAddr, (uint32_t *)&Ser2EToDFlashInfo.Flag, sizeof(Ser2EToDFlashInfo) , Ser2EToDFlashInfoInit);
    ReadDFlashData_fdl(WriteEOLDataAddr, (uint32_t *)&EOLToDFlashInfo.Flag, sizeof(EOLToDFlashInfo) , SerEOLToDFlashInfoInit);
    ReadDFlashData_eel(WriteDTCAddr, (uint32_t *)&DTCToDFlashInfo.Flag  , sizeof(DTCToDFlashInfo)   , DTCToDFlashInfoInit);
    ReadDFlashData_fdl(WriteODOClearAddr, (uint32_t *)&ServiceToDflashInfo.Flag  , sizeof(ServiceToDflashInfo)   , ODOClearInit);

    //if ( (memcmp(BootToDFlashInfo.DID_F187,DID_22_F187,sizeof(BootToDFlashInfo.DID_F187))!=0) ||\
    //     (memcmp(BootToDFlashInfo.DID_F18A,DID_22_F18A,sizeof(BootToDFlashInfo.DID_F18A))!=0) ||\
    //     (memcmp(BootToDFlashInfo.DID_F191,DID_22_F191,sizeof(BootToDFlashInfo.DID_F191))!=0) ||\
    //     (memcmp(BootToDFlashInfo.DID_F189,DID_22_F189,sizeof(BootToDFlashInfo.DID_F189))!=0) ||\
    //     (memcmp(BootToDFlashInfo.DID_F193,DID_22_F193,sizeof(BootToDFlashInfo.DID_F193))!=0) ||\
    //     (memcmp(BootToDFlashInfo.DID_F195,DID_22_F195,sizeof(BootToDFlashInfo.DID_F195))!=0) 
    //   )
    //{
    //    memcpy(BootToDFlashInfo.DID_F187,DID_22_F187,sizeof(BootToDFlashInfo.DID_F187));
    //    memcpy(BootToDFlashInfo.DID_F18A,DID_22_F18A,sizeof(BootToDFlashInfo.DID_F18A));
    //    memcpy(BootToDFlashInfo.DID_F191,DID_22_F191,sizeof(BootToDFlashInfo.DID_F191));
    //    memcpy(BootToDFlashInfo.DID_F189,DID_22_F189,sizeof(BootToDFlashInfo.DID_F189));
    //    memcpy(BootToDFlashInfo.DID_F193,DID_22_F193,sizeof(BootToDFlashInfo.DID_F193));
    //    memcpy(BootToDFlashInfo.DID_F195,DID_22_F195,sizeof(BootToDFlashInfo.DID_F195));
    //    (void)DFlash_WriteData(WriteBootDataAddr , (uint32_t *)&BootToDFlashInfo.Flag, sizeof(BootToDFlashInfo) , WriteFDL);
    //}
    



    if (Ser27_FlowCtrlCnt.LV1ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM )
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    if (Ser27_FlowCtrlCnt.LV11_ReqSeedCnt >= SER27_MAX_REQ_SEED_NUM)
    {
        Ser27_FlowCtrl.LV1DelayCtrl = SER27_ERR_DELAY_TIMER_EN;
    }
    EOL_SetF010(EOLToDFlashInfo.DID_F010, 8u);

    
    DTCConfigurationInit();
}
/*eel Read D-flash*/
uint8_t ReadDFlashData_eel(uint16_t u16BlockNum, uint32_t u32Data[], uint16_t u16Len, InitFunction initFunction)
{
    uint8_t  enResult = 1u;
    enResult = DFlash_ReadData(u16BlockNum, (uint8_t *)u32Data, u16Len, WriteEEL);
    if(enResult == 0u)
    {
        //u32Data = (uint32_t *)u8Data;
        if (*u32Data != 0x7AA7A55Au)
        {
            initFunction();
            enResult = DFlash_WriteData(u16BlockNum, u32Data, u16Len, WriteEEL);
            
        }
    }
    else
    {
        initFunction();
        enResult = DFlash_WriteData(u16BlockNum, u32Data, u16Len, WriteEEL);
    }
    return enResult;
}

/*eel Write D-flash*/
uint8_t WriteDFlashData_eel(uint16_t u16BlockNum, uint32_t u32Data[], uint16_t u16Len, uint8_t isWait)
{
    uint8_t  enResult = 1;
    (void)isWait;
    enResult = DFlash_WriteData(u16BlockNum, (uint8_t *)u32Data, u16Len, WriteEEL);
    return enResult;
}

/*fdl Read D-flash*/

uint8_t ReadDFlashData_fdl(uint16_t u16BlockNum, uint32_t u32Data[], uint16_t u16Len, InitFunction initFunction)
{
    uint8_t  enResult = 0u;
    enResult = DFlash_ReadData(u16BlockNum, (uint8_t *)u32Data, u16Len, WriteFDL);
    if(enResult == 0u)
    {
        //u32Data = (uint32_t *)u8Data;
        if (*u32Data != 0x7AA7A55Au)
        {
            initFunction();
            enResult = DFlash_WriteData(u16BlockNum, u32Data, u16Len, WriteFDL);
            
        }
    }
    else
    {
        initFunction();
        enResult = DFlash_WriteData(u16BlockNum, u32Data, u16Len, WriteFDL);
    }
    return enResult;
}

/*fdl Write D-flash*/
uint8_t WriteDFlashData_fdl(uint16_t u16BlockNum, uint32_t u32Data[], uint16_t u16Len, uint8_t isWait)
{
    uint8_t  enResult = 0;
    (void)isWait;
    enResult = DFlash_WriteData(u16BlockNum, (uint8_t *)u32Data, u16Len, WriteFDL);
    return enResult;
}

/**
  *所有标志位初始化
  */
void AllFlagInit(void)
{
    DiagFlag.Flag = 0x7AA7A55Au;
    DiagFlag.JumpToBootFlag = 0x00000000u;
    DiagFlag.AppValidFlag = 0x00000000u;
    DiagFlag.S11Flag = 0x00000000u;
}

/**
  *27信息初始化
  */
void Ser27ToDFlashInfoInit(void)
{
    Ser27_FlowCtrlCnt.Flag = 0x7AA7A55Au;
    Ser27_FlowCtrlCnt.LV11_InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV11_ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.LV1InvaidKyeCnt = 0u;
    Ser27_FlowCtrlCnt.LV1ReqSeedCnt = 0u;
    Ser27_FlowCtrlCnt.RandNum = 0u;
}

/**
  *boot信息初始化
  */
void BootToDFlashInfoInit(void)
{
    uint8_t i;
    BootToDFlashInfo.Flag = 0x7AA7A55Au;
    for(i = 0; i < 30;i++)
    {
        BootToDFlashInfo.DID_F15B[i] = 0xFF;
    }
    BootToDFlashInfo.DID_F15B[4] = 0x00;
    BootToDFlashInfo.DID_F15B[5] = 0x00;
    BootToDFlashInfo.DID_F15B[6] = 0x00;
    BootToDFlashInfo.DID_F15B[7] = 0x00;
    BootToDFlashInfo.DID_F15B[8] = 0x00;
    BootToDFlashInfo.DID_F15B[9] = 0x00;
    ///*软件成功刷写次数*/
    //BootToDFlashInfo.DID_0200 = 0u;
    ///*软件尝试刷写次数*/
    //BootToDFlashInfo.DID_0201 = 0u;
    ///*boot版本*/
    //memcpy(BootToDFlashInfo.DID_F180, DID_22_F180, sizeof(BootToDFlashInfo.DID_F180));
    ///*ECU零件号*/
    //memcpy(BootToDFlashInfo.DID_F187, DID_22_F187, sizeof(BootToDFlashInfo.DID_F187));
    ///*ECU零件号*/
    //memcpy(BootToDFlashInfo.DID_F18A, DID_22_F18A, sizeof(BootToDFlashInfo.DID_F18A));
    ///*ECU制造日期*/
    //memcpy(BootToDFlashInfo.DID_F18B, DID_22_F18B, sizeof(BootToDFlashInfo.DID_F18B));
    ///*ECU序列号 */
    //memcpy(BootToDFlashInfo.DID_F18C, DID_22_F18C, sizeof(BootToDFlashInfo.DID_F18C));
    ///*主机厂定义的软件版本编号*/
    //memcpy(BootToDFlashInfo.DID_F189, DID_22_F189, sizeof(BootToDFlashInfo.DID_F189));
    ///*主机厂定义的硬件版本编号*/
    //memcpy(BootToDFlashInfo.DID_F191, DID_22_F191, sizeof(BootToDFlashInfo.DID_F191));
    ///*供应商定义的硬件版本编号*/
    //memcpy(BootToDFlashInfo.DID_F193, DID_22_F193, sizeof(BootToDFlashInfo.DID_F193));
    ///*供应商定义的软件版本编号*/
    //memcpy(BootToDFlashInfo.DID_F195, DID_22_F195, sizeof(BootToDFlashInfo.DID_F195));
    ///*测试设备序列号*/
    //memcpy(BootToDFlashInfo.DID_F198, DID_22_F198, sizeof(BootToDFlashInfo.DID_F198));
    ///*软件刷写日期*/
    //memcpy(BootToDFlashInfo.DID_F199, DID_22_F199, sizeof(BootToDFlashInfo.DID_F199));
}

/**
  *2E信息初始化
  */
 /*ECU Manufacture Date（电控单元制造日期）*/
const uint8_t DID_22_F18B[8]    = {0x02, 0x00, 0x02, 0x03, 0x00, 0x09, 0x01, 0x01};
/*Supplier ECU Serial Number（供应商电控单元序列号） */
const uint8_t DID_22_F18C[14]   = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

void Ser2EToDFlashInfoInit(void)
{
    uint8_t i;
 
    Ser2EToDFlashInfo.Flag = 0x7AA7A55Au;
    Ser2EToDFlashInfo.WriteODOCnt = 0;
    /*ECU Manufacture Date（电控单元制造日期）*/
    memcpy(Ser2EToDFlashInfo.DID_F18B, DID_22_F18B, sizeof(Ser2EToDFlashInfo.DID_F18B));
    /*Supplier ECU Serial Number（供应商电控单元序列号） */
    memcpy(Ser2EToDFlashInfo.DID_F18C, DID_22_F18C, sizeof(Ser2EToDFlashInfo.DID_F18C));
    Ser2EToDFlashInfo.DID_1E00[0] = 0x13;
    Ser2EToDFlashInfo.DID_1E00[1] = 0x88;
    Ser2EToDFlashInfo.DID_1E00[2] = 0x27;
    Ser2EToDFlashInfo.DID_1E00[3] = 0x10;
    Ser2EToDFlashInfo.DID_1E00[4] = 0x00;
 
}

void SerEOLToDFlashInfoInit(void)
{
    uint8_t i;

    EOLToDFlashInfo.Flag = 0x7AA7A55Au;

    EOL_InitVal();

    for (i = 0u; i < 8u; ++i)
    {
        EOLToDFlashInfo.DID_F010[i] = EOL_F010.F010_Byte[i];
    }
}

/**
  *DTC信息初始化
  */
void DTCToDFlashInfoInit(void)
{
    uint8_t i;
    DTCToDFlashInfo.Flag = 0x7AA7A55Au;
    for (i = 0u; i < sizeof(DTCToDFlashInfo.DTC) / sizeof(DTCUnion); ++i)
    {
        DTCToDFlashInfo.DTC[i].DTCStatus = DTCNoTestLastClear | DTCNoTestThisCycle;
        DTCToDFlashInfo.DTC[i].DTCAgeing = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCCount = 0x00u;
        DTCToDFlashInfo.DTC[i].DTCPendingCount = 0x00u;

        DTCToDFlashInfo.DTC[i].Snapshot.EngineSpeed_H = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.EngineSpeed_L = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.VehicleSpeed_H = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.VehicleSpeed_L = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.BatteryVoltage_H = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.BatteryVoltage_L = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstOccurOdometer_H = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstOccurOdometer_H_M = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstOccurOdometer_L_M = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.FirstOccurOdometer_L = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.Odometer_H = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.Odometer_H_M = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.Odometer_L_M = 0;
        DTCToDFlashInfo.DTC[i].Snapshot.Odometer_L = 0;

        DTCToDFlashInfo.DTC[i].Extended.F_OccurenceCounter = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Second = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Minute = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Hour = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Day = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Month = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Year = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Distance_H = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Distance_H_M = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Distance_L_M = 0;
        DTCToDFlashInfo.DTC[i].Extended.F_Distance_L = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Second = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Minute = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Hour = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Day = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Month = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Year = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Distance_H = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Distance_H_M = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Distance_L_M = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_Distance_L = 0;
        DTCToDFlashInfo.DTC[i].Extended.L_SPNType = 0;


    }
    for(i = 0u; i < (sizeof(msgList) / sizeof(msgList[0u])); ++i)
    {
        msgList[i][3] = 0u;
    }
    for(i = 0u; i < (sizeof(DTCTimerList) / sizeof(DTCTimerList[0u])); ++i)
    {
        DTCTimerList[i] = 0u;
    }
}

/**
  *DTC信息配置初始化
  */
void DTCConfigurationInit(void)
{
    /*EOLToDFlashInfo.Flag = 0x7AA7A55Au;
    EOLToDFlashInfo.DID_F010[0] = 0;
    EOLToDFlashInfo.DID_F010[1] = 0;
    EOLToDFlashInfo.DID_F010[2] = 0;
    EOLToDFlashInfo.DID_F010[3] = 0;
    EOLToDFlashInfo.DID_F010[4] = 0;
    EOLToDFlashInfo.DID_F010[5] = 0;
    EOLToDFlashInfo.DID_F010[6] = 0;
    EOLToDFlashInfo.DID_F010[7] = 0;*/
}


void ODOClearInit(void)
{
    ServiceToDflashInfo.Flag=0x7AA7A55Au;
    ServiceToDflashInfo.AddCount=0u;
    ServiceToDflashInfo.AddODO=0u;
}
