
#ifndef __LCBI_NON_TFT_H
#define __LCBI_NON_TFT_H

#define LCD_CMD_DISPOFF  0x11
#define LCD_CMD_DISPON   0x12
#define LCD_CMD_SLPOUT   0x13
#define LCD_CMD_SLPIN    0x14
#define LCD_CMD_DISINOFF 0x15
#define LCD_CMD_DISINV   0x16
#define LCD_CMD_MADCTL   0x21
#define LCD_CMD_PASET    0x22
#define LCD_CMD_CASET    0x23
#define LCD_CMD_BPPSEL   0x25
#define LCD_CMD_TE       0x35
#define LCD_CMD_RDRAM    0x39
#define LCD_CMD_WRRAM    0x3A
#define LCD_CMD_SERESET  0x5E
#define LCD_CMD_DISAR    0x91
#define LCD_CMD_FEQ      0x92
#define LCD_CMD_RELOAD   0xCD

extern uint32_t        *LCDPanelGraphicRAM;
extern uint8_t          updateVramIndex;
extern uint16_t         LCD_ActiveCheckTime;

void LCD_Panel_Start_Up(void);
void LCD_Panel_Shut_Down(void);

void        LCD_Panel_Update_Req(uint16_t starPage, uint16_t endPage);
void        LCD_ClearFullScreen(uint8_t FullPixel);
extern void nonTFT_WaitUS(uint32_t waitTime);

#endif /* __LCBI_NON_TFT_H */
