#include "UDS_2FService_Filter.h"

const uint8_t  S2FDLC[] = {7,       5,       5,       4,       4,       4,     };
const uint16_t S2FDID[] = {0x3F80u, 0x3F81u, 0x3F82u, 0x3F83u, 0x3F84u, 0x3F85u};

/**
  *2F服务是否支持功能寻址
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC11(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgID == DIAG_ID_Rx_FUN)
    {
        NRC = serviceNotSupported;
    }
    return NRC;
}

/**
  *2F服务会话是否支持验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC7F(void)
{
    uint8_t NRC = positiveResponse;
    if(getSessionType() == DefaultSession)
    {
        NRC = serviceNotSupportedInActiveSession;
        if(DiagMSG.msgID == DIAG_ID_Rx_PHY)
        {
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F服务解锁等级验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC33(void)
{
    uint8_t NRC = positiveResponse;
    if(getSecurityLevel() == NormalKeyUnlock)
    {
        NRC = positiveResponse;
    }
    else
    {
        NRC = securityAccessDenied;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }  
    return NRC;
}

/**
  *2F服务最小长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC13_MinLengthCheck(void)
{
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgDLC < 3u)
    {
        NRC = incorrectMessageLength;
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    else
    {
        NRC = positiveResponse;
    }
    return NRC;
}

/**
  *2F服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC31(void)
{
    uint8_t NRC = requestOutOfRange;
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F80u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F81u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F82u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F83u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F84u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F85u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *2F服务超出请求范围验证
  *功能寻址下屏蔽该负反馈
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC31_Total(void)
{
    uint8_t NRC = requestOutOfRange;
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F80u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F81u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F82u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            NRC = positiveResponse;
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F83u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if(DiagMSG.msgData.DidDetail.Data[1] <= 0x08u)
            {
                NRC = positiveResponse;
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F84u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if((DiagMSG.msgData.DidDetail.Data[1] <= 0x04u) && (DiagMSG.msgData.DidDetail.Data[1] > 0u))
            {
                NRC = positiveResponse;
            }
        }
    }
    if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == 0x3F85u)
    {
        if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
        {
            NRC = positiveResponse;
        }
        if(DiagMSG.msgData.DidDetail.Data[0] == 3u)
        {
            if(DiagMSG.msgData.DidDetail.Data[1] <= 0x0Bu)
            {
                NRC = positiveResponse;
            }
        }
    }
    if((NRC == requestOutOfRange) && (DiagMSG.msgID == DIAG_ID_Rx_PHY))
    {
        UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
    }
    return NRC;
}

/**
  *2F服务总长度长度验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC13_TotalLengthCheck(void)
{
    uint8_t i;
    uint8_t NRC = positiveResponse;
    if(DiagMSG.msgData.DidDetail.Data[0] == 0u)
    {
        if(DiagMSG.msgDLC != 3u)
        {
            NRC = incorrectMessageLength;
            UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
        }
    }
    else
    {
        for(i = 0u; i < DIM(S2FDID); ++i)
        {
            if(getDID(DiagMSG.msgData.DidDetail.DID_H, DiagMSG.msgData.DidDetail.DID_L) == S2FDID[i])
            {
                if(DiagMSG.msgDLC != S2FDLC[i])
                {
                    NRC = incorrectMessageLength;
                    UDS_Service_Response(0x2Fu, NEGATIVE_RSP, DIAG_ID_Tx, 1u, (uint8_t*)&NRC);
                }
                else
                {
                    NRC = positiveResponse;
                }
                break;
            }
        }
    }
    return NRC;
}

/**
  *2F服务条件验证
  *@return 负反馈编号
  */
uint8_t UDS_2FService_NRC22(void)
{
    uint8_t NRC = positiveResponse;
    return NRC;
}
