#include "RTE_Memory.h"
#include "Internal_EEPROM.h"
#include "r_fdl_types.h"
extern r_fdl_status_t FDL_ReadDataBlock(uint32_t id,uint32_t* data, uint16_t len);
extern r_fdl_status_t FDL_WriteDataBlock(uint32_t id,uint32_t* data, uint16_t len);

uint8_t DFlash_ReadData(uint32_t Adrr, uint8_t *Data,uint16_t len, uint32_t mode)
{
    
    uint8_t enResult = 0u;
    if(mode== WriteEEL)
    {
       enResult = (uint8_t)Internal_EEL_Read(Adrr, Data, len); 
    }
    else 
    {
        if(WriteFDL)
        {
            enResult = (uint8_t)FDL_ReadDataBlock(Adrr, Data, len/4);
        }
    }

    return enResult;
}   

uint8_t DFlash_WriteData(uint32_t Adrr, uint8_t *Data,uint16_t len, uint32_t mode)
{
    uint8_t enResult = 1u;
    if(mode== WriteEEL)
    {
        enResult = Internal_EEL_Write(Adrr, Data, len);
    }
    else
    {
        if( mode== WriteFDL)
        {
            enResult = FDL_WriteDataBlock(Adrr, Data, len/4);
        }
    }
    
    return enResult;
}
