#ifndef LCD_FONT_H__
#define LCD_FONT_H__


#include "TYW_stdint.h"
#include "PIC_Comm.h"



#define FONT_START_ADDR          FONT_14_26new_START_ADDR
#define FONT_MAX_OFFSET_ADDR     FONE_14_26new_LEN

#define  OFFSET_ADDRESS                     0x10000000
#define  FONT_FLASH_START_ADDR             (FONT_START_ADDR  + OFFSET_ADDRESS)        
#define  FONT_FLASH_MAX_OFFSET_ADDR        (FONT_MAX_OFFSET_ADDR)//����
#define  FONT_HIGH_PIX_COUNT               30
#define  MAXFONTRANGE                      2548
#define  NAVI_FONT_MAX_CHAR 50
typedef struct
{
    uint8_t    FontType;
    uint8_t    Reserved1;
    uint8_t    Encoding;
    uint8_t    DataLength;
    uint16_t   FontHeight;
    uint16_t   BaseLine;
    uint16_t   Reserved2;
    uint16_t   NumOfCharRanges;
} BFC_BIN_FONT;

typedef struct 
{
    uint16_t		FirstChar;     /* index of first character */
    uint16_t		LastChar;      /* index of last charcter */
} BFC_BIN_RANGE;

typedef struct 
{
    uint16_t		Width;         /* character width in pixels */
    uint16_t		DataSize;      /* # bytes/words/dwords of pixel data */	
    uint32_t		OffData;       /* Offset of pixel data */
}       BFC_BIN_FORMAT;

typedef struct 
{
    uint16_t		Width;
    uint16_t		High;
    uint32_t		Addr;
    uint8_t	        Result;         
} BFC_BIN_RESULT;

extern       uint8_t          FONT_Init;
extern       BFC_BIN_FONT     g_BFC_BIN_FONT;
extern       BFC_BIN_RANGE    g_FONT_RANGE[MAXFONTRANGE];
extern       uint16_t         g_FONT_NUM[MAXFONTRANGE];
extern       uint8_t         FONT_DISP[282];// FONT_DISP[384];


extern void Gui_LoadFontInfo(void);
extern BFC_BIN_RESULT Gui_GetFontInfo(uint16_t unicodeID);
extern void Gui_GetFontDisp(void);
extern uint8_t Gui_GetFontUnicodeDisp(uint16_t unicode,int16_t x_point,int16_t y_point, int16_t offset_x, int16_t offset_y);

#endif

