#ifndef BUZZER_PLAY_H__
#define BUZZER_PLAY_H__
//#define BUZZER_PLATFORM_16BIT
#ifdef BUZZER_PLATFORM_16BIT
typedef unsigned char Buzzer_uint8_t;
typedef unsigned int Buzzer_uint16_t;
typedef unsigned long Buzzer_uint32_t;
#else
typedef unsigned char Buzzer_uint8_t;
typedef unsigned short Buzzer_uint16_t;
typedef unsigned int Buzzer_uint32_t;
typedef unsigned long long Buzzer_uint64_t;
#endif
/*************************************************************************************/
/*当前文件版本号*/
#define BUZZER_VERSION_NUM 0X20U
/*操作函数返回状态*/
typedef enum
{
	BUZZER_OPERATE_SUCCESS = 0UL, /*函数操作成功*/
	BUZZER_OPERATE_FAIL,		  /*函数操作失败*/
} Buzzer_Operate_Type_en_t;
/*正极控制函数  1：打开  0：关闭*/
typedef Buzzer_Operate_Type_en_t (*Buzzer_Positive_Handle)(Buzzer_uint8_t u8BuzzerOnOff);
/*负极设置函数  u16BuzzerFre ：频率 HZ  。 u16BuzzerDuty ：占空比  千分之一精度*/
typedef Buzzer_Operate_Type_en_t (*Buzzer_Negative_Set)(Buzzer_uint16_t u16BuzzerFre, Buzzer_uint16_t u16BuzzerDuty);
typedef struct
{
	Buzzer_Positive_Handle pfnBuzzerPositiveHandle;
	Buzzer_Negative_Set pfnBuzzerNegativeSet;
} Buzzer_Init_st_t;
typedef struct
{
	Buzzer_uint16_t u16BuzzerFrequency;	 /*频率  HZ*/
	Buzzer_uint16_t u16BuzzerDuty;		 /*占空比 千分之一精度*/
	Buzzer_uint16_t u16BuzzerChargeTime; /*充电时间 ms */
	Buzzer_uint16_t u16BuzzerPlayONTime; /*正常播放时间 ms 需要一直播放时填 0xFFFFU */
	Buzzer_uint16_t u16BuzzerFadeTime;	 /*淡出时间  ms */
} Buzzer_Attribute_st_t;
/*************************************************************************************/
/*KL30和每次唤醒时都调用一次*/
extern void Buzzer_Play_Init(Buzzer_Init_st_t *pstBuzzerInit);
/*声音播放计时函数 , 几毫秒调用一次就传入多少*/
extern void Buzzer_Play_Time_Count(Buzzer_uint8_t u8TimeBase);
/*获取当前播放状态函数  0：空闲    非0 ：忙*/
extern Buzzer_uint8_t Buzzer_Get_Status(void);
/*开始播放函数*/
extern Buzzer_Operate_Type_en_t Buzzer_Start_Play(const Buzzer_Attribute_st_t *pstBuzzerAttribute);
/*停止播放函数*/
extern Buzzer_Operate_Type_en_t Buzzer_Stop_Play(void);
/*实时调用*/
extern void Buzzer_Play_Service(void);
/*确保空闲状态时调用，休眠初始化*/
extern Buzzer_Operate_Type_en_t Buzzer_Play_Sleep_Init(void);
/*读取版本号*/
extern Buzzer_uint8_t Buzzer_Play_Version_Read(void);
/*************************************************************************************/
#endif