#ifndef	_FUELCONFIG_H                            	
#define _FUELCONFIG_H	
#include "g_includes.h"




#define FUEL_R_MIN_VAL	20	//10 X ohm
#define FUEL_R_MAX_VAL	3500    //10 X ohm

#define DISPLAY_BOUNDARY_FIRST 		3000
#define DISPLAY_BOUNDARY_SECOND		2690
#define DISPLAY_BOUNDARY_THIRD		1979
#define DISPLAY_BOUNDARY_FOURTH		1491
#define DISPLAY_BOUNDARY_FIFTH		1136
#define DISPLAY_BOUNDARY_SIXTH		865
#define DISPLAY_BOUNDARY_SEVENTH	652
#define DISPLAY_BOUNDARY_EIGHTH		480
#define DISPLAY_BOUNDARY_NINTH	        345
#define DISPLAY_BOUNDARY_TENTH		215
#define DISPLAY_BOUNDARY_ELEVENTH	150

#define BOUNDARY_FUEL_FIRST 		3000
#define BOUNDARY_FUEL_SECOND		4800
#define BOUNDARY_FUEL_THIRD		10200
#define BOUNDARY_FUEL_FOURTH		15600
#define BOUNDARY_FUEL_FIFTH		21000
#define BOUNDARY_FUEL_SIXTH	        26400
#define BOUNDARY_FUEL_SEVENTH		31800
#define BOUNDARY_FUEL_EIGHTH		37200
#define BOUNDARY_FUEL_NINTH	    	42600
#define BOUNDARY_FUEL_TENTH		48000
#define BOUNDARY_FUEL_ELEVENTH		50400


//Fuel Config
typedef struct _FuelStruct {
    uint16_t FuelShortCircuitR;
    uint16_t FuelOpenCircuitR;
    uint16_t LowFuelWarningResistance;
    uint16_t LowFuelWarningReleaseResistance;
    uint32_t LowFuelWarningFuelCapacity; 
    uint16_t RefuleDteFuelChangeThreshold;      //ml
    uint32_t FullFuelStopCapacity;      //S/F
    uint32_t EmptyFuelStopCapacity;     //S/E
    uint16_t DisplayZoneBoundary[11];
    uint32_t FuelCapacityBoundary[11];
}FuelStruct;

extern void InitFuelParamter(FuelStruct *para);
extern uint8_t *GetFuelSaveData(uint16_t *len);
extern void SetFuelSaveData(uint8_t *data, uint16_t len);

extern void SaveSampleVal(uint16_t FuelResistance); //unit:ohm,accuracy:0.1
extern void FuelFSM(uint16_t FuelResistance);

extern void SetFuelSensorRecoverGroupCnt(uint16_t n);       //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)
extern void SetFuelSensorOpenCircuitGroupCnt(uint16_t n);   //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600) 
extern void SetFuelSensorShortCircuitGroupCnt(uint16_t n);  //1:500ms,2:1000ms,3:1500ms.......,range:5s(10)-30min(3600)

extern void SetRefuleDteFuelChangeThreshold(uint16_t ml);
extern uint32_t ResistanceToCapacity(uint16_t Resistance);
extern uint32_t StepToCapacity(uint8_t Step);
extern void SetPowerSt(uint8_t n);
extern void SetSpeed(uint16_t n);
extern void SetRefuelThreshold(uint32_t data);	/* 2000 ~ 50000:2L ~ 50L, default:6L */
extern uint8_t GetFuelSeg(void); //����
extern uint8_t GetFuelStep(void); //ָ��
extern uint8_t GetFuelStepPointer(void);
extern uint32_t GetFuelCapacityVal(void);
extern uint8_t GetFuelLFW(void);
extern uint16_t GetRefuelVrefResistance(void);

extern uint8_t GetFuelDestStep(void);
extern uint8_t GetOutputFuelStep(void);

extern void SetFuelInit(void);
extern void ExecFuel(void);


enum {
	FuelSensorNormal,
	FuelSensorShortCircuit,
	FuelSensorOpenCircuit,
	FuelSensorPreFault,
};
extern uint8_t GetFuelSensorState(void); 

enum {
    FUEL_ST_BATTERY_RESET,
    FUEL_ST_REFUEL,     
    FUEL_ST_VEHICLE_RUN,	
}; 
extern uint8_t GetFuelFSM_St(void);
extern uint16_t GetFuelResistance(void);

// AFC & DrivingRange
typedef struct _AFC_INIT {
	uint8_t CalcAFCMaxNum;	//max 100km,default 50
	uint16_t AFCMin;	//unit:L,accuracy:0.1
	uint16_t AFCMax;	//unit:L,accuracy:0.1
	uint16_t AFCPreinstall;	//unit:L,accuracy:0.1
	uint32_t CurODO;		// unit:m,accuracy:1
	uint32_t MaxDRMileage;	//unit:km,accuracy:0.01
}AFC_INIT;
extern void InitAFC(AFC_INIT *data);
extern uint8_t *GetDrivingRangeSaveData(uint16_t *len);
extern void SetDrivingRangeSaveData(uint8_t *data, uint16_t len);
extern void ResetAFC(AFC_INIT *data);

typedef struct _AFC_PARA {
	uint32_t CurODO;		// unit:m,accuracy:1
	uint16_t FuleConsume;	// unit:ul,accuracy:1
	uint16_t RPM;			// unit:RPM,accuracy:1
	uint16_t Speed;		// unit:km/h,accuracy:0.1
}AFC_PARA;
extern void SetAFCPara(AFC_PARA *data);

extern void AFCTimerCall(void); //must per 10ms interrupt
extern uint16_t GetDRMileage(void);  //unit:km,accuracy:1
extern uint16_t GetDR_Ori(void);
extern uint16_t GetCurAFC(void); //unit:L,accuracy:0.1 
extern uint16_t GetAFCSumH(void);
extern uint16_t GetAFCSumL(void); 

extern uint16_t GetRefuelResistance(void);


extern void DisplayLongAFC_InitFuelconsume(uint16_t DataH, uint16_t DataL);
extern void DisplayLongAFC_InitODO(uint16_t DataH, uint16_t DataL);
extern void CalcDisplayLongAFC(void);
extern uint16_t GetDisplayLongAFC(void);

extern void DisplayLongAFC_InitFuelconsume_1(uint16_t DataH, uint16_t DataL);
extern void DisplayLongAFC_InitODO_1(uint16_t DataH, uint16_t DataL);
extern void CalcDisplayLongAFC_1(void);
extern uint16_t GetDisplayLongAFC_1(void);

#if 1
void FuelSleep(void);
void FuelWake(void);
void GET_Data_For_YB(void);
void FuelAFCTimeCall(void);
void Fuel_RangeDis(void);
uint8_t GetFuelCapacity_Val(void);
void Data_Fuel_Display(void);
uint8_t Get_Fuel_curPosition(void);
void Data_Fuel_Display_Init(void);
uint8_t Get_Fuel_Valid(void);
void ExecFuel_Init(void);
uint8_t GET_Fuel_Sensor_Resistance_High(void);
uint8_t GET_Fuel_Sensor_Resistance_Low(void);
//void Data_InsFuel_KM_ADD(INT16U Inc);
typedef struct
{
    uint32_t FuelMaxResistance;
    uint32_t FuelMinResistance;
    uint32_t MaxFuelMileage;
    uint32_t MinFuelMileage;
    uint32_t Capacity_Val;
}_BackFuelData;
  
typedef struct
{
    uint8_t Icon;

    uint16_t FastModeCnt;
    Data_Renew_Mode_Enum Mode;
    uint8_t DampT;
    uint8_t DampTCnt;
    uint8_t destPosition;
    uint8_t curPosition;

}_MinFuelDis;
extern _MinFuelDis MinFuelMeter;

typedef struct           
{
    uint8_t Sensor_State;
    uint16_t Res_Pre_Get;
    uint16_t Step_Get_Value;
    uint16_t Step_Get_Valid;
    uint16_t Capacity_PerCent_Export;
    uint16_t FuelExecTime;
    uint16_t AFC;
    uint16_t Capacity_Val;
    uint32_t ChangeDisplayZoneBoundary[11];
    uint32_t ChangeCapacityBoundary[11];
    uint16_t ChangeOpenRes;
    uint16_t ChangeShortRse;
    uint16_t AFCPreinstall;
    uint8_t  Fuel_Sensor_Resistance_High;
    uint8_t  Fuel_Sensor_Resistance_Low;
    
}_MinFuel_Data_Struct;
extern _MinFuel_Data_Struct MinFuelData;

typedef struct
{
	uint8_t DestPosition;
    uint8_t DisStep;
	uint16_t Range;
    uint16_t RangeDis;
    uint16_t LastRange;
    uint8_t RangeValid;
    uint8_t Flg_18FEF200;
}_FuelDis;

extern _FuelDis FuelMeter;



typedef struct
{
    uint16_t FreshTime;
    uint8_t Valid;
    uint8_t First_Distance;
    uint32_t Value;
    uint32_t Display_Value;
    uint32_t Distance;
    uint32_t Time;
    uint32_t  RateSum;
    uint8_t Flg_18FEF200;
    uint32_t Value_Last;
}_Data_InsFuel_Struct;
extern _Data_InsFuel_Struct Data_InsFuel;
#endif
#endif






