#ifndef _NON_VOLATILE_MEMORYS_H_
#define _NON_VOLATILE_MEMORYS_H_

#include "r_typedefs.h"
#include "RTE_GPIO.h"

#define NVM_USE_EEPROM 1

#define NVM_INIT_DATA 0
#define NVM_ODO_DATA 1

#define NVM_MAINT_DATA 2
#define NVM_INDEX_ODO 3
#define NVM_INDEX_ODO_CLR 4

#define NVM_SNAPSHOT_FIRST 5

#define NVM_BusOff    25//6

#define NVM_TOTAL_DATA_NUM 25

typedef union
{
	struct
	{
		uint32_t Value;
		uint8_t ClrCnt;
		uint8_t Rsvd;
		uint16_t Cleared;
	} Sig;
	uint8_t Data[8];
} NVMODOUnion;

extern NVMODOUnion NVMODO;
extern uint8_t u8NVMMaintenance[16];
extern uint8_t u8MileODORelated[16];
extern uint8_t u8MileSnapshotRelated[20][16];

typedef union
{
	struct
	{
		uint32_t TripA_NUM;
		uint32_t TripB_NUM;
	} Sig;
	uint8_t Data[8];
} NVMTRIPUnion;
extern NVMTRIPUnion NVMTRIP;
#define NVM_Trip_VALUE NVMTRIP.Sig.TripA_NUM

extern uint8_t NVMEEPROMFault;
#define NVM_EEPROM_FAULT NVMEEPROMFault

void NVM_Init(void);
void NVM_Data_Update(uint8_t DataName);
void NVM_Data_Update_Service(void);
void Delay_Ms(uint8_t Time);
#endif
