#ifndef __UDS_DTC_H
#define __UDS_DTC_H

#include "TYW_stdint.h"
#include "UDS_Common.h"

#define   B111717       0x911717
#define   B111716       0x911716
#define   U007488       0xC07488
#define   U010087       0xC10087
#define   U014087       0xC14087
#define   U220D00       0xE20D00
#define   B100017       0x900017
#define   B100016       0x900016
#define   B100018       0x900018

#define   cnB111717        0u
#define   cnB111716        1u
#define   cnU007488        2u
#define   cnU010087        3u
#define   cnU014087        4u
#define   cnU220D00        5u
#define   cnB100017        6u
#define   cnB100016        7u
#define   cnB100018        8u

#define   cnMSG400         0u
#define   cnMSG521         1u

extern uint8_t HVoltageStatus;
extern uint8_t LVoltageStatus;
extern uint32_t msgList[2u][4u];
extern uint32_t DTCTimerList[9u];
extern const uint32_t DTCList[9][2];

void TestDTC(uint16_t timer);
void TestDTC_U007488(void);
void TestDTC_B111716(uint16_t timer);
void TestDTC_B111717(uint16_t timer);
void TestDTC_U010087(void);
void TestDTC_U014087(void);
void TestDTC_U220D00(void);
void TestDTC_B100017(uint16_t timer);
void TestDTC_B100016(uint16_t timer);
void TestDTC_B100018(uint16_t timer);
uint8_t getPowerStatus(void);
uint8_t getBusoffStatus(void);
uint8_t getEngStatus(void);
uint8_t getMSGStatus(uint8_t cnMsgID);
void ChangeDTCData(uint8_t DTCNum, uint8_t DTCStatus);
void SaveDTCData(void);

#endif