/*
****************************************************************************
PROJECT : VLIB
FILE ID : $Id: r_dma_sys.h 4630 2015-01-13 16:48:47Z golczewskim $
============================================================================
DESCRIPTION
Generic DMA driver
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2012
                                  by
                       Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2011 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/

#ifndef DMA_SYS_H_
#define DMA_SYS_H_

#ifdef __cplusplus
extern "C"
{
#endif

    /*******************************************************************************
      Title: Generic DMA (Wrapper) Support Functions

      The generic DMA driver uses these functions.
      This functions mainly just call the correct DMA macro function
      -> DMA macro choice is done by selecting the device

    */

    /*******************************************************************************
      Section: Global Functions
    */

    /*******************************************************************************
      Function: R_DMA_SYS_HardwareInit

      Setup the HW part for the generic DMA.

      Parameters:
      Unit       - Instance number

      Returns:
      see: <r_dma_Error_t>
    */

    r_dma_Error_t R_DMA_SYS_HardwareInit(uint32_t Unit);

    /*******************************************************************************
      Function: R_DMA_SYS_HardwareDeInit

      Deinit of the HW part for the generic DMA.

      Parameters:
      Unit       - Instance number

      Returns:
      see: <r_dma_Error_t>
    */

    r_dma_Error_t R_DMA_SYS_HardwareDeInit(uint32_t Unit);

    /*******************************************************************************
      Function: R_DMA_SYS_BaseAddr

      Returns the base address of dedicated macro unit.

      Parameters:
      Unit       - Instance number

      Returns:
      Macro base address
    */

    uint32_t R_DMA_SYS_BaseAddr(uint32_t Unit);

    /*******************************************************************************
      Function: R_DMA_SYS_EnableInt

      Enable the interrupt for the given unit and channel

      Parameters:
      Unit       - Instance number
      ChId       - DMA Channel ID (number)

      Returns:
      void
    */

    void R_DMA_SYS_EnableInt(uint32_t Unit, uint32_t ChId);

    /*******************************************************************************
      Function: R_DMA_SYS_DisableInt

      Disable the interrupt for the given unit and channel

      Parameters:
      Unit       - Instance number
      ChId       - DMA Channel ID (number)

      Returns:
      void
    */

    void R_DMA_SYS_DisableInt(uint32_t Unit, uint32_t ChId);

    /*******************************************************************************
      Function: R_DMA_SYS_LoadChannel

      Load DMA channels with the configuration data.

      Parameters:
      ChCfg       - DMA channel configuration
      NoOfCh      - Number of DMA channels need to be configured

      Returns:
      void
    */
    void R_DMA_SYS_LoadChannel(r_dma_ChCfg_t *ChCfg, uint32_t NoOfCh);

    /*******************************************************************************
      Function: R_DMA_SYS_SwTrigger

      SW trigger.

      Parameters:
      Unit        - DMA unit (normally 0)
      ChId        - DMA channel Id

      Returns:
      void
    */
    void R_DMA_SYS_SwTrigger(uint32_t Unit, uint32_t ChId);

    /*******************************************************************************
      Function: R_DMA_SYS_TransEndStat

      DMA transfer status.

      Parameters:
      Unit        - DMA unit (normally 0)
      ChId        - DMA channel Id

      Returns:
      Transfer status , see <r_dma_TransEndStatType_t>

    */
    r_dma_TransEndStatType_t R_DMA_SYS_TransEndStat(uint32_t Unit, uint32_t ChId);

    /*******************************************************************************
      Function: R_DMA_SYS_TransErrStat

      DMA transfer Error status.

      Parameters:
      Unit        - DMA unit (normally 0)
      ChId        - DMA channel Id

      Returns:
      Transfer status , see <r_dma_TransEndStatType_t>

    */
    r_dma_TransErrStatType_t R_DMA_SYS_TransErrStat(uint32_t Unit, uint32_t ChId);

#ifdef __cplusplus
}
#endif

#endif /* DMA_SYS_H_ */
