/**************************************************************************/ /**
                                                                              * \file     Task_Scheduler.h
                                                                              * \brief    Task Scheduler header file
                                                                              * \details
                                                                              * \author   Zhang Xuan
                                                                              * \version  V1.0.0
                                                                              * \date     06-Sep-2018
                                                                              * \par      History:
                                                                              *           V1.0.0 Initial release
                                                                              * \par      Copyright:
                                                                              *           (c) Heilongjiang TYW Electronics co., LTD
                                                                              ******************************************************************************/

#ifndef TASK_SCHEDULER_H
#define TASK_SCHEDULER_H

/* Includes ------------------------------------------------------------------*/
/* C binding of definitions if building with C++ compiler */
#ifdef __cplusplus
extern
{
#endif

    typedef void (*TaskCbk)(void);
    /*
     #define Platform_16Bit
     #define Platform_32Bit
    */
#ifdef Platform_16Bit
    #define tasklib_uint8_t  unsigned char
    #define tasklib_uint16_t unsigned int
    #define tasklib_uint32_t unsigned long

#else
    #define tasklib_uint8_t  unsigned char
    #define tasklib_uint16_t unsigned short
    #define tasklib_uint32_t unsigned int
    #define tasklib_uint64_t unsigned long long

#endif

    typedef struct
    {
        TaskCbk Exact_Task50us;
        TaskCbk Exact_Task100ms;
        TaskCbk Pseudo_Real_TimeTask;
        TaskCbk Task2ms;
        TaskCbk Task5ms;
        TaskCbk Task10ms;
        TaskCbk Task20ms;
        TaskCbk Task50ms;
        TaskCbk Task100ms;
    } st_Sys_TaskGroup;

    /* Exported functions ------------------------------------------------------- */

    extern void Sys_Init(const st_Sys_TaskGroup *TaskGroup_t);
    extern void Sys_Scheduling_Service(void);
    extern void Sys_Process_ISR(void);

#ifdef __cplusplus
}
#endif

#endif /* _Task_SCHEDULER_H_ */