
#include "Popup_Alarm_Handle.h"
#include "Sound_Alarm_handle.h"
#include "CAN_CH0_CAN_Communication_Matrix.h"

uint16_t u16SoundDiagCtr = 0xFFFF;

void Sound_Alarm_Trigger_DOOR(void)
{
    if ( u8PopAlarmDoor )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_DOOR);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_DOOR);
    }
}

void Sound_Alarm_Trigger_LDWS(void)
{
    if (( SYS_OPR_STAT_IGN_ON )&&(Get_NodeConfig_LWDS() == 1)&&(MenuData.Ldws == 2))
    {
        if(( u8PopAlarmLDWS_L == 0)&&(u8PopAlarmLDWS_R == 0))
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_LDWS);
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_LDWS);
    }
}

// Sound_uint8_t u8SoundAlarmGearPOnce;
void Sound_Alarm_Trigger_GEAR_P(void)
{
    uint16_t u16SndTig = 0U;
    if ( SYS_OPR_STAT_IGN_ON )
    {

        //{
        if ( (Get_CAN_CH0_ID_10FF7521_Sig_PsngrDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_DriverDoorSts( ) == 1) || (Get_CAN_CH0_ID_10FF7521_Sig_RHRDoorSts( ) == 1) )
        {
            uint16_t u16SndGear = Get_CAN_CH0_ID_18F00503_Sig_TransCurrentGear( );
            if ( (Get_EngSpeed_Start_Flag( ) == 1U) )
            {
                if ( u16SndGear == 0X7D )    // N
                {
                    if ( Line_In_Get_Status(LINE_IN_Handbrake) == 1U )
                    {

                        u16SndTig = 1;
                    }
                }
                else
                {
                    u16SndTig = 1;
                }
            }
            if ( u16SndGear == 0x7C )    // R
            {
                if ( Get_DispVechileSpeed( ) >= 10 )
                {
                    u16SndTig = 1;
                }
            }
        }
        // if ( u16SndTig == 0 )
        // {
        //     u8SoundAlarmGearPOnce = 1;
        // }
        //}
        // else
        // {
        //     u8SoundAlarmGearPOnce = 0U;
        // }

        if ( (u8DTC0XB8F0E0xx) || (u32RecSA03DTC == 0XB8F0E000) || (u8DTC0XCCF0E0xx) || (u32RecSA03DTC == 0XCCF0E000) )
        {
            u16SndTig = 1;
        }
        if ( (u8DTC0XB9F0E0xx) || (u32RecSA03DTC == 0xB9F0E000) || (u8DTC0XC1F0E0xx) || (u32RecSA03DTC == 0xC1F0E000) )
        {
            u16SndTig = 1;
        }
        if ( u8PopAlarmGearBoxHighTemp == 1 )
        {
            u16SndTig = 1;
        }
    }
    if ( u8PopAlarmGearBoxFailure == 1 )
    {
        u16SndTig = 1;
    }

    if ( u16SndTig )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_GEAR_P);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_GEAR_P);
    }
}

void Sound_Alarm_Trigger_RADAR(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_10FF1021_Sig_ReverseSts( ) == 1U )
        {
            uint16_t u16SdRadar = 0;
            if ( Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice( ) == 5U )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_LOOP);
                u16SdRadar = 1;
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_LOOP);
            }

            if ( Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice( ) == 4U )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_8);
                u16SdRadar = 1;
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_8);
            }
            if ( Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice( ) == 3U )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_4);
                u16SdRadar = 1;
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_4);
            }
            if ( Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice( ) == 2U )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_2);
                u16SdRadar = 1;
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_2);
            }
            if ( Get_CAN_CH0_ID_18FFB078_Sig_PAM_Voice( ) == 1U )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_1);
                u16SdRadar = 1;
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_1);
            }
            if ( u16SdRadar == 0 )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_RADAR_0);
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_0);
            }
        }
        else
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_LOOP);
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_8);
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_4);
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_2);
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_1);
            Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_0);
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_LOOP);
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_8);
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_4);
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_2);
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_1);
        Sound_Alarm_Delete_Normal(SOUND_ALARM_RADAR_0);
    }
}
#define SOUND_ENGLUBR_TIME 80
uint8_t u8SoundEngineLubricatTime = 0;
void    Sound_Alarm_Trigger_TEMP(void)
{
    uint16_t u16SndTig = 0U;
    if ( u8PopAlarmTemp )
    {
        u16SndTig = 1;
    }

    if ( u8PopAlarmEngineLubricate )
    {
        u16SndTig = 1;
    }

    if ( u16SndTig )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_TEMP);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_TEMP);
    }
}

void Sound_Alarm_Trigger_Par_Full_Reset(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FD7C00_Msg_Count) != CAN_SIG_LOST )
        {
            uint16_t u16SoundCondition = Get_CAN_CH0_ID_18FD7C00_Sig_DPFLampSts( );
            if ( (u16SoundCondition == 2) || (u16SoundCondition == 4) )
            {
                // Sound_Alarm_Request_Normal(SOUND_ALARM_PAR_FULL_MANUAL_RESET);
            }
            else
            {
                if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_PAR_FULL_MANUAL_RESET )
                {
                    Sound_Alarm_Delete_Normal(SOUND_ALARM_PAR_FULL_MANUAL_RESET);
                }
            }
        }
        else
        {
            if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_PAR_FULL_MANUAL_RESET )
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_PAR_FULL_MANUAL_RESET);
            }
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_PAR_FULL_MANUAL_RESET);
    }
}

void Sound_Alarm_Trigger_TBox(void)
{

    if ( u8PopAlarmTBoxDismantle )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_TBOX);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_TBOX )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_TBOX);
        }
    }
    if ( u8PopAlarmFuelSenFail )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_FUEL_SEN_FAIL);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_FUEL_SEN_FAIL )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_FUEL_SEN_FAIL);
        }
    }
    // if ( u8SoundAlarmGearPOnce )
    if ( (u8DTC0XCD160Bxx) || (u32RecSA03DTC == 0xCD160B00) )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_START_IN_P_ONCE);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_START_IN_P_ONCE )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_START_IN_P_ONCE);
        }
    }
    if ( u8PopAlarmBreakToShift )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_BRAKE_TO_SHIFT);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_BRAKE_TO_SHIFT )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_BRAKE_TO_SHIFT);
        }
    }
    if ( u8PopAlarmGearBoxCaution )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_GEARBOX_CAUTION);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_GEARBOX_CAUTION )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_GEARBOX_CAUTION);
        }
    }
    if ( u8PopAlarmESCActive )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_ESC_ATCIVE);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_ESC_ATCIVE )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_ESC_ATCIVE);
        }
    }
    if ( u8PopAlarmESCClose )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_ESC_CLOSE);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_ESC_CLOSE )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_ESC_CLOSE);
        }
    }
    if ( u8PopAlarmESCFailure )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_ESC_FAILURE);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_ESC_FAILURE )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_ESC_FAILURE);
        }
    }
}
void Sound_Alarm_Trigger_LOW_OIL_PRESSURE(void)
{
}
void Sound_Alarm_Trigger_DPF(void)
{
    if ( u8PopAlarmDPF )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_DPF);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_DPF )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_DPF);
        }
    }
}
void Sound_Alarm_Trigger_SPEED_LIMIT(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( (CAN_MSG_Status(&CAN_CH0_CanMsgOp, CAN_CH0_ID_can18FF2100_Msg_Count) == CAN_SIG_LOST) || (CanReceive.Can_18FF2100 != 1) )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_SPEED_LIMIT);
        }
        else
        {
            if ( Get_CAN_CH0_ID_18FF2100_Sig_EDC_MaxVehSpeedLimSetp( ) <= (Common_Get_Act_V_Speed( ) / 10) )
            {
                Sound_Alarm_Request_Normal(SOUND_ALARM_SPEED_LIMIT);
            }
            else
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_SPEED_LIMIT);
            }
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_SPEED_LIMIT);
    }
}
void Sound_Alarm_Trigger_UREA(void)
{

    // if ( u8PopAlarmUreaFailChange )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA);
    //     }
    // }
    // if ( u8PopAlarmUreaLowAdd )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_2);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_2 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_2);
    //     }
    // }
    // if ( u8PopAlarmUreaFailLimit75 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_3);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_3 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_3);
    //     }
    // }
    // if ( u8PopAlarmUreaLowLimit75 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_4);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_4 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_4);
    //     }
    // }
    // if ( u8PopAlarmUreaLowTqrqueLimit75 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_5);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_5 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_5);
    //     }
    // }
    // if ( u8PopAlarmUreaFailReset20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_6);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_6 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_6);
    //     }
    // }
    // if ( u8PopAlarmUreaLowReset20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_7);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_7 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_7);
    //     }
    // }
    // if ( u8PopAlarmUreaFail20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_8);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_8 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_8);
    //     }
    // }
    // if ( u8PopAlarmUreaLow20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_9);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_9 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_9);
    //     }
    // }

    // if ( u8PopAlarmLimit75Change )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_10);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_10 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_10);
    //     }
    // }

    // if ( u8PopAlarmEmissionFailService )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_11);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_11 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_11);
    //     }
    // }
    // if ( u8PopAlarmEmissionFailLimit75 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_12);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_12 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_12);
    //     }
    // }
    // if ( u8PopAlarmLimit75Service )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_13);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_13 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_13);
    //     }
    // }
    // if ( u8PopAlarmEmissionFailReset20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_14);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_14 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_14);
    //     }
    // }
    // if ( u8PopAlarmEmissionFail20 )
    // {
    //     Sound_Alarm_Request_Normal(SOUND_ALARM_UREA_15);
    // }
    // else
    // {
    //     if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA_15 )
    //     {
    //         Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA_15);
    //     }
    // }

    if ( (u8PopAlarmUreaFailChange) || (u8PopAlarmUreaLowAdd) || (u8PopAlarmUreaFailLimit75) || (u8PopAlarmUreaLowLimit75) || (u8PopAlarmUreaLowTqrqueLimit75) || (u8PopAlarmUreaFailReset20) || (u8PopAlarmUreaLowReset20) || (u8PopAlarmUreaFail20) || (u8PopAlarmUreaLow20) || (u8PopAlarmLimit75Change) || (u8PopAlarmEmissionFailService) || (u8PopAlarmEmissionFailLimit75) || (u8PopAlarmLimit75Service) || (u8PopAlarmEmissionFailReset20) || (u8PopAlarmEmissionFail20) )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_UREA);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_UREA )
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_UREA);
        }
    }
}
void Sound_Alarm_Trigger_TPMS(void)
{

    if ( (u8PopAlarmTPMS) )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_TPMS);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_TPMS )
        {

            Sound_Alarm_Delete_Normal(SOUND_ALARM_TPMS);
        }
    }
    if ( (u8PopAlarmTPMSConfigError) )
    {
        // Sound_Alarm_Request_Normal(SOUND_ALARM_TPMS_CONFIG_ERROR);
    }
    else
    {
        if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_TPMS_CONFIG_ERROR )
        {

            Sound_Alarm_Delete_Normal(SOUND_ALARM_TPMS_CONFIG_ERROR);
        }
    }
}

void Sound_Alarm_Trigger_SAFE_BELT(void)
{
    if ( u8SafeBeltTrigger == 2 )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_SAFE_BELT);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_SAFE_BELT);
    }
}
void Sound_Alarm_Trigger_LIGHT_LEFT_ON(void)
{
    if ( u8PopAlarmPositionLight )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_LIGHT_LEFT_ON);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_LIGHT_LEFT_ON);
    }
}
void Sound_Alarm_Trigger_UNPLUGGED_KEY(void)
{
    if ( u8PopAlarmKEY )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_UNPLUGGED_KEY);
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_UNPLUGGED_KEY);
    }
}
uint8_t u8SoundTurnL    = 0U;
uint8_t u8SoundTurnR    = 0U;
uint8_t u8TurnTickCount = 0;
uint8_t u8TurnTockCount = 0;
void    Sound_Alarm_Trigger_TURN(void)
{

    uint8_t u8SoundTurnLBuf = Get_CAN_CH0_ID_10FF1021_Sig_LHTurnSignalSts( );
    uint8_t u8SoundTurnRBuf = Get_CAN_CH0_ID_10FF1021_Sig_RHTurnSignalSts( );
    if ( SYS_OPR_STAT_HALT )
    {
        return;
    }
    if ( (Common_GetIgnOnTime( ) < SELF_CHECK_TIME) && (SYS_OPR_STAT_IGN_ON) )
    {
        return;
    }
    if ( (u16SoundDiagCtr <= 0x0B) )
    {
        return;
    }

    if ( u8TurnTickCount < 5 )
    {
        u8TurnTickCount++;
    }
    if ( u8TurnTickCount >= 5 )
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_TICK);
    }
    if ( u8TurnTockCount < 5 )
    {
        u8TurnTockCount++;
    }
    if ( u8TurnTockCount >= 5 )
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_TOCK);
    }

    if ( ((u8SoundTurnL == 1U) && (u8SoundTurnLBuf == 0U)) || ((u8SoundTurnR == 1U) && (u8SoundTurnRBuf == 0U)) )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_TOCK);
        u8TurnTockCount = 0U;
    }
    if ( ((u8SoundTurnL == 0U) && (u8SoundTurnLBuf == 1U)) || ((u8SoundTurnR == 0U) && (u8SoundTurnRBuf == 1U)) )
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_TICK);
        u8TurnTickCount = 0U;
    }
    u8SoundTurnL = u8SoundTurnLBuf;
    u8SoundTurnR = u8SoundTurnRBuf;
}
Sound_uint32_t u32SoundEnableSuspend = 1;
void           Sound_Alarm_Trigger_Volume(void)
{
    /*当前有声音报警，且不是设置音量*/
    if ( (Sound_Alarm_Current_Read( ) < SOUND_ALARM_MAX) && (Sound_Alarm_Current_Read( ) != SOUND_ALARM_VOLUME) )
    {
    }
    else
    {
        Sound_Alarm_Request_Normal(SOUND_ALARM_VOLUME);
    }
    if ( u32SoundEnableSuspend == 1 )
    {

        uint32_t i = 0;
        for ( i = SOUND_ALARM_DPF; i < SOUND_ALARM_MAX; i++ )
        {
            Sound_Alarm_Enable_Suspend(i, 0);
        }
        u32SoundEnableSuspend = 0;
    }
}
void Sound_Alarm_Volume_Menu_Check(void)
{
    if ( (Menu_Get_Current_Cursor_Information( ) != MENU_ITEM_SET_Sound) )
    {
        if ( u32SoundEnableSuspend == 0 )
        {
            uint32_t i = 0;
            for ( i = SOUND_ALARM_DPF; i < SOUND_ALARM_MAX; i++ )
            {
                Sound_Alarm_Enable_Suspend(i, 1);
            }
            u32SoundEnableSuspend = 1;
        }
    }
}

void Sound_Alarm_Trigger_HILL_HOLD_MALF(void)
{
    if ( (SYS_OPR_STAT_IGN_ON) && (COF_ESP_EXIST) )
    {
        if ( Get_CAN_CH0_ID_0A18A006_Sig_HhFail( ) == 1 )
        {
            // Sound_Alarm_Request_Normal(SOUND_ALARM_HILL_HOLD_MALF);
        }
        else
        {
            if ( Sound_Alarm_Current_Read( ) != SOUND_ALARM_HILL_HOLD_MALF )
            {
                Sound_Alarm_Delete_Normal(SOUND_ALARM_HILL_HOLD_MALF);
            }
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_HILL_HOLD_MALF);
    }
}

void Sound_Alarm_Trigger_GEAR_R(void)
{
    if ( SYS_OPR_STAT_IGN_ON )
    {
        if ( Get_CAN_CH0_ID_10FF1021_Sig_ReverseSts( ) == 1U )
        {
            Sound_Alarm_Request_Normal(SOUND_ALARM_R_Gear);
        }
        else
        {
            Sound_Alarm_Delete_Normal(SOUND_ALARM_R_Gear);
        }
    }
    else
    {
        Sound_Alarm_Delete_Normal(SOUND_ALARM_R_Gear);
    }
}

void Sound_Alarm_Trigger_Time(void)
{
    if ( Get_EngSpeed_Start_Flag( ) == 1U )
    {
        if ( u8SoundEngineLubricatTime < SOUND_ENGLUBR_TIME )
        {

            u8SoundEngineLubricatTime++;
        }
    }
    else
    {
        u8SoundEngineLubricatTime = 0;
    }
}
void Sound_Alarm_Trigger_Delete_All(void)
{
    Sound_Alarm_en_t enSoundIndexBuf = 0U;
    for ( enSoundIndexBuf = 0U; enSoundIndexBuf < SOUND_ALARM_MAX; enSoundIndexBuf++ )
    {
        Sound_Alarm_Delete_Normal(enSoundIndexBuf);
    }
}

void Sound_Alarm_Trigger_OFF_Init(void)
{
    u16SoundDiagCtr = 0xFFFF;
    Sound_Alarm_Trigger_Delete_All( );
}
void Sound_Alarm_Trigger_ON_Init(void)
{
    Sound_Alarm_Trigger_Delete_All( );
    u16SoundDiagCtr = 0xFFFF;
}
void Soung_Trigger_One(uint16_t u16SoundOne)
{
    uint16_t i = 0;
    for ( i = 0; i < SOUND_ALARM_MAX; i++ )
    {
        if ( u16SoundOne == i )
        {
            Sound_Alarm_Request_Normal(i);
        }
        else
        {
            Sound_Alarm_Delete_Normal(i);
        }
    }
}
void Sound_Alarm_Trigger_Service(void)
{
    if ( SYS_OPR_STAT_HALT )
    {
        return;
    }
    if ( (u16SoundDiagCtr <= 0x0B) )
    {
        switch ( u16SoundDiagCtr )
        {
            case 0:
                Sound_Alarm_Trigger_Delete_All( );
                break;
            case 1:
                Soung_Trigger_One(SOUND_ALARM_DOOR);
                break;
            case 2:
                Soung_Trigger_One(SOUND_ALARM_SAFE_BELT);
                break;
            case 3:
                Soung_Trigger_One(SOUND_ALARM_TEMP);
                break;
            case 4:
                Soung_Trigger_One(SOUND_ALARM_LOW_OIL_PRESSURE);
                break;
            case 5:
                Soung_Trigger_One(SOUND_ALARM_UNPLUGGED_KEY);
                break;
            case 6:
                Soung_Trigger_One(SOUND_ALARM_LIGHT_LEFT_ON);
                break;
            case 7:
                Soung_Trigger_One(SOUND_ALARM_TICK);
                break;
            case 8:
                Soung_Trigger_One(SOUND_ALARM_UREA);
                break;
            case 9:
                Soung_Trigger_One(SOUND_ALARM_TPMS);
                break;
            case 0x0A:
                // Soung_Trigger_One(SOUND_ALARM_DOOR);
                break;
            case 0X0B:
                Soung_Trigger_One(SOUND_ALARM_RADAR_LOOP);
                break;
            default:
                break;
        }
        return;
    }

    Sound_Alarm_Volume_Menu_Check( );
    if ( (Common_GetIgnOnTime( ) >= SELF_CHECK_TIME) && (SYS_OPR_STAT_IGN_ON) )
    {
        Sound_Alarm_Trigger_DPF( );
        Sound_Alarm_Trigger_DOOR( );
        Sound_Alarm_Trigger_RADAR( );
        Sound_Alarm_Trigger_GEAR_P( );
        Sound_Alarm_Trigger_TEMP( );
        Sound_Alarm_Trigger_Par_Full_Reset( );
        Sound_Alarm_Trigger_SPEED_LIMIT( );
        Sound_Alarm_Trigger_UREA( );
        Sound_Alarm_Trigger_TPMS( );
        Sound_Alarm_Trigger_GEAR_R( );
        Sound_Alarm_Trigger_SAFE_BELT( );
        Sound_Alarm_Trigger_TBox( );

        Sound_Alarm_Trigger_LOW_OIL_PRESSURE( );
        Sound_Alarm_Trigger_HILL_HOLD_MALF( );
        Sound_Alarm_Trigger_LDWS();
    }
    if ( SYS_OPR_STAT_IGN_OFF )
    {

        Sound_Alarm_Trigger_GEAR_P( );
        Sound_Alarm_Trigger_LIGHT_LEFT_ON( );
        Sound_Alarm_Trigger_UNPLUGGED_KEY( );
    }
    // Sound_Alarm_Trigger_TURN();
}

/*
u8OnOff : 0 诊断不控制  3 诊断控制
u8Index ：受控时，具体播放哪个报警
*/
void Sound_Diag_Ctrl(Sound_uint8_t u8OnOff, Sound_uint8_t u8Index)
{
    if ( u8OnOff == 3 )
    {
        u16SoundDiagCtr = u8Index;
    }
    else
    {
        u16SoundDiagCtr = 0xFFFF;
    }
}
Sound_uint16_t Sound_Get_Diag_Ctrl(void)
{
    return u16SoundDiagCtr;
}