/*
****************************************************************************
PROJECT : VLIB - BSP API
FILE    : $Id: r_bsp_api.h 7262 2016-01-15 13:34:37Z michael.golczewski $
============================================================================
DESCRIPTION
BSP API - API for the board support functions
============================================================================
                            C O P Y R I G H T
============================================================================
                           Copyright (c) 2012
                                  by
                       Renesas Electronics (Europe) GmbH.
                           Arcadiastrasse 10
                          D-40472 Duesseldorf
                               Germany
                          All rights reserved.
============================================================================
Purpose: only for testing

DISCLAIMER
This software is supplied by Renesas Electronics Corporation and is only
intended for use with Renesas products. No other uses are authorized. This
software is owned by Renesas Electronics Corporation and is protected under
all applicable laws, including copyright laws.
THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT
LIMITED TO WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE
AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED.
TO THE MAXIMUM EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS
ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES SHALL BE LIABLE
FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR
ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
Renesas reserves the right, without notice, to make changes to this software
and to discontinue the availability of this software. By using this software,
you agree to the additional terms and conditions found by accessing the
following link:
http://www.renesas.com/disclaimer *
Copyright (C) 2011 Renesas Electronics Corporation. All rights reserved.

****************************************************************************
*/
#ifndef BSP_API_H_
#define BSP_API_H_

#ifdef __cplusplus
extern "C"
{
#endif

    /*******************************************************************************
      Title: BSP API

      An application using the Board Support Package should include this header file.
    */

    /*******************************************************************************
      Section: Global constants
        Define the maximum character length of board information strings.
    */

    /*******************************************************************************
      Section: Global Types
    */

    /*******************************************************************************
      Section: Global API Functions
    */

    /*******************************************************************************
      Function: R_BSP_LowInit

      Init BSP hardware on a lower (before main() ) level.

      Parameters:
      void

      Returns:
      == E_OK    - init successfully
      != E_OK    - init failed
    */

    void R_BSP_LowInit(void);

    /*******************************************************************************
      Function: R_BSP_Init

      Init BSP hardware.

      Parameters:
      void

      Returns:
      == E_OK    - init successfully
      != E_OK    - init failed
    */

    r_Error_t R_BSP_Init(void);

    /*******************************************************************************
      Function: R_BSP_DeInit

      De-Init BSP hardware.

      Parameters:
      void

      Returns:
      == R_ERR_OK    - deinit successfully
      != R_ERR_OK    - deinit failed
    */

    r_Error_t R_BSP_DeInit(void);

#ifdef __cplusplus
}
#endif

#endif /* R_BSP_API_H */
