
  
#include "g_includes.h"
#include "Key.h"
#include "Key_user.h"
#include "Menu.h"


#define Back_Menu_Time		1000
_Page_Infor PageInfor;
void Menu_Service(Menu_Key_en_t enMenuKey);
void Key_Operation_Left(Key_Event_en_t enKeyEvent)
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:
		Menu_Service(MENU_KEY_LEFT_SHORT);
		Pop_Alarm_Hide_Current();
		break;
	case KEY_EVENT_SHORT_PRESS_2:	
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3

		break;
	case KEY_EVENT_LONG_PRESS_3:	//4s
		
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_ECU_RANGE)
		{
			if(Get_CAN_CH0_ID_10FF1021_Sig_HighBeamSts() == 1)
			{
				if(Get_CAN_CH0_ID_10FF1021_Sig_RearFogLightSts() == 1)
				{
					if(Get_CAN_CH0_ID_10FF1021_Sig_FrontFogLightSts() == 1)
					{
						Data_Clear_TYW();
					}
				}
			}
		}
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_LEFT_EVENT_NONE_Service();
		break;
	default:
		break;
	}
}
void Key_Operation_Right(Key_Event_en_t enKeyEvent)
{
	switch (enKeyEvent)
	{
	case KEY_EVENT_SHORT_PRESS_1:	
		if(Pop_Alarm_Get_Current() < POP_ALARM_MAX)
		{
			;
		}
		else
		{
			Menu_Service(MENU_KEY_RIGHT_SHORT);
		}
		Pop_Alarm_Hide_Current();
		break;
	case KEY_EVENT_SHORT_PRESS_2:		
		break;
	case KEY_EVENT_LONG_PRESS_1:	//2s
		if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_ECU_TRIP)
		{
			Data_Clear_Trip();
			Data_Clear_Ins_fuel();
			Data_Clear_Avg_fuel();						 
			Data_Avg_Speed_Reset();
			//Data_Clear_Range();
		}
		break;
	case KEY_EVENT_LONG_PRESS_2:	//3s
		if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_ECU_MAINTAIN)
		{
			Maint_Reset(1);
		}
		break;
	case KEY_EVENT_LONG_PRESS_3:	//4s
		if(Menu_Get_Current_Cursor_Information() == MENU_ITEM_ECU_TRIP)
		{
			Data_Clear_Odo();
		}
		break;
	case KEY_EVENT_LONG_PRESS_4:	//10s
		Data_Clear_TYW();
		break;
	case KEY_EVENT_OFF_TO_ON:		
		break;
	case KEY_EVENT_ON_TO_OFF:
		break;
	case KEY_EVENT_NONE:
		KEY_RIGHT_EVENT_NONE_Service();
		break;
	default:		
		break;
	}
}
//void Key_Operation_FLIP(Key_Event_en_t enKeyEvent)
//{
//}
//void Key_Operation_ADJUST(Key_Event_en_t enKeyEvent)
//{
//}

/*---------------------------------------------------------------------------------------*/
Key_Status_en_t Key_Status_Read_Left(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (KEY0_MCU_IN)
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	else
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}

	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_Right(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	if (KEY1_MCU_IN)
	{
		enKeyReal = KEY_REALTIME_LOOSEN;
	}
	else
	{
		enKeyReal = KEY_REALTIME_PRESS;
	}

	return enKeyReal;
}
/*Key_Status_en_t Key_Status_Read_FLIP(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	//if (0)
	//{
	//	enKeyReal = KEY_REALTIME_LOOSEN;
	//}
	//else
	//{
	//	enKeyReal = KEY_REALTIME_PRESS;
	//}

	return enKeyReal;
}
Key_Status_en_t Key_Status_Read_ADJUST(void)
{
	Key_Status_en_t enKeyReal = KEY_REALTIME_LOOSEN;
	//if (0)
	//{
	//	enKeyReal = KEY_REALTIME_LOOSEN;
	//}
	//else
	//{
	//	enKeyReal = KEY_REALTIME_PRESS;
	//}

	return enKeyReal;
}*/

/*---------------------------------------------------------------------------------------*/
const Key_Attribute_st_t stKeyAttribute[KEY_NUM_MAX] =
	{
		{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Left, Key_Operation_Left},
		{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_Right, Key_Operation_Right},
		//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_FLIP, Key_Operation_FLIP},
		//{KEY_NEED_DEBOUNCE_NORMAL, Key_Status_Read_ADJUST, Key_Operation_ADJUST},

};

/*---------------------------------------------------------------------------------------*/

//#pragma ghs section bss = ".myNonInitArea"
Key_uint8_t u8KeyRamData[KEY_RAM_DATA_LEN];
//#pragma ghs section bss = default


void Key_KL30_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;
	Key_uint16_t i;
	for (i = 0; i < KEY_RAM_DATA_LEN; i++)
	{
		u8KeyRamData[i] = 0;
	}

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF;
	Key_KL30_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,500U);
	Key_Parameter_Set_Short_Press_2_Time(1000U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(3000U);
	Key_Parameter_Set_Long_Press_3_Time(4000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);	
}
void Key_Wakeup_Init_EXample(void)
{
	Key_Init_st_t stKeyInitTem;

	stKeyInitTem.u8KeyNum = KEY_NUM_MAX;
	stKeyInitTem.enKeyIGNRealStatus = KEY_IG_OFF; //

	Key_Wakeup_Init(&u8KeyRamData[0], stKeyAttribute, &stKeyInitTem);

	Key_Parameter_Set_Short_Press_1_Time(50U,500U);
	Key_Parameter_Set_Short_Press_2_Time(1000U,2000U);

	Key_Parameter_Set_Long_Press_1_Time(2000U);
	Key_Parameter_Set_Long_Press_2_Time(3000U);
	Key_Parameter_Set_Long_Press_3_Time(4000U);
	Key_Parameter_Set_Long_Press_4_Time(10000U);	
}


void KEY_LEFT_EVENT_NONE_Service(void)	
{
	
	PageInfor.Back_Time_Left++;
	if(PageInfor.Back_Time_Left > Back_Menu_Time)
	{
		PageInfor.Back_Time_Left = 0;
		PageInfor.Back_Time_Left_Flag = 1;
	}
	if((PageInfor.Back_Time_Left_Flag == 1)&&(PageInfor.Back_Time_Right_Flag == 1))
	{
		Menu_Service(MENU_KEY_TIMEOUT);
		PageInfor.Back_Time_Left_Flag = 0;
		PageInfor.Back_Time_Right_Flag = 0;
	}
}

void KEY_RIGHT_EVENT_NONE_Service(void)	
{
	PageInfor.Back_Time_Right++;
	if(PageInfor.Back_Time_Right > Back_Menu_Time)
	{
		PageInfor.Back_Time_Right = 0;
		PageInfor.Back_Time_Right_Flag = 1;
	}
	if((PageInfor.Back_Time_Left_Flag == 1)&&(PageInfor.Back_Time_Right_Flag == 1))
	{
		Menu_Service(MENU_KEY_TIMEOUT);
		PageInfor.Back_Time_Left_Flag = 0;
		PageInfor.Back_Time_Right_Flag = 0;
	}
}


void Key_Clear_Time(void)
{
	if(Key_Status_Read_Left() == KEY_REALTIME_PRESS)
	{
		PageInfor.Back_Time_Left = 0;
		PageInfor.Back_Time_Left_Flag = 0;
		PageInfor.Back_Time_Right_Flag = 0;
	}
	if(Key_Status_Read_Right() == KEY_REALTIME_PRESS)
	{
		PageInfor.Back_Time_Right = 0;
		PageInfor.Back_Time_Left_Flag = 0;
		PageInfor.Back_Time_Right_Flag = 0;
	}
}